/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionEvent;
import com.huawei.dc.common.components.deviceselection.table.DeviceTableActionListener;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.taskmgmt.controller.IHighModeNotifier;
import com.huawei.dc.taskmgmt.controller.UpModeCheckController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.u2000.framework.help.HelpLabel;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HighEfficiencyModePanel
extends JPanel
implements DeviceTableActionListener {
    private static final long serialVersionUID = 3818762691060020468L;
    private List<IHighModeNotifier> m_oHighModelistenerLst = new ArrayList<IHighModeNotifier>();
    private transient JCheckBox m_oHighefficiencyModeCheckbox = null;
    private ITask m_oTaskDataObj = null;
    private String m_strMsg;
    private String m_strErrorMsg;
    private HelpLabel m_oHighefficiencyModehelpLable = null;

    public HighEfficiencyModePanel(ITask oTaskDataObj) {
        this.m_oTaskDataObj = oTaskDataObj;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setName("taskmgmt_TaskMgmtOperationSelecPanel_modePanel");
        JPanel jpanerl = null;
        if (ResourceManager.getInstance().getResString("LBL_TOLERANCE_MODE").equals(this.getHighLevelModeCheckbox().getText())) {
            String strm_oHighefficiencyModeHelpID = ResourceManager.getInstance().getResString("HELP_TOPIC_LBL_TOLERANCE_MODE", "helpmapfile");
            this.m_oHighefficiencyModehelpLable = new HelpLabel("", strm_oHighefficiencyModeHelpID);
            this.m_oHighefficiencyModehelpLable.setPreferredSize(new Dimension(20, 20));
            this.m_oHighefficiencyModehelpLable.setMinimumSize(new Dimension(20, 20));
            this.m_oHighefficiencyModehelpLable.setIcon((Icon)ResourceManager.getInstance().getImage("help1.png"));
            jpanerl = new JPanel();
            jpanerl.setLayout(new GridBagLayout());
            jpanerl.add((Component)this.getHighLevelModeCheckbox(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
            if (!DCFrameWorkUtil.isHelpIDFormSA()) {
                jpanerl.add((Component)this.m_oHighefficiencyModehelpLable, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
            }
            this.add((Component)jpanerl, "West");
        } else {
            this.add((Component)this.getHighLevelModeCheckbox(), "West");
        }
        this.initGUIData();
        DCFrameWorkUtil.setHighModePanel(this);
    }

    public void registerForNotification(IHighModeNotifier oHighModeNotifier) {
        this.m_oHighModelistenerLst.add(oHighModeNotifier);
    }

    public void unregisterForNotification(IHighModeNotifier oHighModeNotifier) {
        this.m_oHighModelistenerLst.remove(oHighModeNotifier);
    }

    private JCheckBox getHighLevelModeCheckbox() {
        this.m_oHighefficiencyModeCheckbox = new JCheckBox();
        this.m_oHighefficiencyModeCheckbox.setName("taskmgmt_HighEfficiencyModePanel_m_oHighefficiencyModeCheckbox");
        this.m_oHighefficiencyModeCheckbox.setText(ResourceManager.getInstance().getResString("LBL_HIGH_EFFICIENCY_MODE"));
        this.m_strMsg = ResourceManager.getInstance().getResString("INFO_HIGH_LEVEL_MODE_DETAIL_V2");
        this.m_strErrorMsg = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_PACKAGE_CUSTOM");
        this.m_oHighefficiencyModeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HighEfficiencyModePanel.this.m_oHighefficiencyModeCheckbox.isSelected()) {
                    THashSet<Resource> allResoutLst = null;
                    List<String[]> neList = null;
                    if (null != HighEfficiencyModePanel.this.m_oTaskDataObj && null != HighEfficiencyModePanel.this.m_oTaskDataObj.getDeviceType()) {
                        allResoutLst = HighEfficiencyModePanel.this.m_oTaskDataObj.getDeviceType().getResources();
                        neList = UpModeCheckController.getInstance().isNoSupportHighLevelMode(HighEfficiencyModePanel.this.m_oTaskDataObj);
                    }
                    if (null == neList || null == allResoutLst || neList.size() == allResoutLst.size()) {
                        HighEfficiencyModePanel.this.m_oHighefficiencyModeCheckbox.setSelected(false);
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), HighEfficiencyModePanel.this.m_strErrorMsg, ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                        return;
                    }
                    if (0 == neList.size()) {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), HighEfficiencyModePanel.this.m_strMsg, ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                    } else {
                        HighEfficiencyModePanel.this.display(neList);
                    }
                    HighEfficiencyModePanel.this.refreshTaskAndResoruceUpMode(true);
                    HighEfficiencyModePanel.this.sendHighModeChangeEvent(true);
                } else {
                    HighEfficiencyModePanel.this.refreshTaskAndResoruceUpMode(false);
                    HighEfficiencyModePanel.this.sendHighModeChangeEvent(false);
                }
            }
        });
        return this.m_oHighefficiencyModeCheckbox;
    }

    private void display(List<String[]> neList) {
        String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_SEQ_NO"), ResourceManager.getInstance().getResString("DEVICE_NAME_HEADER")};
        final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(columnNames, neList);
        commonFileCheckResultDlg.setTitle(ResourceManager.getInstance().getResString("SUGGESTION"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                commonFileCheckResultDlg.setVisible(true);
            }
        });
    }

    public void setCheckboxEnableStatus(boolean bEnable) {
        if (bEnable) {
            this.m_oHighefficiencyModeCheckbox.setEnabled(true);
        } else {
            this.m_oHighefficiencyModeCheckbox.setEnabled(false);
            this.m_oHighefficiencyModeCheckbox.setSelected(false);
            this.refreshTaskAndResoruceUpMode(false);
            this.sendHighModeChangeEvent(false);
        }
    }

    private void initGUIData() {
        ITaskDeviceOperation oTaskLoadSoftwareOper;
        if (null == this.m_oTaskDataObj) {
            return;
        }
        int iSelectState = this.m_oTaskDataObj.getHighefficiencyMode();
        if (iSelectState == 1 && null != this.m_oHighefficiencyModeCheckbox) {
            this.m_oHighefficiencyModeCheckbox.setSelected(true);
            this.m_oTaskDataObj.setIsCheckHighEfficiency(true);
        }
        if (null != (oTaskLoadSoftwareOper = TaskInfoUtil.getTaskOperation(this.m_oTaskDataObj, 6)) && !oTaskLoadSoftwareOper.isSelected()) {
            this.m_oHighefficiencyModeCheckbox.setSelected(false);
            this.m_oHighefficiencyModeCheckbox.setEnabled(false);
        }
        this.updateHighEfficiencyModeCheckBoxStatus();
    }

    public void refreshTaskAndResoruceUpMode(boolean bHighLevelMode) {
        TaskInfoUtil2.refreshTaskMode(this.m_oTaskDataObj, bHighLevelMode);
        TaskInfoUtil2.refreshResourceMode(this.m_oTaskDataObj, bHighLevelMode);
    }

    public JCheckBox getHighefficiencyModeCheckbox() {
        return this.m_oHighefficiencyModeCheckbox;
    }

    protected void sendHighModeChangeEvent(boolean bSelected) {
        int iSizeOflst = this.m_oHighModelistenerLst.size();
        for (int i = 0; i < iSizeOflst; ++i) {
            IHighModeNotifier oHighModeNotifier = this.m_oHighModelistenerLst.get(i);
            oHighModeNotifier.handleHighModeChangeNotification(bSelected);
        }
    }

    @Override
    public void onTableActionPerformed(DeviceTableActionEvent event) {
        if (null == event) {
            return;
        }
        int iEventType = event.getEventType();
        switch (iEventType) {
            case 1: {
                List resourceLst = (List)event.getSource();
                this.handleDevDelete(resourceLst);
                break;
            }
            case 4: {
                DeviceInfo[] devInfos;
                for (DeviceInfo devInfo : devInfos = (DeviceInfo[])event.getSource()) {
                    this.handleDevAdd(devInfo);
                }
                break;
            }
            case 3: {
                DeviceInfo[] devInfos = (DeviceInfo[])event.getSource();
                if (null == devInfos) break;
                for (DeviceInfo devInfo : devInfos) {
                    int iDevID = devInfo.getDevId();
                    Resource resource = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
                    if (null == resource) continue;
                    ArrayList<Resource> resourceLst = new ArrayList<Resource>();
                    resourceLst.add(resource);
                    this.handleDevDelete(resourceLst);
                }
                break;
            }
        }
    }

    private void handleDevDelete(List<Resource> resourceLst) {
        THashSet<Resource> resLst = this.m_oTaskDataObj.getDeviceType().getResources();
        if (null == resourceLst || resLst.isEmpty()) {
            return;
        }
        Iterator<Resource> itor = resourceLst.iterator();
        Resource resourceInfo = null;
        while (itor.hasNext()) {
            resourceInfo = itor.next();
            if (null != resourceInfo && !resLst.contains((Object)resourceInfo)) continue;
            resLst.remove((Object)resourceInfo);
        }
        this.updateHighEfficiencyModeCheckBoxStatus();
        if (!this.m_oHighefficiencyModeCheckbox.isSelected()) {
            return;
        }
        THashSet<Resource> allResoutLst = this.m_oTaskDataObj.getDeviceType().getResources();
        if (0 >= allResoutLst.size()) {
            return;
        }
        boolean isSupport = UpModeCheckController.getInstance().isAllSupportHighLevelMode(this.m_oTaskDataObj);
        if (!isSupport) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("INFO_HIGH_MODE_NOT_SUPPORT"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            this.m_oHighefficiencyModeCheckbox.setSelected(false);
        }
    }

    private void handleDevAdd(DeviceInfo oDeviceInfo) {
        if (null == oDeviceInfo) {
            return;
        }
        int iDevID = oDeviceInfo.getDevId();
        Resource resource = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
        if (null == resource) {
            return;
        }
        this.m_oTaskDataObj.getDeviceType().getResources().add((Object)resource);
        if (!this.m_oHighefficiencyModeCheckbox.isSelected()) {
            return;
        }
        boolean isSupport = UpModeCheckController.getInstance().isAllSupportHighLevelMode(this.m_oTaskDataObj);
        if (!isSupport) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("INFO_HIGH_MODE_NOT_SUPPORT"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
            this.m_oHighefficiencyModeCheckbox.setSelected(false);
        }
        this.updateHighEfficiencyModeCheckBoxStatus();
    }

    public void dispose() {
        if (null != this.m_oHighModelistenerLst) {
            this.m_oHighModelistenerLst.clear();
            this.m_oHighModelistenerLst = null;
        }
        if (null != this.m_oTaskDataObj) {
            this.m_oTaskDataObj = null;
        }
        DCCleanupUtil.cleanUpPanel(this);
    }

    private void updateHighEfficiencyModeCheckBoxStatus() {
        if (UpModeCheckController.getInstance().isAllNotSupportToleranceMode(this.m_oTaskDataObj)) {
            this.m_oTaskDataObj.setIsCheckHighEfficiency(false);
        } else {
            this.m_oTaskDataObj.setIsCheckHighEfficiency(true);
        }
    }
}

