/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCBDResetInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetBDResetInfoReq;
import com.huawei.dc.common.components.DCDateChooser;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.AutoProgressDlgForOptix;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.BrowseGroupFileDlg;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ProgressBar;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SoftHarderBootInfo;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.GroupTablePanel;
import com.huawei.dc.taskmgmt.view.common.QueryBoardResetInfoDlg;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.swimap.iview.util.format.TimeFormatService;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class GroupingAtivePanel
extends JPanel {
    private static final long serialVersionUID = 3078937963140331710L;
    private JButton activeGroupButton;
    protected AsnDCDefaultActiveGroupRsp activeGroupRspTemp;
    private JCheckBox activeTimeCheckBoc;
    private JLabel avtiveTimeJLabel;
    private BrowseGroupFileDlg browseGroupFileDlg;
    private JPanel centerPan;
    public String filePath = null;
    private JCheckBox forceParallelActiveChk;
    private JLabel forceParallelActiveLab;
    public GroupTablePanel groupTablePan;
    private JCheckBox confSendtoBoardChk;
    private JLabel confSendtoBoardLab;
    boolean hasWarn = false;
    private boolean isSelectPsBfr;
    private int m_iTaskType = 2;
    private ActivationConfigPara m_oActivateConfigPara = null;
    private JTextField m_oFileTextField;
    protected ProgressBar m_oProgressbar;
    protected AutoProgressDlgForOptix m_oprogressDlg = null;
    private JTable m_oStatisticTable;
    private DefaultTableModel m_oStatisticTableModel;
    protected ITask m_oTask;
    private DCDateChooser m_oTimeTextField = null;
    private String m_strDefaultTImeString = "    -  -     :  :  ";
    private JLabel orderJLabel;
    private JScrollPane oScrollPanl;
    public Calendar oStartimeCal;
    private int PKG_BD_BD = 11;
    private int PKG_BD_MSCC = 1;
    private int PKG_BD_MXC1 = 3;
    private int PKG_BD_SSCC = 2;
    private JLabel remarkJLabel;
    private JButton selectFileButton;
    private JCheckBox selectFileCheckBoc;
    private JLabel selectFileJLabel;
    public Calendar startTime = null;
    private JPanel topPan;
    private int iGroupingAtivePanelSize = 890;
    private int iTopPan = 886;
    private int iGroupTablePan = 836;
    private int iCenterPan = 862;
    private int iOrderLabel = 850;

    public GroupingAtivePanel(int taskType) {
        this.m_iTaskType = taskType;
        this.setLayout(null);
        this.setSize(this.iGroupingAtivePanelSize, 574);
        this.jbInit();
    }

    public GroupingAtivePanel(ITask iTask, ActivationConfigPara oActivateConfigPara, int taskType) {
        this.m_iTaskType = taskType;
        this.m_oTask = iTask;
        this.m_oActivateConfigPara = oActivateConfigPara;
        this.setLayout(null);
        this.setSize(this.iGroupingAtivePanelSize, 574);
        this.jbInit();
    }

    public GroupingAtivePanel(ITask iTask, int taskType) {
        this.m_iTaskType = taskType;
        this.m_oTask = iTask;
        this.setLayout(null);
        this.setSize(this.iGroupingAtivePanelSize, 574);
        this.jbInit();
    }

    public void activeGroupButtonAction() {
    }

    protected void clearActivateTime() {
        if (this.activeTimeCheckBoc.isSelected()) {
            this.activeTimeCheckBoc.setSelected(false);
            this.m_oTimeTextField.setCalendar(null);
        }
    }

    private final int convertBoardType(int iBoardType) {
        iBoardType = this.PKG_BD_SSCC == iBoardType || this.PKG_BD_MSCC == iBoardType ? this.PKG_BD_MSCC : (this.PKG_BD_BD == iBoardType ? this.PKG_BD_SSCC : this.PKG_BD_MXC1);
        return iBoardType;
    }

    private void createCenterPan() {
        this.centerPan = new JPanel();
        this.centerPan.setName("TaskMgmt_GroupingActivePanel_centerPan");
        this.centerPan.setLayout(null);
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), ResourceManager.getInstance().getResString("SET_ACTIVE_ORDER"));
        this.centerPan.setBorder(oBorder);
        if (this.getM_iTaskType() == 0) {
            this.centerPan.setBounds(12, 73, this.iCenterPan, 395);
        } else if (this.getM_iTaskType() == 2 || this.getM_iTaskType() == 1) {
            this.centerPan.setBounds(12, 78, this.iCenterPan, 289);
        }
        this.orderJLabel = new JLabel();
        this.orderJLabel.setBounds(12, 10, this.iOrderLabel, 42);
        String oneRow = ResourceManager.getInstance().getResString("SET_ACTIVE_ORDER_1_NODE_ONE_ROW");
        String strLabel = "<html><body>" + oneRow + "<body></html>";
        this.orderJLabel.setText(strLabel);
    }

    public void createGroupTablePan() {
    }

    private void createTopPan() {
        this.topPan = new JPanel();
        this.topPan.setName("TaskMgmt_GroupingActivePanel_topPan");
        this.topPan.setLayout(new GridBagLayout());
        JPanel oBtnPanel = new JPanel();
        boolean isForcedAndConcurrentActivationType = this.isForcedAndConcurrentActivationType();
        oBtnPanel.setLayout(new FlowLayout(0, 3, 0));
        this.topPan.setBounds(4, 0, this.iTopPan, 77);
        this.remarkJLabel = new JLabel();
        this.remarkJLabel.setText(ResourceManager.getInstance().getResString("GROUPING_ACTIVATION_DIALOG_NOTE"));
        this.initializeTimeComponent();
        this.initializeFileComponent();
        this.initActiveGroupButton();
        if (null != this.m_oTask) {
            oBtnPanel.add(this.activeGroupButton);
            if (this.m_oTask.getTaskTypeId() != 10 && this.m_oTask.getTaskTypeId() != 0 && this.m_oTask.getTaskTypeId() != 1 && this.m_oTask.getTaskTypeId() != 4 && this.m_oTask.getTaskTypeId() != 13 && (this.m_oTask.getTaskTypeId() != 5 || this.m_oTask.getUpgradeLevel() != 1)) {
                oBtnPanel.add(this.selectFileCheckBoc);
                oBtnPanel.add(this.selectFileJLabel);
                oBtnPanel.add(this.m_oFileTextField);
                oBtnPanel.add(this.selectFileButton);
            }
        } else {
            oBtnPanel.add(this.activeGroupButton);
            oBtnPanel.add(this.selectFileCheckBoc);
            oBtnPanel.add(this.selectFileJLabel);
            oBtnPanel.add(this.m_oFileTextField);
            oBtnPanel.add(this.selectFileButton);
        }
        oBtnPanel.add(this.activeTimeCheckBoc);
        oBtnPanel.add(this.avtiveTimeJLabel);
        oBtnPanel.add((Component)((Object)this.m_oTimeTextField));
        this.topPan.add((Component)this.remarkJLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 0, 0), 0, 0));
        this.topPan.add((Component)oBtnPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 1, 0, 0), 0, 0));
        if (isForcedAndConcurrentActivationType) {
            this.topPan.remove(oBtnPanel);
            this.forceParallelActiveLab = new JLabel();
            this.forceParallelActiveLab.setText(ResourceManager.getInstance().getResString("FORCE_PARALLEL_ACTIVE_CHK"));
            this.initParallelActiveChkBox();
            oBtnPanel.add(this.forceParallelActiveChk);
            oBtnPanel.add(this.forceParallelActiveLab);
            if (13 == this.m_oTask.getTaskTypeId() && this.isContainDeleteDBOpr(this.m_oTask)) {
                this.confSendtoBoardLab = new JLabel();
                this.confSendtoBoardLab.setText(ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT"));
                this.initConfSendtoBoardChkBox();
                oBtnPanel.add(this.confSendtoBoardChk);
                oBtnPanel.add(this.confSendtoBoardLab);
                oBtnPanel.setBounds(10, 0, this.iCenterPan, 50);
                this.updateConfSendtoBoardChkByTask(this.m_oTask);
            }
            oBtnPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), DCFrameWorkUtil.getLocalizedString("ACTIVE_CONFIGURE_BORDER")));
            this.topPan.add((Component)oBtnPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 10, 0, 16), 0, 0));
        }
    }

    private void initParallelActiveChkBox() {
        this.forceParallelActiveChk = new JCheckBox();
        this.forceParallelActiveChk.setPreferredSize(new Dimension(17, 18));
        this.forceParallelActiveChk.setSelected(this.isOSSUlActive());
        this.forceParallelActiveChk.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroupingAtivePanel.this.forceParallelActiveChk.isSelected()) {
                    GroupingAtivePanel.this.m_oActivateConfigPara.setoActivationType("OSSU");
                    int iConfirm = DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("FORCE_PARALLEL_ACTIVE_CONFIRM"), DCFrameWorkUtil.getLocalizedString("WARNING"), 0, 2);
                    if (0 == iConfirm) return;
                    GroupingAtivePanel.this.forceParallelActiveChk.setSelected(false);
                    GroupingAtivePanel.this.m_oActivateConfigPara.setoActivationType("");
                    return;
                } else {
                    GroupingAtivePanel.this.m_oActivateConfigPara.setoActivationType("");
                }
            }
        });
        if (this.getM_iTaskType() == 2) {
            this.forceParallelActiveChk.setEnabled(false);
        }
    }

    private void initConfSendtoBoardChkBox() {
        this.confSendtoBoardChk = new JCheckBox();
        this.confSendtoBoardChk.setPreferredSize(new Dimension(17, 18));
        this.confSendtoBoardChk.setSelected(this.m_oActivateConfigPara.isConfSendToBoard());
        this.confSendtoBoardChk.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GroupingAtivePanel.this.confSendtoBoardChk.isSelected()) {
                    GroupingAtivePanel.this.m_oActivateConfigPara.setIsConfSendToBoard(false);
                    int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("CONF_SEND_TO_BOARD"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
                    if (0 == iConfirm) return;
                    GroupingAtivePanel.this.confSendtoBoardChk.setSelected(true);
                    GroupingAtivePanel.this.m_oActivateConfigPara.setIsConfSendToBoard(true);
                    return;
                } else {
                    GroupingAtivePanel.this.confSendtoBoardChk.setSelected(true);
                    GroupingAtivePanel.this.m_oActivateConfigPara.setIsConfSendToBoard(true);
                }
            }
        });
        if (this.getM_iTaskType() == 2) {
            this.confSendtoBoardChk.setEnabled(false);
        }
    }

    public Calendar getActivateTime() {
        if (this.activeTimeCheckBoc.isSelected()) {
            String strTime = this.m_oTimeTextField.getTextField().getText();
            if (0 == Collator.getInstance().compare(strTime, "  /  /       :  :  ")) {
                return null;
            }
            this.startTime = this.m_oTimeTextField.getCalendar(true);
            return this.startTime;
        }
        return null;
    }

    public AsnDCDefaultActiveGroupRsp getActiveGroupRspTemp() {
        return this.activeGroupRspTemp;
    }

    public JCheckBox getActiveTimeCheckBoc() {
        return this.activeTimeCheckBoc;
    }

    public BrowseGroupFileDlg getBrowseGroupFileDlg() {
        return this.browseGroupFileDlg;
    }

    public JTextField getFileTextField() {
        return this.m_oFileTextField;
    }

    public int getM_iTaskType() {
        return this.m_iTaskType;
    }

    public String getPath() {
        return this.filePath;
    }

    public AutoProgressDlgForOptix getProgressDlg() {
        return this.m_oprogressDlg;
    }

    public JCheckBox getSelectFileCheckBoc() {
        return this.selectFileCheckBoc;
    }

    public boolean getThreadStop() {
        return this.m_oProgressbar.getThreadStop();
    }

    public DCDateChooser getTimeTextField() {
        return this.m_oTimeTextField;
    }

    private void initActiveGroupButton() {
        this.activeGroupButton = new JButton();
        this.activeGroupButton.setName("TaskMgmt_GroupingActivePanel_activeGroupButton");
        this.activeGroupButton.setPreferredSize(new Dimension(158, 21));
        this.activeGroupButton.setEnabled(true);
        this.activeGroupButton.setText(ResourceManager.getInstance().getResString("GET_DEFAULT_ACTIVATION_GROUP"));
        this.activeGroupButton.setMnemonic('G');
        this.activeGroupButton.setToolTipText(ResourceManager.getInstance().getResString("GET_DEFAULT_ACTIVATION_GROUP"));
        this.activeGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingAtivePanel.this.activeGroupButtonAction();
            }
        });
    }

    private HashMap<Integer, SoftHarderBootInfo> initBoardTypeMap() {
        HashMap<Integer, SoftHarderBootInfo> oBoardTypeMap = new HashMap<Integer, SoftHarderBootInfo>();
        SoftHarderBootInfo oBootInfo = null;
        for (int i = 1; i < 4; ++i) {
            oBootInfo = new SoftHarderBootInfo();
            oBootInfo.setHarderBootNum(0);
            oBootInfo.setSoftBootNum(0);
            oBoardTypeMap.put(i, oBootInfo);
        }
        return oBoardTypeMap;
    }

    private void initializeFileComponent() {
        this.selectFileJLabel = new JLabel();
        this.selectFileJLabel.setText(ResourceManager.getInstance().getResString("LBL_SELECT_FILES"));
        this.selectFileJLabel.setToolTipText(ResourceManager.getInstance().getResString("LBL_SELECT_FILES_TOOLTIP"));
        this.m_oFileTextField = new JTextField();
        this.m_oFileTextField.setName("TaskMgmt_GroupingActivePanel_m_oFileTextField");
        this.m_oFileTextField.setEditable(false);
        this.m_oFileTextField.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent me) {
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                GroupingAtivePanel.this.m_oFileTextField.setToolTipText(GroupingAtivePanel.this.m_oFileTextField.getText());
            }
        });
        this.selectFileButton = new JButton();
        this.selectFileButton.setName("TaskMgmt_GroupingActivePanel_selectFileButton");
        this.selectFileButton.setText("...");
        this.selectFileButton.setToolTipText(ResourceManager.getInstance().getResString("SELECT_FILE"));
        this.selectFileButton.setEnabled(false);
        this.selectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingAtivePanel.this.selectFileButtonAction();
            }
        });
        this.selectFileCheckBoc = new JCheckBox();
        this.selectFileCheckBoc.setName("TaskMgmt_GroupingActivePanel_selectFileCheckBoc");
        this.selectFileCheckBoc.setSelected(false);
        this.selectFileCheckBoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroupingAtivePanel.this.selectFileCheckBoc.isSelected()) {
                    GroupingAtivePanel.this.selectFileButton.setEnabled(true);
                } else {
                    GroupingAtivePanel.this.selectFileButton.setEnabled(false);
                    GroupingAtivePanel.this.m_oFileTextField.setText("");
                }
            }
        });
        this.m_oFileTextField.setPreferredSize(new Dimension(105, 21));
        this.selectFileButton.setPreferredSize(new Dimension(20, 21));
        this.selectFileCheckBoc.setPreferredSize(new Dimension(17, 21));
    }

    private void initializeTimeComponent() {
        this.avtiveTimeJLabel = new JLabel();
        this.avtiveTimeJLabel.setText(ResourceManager.getInstance().getResString("ACTIVE_TIME_FOR_FIRST"));
        this.m_oTimeTextField = new DCDateChooser();
        this.m_oTimeTextField.setName("TaskMgmt_GroupingActivePanel_m_oTimeTextField");
        this.m_oTimeTextField.setPreferredSize(new Dimension(200, 21));
        this.m_oTimeTextField.setEnabled(false);
        this.m_oTimeTextField.setCalendar(null);
        this.m_strDefaultTImeString = this.m_oTimeTextField.getTextField().getText();
        this.activeTimeCheckBoc = new JCheckBox();
        this.activeTimeCheckBoc.setName("TaskMgmt_GroupingActivePanel_activeTimeCheckBoc");
        this.activeTimeCheckBoc.setPreferredSize(new Dimension(17, 21));
        this.activeTimeCheckBoc.setSelected(false);
        this.activeTimeCheckBoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroupingAtivePanel.this.isSelectPsBfr()) {
                    GroupingAtivePanel.this.showMessage(ResourceManager.getInstance().getResString("PAUSE_AND_SCHEDULED_ACTIVATE_CONFLICT_MSG"));
                    GroupingAtivePanel.this.activeTimeCheckBoc.setSelected(false);
                }
                if (GroupingAtivePanel.this.activeTimeCheckBoc.isSelected()) {
                    GroupingAtivePanel.this.m_oTimeTextField.setEnabled(true);
                    Calendar oCurrentTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
                    GroupingAtivePanel.this.m_oTimeTextField.setCalendar(oCurrentTime);
                } else {
                    GroupingAtivePanel.this.m_oTimeTextField.setEnabled(false);
                    GroupingAtivePanel.this.m_oTimeTextField.setCalendar(null);
                }
                GroupingAtivePanel.this.m_oTimeTextField.updateUI();
            }
        });
    }

    public void initStatisticTable() {
        this.m_oStatisticTable = new JTable();
        Object[] tableColName = new String[]{"", DCFrameWorkUtil.getLocalizedString("MASTER_SLAVE_BOARD"), DCFrameWorkUtil.getLocalizedString("COMMON_BOARD"), DCFrameWorkUtil.getLocalizedString("CROSS_CONNECT_BOARD")};
        Object[][] data = new String[][]{{DCFrameWorkUtil.getLocalizedString("HARD_RESET")}, {DCFrameWorkUtil.getLocalizedString("SOFT_RESET")}};
        this.m_oStatisticTableModel = new DefaultTableModel(data, tableColName);
        this.m_oStatisticTable = new JTable(this.m_oStatisticTableModel){
            private static final long serialVersionUID = -5012582285261919437L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oStatisticTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 7360751483860936090L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setBackground(table.getTableHeader().getBackground());
                this.setText(table.getValueAt(row, column).toString());
                return this;
            }
        });
        this.m_oStatisticTable.getTableHeader().setReorderingAllowed(false);
    }

    private boolean isForcedAndConcurrentActivationType() {
        return this.m_oTask != null && (this.m_oTask.getTaskTypeId() == 4 || this.m_oTask.getTaskTypeId() == 13 || this.m_oTask.getTaskTypeId() == 5 && this.m_oTask.getUpgradeLevel() == 1);
    }

    public boolean isHasWarn() {
        return this.hasWarn;
    }

    private boolean isHaveSupportQueryNe() {
        THashSet<Resource> resList = this.m_oTask.getDeviceType().getResources();
        for (Resource res : resList) {
            int iUpmodeConfig = res.getUpgradeMode();
            if (0 == (iUpmodeConfig & 0x10000)) continue;
            return true;
        }
        return false;
    }

    private boolean isTL1Device() {
        THashSet<Resource> resList = this.m_oTask.getDeviceType().getResources();
        for (Resource res : resList) {
            if (!DeviceInfoUtil.isTL1Dev(res.getDeviceID())) continue;
            return true;
        }
        return false;
    }

    private boolean isOSSUlActive() {
        boolean isOSSU = false;
        if ("OSSU".equals(this.m_oActivateConfigPara.getoActivationType())) {
            isOSSU = true;
        }
        return isOSSU;
    }

    private boolean isSelectLoadOperAndSetPkgFile() {
        List<ITaskDeviceOperation> oSupportedOperationLst = this.m_oTask.getSupportedOperation();
        int iSizeOfLst = oSupportedOperationLst.size();
        for (int i = 0; i < iSizeOfLst; ++i) {
            boolean isSelPkgFile;
            ITaskDeviceOperation oTaskDevOp = oSupportedOperationLst.get(i);
            if (!(oTaskDevOp instanceof LoadSoftwareOperation)) continue;
            LoadSoftwareOperation operation = (LoadSoftwareOperation)oTaskDevOp;
            boolean bl = isSelPkgFile = this.m_oTask.getLoadFileInfoListParam() != null && this.m_oTask.getLoadFileInfoListParam().getLoadFileInfoList().size() != 0;
            if (!operation.isSelected() || !isSelPkgFile) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectPsBfr() {
        return this.isSelectPsBfr;
    }

    protected boolean isSelForceParallelActive() {
        if (null == this.forceParallelActiveChk) {
            return false;
        }
        return this.forceParallelActiveChk.isSelected();
    }

    private boolean isSetQueryBtnEnable() {
        return this.isHaveSupportQueryNe() && this.isSelectLoadOperAndSetPkgFile() && !this.isTL1Device();
    }

    public void jbInit() {
        this.createTopPan();
        this.createCenterPan();
        this.add(this.topPan);
        this.add(this.centerPan);
    }

    private void queryBoradsResetInformation() {
        LoadFileInfoListParam oLoadFileInfoListParam = this.m_oTask.getLoadFileInfoListParam();
        if (null == oLoadFileInfoListParam) {
            DCDebugTracer.trace("DC::GroupingAtivePanel::queryBoradsResetInformation()::oLoadFileInfoListParam == null");
            return;
        }
        List<LoadFileInfo> fileInfoList = oLoadFileInfoListParam.getLoadFileInfoList();
        if (null == fileInfoList || 0 == fileInfoList.size()) {
            DCDebugTracer.trace("DC::GroupingAtivePanel::queryBoradsResetInformation()::fileInfoList is null");
            return;
        }
        THashSet<Resource> resList = this.m_oTask.getDeviceType().getResources();
        if (0 == resList.size()) {
            DCDebugTracer.trace("DC::GroupingAtivePanel::queryBoradsResetInformation()::resList is null");
            return;
        }
        AsnDCGetBDResetInfoReq oGetBDResetInfoReq = new AsnDCGetBDResetInfoReq();
        List<Resource> unSupportQueryRes = this.fillBDResetInfoReq(fileInfoList, resList, oGetBDResetInfoReq);
        if (null == oGetBDResetInfoReq.oAsnBDResetInfoLst || 0 == oGetBDResetInfoReq.oAsnBDResetInfoLst.size()) {
            final QueryBoardResetInfoDlg oQueryDlg = new QueryBoardResetInfoDlg(0, this.m_oTask.getTaskName(), unSupportQueryRes);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oQueryDlg.setVisible(true);
                }
            });
        } else {
            try {
                TaskAsynCommController.getInstance().queryBoardsResetInformation(oGetBDResetInfoReq, this.m_oTask.getTaskName(), unSupportQueryRes);
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(e.getErrorCode())), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
    }

    private List<Resource> fillBDResetInfoReq(List fileInfoList, THashSet<Resource> resList, AsnDCGetBDResetInfoReq oGetBDResetInfoReq) {
        ArrayList<Resource> unSupportQueryRes = new ArrayList<Resource>();
        LoadFileInfo oFirstLoadFileInfo = (LoadFileInfo)fileInfoList.get(0);
        if (0 == oFirstLoadFileInfo.getDeviceId()) {
            for (Resource res : resList) {
                int iUpmodeConfig = res.getUpgradeMode();
                if (0 == (iUpmodeConfig & 0x10000)) {
                    unSupportQueryRes.add(res);
                    continue;
                }
                AsnDCBDResetInfo bdResetInfo = new AsnDCBDResetInfo();
                bdResetInfo.iDevID = BigInteger.valueOf(res.getDeviceID());
                bdResetInfo.strFilePath = oFirstLoadFileInfo.getAbsoluteFilePath().getBytes();
                oGetBDResetInfoReq.oAsnBDResetInfoLst.add((Object)bdResetInfo);
            }
        } else {
            for (int i = 0; i < fileInfoList.size(); ++i) {
                LoadFileInfo oLoadFileInfo = (LoadFileInfo)fileInfoList.get(i);
                boolean isSupportQuery = false;
                for (Resource res : resList) {
                    if (res.getDeviceID() != oLoadFileInfo.getDeviceId()) continue;
                    int iUpmodeConfig = res.getUpgradeMode();
                    if (0 != (iUpmodeConfig & 0x10000)) {
                        isSupportQuery = true;
                        break;
                    }
                    unSupportQueryRes.add(res);
                    break;
                }
                if (!isSupportQuery) continue;
                AsnDCBDResetInfo bdResetInfo = new AsnDCBDResetInfo();
                bdResetInfo.iDevID = BigInteger.valueOf(oLoadFileInfo.getDeviceId());
                bdResetInfo.strFilePath = oLoadFileInfo.getAbsoluteFilePath().getBytes();
                oGetBDResetInfoReq.oAsnBDResetInfoLst.add((Object)bdResetInfo);
            }
        }
        return unSupportQueryRes;
    }

    public void removeFileComponent() {
        this.topPan.remove(this.selectFileCheckBoc);
        this.topPan.remove(this.selectFileJLabel);
        this.topPan.remove(this.m_oFileTextField);
        this.topPan.remove(this.selectFileButton);
        this.topPan.remove(this.activeGroupButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFileButtonAction() {
        try {
            this.browseGroupFileDlg = new BrowseGroupFileDlg();
            if (this.filePath != null && !Collator.getInstance().equals(this.filePath, "")) {
                this.browseGroupFileDlg.getBrowsePanel().setPathFiled(this.filePath, false);
            }
            this.browseGroupFileDlg.setVisible(true);
            if (this.browseGroupFileDlg.isClickOk) {
                this.filePath = this.browseGroupFileDlg.getPath();
                this.m_oFileTextField.setText(this.filePath);
            }
        }
        catch (DCException ex) {
            DCDebugTracer.trace(ex);
        }
        finally {
            if (null != this.browseGroupFileDlg) {
                this.browseGroupFileDlg.setToNull();
                this.browseGroupFileDlg.dispose();
            }
        }
    }

    public void setActiveGroupRspTemp(AsnDCDefaultActiveGroupRsp activeGroupRspTemp) {
        this.activeGroupRspTemp = activeGroupRspTemp;
    }

    public void setBoundsForViewForBoardLevel() {
        this.centerPan.setBounds(12, 78, this.iCenterPan, 239);
        this.groupTablePan.setBounds(12, 55, this.iGroupTablePan, 170);
    }

    public void setBoundsForViewForDevLevel() {
        this.topPan.setBounds(2, 0, this.iTopPan, 52);
        this.groupTablePan.setBounds(12, 66, this.iGroupTablePan, 180);
        this.centerPan.setBounds(12, 53, this.iCenterPan, 261);
    }

    public void setBoundsForViewSimBoardLevel() {
        this.centerPan.setBounds(12, 78, this.iCenterPan, 240);
        this.groupTablePan.setBounds(12, 55, this.iGroupTablePan, 115);
        this.oScrollPanl.setBounds(12, 180, this.iGroupTablePan, 53);
    }

    public void setCheckBoxDisenable() {
        this.selectFileCheckBoc.setEnabled(false);
        this.m_oFileTextField.setEnabled(false);
        this.selectFileButton.setEnabled(false);
        this.selectFileJLabel.setForeground(Color.GRAY);
    }

    public void setDisableAllComp() {
        this.activeTimeCheckBoc.setEnabled(false);
        this.m_oTimeTextField.setEnabled(false);
        this.selectFileCheckBoc.setEnabled(false);
        this.m_oFileTextField.setEnabled(false);
        this.selectFileButton.setEnabled(false);
        this.activeGroupButton.setEnabled(false);
        this.groupTablePan.setViewStatus(true);
    }

    public void setFilePath(String filePath) {
        if (filePath != null) {
            this.selectFileCheckBoc.setSelected(true);
            this.selectFileButton.setEnabled(true);
            this.m_oFileTextField.setText(filePath);
        }
    }

    public void setHasWarn(boolean hasWarn) {
        this.hasWarn = hasWarn;
    }

    public void setOrderJLabelPlaceForBoardLevel() {
        this.centerPan.add(this.orderJLabel);
    }

    public void setOrderJLabelPlaceForDevLevel() {
        String rowInfo = ResourceManager.getInstance().getResString("SET_ACTIVE_ORDER_1_NODE_ROW");
        String strLabel = "<html><body>" + rowInfo + "<body></html>";
        this.orderJLabel.setText(strLabel);
        this.orderJLabel.setSize(this.iOrderLabel, 42);
        this.topPan.remove(this.remarkJLabel);
        this.centerPan.add(this.orderJLabel);
        this.avtiveTimeJLabel.setBounds(37, 20, 100, 21);
        this.m_oTimeTextField.setBounds(145, 20, 200, 21);
        this.activeTimeCheckBoc.setBounds(12, 20, 25, 21);
    }

    public void setSelectPsBfr(boolean isSelectPsBfr) {
        this.isSelectPsBfr = isSelectPsBfr;
    }

    public void setStartTime(Calendar startTime) {
        if (startTime != null) {
            this.activeTimeCheckBoc.setSelected(true);
            this.m_oTimeTextField.setEnabled(true);
            this.m_oTimeTextField.setCalendar(startTime);
        }
    }

    public void setTablePanForBoardLevel() {
        this.groupTablePan.setBounds(12, 50, this.iGroupTablePan, 335);
        if (0 == this.getM_iTaskType()) {
            this.groupTablePan.setBounds(12, 50, this.iGroupTablePan, 335);
        } else {
            this.groupTablePan.setBounds(12, 55, this.iGroupTablePan, 220);
        }
        this.centerPan.add(this.groupTablePan);
    }

    public void setTablePanForDevLevel() {
        this.topPan.setBounds(4, 0, this.iTopPan, 52);
        if (0 == this.getM_iTaskType()) {
            this.centerPan.setBounds(12, 53, this.iCenterPan, 415);
            this.groupTablePan.setBounds(12, 50, this.iGroupTablePan, 350);
        } else {
            this.centerPan.setBounds(12, 53, this.iCenterPan, 312);
            this.groupTablePan.setBounds(12, 66, this.iGroupTablePan, 231);
        }
        if (13 == this.m_oTask.getTaskTypeId() || 4 == this.m_oTask.getTaskTypeId()) {
            boolean isQureyBtnEnable = this.isSetQueryBtnEnable();
            this.groupTablePan.getQueryBtn().setVisible(true);
            this.groupTablePan.getQueryBtn().setEnabled(isQureyBtnEnable);
            this.groupTablePan.getQueryBtn().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupingAtivePanel.this.queryBoradsResetInformation();
                }
            });
        }
        this.centerPan.add(this.groupTablePan);
    }

    public void setTablePanForSimBoardLevel() {
        this.initStatisticTable();
        this.oScrollPanl = new JScrollPane(this.m_oStatisticTable);
        if (0 == this.getM_iTaskType()) {
            this.groupTablePan.setBounds(12, 50, this.iGroupTablePan, 280);
            this.oScrollPanl.setBounds(12, 335, this.iGroupTablePan, 53);
        } else {
            this.groupTablePan.setBounds(12, 55, this.iGroupTablePan, 150);
            this.oScrollPanl.setBounds(12, 220, this.iGroupTablePan, 53);
        }
        this.centerPan.add(this.oScrollPanl);
        this.centerPan.add(this.groupTablePan);
    }

    public void setThreadStop(boolean m_bThreadStop) {
        this.m_oProgressbar.setThreadStop(m_bThreadStop);
    }

    public void setTimeComponentBounds(int x, int y, int width, int high) {
        this.m_oTimeTextField.setBounds(x, y, width, high);
    }

    void showMessage(String strMessage) {
        DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), strMessage);
    }

    private void statisticBoardTypeData(ActiveInfo oActiveInfo, HashMap<Integer, SoftHarderBootInfo> oBoardTypeMap) {
        Vector oActDevInfoList = null;
        Vector<ActiveGroupInfo> oGroupList = oActiveInfo.getGroupList();
        for (ActiveGroupInfo oGroup : oGroupList) {
            oActDevInfoList = oGroup.getActivationInfoLst();
            Vector oBoardList = null;
            for (ActiveDevInfo oActDevInfo : oActDevInfoList) {
                oBoardList = oActDevInfo.getBoardList();
                for (ActiveBoardInfo oBoardInfo : oBoardList) {
                    int hardNum;
                    int iBoardType = oBoardInfo.getBoardType();
                    iBoardType = this.convertBoardType(iBoardType);
                    int activeMode = oBoardInfo.getActiveDeviceMode();
                    if (4 == activeMode) {
                        hardNum = oBoardTypeMap.get(iBoardType).getSoftBootNum();
                        oBoardTypeMap.get(iBoardType).setSoftBootNum(++hardNum);
                        continue;
                    }
                    if (5 != activeMode) continue;
                    hardNum = oBoardTypeMap.get(iBoardType).getHarderBootNum();
                    oBoardTypeMap.get(iBoardType).setHarderBootNum(++hardNum);
                }
            }
        }
    }

    public void updateStatisticTable(ActiveInfo oActiveInfo) {
        if (null == oActiveInfo) {
            return;
        }
        HashMap<Integer, SoftHarderBootInfo> oBoardTypeMap = this.initBoardTypeMap();
        this.statisticBoardTypeData(oActiveInfo, oBoardTypeMap);
        int hardNum = 0;
        int softNum = 0;
        if (null == this.m_oStatisticTable || null == this.m_oStatisticTableModel) {
            return;
        }
        for (int i = 1; i < this.m_oStatisticTable.getColumnCount(); ++i) {
            hardNum = oBoardTypeMap.get(i).getHarderBootNum();
            softNum = oBoardTypeMap.get(i).getSoftBootNum();
            this.m_oStatisticTableModel.setValueAt(hardNum, 0, i);
            this.m_oStatisticTableModel.setValueAt(softNum, 1, i);
        }
        DCFrameWorkUtil.updateUI(this.m_oStatisticTable);
    }

    public ValidationResult validateData() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (this.groupTablePan.getRootNode().getChildCount() == 0) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("DOESNOT_GROUPING_FOR_DEVICES"));
        }
        return oValidationResult;
    }

    public ValidationResult validateFilePath() {
        boolean isEmptyPath;
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        boolean bl = isEmptyPath = this.selectFileCheckBoc.isSelected() && null == this.filePath;
        if (isEmptyPath) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_SELECT_LOAD_CONFIG_PATH"));
        }
        return oValidationResult;
    }

    public ValidationResult validateGroupingPath() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (this.groupTablePan.getRootNode().getChildCount() == 0) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_GROUPING"));
            return oValidationResult;
        }
        if (null != this.m_oTask && this.m_oTask.getHighefficiencyMode() == 1 && null != this.groupTablePan.getRemoveParseGroupLst() && this.groupTablePan.getRemoveParseGroupLst().size() != 0) {
            oValidationResult.setErrorCode(0);
            oValidationResult.setErrorType(5);
            String strErrorMsg = "";
            strErrorMsg = ResourceManager.getInstance().getResString("INFO_HIGH_MODE_REMOVE_ACTIVATE_BREAKPOINT");
            String title = ResourceManager.getInstance().getResString("SUGGESTION");
            String[] columns = new String[]{ResourceManager.getInstance().getResString("SERIAL_NO"), ResourceManager.getInstance().getResString("GROUP_NAME_COLUMN")};
            TaskOperationResultDialog resultDlg = new TaskOperationResultDialog(title, 0, true, columns);
            resultDlg.setMessage(strErrorMsg);
            RowData oRowData = null;
            Vector<Object> rowData = null;
            String sGroupName = "";
            for (int i = 0; i < this.groupTablePan.getRemoveParseGroupLst().size(); ++i) {
                oRowData = this.groupTablePan.getRemoveParseGroupLst().get(i);
                if (null == oRowData) continue;
                sGroupName = oRowData.getGroupName();
                rowData = new Vector<Object>(2);
                rowData.add("" + (i + 1));
                rowData.add(sGroupName);
                resultDlg.addRowInModel(rowData);
            }
            resultDlg.setVisible(true);
        }
        return oValidationResult;
    }

    public ValidationResult validateTaskTime() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (this.activeTimeCheckBoc.isSelected()) {
            if (this.m_oTimeTextField.getTextField().getText().equals(this.m_strDefaultTImeString)) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("ACTIVATION_START_TIME_NULL_MSG"));
            } else {
                oValidationResult = this.validateWithCurrentTime();
            }
        }
        return oValidationResult;
    }

    public ValidationResult validateWithCurrentTime() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        Calendar oCurrentTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
        this.oStartimeCal = Calendar.getInstance();
        this.oStartimeCal = this.m_oTimeTextField.getCalendar(true);
        if (this.oStartimeCal.equals(oCurrentTime) || this.oStartimeCal.before(oCurrentTime)) {
            String sCurrentTime = TimeFormatService.getString((Calendar)oCurrentTime);
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("ACTIVATION_START_TIME_GREATER_CURRENT_TIME", new String[]{sCurrentTime}));
            oValidationResult.setWarningMessage(true);
        }
        return oValidationResult;
    }

    public JCheckBox getConfSendtoBoardChk() {
        return this.confSendtoBoardChk;
    }

    public boolean isDeleteDBOprSelect(ITask oTask) {
        boolean bIsDeleteDBOprSelect = false;
        List<ITaskDeviceOperation> oTaskOpLst = oTask.getSupportedOperation();
        for (int i = 0; i < oTaskOpLst.size(); ++i) {
            ITaskDeviceOperation oTaskDeviceOperation = oTaskOpLst.get(i);
            if (30 != oTaskDeviceOperation.getOperationId()) continue;
            bIsDeleteDBOprSelect = oTaskDeviceOperation.isSelected();
            break;
        }
        return bIsDeleteDBOprSelect;
    }

    public boolean isContainDeleteDBOpr(ITask oTask) {
        boolean bisContainDeleteDBOpr = false;
        List<ITaskDeviceOperation> oTaskOpLst = oTask.getSupportedOperation();
        for (int i = 0; i < oTaskOpLst.size(); ++i) {
            ITaskDeviceOperation oTaskDeviceOperation = oTaskOpLst.get(i);
            if (30 != oTaskDeviceOperation.getOperationId()) continue;
            bisContainDeleteDBOpr = true;
            break;
        }
        return bisContainDeleteDBOpr;
    }

    public void updateConfSendtoBoardChkByTask(ITask oTask) {
        if (!this.isDeleteDBOprSelect(oTask) && null != this.confSendtoBoardChk) {
            if (this.confSendtoBoardChk.isEnabled()) {
                this.m_oActivateConfigPara.setIsConfSendToBoard(false);
            }
            this.confSendtoBoardChk.setEnabled(false);
            this.confSendtoBoardChk.setSelected(false);
        }
    }
}

