/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupRsp;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.RowData;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.CheckBoxOperation;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class GroupTablePanel
extends JPanel {
    protected BaseCommManager m_oCommManager = null;
    public JSortTreeTable m_oTaskTreeTable;
    private transient DCTreeTableModel m_oTaskTreeTableModel;
    private JTree m_oTaskTree;
    private JScrollPane m_oScrollPane;
    private TreeTableNode m_oRootNode;
    private JButton upButton;
    private JButton downButton;
    private JButton newButton;
    private JButton deleteButton;
    private ImageIcon m_oUpIcon;
    private ImageIcon m_oDownIcon;
    private ImageIcon m_oNewIcon;
    private ImageIcon m_oDeleteIcon;
    private ImageIcon m_oExpandIcon;
    private ImageIcon m_oCollapseIcon;
    private JButton expandButton;
    private JButton collapseButton;
    private JButton boardCheckOutButton;
    private ImageIcon boardCheckOutIcon;
    private boolean isViewStatus = false;
    private ITask iTask;
    public int mousePressedRow = -1;
    private int NODE_AREA_X = 40;
    private JPanel m_toolBarPanel;
    private JButton m_queryBtn;
    private JToolBar m_toolBar;
    protected static final int DIRECTION_UP = 0;
    protected static final int DIRECTION_DOWN = 1;
    public boolean m_bIsGroupNodePressed = false;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private int m_iSelectionType = 2;
    private static final int PAUSE_BEFORE_CURRENT_GROUP = 3;
    protected List<com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData> m_oRemoveParseGroupLst = null;

    public GroupTablePanel() {
        this.setLayout(new BorderLayout());
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
        this.jInit();
    }

    public GroupTablePanel(ITask oTask) {
        this.iTask = oTask;
        this.setLayout(new BorderLayout());
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
        this.jInit();
    }

    private void jInit() {
        this.createTreeTable();
        this.initializeMoveButtonComponent();
        this.m_oScrollPane = new JScrollPane((Component)((Object)this.m_oTaskTreeTable));
        this.m_oScrollPane.setName("TaskMgmt_GroupTablePanel_m_oScrollPane");
        this.m_oScrollPane.setBounds(3, 24, 832, 365);
        this.m_toolBar = new JToolBar();
        this.m_toolBar.setName("TaskMgmt_GroupTablePanel_m_toolBar");
        this.m_toolBar.setFloatable(false);
        this.m_toolBar.setRollover(true);
        this.m_toolBar.setMaximumSize(new Dimension(50, 40));
        this.m_toolBar.setMinimumSize(new Dimension(50, 40));
        JSeparator sp1 = new JSeparator(1);
        sp1.setMaximumSize(new Dimension(3, 28));
        sp1.setMinimumSize(new Dimension(3, 28));
        sp1.setPreferredSize(new Dimension(3, 28));
        JSeparator sp2 = new JSeparator(1);
        sp2.setMaximumSize(new Dimension(3, 28));
        sp2.setMinimumSize(new Dimension(3, 28));
        sp2.setPreferredSize(new Dimension(3, 28));
        this.m_toolBar.add(this.newButton);
        this.m_toolBar.add(this.getVerticalSeparator());
        this.m_toolBar.add(this.downButton);
        this.m_toolBar.add(this.upButton);
        this.m_toolBar.add(this.getVerticalSeparator());
        this.m_toolBar.add(this.expandButton);
        this.m_toolBar.add(this.collapseButton);
        this.m_toolBar.add(this.getVerticalSeparator());
        this.m_toolBar.add(this.deleteButton);
        this.m_queryBtn = new JButton(ResourceManager.getInstance().getResString("QUERY_BOARD_RESET_INFO_BTN"));
        this.m_queryBtn.setName("TaskMgmt_GroupTablePanel_m_queryBtn");
        this.m_queryBtn.setVisible(false);
        this.m_toolBarPanel = new JPanel();
        this.m_toolBarPanel.setLayout(new FlowLayout(0));
        this.m_toolBarPanel.add(this.m_toolBar);
        this.m_toolBarPanel.add(this.m_queryBtn);
        this.add((Component)this.m_toolBarPanel, "North");
        this.add((Component)this.m_oScrollPane, "Center");
        Border oBorder = BorderFactory.createEtchedBorder(Color.gray, Color.white);
        this.setBorder(oBorder);
        this.setFocusable(true);
    }

    private JSeparator getVerticalSeparator() {
        JSeparator sp = new JSeparator(1);
        sp.setMaximumSize(new Dimension(3, 28));
        sp.setMinimumSize(new Dimension(3, 28));
        sp.setPreferredSize(new Dimension(3, 28));
        return sp;
    }

    public void populateDeviceInTable(THashSet<Resource> resourceList) {
    }

    public void populateDeviceInTable(AsnDCDefaultActiveGroupRsp oDefaultActivateGroupRsp, THashSet<Resource> resourceList) {
    }

    public void addBoardCheckOutToPanel() {
        this.m_toolBar.add((Component)this.boardCheckOutButton, 1);
    }

    private void initializeMoveButtonComponent() {
        this.m_oUpIcon = ResourceManager.getInstance().getImage("autoupgrade_moveup.gif");
        this.upButton = new JButton("", this.m_oUpIcon);
        this.upButton.setName("TaskMgmt_GroupTablePanel_upButton");
        this.upButton.setBackground(this.getBackground());
        this.upButton.setEnabled(false);
        this.upButton.setToolTipText(ResourceManager.getInstance().getResString("UP"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupTablePanel.this.upButtonAction();
            }
        });
        this.m_oDownIcon = ResourceManager.getInstance().getImage("autoupgrade_movedown.gif");
        this.downButton = new JButton("", this.m_oDownIcon);
        this.downButton.setName("TaskMgmt_GroupTablePanel_downButton");
        this.downButton.setBackground(this.getBackground());
        this.downButton.setEnabled(false);
        this.downButton.setToolTipText(ResourceManager.getInstance().getResString("DOWN"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupTablePanel.this.downButtonAction();
            }
        });
        this.m_oNewIcon = ResourceManager.getInstance().getImage("new_activation_group.gif");
        this.newButton = new JButton("", this.m_oNewIcon);
        this.newButton.setName("TaskMgmt_GroupTablePanel_newButton");
        this.newButton.setBackground(this.getBackground());
        this.newButton.setEnabled(false);
        this.newButton.setToolTipText(ResourceManager.getInstance().getResString("NEW"));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupTablePanel.this.newButtonAction();
                GroupTablePanel.this.updateTableView();
            }
        });
        this.m_oDeleteIcon = ResourceManager.getInstance().getImage("delete.gif");
        this.deleteButton = new JButton("", this.m_oDeleteIcon);
        this.deleteButton.setName("TaskMgmt_GroupTablePanel_deleteButton");
        this.deleteButton.setBackground(this.getBackground());
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText(ResourceManager.getInstance().getResString("DELETE"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupTablePanel.this.deleteButtonAction();
            }
        });
        this.m_oExpandIcon = ResourceManager.getInstance().getImage("expand_tasks.gif");
        this.expandButton = new JButton("", this.m_oExpandIcon);
        this.expandButton.setName("TaskMgmt_GroupTablePanel_expandButton");
        this.expandButton.setBackground(this.getBackground());
        this.expandButton.setEnabled(false);
        this.expandButton.setToolTipText(ResourceManager.getInstance().getResString("EXPAND"));
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupTablePanel.this.expandButtonAction();
            }
        });
        this.m_oCollapseIcon = ResourceManager.getInstance().getImage("collapse_tasks.gif");
        this.collapseButton = new JButton("", this.m_oCollapseIcon);
        this.collapseButton.setName("TaskMgmt_GroupTablePanel_collapseButton");
        this.collapseButton.setBackground(this.getBackground());
        this.collapseButton.setEnabled(false);
        this.collapseButton.setToolTipText(ResourceManager.getInstance().getResString("COLLAPSE"));
        this.collapseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupTablePanel.this.collapseButtonAction();
            }
        });
        this.boardCheckOutIcon = ResourceManager.getInstance().getImage("check_activation_group.gif");
        this.boardCheckOutButton = new JButton("", this.boardCheckOutIcon);
        this.boardCheckOutButton.setName("TaskMgmt_GroupTablePanel_boardCheckOutButton");
        this.boardCheckOutButton.setBackground(this.getBackground());
        this.boardCheckOutButton.setEnabled(false);
        this.boardCheckOutButton.setToolTipText(ResourceManager.getInstance().getResString("CHECK_ACTIVATION_GROUP_INFO"));
        this.boardCheckOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GroupTablePanel.this.boardCheckOutButtonAction();
                    }
                }).start();
            }
        });
    }

    public void boardCheckOutButtonAction() {
    }

    private void expandButtonAction() {
        this.expandAll(this.m_oTaskTree, new TreePath(this.m_oRootNode), true);
    }

    private void collapseButtonAction() {
        this.expandAll(this.m_oTaskTree, new TreePath(this.m_oRootNode), false);
        this.updateTableView();
    }

    public void upButtonAction() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (arrSelectedRows.length == 0) {
            return;
        }
        TreePath oTreePathFirst = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
        TreeTableNode oNodeFirst = (TreeTableNode)oTreePathFirst.getLastPathComponent();
        TreeTableNode parentNodeFirst = (TreeTableNode)oNodeFirst.getParent();
        RowData nodeInfoFirst = (RowData)parentNodeFirst.getUserObject();
        Vector<TreeTableNode> nodeLst = new Vector<TreeTableNode>();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            TreeTableNode parentNode = (TreeTableNode)oNode.getParent();
            RowData nodeInfo = (RowData)parentNode.getUserObject();
            if (nodeInfoFirst.getGroupId() != nodeInfo.getGroupId()) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("DOES_NOT_MOVE_IN_THE_DIFFERENT_GROUP"), ResourceManager.getInstance().getResString("INFO"), 1);
                nodeLst.clear();
                return;
            }
            nodeLst.add(oNode);
        }
        for (int j = 0; j < nodeLst.size(); ++j) {
            TreeTableNode oNode = (TreeTableNode)nodeLst.get(j);
            this.upLeafNode(oNode, parentNodeFirst);
        }
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oTaskTreeTable));
        this.setButtonStatus();
    }

    public void upLeafNode(TreeTableNode oNode, TreeTableNode parentNode) {
    }

    public void downButtonAction() {
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (arrSelectedRows.length == 0) {
            return;
        }
        TreePath oTreePathFirst = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
        TreeTableNode oNodeFirst = (TreeTableNode)oTreePathFirst.getLastPathComponent();
        TreeTableNode parentNodeFirst = (TreeTableNode)oNodeFirst.getParent();
        RowData nodeInfoFirst = (RowData)parentNodeFirst.getUserObject();
        Vector<TreeTableNode> nodeLst = new Vector<TreeTableNode>();
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            TreeTableNode parentNode = (TreeTableNode)oNode.getParent();
            RowData nodeInfo = (RowData)parentNode.getUserObject();
            if (nodeInfoFirst.getGroupId() != nodeInfo.getGroupId()) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("DOES_NOT_MOVE_IN_THE_DIFFERENT_GROUP"), ResourceManager.getInstance().getResString("INFO"), 1);
                nodeLst.clear();
                return;
            }
            nodeLst.add(oNode);
        }
        for (int j = 0; j < nodeLst.size(); ++j) {
            TreeTableNode oNode = (TreeTableNode)nodeLst.get(j);
            this.downLeafNode(oNode, parentNodeFirst);
        }
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oTaskTreeTable));
        this.setButtonStatus();
    }

    public void downLeafNode(TreeTableNode oNode, TreeTableNode parentNode) {
    }

    public void newButtonAction() {
    }

    public void deleteButtonAction() {
        int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("GROUP_DELETE_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutput) {
            return;
        }
        int[] arrSelectedRows = this.m_oTaskTreeTable.getSelectedRows();
        if (arrSelectedRows.length != 1) {
            return;
        }
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(arrSelectedRows[0]);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        TreeTableNode parentNode = (TreeTableNode)oNode.getParent();
        this.removeGroupNode(oNode, parentNode);
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_oTaskTreeTable));
        this.setButtonStatus();
    }

    public void removeGroupNode(TreeTableNode oNode, TreeTableNode parentNode) {
    }

    private void createTreeTable() {
        this.createTreeTableModel();
        this.m_oTaskTreeTable = new JSortTreeTable(this.m_oTaskTreeTableModel);
        this.m_oTaskTreeTable.setName("TaskMgmt_GroupTablePanel_m_oTaskTreeTable");
        this.initializeSelectionSingleModel();
        this.initializeTreeTable();
    }

    private void initializeTreeTable() {
        this.m_oTaskTree = this.m_oTaskTreeTable.getTree();
        this.m_oTaskTree.setName("TaskMgmt_GroupTablePanel_m_oTaskTree");
        this.m_oTaskTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTaskTree.setToggleClickCount(2);
        this.setInitializeTreeTable();
        if (null != this.iTask && 3 == this.iTask.getTaskTypeId()) {
            this.m_oTaskTreeTable.getColumnModel().getColumn(3).setCellRenderer(new OperationSelecCheckBoxRenderer());
            this.m_oTaskTreeTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTaskTreeTable.getSize().width, 28));
            this.m_oTaskTreeTable.getTableHeader().getColumnModel().getColumn(3).setPreferredWidth(120);
            ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
            TableColumn oParseCoulmn = this.m_oTaskTreeTable.getColumnModel().getColumn(3);
            this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, true, this, this.m_oTaskTreeTable.getTableHeader().getBackground());
            oParseCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
        }
        this.m_oTaskTreeTable.getTree().setCellRenderer(new MyTreeCellRenderer());
        this.m_oTaskTreeTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oTaskTreeTable.addKeyListener(this.generateKeyListenerForTable());
        this.m_oTaskTreeTable.addMouseMotionListener(this.generateMotionListenerForTable());
        this.m_oTaskTreeTable.setRowHeight(20);
        this.m_oTaskTreeTable.setShowHorizontalLines(true);
        this.m_oTaskTreeTable.setShowVerticalLines(false);
        this.m_oTaskTreeTable.setColumnSelectionAllowed(false);
        this.m_oTaskTreeTable.setRowSelectionAllowed(false);
    }

    public void setInitializeTreeTable() {
    }

    public void initializeSelectionSingleModel() {
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        oTaskSelection.setSelectionMode(0);
        this.m_oTaskTreeTable.setSelectionModel(oTaskSelection);
    }

    private void createTreeTableModel() {
        String[] strColumnNames = this.getColumnNames();
        Class[] arrColumnTypes = this.getColumnTypes();
        boolean[] arrSortableColumns = this.getSortableColumns();
        boolean[] arrEditableColumns = this.getEditableColumns();
        this.m_oTaskTreeTableModel = new DCTreeTableModel(strColumnNames, arrColumnTypes, arrSortableColumns, arrEditableColumns, this.getMethodNames());
        this.m_oRootNode = this.m_oTaskTreeTableModel.getRoot();
    }

    public String[] getMethodNames() {
        return null;
    }

    public String[] getColumnNames() {
        return null;
    }

    public Class[] getColumnTypes() {
        return null;
    }

    public boolean[] getSortableColumns() {
        return null;
    }

    public boolean[] getEditableColumns() {
        return null;
    }

    public void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != GroupTablePanel.this.m_toolBar) {
                    GroupTablePanel.this.m_toolBar.updateUI();
                }
                GroupTablePanel.this.m_oTaskTreeTable.getTableHeader().updateUI();
                GroupTablePanel.this.m_oTaskTreeTable.updateUI();
                GroupTablePanel.this.updateUI();
            }
        });
    }

    public JSortTreeTable getTaskTreeTable() {
        return this.m_oTaskTreeTable;
    }

    private MouseMotionListener generateMotionListenerForTable() {
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
    }

    private KeyListener generateKeyListenerForTable() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                GroupTablePanel.this.taskTable_KeyPressed(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                GroupTablePanel.this.taskTable_KeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                GroupTablePanel.this.taskTable_KeyPressed(e);
            }
        };
    }

    public void taskTable_KeyPressed(KeyEvent e) {
        if (this.isViewStatus) {
            return;
        }
        this.setButtonStatus();
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                GroupTablePanel.this.taskTable_MousePressed(oMouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent oMouseEvent) {
                GroupTablePanel.this.taskTable_MouseReleased(oMouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                GroupTablePanel.this.taskTable_MouseClicked(oMouseEvent);
            }
        };
    }

    public void taskTable_MousePressed(MouseEvent oMouseEvent) {
        this.mousePressedRow = this.m_oTaskTree.getRowForLocation(this.NODE_AREA_X, oMouseEvent.getY());
        TreePath oTreePath = this.getTaskTreeTable().getTree().getPathForRow(this.mousePressedRow);
        TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        RowData nodeInfo = (RowData)oNode.getUserObject();
        if (nodeInfo.getNodeType() == 1) {
            this.m_bIsGroupNodePressed = true;
        }
    }

    public void taskTable_MouseReleased(MouseEvent oMouseEvent) {
        if (this.m_oRootNode.getChildCount() > 0) {
            this.expandButton.setEnabled(true);
            this.collapseButton.setEnabled(true);
        }
        if (this.isViewStatus) {
            return;
        }
        int row = this.m_oTaskTree.getRowForLocation(this.NODE_AREA_X, oMouseEvent.getY());
        if (!this.m_bIsGroupNodePressed) {
            this.rowToRowTow(row, this.mousePressedRow);
        }
        this.setButtonStatus();
        this.m_bIsGroupNodePressed = false;
    }

    public void rowToRowTow(int row, int mousePressedRow) {
    }

    public void exchangeGroups(int row, int mousePressedRow) {
    }

    public void taskTable_MouseClicked(MouseEvent oMouseEvent) {
    }

    public void setButtonStatus() {
    }

    public TreeTableNode getRootNode() {
        return this.m_oRootNode;
    }

    public void setCellRenderer(JLabel label, Object value) {
    }

    public void setViewStatus(boolean isViewStatus) {
        this.isViewStatus = isViewStatus;
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.newButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        if (null != this.m_oCheckBoxHeader) {
            this.m_oCheckBoxHeader.setEnabled(false);
        }
    }

    public void setUpButtonEnable(boolean isEnable) {
        this.upButton.setEnabled(isEnable);
    }

    public void setDownButtonEnable(boolean isEnable) {
        this.downButton.setEnabled(isEnable);
    }

    public void setNewButtonEnable(boolean isEnable) {
        this.newButton.setEnabled(isEnable);
    }

    public void setDeleteButtonEnable(boolean isEnable) {
        this.deleteButton.setEnabled(isEnable);
    }

    public boolean getViewStatus() {
        return this.isViewStatus;
    }

    public void expandAll(JTree tree, TreePath parent, boolean expand) {
        try {
            TreeTableNode node = (TreeTableNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeTableNode n = (TreeTableNode)e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public JTree getTaskTree() {
        return this.m_oTaskTree;
    }

    public JButton getExpandButton() {
        return this.expandButton;
    }

    public JButton getCollapseButton() {
        return this.collapseButton;
    }

    public JButton getBoardCheckOutButton() {
        return this.boardCheckOutButton;
    }

    public void setPauseBeforeCurrentGroupIndex(int index) {
    }

    public List<com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData> getRemoveParseGroupLst() {
        return this.m_oRemoveParseGroupLst;
    }

    public JButton getQueryBtn() {
        return this.m_queryBtn;
    }

    private void setCheckBoxStatusOnDevRow() {
        boolean bSelected = false;
        switch (this.m_iSelectionType) {
            case 0: {
                bSelected = false;
                break;
            }
            case 1: {
                bSelected = true;
                break;
            }
            case 2: {
                bSelected = true;
                break;
            }
            default: {
                bSelected = false;
            }
        }
        TreeTableNode rootNode = this.getRootNode();
        int devCount = rootNode.getChildCount();
        for (int i = 0; i < devCount; ++i) {
            TreeTableNode devNode = (TreeTableNode)rootNode.getChildAt(i);
            com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData oRowData = (com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData)devNode.getUserObject();
            CheckBoxOperation oCheckBoxOperation = oRowData.getPause();
            if (oCheckBoxOperation.getIsSelect() == bSelected || !oCheckBoxOperation.getIsShow()) continue;
            oCheckBoxOperation.setIsSelect(bSelected);
            oRowData.setPause(oCheckBoxOperation);
            devNode.setUserObject(oRowData);
        }
    }

    private void checkHeadStatus() {
        this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        this.m_oTaskTreeTable.getTableHeader().repaint();
    }

    public int getSelectedType() {
        int iAllPauseEnable = 0;
        int iAlreadySelectedParseCount = 0;
        TreeTableNode rootNode = this.getRootNode();
        int devCount = rootNode.getChildCount();
        iAllPauseEnable = devCount - 1;
        for (int i = 0; i < devCount; ++i) {
            TreeTableNode devNode = (TreeTableNode)rootNode.getChildAt(i);
            com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData oRowData = (com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.RowData)devNode.getUserObject();
            CheckBoxOperation oCheckBoxOperation = oRowData.getPause();
            if (!oCheckBoxOperation.getIsSelect()) continue;
            ++iAlreadySelectedParseCount;
        }
        if (iAllPauseEnable == iAlreadySelectedParseCount && iAlreadySelectedParseCount > 0) {
            this.m_iSelectionType = 0;
        }
        if (iAlreadySelectedParseCount == 0) {
            this.m_iSelectionType = 2;
        }
        if (iAllPauseEnable > iAlreadySelectedParseCount && iAlreadySelectedParseCount > 0) {
            this.m_iSelectionType = 1;
        }
        return this.m_iSelectionType;
    }

    public void refreshTable() {
        this.updateTableView();
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            GroupTablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
            if (!(source instanceof AbstractButton)) {
                return;
            }
            GroupTablePanel.this.setCheckBoxStatusOnDevRow();
            GroupTablePanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            GroupTablePanel.this.refreshTable();
        }
    }

    private class OperationSelecCheckBoxRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -7801680906070352756L;

        public OperationSelecCheckBoxRenderer() {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UIManager.getColor("Table.gridColor")));
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            if (value instanceof CheckBoxOperation) {
                CheckBoxOperation pause = (CheckBoxOperation)value;
                if (pause.getIsShow()) {
                    ImageIcon m_oSelectIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                    if (pause.getIsSelect()) {
                        m_oSelectIcon = ResourceManager.getInstance().getImage("all.gif");
                        this.setIcon(m_oSelectIcon);
                    } else {
                        this.setIcon(m_oSelectIcon);
                    }
                } else {
                    this.setIcon(null);
                    this.setText("");
                }
            } else {
                this.setIcon(null);
                this.setText("");
                this.setBackground(GroupTablePanel.this.m_oTaskTreeTable.getBackground());
            }
            if (bIsSelected) {
                this.setBackground(GroupTablePanel.this.m_oTaskTreeTable.getSelectionBackground());
                this.setForeground(GroupTablePanel.this.m_oTaskTreeTable.getSelectionForeground());
            } else {
                this.setBackground(GroupTablePanel.this.m_oTaskTreeTable.getBackground());
                this.setForeground(GroupTablePanel.this.m_oTaskTreeTable.getForeground());
            }
            GroupTablePanel.this.checkHeadStatus();
            this.updateUI();
            return this;
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -722216620206927123L;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setOpaque(true);
            GroupTablePanel.this.setCellRenderer(this, value);
            if (GroupTablePanel.this.m_oTaskTreeTable.isRowSelected(row)) {
                this.setBackground(GroupTablePanel.this.m_oTaskTreeTable.getSelectionBackground());
                this.setForeground(Color.white);
            } else {
                this.setBackground(GroupTablePanel.this.m_oTaskTreeTable.getBackground());
                this.setForeground(GroupTablePanel.this.m_oTaskTreeTable.getForeground());
            }
            return this;
        }
    }
}

