/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanelToBig;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceSelectionDropDownPanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeButtonInfo;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarModel;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.ITargetVersion;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.ITaskTypeConfiguration;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.taskmgmt.controller.TaskDevSelectionValidationManager;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.SelectTimeAndVersionPanel;
import com.huawei.dc.taskmgmt.view.common.SelectTimeAndVersionPanelToBig;
import com.huawei.dc.taskmgmt.view.common.TaskBasePanel;
import com.huawei.dc.taskmgmt.view.model.TaskMgmtOperationSelecModel;
import com.huawei.dc.taskmgmt.view.modifytask.ModifyWithUpgradeType;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DeviceListPanel
extends TaskBasePanel {
    private static final long serialVersionUID = 1L;
    private ITaskTypeConfiguration m_oTaskTypeConfiguration;
    private SelectTimeAndVersionPanel m_oTimeAndVersionPanel;
    private ComboBoxWithToolTip m_oTargetComboBox;
    private ArrayList m_oTargetVersionlistenerLst = new ArrayList();
    private DeviceSelectionPanel m_oDeviceSelectionPanel;
    private ITask m_oTask;
    private DeviceSelectionDropDownPanel m_oDeviceSelectionDropDownPanel;
    private List<Resource> m_oStackDevList = new ArrayList<Resource>(0);
    private DCModalDialog m_oParendDlg = null;

    public DeviceListPanel(ITask oTask, int iModifyType, DCModalDialog oParendDlg) throws DCException {
        GridBagLayout thisLayout = new GridBagLayout();
        this.setLayout(thisLayout);
        this.m_oTask = oTask;
        this.m_oParendDlg = oParendDlg;
        this.fillStackDeviceList();
        this.getTaskTypeConfiguration();
        this.initTimeAndVersionPanel(oTask, iModifyType);
        DeviceTreeToolBarModel oToolBarModel = this.getToolBarModel(oTask);
        int iTaskTypeId = this.m_oTask.getTaskTypeId();
        if (iTaskTypeId == 7) {
            oTask.setTaskViewType(5);
        }
        this.m_oDeviceSelectionPanel = new DeviceSelectionPanelToBig(this.m_oTask.getIsOffLineTask());
        this.m_oDeviceSelectionPanel.setName("TaskMgmt_DeviceListPanel_m_oDeviceSelectionPanel");
        this.m_oDeviceSelectionPanel.initDeviceSelectionPanel(oToolBarModel, true, false, oTask.getTaskViewType(), iTaskTypeId, this.m_oTimeAndVersionPanel);
        this.m_oDeviceSelectionDropDownPanel = this.m_oDeviceSelectionPanel.getDeviceSelectionDropDownPanel();
        this.setDeviceSelectionProperties(this.m_oDeviceSelectionPanel);
        this.m_oDeviceSelectionPanel.initializePanelForDeviceType(this.m_oTask.getSelectedDeviceType(), this.m_oTask.getTaskTypeId(), iModifyType);
        this.setBoundsForDevice();
        this.add((Component)this.m_oDeviceSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 0, 12), 0, 0));
        int MODIFY_TASK = 2;
        boolean COPY_TASK = true;
        if (iModifyType == 2 || iModifyType == 1) {
            this.m_oDeviceSelectionPanel.enableDeviceDropDowns(false);
        }
        this.add((Component)this.m_oTimeAndVersionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.addListenertoTargetVersionComboBox();
    }

    private void fillStackDeviceList() {
        THashSet<Resource> oResList = this.m_oTask.getDeviceType().getResources();
        for (Resource oRes : oResList) {
            if (3 != oRes.getRoleType()) continue;
            this.m_oStackDevList.add(oRes);
        }
    }

    private void setBoundsForDevice() {
        if (this.m_oTask.getTaskTypeId() != 3 && this.m_oTask.getTaskTypeId() != 5 && this.m_oTask.getTaskTypeId() != 4 && this.m_oTask.getTaskTypeId() != 12 && this.m_oTask.getTaskTypeId() != 13) {
            this.m_oDeviceSelectionPanel.setPreferredSize(new Dimension(670, 345));
            this.m_oDeviceSelectionPanel.setMinimumSize(new Dimension(670, 345));
            this.m_oTimeAndVersionPanel.setPreferredSize(new Dimension(600, 34));
            this.m_oTimeAndVersionPanel.setMinimumSize(new Dimension(600, 34));
        } else {
            this.m_oDeviceSelectionPanel.setPreferredSize(new Dimension(970, 320));
            this.m_oDeviceSelectionPanel.setMinimumSize(new Dimension(970, 320));
            this.m_oTimeAndVersionPanel.setPreferredSize(new Dimension(907, 25));
            this.m_oTimeAndVersionPanel.setMinimumSize(new Dimension(907, 24));
        }
    }

    public ITask getTaskObj() {
        return this.m_oTask;
    }

    private void addListenertoTargetVersionComboBox() {
        this.m_oTargetComboBox = this.m_oTimeAndVersionPanel.getTargetVersionComboBox();
        if (null != this.m_oTask.getTargetVersion()) {
            this.m_oTargetComboBox.setSelectedItem(this.m_oTask.getTargetVersion());
        }
        this.m_oTargetComboBox.setName("TaskMgmt_DeviceListPanel_m_oTargetComboBox");
        this.m_oTargetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                if (null == DeviceListPanel.this.m_oTargetComboBox.getSelectedItem()) {
                    return;
                }
                DeviceListPanel.this.onTargetVersionChange();
            }
        });
    }

    public void onTargetVersionChange() {
        DCDebugTracer.trace("method onTargetVersionChange start");
        String strTargetVersion = "";
        if (null != this.m_oTargetComboBox.getSelectedItem()) {
            strTargetVersion = this.m_oTargetComboBox.getSelectedItem().toString();
        }
        this.m_oTask.setTargetVersion(strTargetVersion);
        if (0 == this.m_oDeviceSelectionPanel.getDeviceTablePanel().getCurrentResources().size()) {
            DCDebugTracer.trace("method onTargetVersionChange end.. resource list is empty.");
            return;
        }
        int iSizeOflst = this.m_oTargetVersionlistenerLst.size();
        for (int i = 0; i < iSizeOflst; ++i) {
            ITargetVersion oTargetVersion = (ITargetVersion)this.m_oTargetVersionlistenerLst.get(i);
            try {
                oTargetVersion.handleTargetVersionChangeNotification(this.m_oTimeAndVersionPanel.isDeviceVersionChanged());
                continue;
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                this.m_oTargetComboBox.setSelectedIndex(this.m_oTargetComboBox.getOldSelectIndex());
                this.m_oTargetComboBox.repaint();
            }
        }
        DCDebugTracer.trace("method onTargetVersionChange end..");
    }

    public void registerForNotification(ITargetVersion oTargetVersion) {
        this.m_oTargetVersionlistenerLst.add(oTargetVersion);
    }

    public void unregisterForNotification(ITargetVersion oTargetVersion) {
        if (null != this.m_oTargetVersionlistenerLst) {
            this.m_oTargetVersionlistenerLst.remove(oTargetVersion);
        }
    }

    public LoadSoftwareOperation getLoadSoftwareOperation() {
        ArrayList oSupportedOperationLst = (ArrayList)this.m_oTask.getSupportedOperation();
        int iCount = oSupportedOperationLst.size();
        Object OperationType = null;
        for (int index = 0; index < iCount; ++index) {
            OperationType = oSupportedOperationLst.get(index);
            if (!(OperationType instanceof LoadSoftwareOperation)) continue;
            return OperationType;
        }
        return null;
    }

    private void getTaskTypeConfiguration() {
        IDeviceXMLConfigModel oDevXMLConfigModel = DeviceXMLConfigModel.getInstance();
        DeviceType oDeviceType = this.m_oTask.getSelectedDeviceType();
        IDeviceTypeConfigModel oDevTypeConfigModel = oDevXMLConfigModel.getDeviceTypeConfigModel(oDeviceType);
        this.m_oTaskTypeConfiguration = oDevTypeConfigModel.getTaskTaskTypeConfiguration();
    }

    private DeviceTreeToolBarModel getToolBarModel(ITask oTask) {
        int iTaskType = oTask.getTaskTypeId();
        DeviceTreeButtonInfo oDeviceButton = null;
        DeviceTreeButtonInfo oSubmapButton = null;
        DeviceTreeButtonInfo oDeviceBoardButton = null;
        DeviceTreeButtonInfo oSubmapBoardButton = null;
        DeviceTreeToolBarModel oButtonModel = new DeviceTreeToolBarModel();
        if (oTask.getTaskTypeId() == 7) {
            return oButtonModel;
        }
        if (oTask.getTaskViewType() == 1 || oTask.getTaskViewType() == 3) {
            oDeviceButton = new DeviceTreeButtonInfo(0, true);
            if (!DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.isShowSubMap()) {
                oSubmapButton = new DeviceTreeButtonInfo(1, true);
            }
            oDeviceBoardButton = new DeviceTreeButtonInfo(2, false);
            oSubmapBoardButton = new DeviceTreeButtonInfo(3, false);
        } else {
            oDeviceButton = new DeviceTreeButtonInfo(0, false);
            if (!DCFrameWorkUtil.getIsSingleClient()) {
                oSubmapButton = new DeviceTreeButtonInfo(1, false);
            }
            oDeviceBoardButton = new DeviceTreeButtonInfo(2, true);
            oSubmapBoardButton = new DeviceTreeButtonInfo(3, true);
        }
        oButtonModel.addButton(oDeviceButton);
        if (this.m_oTaskTypeConfiguration.isSupportBoardLevelTask(iTaskType)) {
            oButtonModel.addButton(oDeviceBoardButton);
        }
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            oButtonModel.addButton(oSubmapButton);
        }
        if (this.m_oTaskTypeConfiguration.isSupportBoardLevelTask(iTaskType)) {
            oButtonModel.addButton(oSubmapBoardButton);
        }
        DeviceTreeButtonInfo oSearchButton = new DeviceTreeButtonInfo(4);
        oButtonModel.addButton(oSearchButton);
        oButtonModel.addVerticalSeperator();
        DeviceTreeButtonInfo oImportButton = new DeviceTreeButtonInfo(6);
        oButtonModel.addButton(oImportButton);
        DeviceTreeButtonInfo oExportButton = new DeviceTreeButtonInfo(7);
        oButtonModel.addButton(oExportButton);
        oButtonModel.addVerticalSeperator();
        DeviceTreeButtonInfo oExpandButton = new DeviceTreeButtonInfo(8);
        oButtonModel.addButton(oExpandButton);
        DeviceTreeButtonInfo oCollapseButton = new DeviceTreeButtonInfo(9);
        oButtonModel.addButton(oCollapseButton);
        return oButtonModel;
    }

    private void initTimeAndVersionPanel(ITask oTask, int iModifyType) throws DCException {
        this.m_oTimeAndVersionPanel = null == oTask.getTaskContentType() ? new SelectTimeAndVersionPanelToBig(oTask, iModifyType) : new ModifyWithUpgradeType(oTask, iModifyType);
        this.m_oTimeAndVersionPanel.populateVersionModel(oTask.getSelectedDeviceType().getDeviceTypeID(), oTask.getSelectedDeviceType().getDeviceTypeVersionID());
        if (null != oTask.getTargetVersion()) {
            this.m_oTimeAndVersionPanel.setVersion(oTask.getTargetVersion());
        }
    }

    private void setDeviceSelectionProperties(DeviceSelectionPanel oDeviceSelectionPanel) {
        if (this.m_oTask.getTaskTypeId() == 3 || this.m_oTask.getTaskTypeId() == 5 || this.m_oTask.getTaskTypeId() == 4 || this.m_oTask.getTaskTypeId() == 12 || this.m_oTask.getTaskTypeId() == 13) {
            oDeviceSelectionPanel.enableDeviceDropDowns(true);
        } else {
            oDeviceSelectionPanel.enableDeviceDropDowns(false);
        }
        oDeviceSelectionPanel.setBounds(12, 12, 900, 545);
    }

    public void validateEntries() {
    }

    protected void showErrorMsg(String errorMessage) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorMessage, ResourceManager.getInstance().getResString("ERROR"), 0);
    }

    @Override
    public String getTaskDialogTitle() {
        return null;
    }

    @Override
    public void initPanelComponent(ITask taskDataObj) throws DCException {
    }

    @Override
    public ValidationResult validateInput() {
        DeviceTree oTree;
        int iSelectedCount;
        ValidationResult oValidateResult = new ValidationResult();
        oValidateResult.setErrorCode(0);
        int taskTypeId = this.m_oTask.getTaskTypeId();
        if (7 != taskTypeId && 0 >= (iSelectedCount = this.m_oDeviceSelectionPanel.getDeviceTablePanel().getDeviceSelectionTable().getSelectedRowCount())) {
            oValidateResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_DEVICES_SELECTED"));
            oValidateResult.setErrorType(1);
            oValidateResult.setErrorCode(-1);
            oValidateResult.setWarningMessage(true);
            return oValidateResult;
        }
        oValidateResult = this.validateDeviceSelection();
        if (0 == oValidateResult.getErrorCode()) {
            oValidateResult = this.validateDeviceUpgradeMode(this.m_oTask);
        }
        if (0 == oValidateResult.getErrorCode()) {
            oValidateResult = this.m_oTimeAndVersionPanel.validateInput();
        }
        if (null != (oTree = this.m_oDeviceSelectionPanel.getDeviceTree())) {
            this.m_oTask.setTaskViewType(oTree.getTreeDescriptor().getViewType());
        }
        return oValidateResult;
    }

    public ValidationResult validateDeviceUpgradeMode(ITask oTask) {
        ValidationResult oValidateResult = new ValidationResult();
        boolean bUpgradeReqd = false;
        boolean bSlaveInfoReqd = false;
        bUpgradeReqd = oTask.isUpdateForSelectDev();
        bSlaveInfoReqd = this.isSlaveInfoReqd();
        if (!oTask.getIsOffLineTask()) {
            THashSet<Resource> oResources = oTask.getDeviceType().getResources();
            Iterator oResItorForGetUpMode = oResources.iterator();
            Resource oResource = null;
            while (oResItorForGetUpMode.hasNext() && !bUpgradeReqd) {
                oResource = (Resource)oResItorForGetUpMode.next();
                if (4368 != oResource.getUpgradeMode()) continue;
                bUpgradeReqd = true;
                break;
            }
        }
        if (bSlaveInfoReqd || bUpgradeReqd) {
            if (bUpgradeReqd && oTask.getIsOffLineTask()) {
                TaskMgmtOperationSelecModel taskMgmtOperationSelecModel = new TaskMgmtOperationSelecModel();
                DeviceType deviceType = oTask.getDeviceType();
                String strDevTypeName = deviceType.getDeviceTypeName();
                String strDevTypeVerName = deviceType.getDeviceTypeVersionName() + "_telnet";
                deviceType.setDeviceTypeVersionName(strDevTypeVerName);
                try {
                    taskMgmtOperationSelecModel.getSupportedOperationLst(oTask, strDevTypeName, strDevTypeVerName, DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(deviceType.getDeviceTypeID(), deviceType.getDeviceTypeVersionID()));
                    THashSet<Resource> resLst = deviceType.getResources();
                    Iterator oResItor = resLst.iterator();
                    Resource res = null;
                    int iUpgradMode = 4368;
                    if (4 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
                        iUpgradMode = 150654;
                    }
                    while (oResItor.hasNext()) {
                        res = (Resource)oResItor.next();
                        res.setUpgradeMode(iUpgradMode);
                    }
                }
                catch (DCException e) {
                    DCDebugTracer.trace(e);
                }
                bUpgradeReqd = false;
            }
            TaskDevSelectionValidationManager oTaskDevSelMag = new TaskDevSelectionValidationManager();
            oValidateResult = oTaskDevSelMag.validateDeviceSelection(oTask, bUpgradeReqd, bSlaveInfoReqd, this.m_oParendDlg);
        }
        if (0 == oValidateResult.getErrorCode()) {
            this.updateStackList(oTask);
        }
        this.updateTaskForStackDevice(oTask);
        return oValidateResult;
    }

    private void updateTaskForStackDevice(ITask oTask) {
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        THashSet oAddedResLst = new THashSet();
        for (Resource oRes : oResList) {
            if (3 != oRes.getRoleType()) continue;
            for (int i = 0; i < this.m_oStackDevList.size(); ++i) {
                if (oRes.getDeviceID() != this.m_oStackDevList.get(i).getDeviceID() || -1 == this.m_oStackDevList.get(i).getStackId() || oResList.contains((Object)this.m_oStackDevList.get(i))) continue;
                oAddedResLst.add((Object)this.m_oStackDevList.get(i));
            }
        }
        if (!oAddedResLst.isEmpty()) {
            oResList.addAll((Collection)oAddedResLst);
        }
    }

    private void updateStackList(ITask oTask) {
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        for (Resource oRes : oResList) {
            if (3 != oRes.getRoleType() || this.m_oStackDevList.contains(oRes)) continue;
            this.m_oStackDevList.add(oRes);
        }
    }

    private boolean isSlaveInfoReqd() {
        boolean isSlaveReqd = false;
        THashSet<Resource> oResList = this.m_oTask.getDeviceType().getResources();
        for (Resource oRes : oResList) {
            if (3 != oRes.getRoleType() || this.m_oStackDevList.contains(oRes)) continue;
            isSlaveReqd = true;
            break;
        }
        return isSlaveReqd;
    }

    public void updateDeviceSelection() {
        this.m_oTask.setTempDevTypeForUpgardeModel(this.m_oTask.getDeviceType());
        this.m_oTask.setDeviceType(this.getSelectDeviceDataModelForALL());
        this.updateTaskForStackDevice(this.m_oTask);
    }

    private ValidationResult validateDeviceSelection() {
        ValidationResult oValidResult = new ValidationResult();
        oValidResult.setErrorCode(0);
        oValidResult = DeviceInfoManagerImpl.getInstance().validateDeviceSelection(this.m_oDeviceSelectionPanel, this.m_oTask, null);
        if (oValidResult.getErrorCode() == 0) {
            this.m_oTask.setTempDevTypeForUpgardeModel(this.m_oTask.getDeviceType());
            this.m_oTask.setDeviceType(this.getSelectDeviceDataModelForALL());
            this.updateTaskForStackDevice(this.m_oTask);
        }
        return oValidResult;
    }

    private DeviceType getSelectDeviceDataModelForALL() {
        DeviceTypeInfo oDevTypeInfo = this.m_oDeviceSelectionDropDownPanel.getSelectedDeviceType();
        THashSet<Resource> resList = this.m_oDeviceSelectionPanel.getDeviceTablePanel().getCurrentResources();
        DeviceType oDeviceType = new DeviceType();
        oDeviceType.setDeviceTypeID(oDevTypeInfo.getDevTypeID());
        oDeviceType.setDeviceTypeVersionID(oDevTypeInfo.getDevTypeVersionId());
        oDeviceType.setDeviceTypeName(oDevTypeInfo.getDevTypeName());
        oDeviceType.setDeviceTypeVersionName(oDevTypeInfo.getDevTypeVersionName());
        oDeviceType.setResources(resList);
        int allDevTypeId = -1;
        int allDevTypeVersionId = -1;
        if (oDevTypeInfo.getDevTypeID() == allDevTypeId && oDevTypeInfo.getDevTypeVersionId() == allDevTypeVersionId) {
            Resource res;
            DeviceInfo devInfo;
            DeviceTypeInfo devTypeInfo;
            IDeviceInfoManager deviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
            if (null != resList && resList.size() > 0 && null != (devTypeInfo = (devInfo = deviceInfoManager.getDevice((res = (Resource)resList.iterator().next()).getDeviceID())).getDeviceTypeInfo())) {
                oDeviceType.setDeviceTypeID(devTypeInfo.getDevTypeID());
                oDeviceType.setDeviceTypeVersionID(devTypeInfo.getDevTypeVersionId());
                oDeviceType.setDeviceTypeName(devTypeInfo.getDevTypeName());
                oDeviceType.setDeviceTypeVersionName(devTypeInfo.getDevTypeVersionName());
            }
        }
        return oDeviceType;
    }

    public ComboBoxWithToolTip getTargetVersionComboBox() {
        return this.m_oTargetComboBox;
    }

    public void dispose() {
        if (this.m_oDeviceSelectionDropDownPanel != null) {
            this.m_oDeviceSelectionDropDownPanel = null;
        }
        if (this.m_oTaskTypeConfiguration != null) {
            this.m_oTaskTypeConfiguration = null;
        }
        if (this.m_oTimeAndVersionPanel != null) {
            this.m_oTimeAndVersionPanel.dispose();
            this.m_oTimeAndVersionPanel = null;
        }
        if (this.m_oTargetComboBox != null) {
            this.m_oTargetComboBox.removeAllItems();
            this.m_oTargetComboBox = null;
        }
        if (this.m_oTargetVersionlistenerLst != null) {
            this.m_oTargetVersionlistenerLst.clear();
            this.m_oTargetVersionlistenerLst = null;
        }
        if (this.m_oDeviceSelectionPanel != null) {
            this.m_oDeviceSelectionPanel.disposePanel();
            this.m_oDeviceSelectionPanel = null;
        }
        if (this.m_oTask != null) {
            this.m_oTask = null;
        }
        DCCleanupUtil.cleanUpPanel(this);
    }

    public DeviceSelectionPanel getDeviceSelectionPanel() {
        return this.m_oDeviceSelectionPanel;
    }
}

