/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResourceLst;
import com.huawei.dc.common.components.deviceselection.dropdown.DeviceSelectionDropDownPanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.sam.event.SAMChangeEventReceiver;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.HighEfficiencyModePanel;
import com.huawei.dc.taskmgmt.view.common.TaskBasePanel;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.huawei.dc.taskmgmt.view.createtask.CreateTaskDeviceSelectionPanel;
import com.huawei.dc.taskmgmt.view.createtask.TaskConfirmationPanel;
import com.huawei.dc.taskmgmt.view.createtask.TaskDevSelecPanelWithUpgradeType;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreateTaskDialog
extends DCModalDialog
implements IDeviceConfigChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final int COL_DEV_IP_ADDRESS = 3;
    private static boolean isProxied = false;
    private static boolean isCreatingTask = false;
    private static final Dimension BUTTON_DIMENSION = new Dimension(100, 21);
    private JPanel m_oContentPane = null;
    private JPanel m_oMainPanel = null;
    private JPanel m_oStepPanel = null;
    private JPanel m_oBtnPanel = null;
    private JPanel m_oRadioButtonPanel = null;
    private JLabel m_oStepLabel = null;
    private JButton m_PreButton = null;
    private JButton m_NextButton = null;
    private JButton m_OkButton = null;
    private JButton m_CancelButton = null;
    private ArrayList<TaskBasePanel> arrPanelList = new ArrayList();
    private int iCurrentStep = 0;
    private ResourceManager m_ResourceMgnr = null;
    protected final int MIN_PANEL_WIDTH = 770;
    protected final int MAX_PANEL_HEIGHT = 529;
    private int iTotalStep = 0;
    private ITask m_oTaskDataObj = null;
    private String m_strHelpFileName;

    public CreateTaskDialog(ITask oTaskDataObj) {
        DCFrameWorkUtil.setIsNeedToSendCmdCode(true);
        isCreatingTask = true;
        this.m_ResourceMgnr = ResourceManager.getInstance();
        this.m_oTaskDataObj = oTaskDataObj;
        this.initialize();
    }

    public CreateTaskDialog() {
    }

    public static boolean isCreatingTask() {
        return isCreatingTask;
    }

    public static boolean isProxied() {
        return isProxied;
    }

    public static void setProxied(boolean isProxied) {
        CreateTaskDialog.isProxied = isProxied;
    }

    public TaskBasePanel getPanel(int num) {
        if (num >= 0 && num <= this.arrPanelList.size() - 1 && this.arrPanelList.size() > 0) {
            return this.arrPanelList.get(num);
        }
        return null;
    }

    public void addPanel(TaskBasePanel basePanel) {
        this.arrPanelList.add(basePanel);
        if (basePanel instanceof TaskMgmtOperationSelecPanel) {
            ((TaskMgmtOperationSelecPanel)basePanel).setParentDlg(this);
        }
        if (this.arrPanelList.size() == 1) {
            this.setCurrentPanel(basePanel);
        }
        ++this.iTotalStep;
    }

    public void show() {
        this.setStepTitle();
        this.getPreButton().setEnabled(false);
        if (this.arrPanelList.size() == 1) {
            this.getPreButton().hide();
            this.getNextButton().hide();
            this.getOkButton().setEnabled(true);
        } else if (this.arrPanelList.size() < 1) {
            this.m_oStepLabel.hide();
            this.getPreButton().hide();
            this.getNextButton().hide();
            this.getOkButton().hide();
        } else {
            this.getNextButton().setEnabled(true);
            this.getOkButton().setEnabled(false);
        }
        super.show();
    }

    public void previewAction() {
        if (this.iCurrentStep - 1 < 0) {
            this.iCurrentStep = 0;
            return;
        }
        --this.iCurrentStep;
        if (this.iCurrentStep == 0) {
            this.m_PreButton.setEnabled(false);
        }
        this.m_OkButton.setEnabled(false);
        this.m_NextButton.setEnabled(true);
        this.setStepTitle();
        this.setCurrentPanel(this.getPanel(this.iCurrentStep));
    }

    public boolean isSelectedHighEfficiency() {
        JCheckBox cbo = new HighEfficiencyModePanel(this.m_oTaskDataObj).getHighefficiencyModeCheckbox();
        return cbo.isSelected();
    }

    public void nextAction() {
        DCDebugTracer.trace("DC::CreateTaskDialog::nextAction start");
        DCDebugTracer.trace("DC::CreateTaskDialog::CurrentStep:" + this.iCurrentStep);
        if (this.iCurrentStep + 1 > this.arrPanelList.size() - 1) {
            this.iCurrentStep = this.arrPanelList.size() - 1;
            DCDebugTracer.trace("CreateTaskDialog::nextAction end.. (iCurrentStep + 1) > (arrPanelList.size() - 1)");
            return;
        }
        ValidationResult validateInput = this.getPanel(this.iCurrentStep).validateInput();
        if (1 == this.iCurrentStep && TaskSrcDstVersionCheck.getInstance().getTaskTypeinfoIsUpgradeOrDowngrade(this.m_oTaskDataObj.getTaskTypeId()) && TaskSrcDstVersionCheck.getInstance().getbValDesVerFail()) {
            DCDebugTracer.trace("CreateTaskDialog::nextAction Validate DestinationVersion Failed");
            if (TaskSrcDstVersionCheck.getInstance().getbSendCmdVerFail()) {
                TaskSrcDstVersionCheck.getInstance().setbSendCmdFail(false);
                this.showErrorMsgDlg(ResourceManager.getInstance().getResString("SEND_FAIL"));
            }
            TaskSrcDstVersionCheck.getInstance().setbValDesVerFail(false);
            return;
        }
        if (null != validateInput && 4 == validateInput.getErrorType()) {
            DCDebugTracer.traceStack();
            DCDebugTracer.trace("CreateTaskDialog::nextAction end.. ValidationResult.NONE == validateInput.getErrorType()");
            return;
        }
        boolean isProxied = this.checkIsProxiedDevice();
        boolean b = false;
        if (this.iCurrentStep == 0) {
            CreateTaskDialog.setProxied(isProxied);
        } else if (this.iCurrentStep == 1) {
            b = true;
        }
        boolean bReturn = false;
        if (validateInput != null && validateInput.getErrorCode() != 0 && validateInput.isWarningMessage()) {
            this.showWarningMsgDlg(validateInput.getErrorMessage());
            return;
        }
        bReturn = validateInput != null && validateInput.getErrorCode() != 0 && !validateInput.isWarningMessage() ? this.processValidationResult(validateInput) : this.confThirdFTP(b, isProxied);
        if (bReturn) {
            return;
        }
        if (this.iCurrentStep == 0 && isProxied) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("PROXY_DEVICE_WAS_SELECTED_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
        }
        ++this.iCurrentStep;
        if (2 == this.iCurrentStep) {
            List<ITaskDeviceOperation> m_oTaskOprList = this.m_oTaskDataObj.getSupportedOperation();
            for (int i = 0; i < m_oTaskOprList.size(); ++i) {
                ITaskDeviceOperation oTaskDeviceOperation = m_oTaskOprList.get(i);
                if (!(oTaskDeviceOperation instanceof LoadSoftwareOperation)) continue;
                if (!oTaskDeviceOperation.isSelected()) break;
                LoadSoftwareOperation oLoadSoftwareOperation = (LoadSoftwareOperation)oTaskDeviceOperation;
                LoadFileInfoListParam oLoadFileInfoListParam = (LoadFileInfoListParam)oLoadSoftwareOperation.getConfiguredPara();
                Component m_oLoadSimulationPackageView = oLoadSoftwareOperation.getLoadSimulationPackageView();
                if (oLoadFileInfoListParam != null && oLoadFileInfoListParam.getLoadFileInfoList().size() > 0 || m_oLoadSimulationPackageView != null) break;
                --this.iCurrentStep;
                return;
            }
        }
        if (this.iCurrentStep == this.arrPanelList.size() - 1) {
            this.m_OkButton.setEnabled(true);
            this.m_NextButton.setEnabled(false);
        }
        this.m_PreButton.setEnabled(true);
        this.setStepTitle();
        this.setCurrentPanel(this.getPanel(this.iCurrentStep));
        DCDebugTracer.trace("DC::CreateTaskDialog::CurrentStep:" + this.iCurrentStep);
        DCDebugTracer.trace("DC::CreateTaskDialog::nextAction end..");
    }

    public boolean confThirdFTP(boolean b, boolean isProxied) {
        String strServerName;
        boolean bReturn = false;
        if (b && isProxied && null != DCFrameWorkUtil.getTaskMgmtOperationSelecPanel() && DCFrameWorkUtil.getTaskMgmtOperationSelecPanel().isSettingThridFTP() && "".equals(strServerName = this.m_oTaskDataObj.getThirdPartyServerName())) {
            int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("PROXY_DEVICE_USING_THIRD_PARTY_FTP_FOR_BACKUP_AND_LOAD_CONFIRM_MSG"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
            if (0 == iConfirm) {
                SystemSettingDlg oSystemSettingDlg = new SystemSettingDlg();
                oSystemSettingDlg.setTabSelectedIndex(oSystemSettingDlg.getBoardTabIndex());
                oSystemSettingDlg.setVisible(true);
                strServerName = this.m_oTaskDataObj.getThirdPartyServerName();
                if ("".equals(strServerName)) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CHECK_NOT_SET_THRID_FTP_FOR_UPGRADE_TASK"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    bReturn = true;
                    return bReturn;
                }
            } else {
                bReturn = true;
                return bReturn;
            }
        }
        return bReturn;
    }

    public boolean processValidationResult(ValidationResult validateInput) {
        boolean bReturn = false;
        if (1 == validateInput.getErrorType()) {
            if (this.m_oTaskDataObj.getDeviceType() != null) {
                if (this.m_oTaskDataObj.isThirdPartySupported()) {
                    if (this.m_oTaskDataObj.getDeviceType().getDeviceDomain() != 4) {
                        DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("FTO_IS_NOT_RUNNING"), ResourceManager.getInstance().getResString("ERROR"), 0);
                    }
                } else {
                    this.showInfoMsgDlg(validateInput.getErrorMessage());
                }
            } else {
                this.showInfoMsgDlg(validateInput.getErrorMessage());
            }
            bReturn = true;
            return bReturn;
        }
        if (3 == validateInput.getErrorType()) {
            if (0 != this.showConfirmMsgDlg(validateInput.getErrorMessage())) {
                bReturn = true;
                return bReturn;
            }
        } else {
            if (5 == validateInput.getErrorType()) {
                DCDebugTracer.traceStack();
                DCDebugTracer.trace("CreateTaskDialog::nextAction ValidationResult.RETURN == validateInput.getErrorType()");
                bReturn = true;
                return bReturn;
            }
            this.showErrorMsgDlg(validateInput.getErrorMessage());
            bReturn = true;
            return bReturn;
        }
        if (this.getPanel(this.iCurrentStep) instanceof TaskMgmtOperationSelecPanel) {
            this.getPanel(this.iCurrentStep);
            List<ITaskDeviceOperation> operList = this.m_oTaskDataObj.getSupportedOperation();
            for (ITaskDeviceOperation oTaskOp : operList) {
                int iConfirm;
                if (2 != this.m_oTaskDataObj.getTaskTypeId() || !(oTaskOp instanceof ActivationOperation) || !oTaskOp.isSelected() || 0 == (iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SELECT_ACTIVATION_CONFIRM"), ResourceManager.getInstance().getResString("CONFIRM"), 0))) continue;
                bReturn = true;
                return bReturn;
            }
        }
        return bReturn;
    }

    public void cancelAction() {
        this.closeDialog();
    }

    public void okAction() {
        this.m_OkButton.setEnabled(false);
        final SimpleProgressDlg m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("NEW_TASK_PROGRESS"), true, this, ResourceManager.getInstance().getResString("GETTING_NEW_TASK_PROGRESS"), true){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelButtonActionPerformed() {
                this.dispose();
            }
        };
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CreateTaskDialog.this.updateDataOperation();
                    ArrayList<Resource> deleteNeList = new ArrayList<Resource>(0);
                    for (Resource res : CreateTaskDialog.this.m_oTaskDataObj.getDeviceType().getResources()) {
                        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(res.getDeviceID());
                        if (oDeviceInfo != null) continue;
                        deleteNeList.add(res);
                    }
                    if (deleteNeList.size() > 0) {
                        String strOperationResultTitle = ResourceManager.getInstance().getResString("TASK_REPORT_OPERATION_RESULT");
                        TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strOperationResultTitle, 1, true){
                            private static final long serialVersionUID = -1223255311071915218L;

                            @Override
                            protected void closeDialog() {
                                this.doCleanUp();
                                DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
                                this.dispose();
                                m_oValidationProgressDlg.dispose();
                                CreateTaskDialog.this.m_OkButton.setEnabled(true);
                                CreateTaskDialog.this.cancelAction();
                            }
                        };
                        oDlg.setMessage(ResourceManager.getInstance().getResString("CREATE_TASK_FAILED"));
                        for (Resource res : deleteNeList) {
                            String resName = res.getDeviceName() + "(" + res.getDeviceIP() + ")";
                            oDlg.addRowInModel(resName, ResourceManager.getInstance().getResString("NO_DEVICE_FOUND"));
                        }
                        DCDebugTracer.trace("contains deleted device in task, create task failed.");
                        oDlg.setVisible(true);
                    }
                    TaskSyncCommController.getInstance().createTask(CreateTaskDialog.this.m_oTaskDataObj, 43872);
                }
                catch (DCException e) {
                    DCDebugTracer.trace(e);
                    if (null == e.getDetail()) {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                    } else if (e.getDetail() instanceof AsnTaskResourceLst) {
                        AsnTaskResourceLst resourceList = (AsnTaskResourceLst)e.getDetail();
                        if (0 < resourceList.size()) {
                            String strOperationResultTitle = ResourceManager.getInstance().getResString("TASK_REPORT_OPERATION_RESULT");
                            TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strOperationResultTitle, 1, true);
                            oDlg.setMessage(ResourceManager.getInstance().getResString("CREATE_TASK_FAILED"));
                            int length = resourceList.size();
                            String errorMsg = e.getMessage();
                            AsnTaskResource asnRes = null;
                            THashSet<Resource> oResList = CreateTaskDialog.this.m_oTaskDataObj.getDeviceType().getResources();
                            for (int i = 0; i < length; ++i) {
                                asnRes = (AsnTaskResource)resourceList.get(i);
                                for (Resource res : oResList) {
                                    if (asnRes.iDeviceId.intValue() != res.getDeviceID()) continue;
                                    String resName = res.getDeviceName() + "(" + res.getDeviceIP() + ")";
                                    oDlg.addRowInModel(resName, errorMsg);
                                }
                            }
                            m_oValidationProgressDlg.dispose();
                            CreateTaskDialog.this.m_OkButton.setEnabled(true);
                            oDlg.setVisible(true);
                        }
                    } else {
                        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                    }
                    DCDebugTracer.traceError(e.getMessage());
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                    DCDebugTracer.trace("DC::CreateTaskDialog::cancelAction::throw exception::" + e.getMessage());
                    m_oValidationProgressDlg.dispose();
                    CreateTaskDialog.this.m_OkButton.setEnabled(true);
                    return;
                }
                CreateTaskDialog.this.m_oTaskDataObj.setTemporaryLoadSimPackageInfo(null);
                m_oValidationProgressDlg.dispose();
                CreateTaskDialog.this.closeDialog();
            }
        }).start();
        m_oValidationProgressDlg.setVisible(true);
    }

    private void updateDataOperation() {
        String strTargetVersion = this.m_oTaskDataObj.getTargetVersion();
        if (null == strTargetVersion || 0 == strTargetVersion.length()) {
            List<ITaskDeviceOperation> oTaskDevOpLst = this.m_oTaskDataObj.getSupportedOperation();
            for (int i = 0; i < oTaskDevOpLst.size(); ++i) {
                ITaskDeviceOperation oTaskDevOp = oTaskDevOpLst.get(i);
                if (oTaskDevOp.getOperationId() != 5) continue;
                oTaskDevOp.setEnabled(false);
            }
        }
    }

    public int getTotalStep() {
        return this.iTotalStep;
    }

    private void showWarningMsgDlg(String strErrorMessage) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrorMessage, ResourceManager.getInstance().getResString("SUGGESTION"), 1);
    }

    private void showInfoMsgDlg(String strErrorMessage) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrorMessage, ResourceManager.getInstance().getResString("SUGGESTION"), 1);
    }

    private int showConfirmMsgDlg(String strMessage) {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), strMessage, ResourceManager.getInstance().getResString("CONFIRM"), 0);
        return iConfirm;
    }

    private void showErrorMsgDlg(String errorMessage) {
        if (null == errorMessage) {
            return;
        }
        DCOptionPane.showMessageDialog((Component)((Object)this), errorMessage, ResourceManager.getInstance().getResString("ERROR"), 0);
    }

    private JPanel getMainPanel() {
        if (this.m_oMainPanel == null) {
            this.m_oStepLabel = new JLabel("", 4);
            this.m_oStepLabel.setPreferredSize(new Dimension(165, 20));
            this.m_oStepLabel.setMinimumSize(new Dimension(165, 20));
            this.m_oMainPanel = new JPanel();
            GridBagLayout mainLayout = new GridBagLayout();
            this.m_oMainPanel.setLayout(mainLayout);
            this.m_oMainPanel.add((Component)this.m_oStepLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 10, 0, 12), 0, 0));
            this.m_oMainPanel.add((Component)this.getStepPanel(), new GridBagConstraints(0, 0, 6, 8, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.m_oMainPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(5, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 12), 0, 0));
        }
        return this.m_oMainPanel;
    }

    private JPanel getButtonPanel() {
        if (null == this.m_oBtnPanel) {
            this.m_oBtnPanel = new JPanel();
            this.m_oBtnPanel.setPreferredSize(new Dimension(440, 35));
            this.m_oBtnPanel.setMinimumSize(new Dimension(440, 35));
            GridBagLayout btnLayout = new GridBagLayout();
            this.m_oBtnPanel.setLayout(btnLayout);
            this.m_oBtnPanel.add((Component)this.getCancelButton(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 4, 12, 0), 0, 0));
            this.m_oBtnPanel.add((Component)this.getOkButton(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 4, 12, 0), 0, 0));
            this.m_oBtnPanel.add((Component)this.getNextButton(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 4, 12, 0), 0, 0));
            this.m_oBtnPanel.add((Component)this.getPreButton(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 4, 12, 0), 0, 0));
        }
        return this.m_oBtnPanel;
    }

    private JPanel getJContentPane() {
        if (this.m_oContentPane == null) {
            GridBagLayout gridLayout = new GridBagLayout();
            this.m_oContentPane = new JPanel();
            this.m_oContentPane.setLayout(gridLayout);
            this.m_oContentPane.add((Component)this.getMainPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.m_oContentPane;
    }

    private JPanel getStepPanel() {
        if (this.m_oStepPanel == null) {
            this.m_oStepPanel = new JPanel();
            GridBagLayout stepLayout = new GridBagLayout();
            stepLayout.rowWeights = new double[]{0.1};
            stepLayout.columnWeights = new double[]{0.1};
            this.m_oStepPanel.setLayout(stepLayout);
            this.m_oStepPanel.setPreferredSize(new Dimension(612, 362));
            this.m_oStepPanel.setMinimumSize(new Dimension(612, 362));
        }
        return this.m_oStepPanel;
    }

    private void setCurrentPanel(TaskBasePanel currentPanel) {
        this.m_oStepPanel.removeAll();
        this.refreshDialog();
        if (currentPanel != null) {
            try {
                currentPanel.initPanelComponent(this.m_oTaskDataObj);
                this.setTitle(currentPanel.getTaskDialogTitle());
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("Error"), 0);
                DCDebugTracer.trace("DC::CreateTaskDialog::setCurrentPanel::throw exception::" + e.getMessage());
                this.previewAction();
            }
            currentPanel.setPreferredSize(new Dimension(612, 362));
            currentPanel.setMinimumSize(new Dimension(612, 362));
            int iYAxis = 1;
            if (!(this.m_oTaskDataObj.getTaskTypeId() != 0 && this.m_oTaskDataObj.getTaskTypeId() != 1 && this.m_oTaskDataObj.getTaskTypeId() != 5 && this.m_oTaskDataObj.getTaskTypeId() != 12 && this.m_oTaskDataObj.getTaskTypeId() != 4 && this.m_oTaskDataObj.getTaskTypeId() != 13 || currentPanel instanceof TaskMgmtOperationSelecPanel || currentPanel instanceof TaskConfirmationPanel)) {
                iYAxis = 0;
            }
            Insets oInsets = new Insets(0, 0, 0, 0);
            if (currentPanel instanceof TaskMgmtOperationSelecPanel) {
                oInsets = new Insets(25, 0, 0, 0);
            }
            this.m_oStepPanel.add((Component)currentPanel, new GridBagConstraints(0, iYAxis, 1, 1, 1.0, 1.0, 10, 1, oInsets, 0, 0));
        }
        this.m_oStepPanel.requestFocus();
        this.refreshDialog();
    }

    private void refreshDialog() {
        this.m_oContentPane.updateUI();
        this.m_oContentPane.repaint();
    }

    private JButton getPreButton() {
        if (this.m_PreButton == null) {
            this.m_PreButton = new JButton();
            this.m_PreButton.setName("TaskMgmt_CreateTaskDialog_m_PreButton");
            this.m_PreButton.setText(this.m_ResourceMgnr.getResString("PREVIOUS"));
            this.m_PreButton.setVerticalTextPosition(3);
            this.m_PreButton.setMnemonic(80);
            this.m_PreButton.setPreferredSize(BUTTON_DIMENSION);
            this.m_PreButton.setMinimumSize(BUTTON_DIMENSION);
            this.m_PreButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateTaskDialog.this.previewAction();
                }
            });
        }
        return this.m_PreButton;
    }

    private JButton getNextButton() {
        if (this.m_NextButton == null) {
            this.m_NextButton = new JButton();
            this.m_NextButton.setName("TaskMgmt_CreateTaskDialog_m_NextButton");
            this.m_NextButton.setText(this.m_ResourceMgnr.getResString("NEXT"));
            this.m_NextButton.setVerticalTextPosition(3);
            this.m_NextButton.setMnemonic(78);
            this.m_NextButton.setPreferredSize(BUTTON_DIMENSION);
            this.m_NextButton.setMinimumSize(BUTTON_DIMENSION);
            this.m_NextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateTaskDialog.this.nextAction();
                }
            });
        }
        return this.m_NextButton;
    }

    private JButton getOkButton() {
        if (this.m_OkButton == null) {
            this.m_OkButton = new JButton();
            this.m_OkButton.setName("TaskMgmt_CreateTaskDialog_m_OkButton");
            this.m_OkButton.setText(this.m_ResourceMgnr.getResString("OK"));
            this.m_OkButton.setVerticalTextPosition(3);
            this.m_OkButton.setMnemonic(70);
            this.m_OkButton.setPreferredSize(BUTTON_DIMENSION);
            this.m_OkButton.setMinimumSize(BUTTON_DIMENSION);
            this.m_OkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateTaskDialog.this.okAction();
                }
            });
        }
        return this.m_OkButton;
    }

    private JButton getCancelButton() {
        if (this.m_CancelButton == null) {
            this.m_CancelButton = new JButton();
            this.m_CancelButton.setName("TaskMgmt_CreateTaskDialog_m_CancelButton");
            this.m_CancelButton.setVerticalTextPosition(3);
            this.m_CancelButton.setText(ResourceManager.getInstance().getResString("CANCEL"));
            this.m_CancelButton.setPreferredSize(BUTTON_DIMENSION);
            this.m_CancelButton.setMinimumSize(BUTTON_DIMENSION);
            this.m_CancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateTaskDialog.this.cancelAction();
                }
            });
        }
        return this.m_CancelButton;
    }

    private void initialize() {
        InternalFrame oTaskMainFrame;
        this.setSize(770, 529);
        this.limitPanelMinSize();
        GridBagLayout thisLayout = new GridBagLayout();
        this.setLayout(thisLayout);
        this.setContentPane(this.getJContentPane());
        this.setResizable(true);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        DataCenterModuleManager dataCenterModuleManager = DCFrameWorkUtil.getDCModuleManager();
        DCFrameWorkUtil.getDCModuleManager();
        int m_iTaskMainPanelRegisteID = dataCenterModuleManager.getPanelRegisteID(2);
        if (m_iTaskMainPanelRegisteID != -1 && null != (oTaskMainFrame = DCFrameWorkUtil.getDCModuleManager().getWindowManager().getWindow(m_iTaskMainPanelRegisteID))) {
            this.setParentDefault(false);
            this.setModalParent(oTaskMainFrame);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    CreateTaskDialog.this.dispose();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    CreateTaskDialog.this.dispose();
                }
            }
        });
    }

    private void setStepTitle() {
        this.m_oStepLabel.setText(this.m_ResourceMgnr.getResString("DIALOG_STEP_HEAD") + ' ' + Integer.toString(this.iCurrentStep + 1) + ' ' + this.m_ResourceMgnr.getResString("DIALOG_STEP_OF") + ' ' + this.iTotalStep + ' ' + this.m_ResourceMgnr.getResString("DIALOG_STEP_END"));
    }

    @Override
    protected String getCurrentContext() {
        return this.m_strHelpFileName;
    }

    public void setCurrentHelpKey(String strHelpKey) {
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), strHelpKey);
    }

    private void limitPanelMinSize() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentevent) {
                if (CreateTaskDialog.this.getSize().width < 770 || CreateTaskDialog.this.getSize().height < 529) {
                    CreateTaskDialog.this.setSize(770, 529);
                }
            }
        });
    }

    @Override
    public void doCleanUp() {
        TaskBasePanel taskBasePanel = null;
        DeviceTreePanel devTreePanel = null;
        DeviceSelectionDropDownPanel devSelDropDownPanel = null;
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        for (int i = this.arrPanelList.size() - 1; i >= 0; --i) {
            taskBasePanel = this.arrPanelList.get(i);
            if (taskBasePanel instanceof TaskDevSelecPanelWithUpgradeType) {
                devTreePanel = ((TaskDevSelecPanelWithUpgradeType)taskBasePanel).m_oDeviceSelectionPanel.getDevcieTreePanel();
                if (null != devTreePanel) {
                    devTreePanel.unrgisterForNotifications();
                    devTreePanel.disposePanel();
                    devTreePanel = null;
                }
                if (null != (devSelDropDownPanel = ((TaskDevSelecPanelWithUpgradeType)taskBasePanel).m_oDeviceSelectionPanel.getDeviceSelectionDropDownPanel())) {
                    devSelDropDownPanel.unRegisterForServerodifications();
                }
                devSelDropDownPanel = null;
                CreateTaskDeviceSelectionPanel oCreateTaskDeviceSelectionPanel = DCFrameWorkUtil.getCreateTaskDeviceSelectionPanel();
                if (null != oCreateTaskDeviceSelectionPanel) {
                    oCreateTaskDeviceSelectionPanel.doCleanUp();
                    ObjectStore.getInstance().removeObjectInstance("CreateTaskDeviceSelectionPanel");
                    oCreateTaskDeviceSelectionPanel = null;
                }
            } else if (taskBasePanel instanceof TaskMgmtOperationSelecPanel) {
                ObjectStore.getInstance().removeObjectInstance("TaskMgmtOperationSelectionPanel");
                ((TaskMgmtOperationSelecPanel)taskBasePanel).cleanUp();
            } else if (taskBasePanel instanceof TaskConfirmationPanel) {
                ((TaskConfirmationPanel)taskBasePanel).cleanUp();
            }
            taskBasePanel = null;
            super.doCleanUp();
        }
        DCCleanupUtil.cleanupComponent(this.m_NextButton);
        DCCleanupUtil.cleanupComponent(this.m_PreButton);
        DCCleanupUtil.cleanupComponent(this.m_oMainPanel);
        DCCleanupUtil.cleanupComponent(this.m_oStepPanel);
        DCCleanupUtil.cleanupComponent(this.m_oBtnPanel);
        this.arrPanelList.clear();
        this.m_oStepLabel = null;
        this.m_oStepPanel = null;
        this.m_oMainPanel.removeAll();
        this.m_oMainPanel.setLayout(null);
        this.m_oMainPanel = null;
        this.m_oContentPane.removeAll();
        this.m_oContentPane.setLayout(null);
        this.m_oContentPane = null;
        this.m_oBtnPanel = null;
        if (null != this.m_oRadioButtonPanel) {
            this.m_oRadioButtonPanel.removeAll();
            this.m_oRadioButtonPanel = null;
        }
        this.m_ResourceMgnr = null;
        this.m_oTaskDataObj = null;
        this.arrPanelList = null;
        this.m_PreButton = null;
        this.m_NextButton = null;
        this.m_OkButton = null;
        this.m_CancelButton = null;
        this.m_strHelpFileName = null;
        isCreatingTask = false;
        super.doCleanUp();
    }

    @Override
    protected void closeDialog() {
        TaskBasePanel taskBasePanel = null;
        int panelSize = this.arrPanelList.size();
        for (int i = 0; i < panelSize; ++i) {
            taskBasePanel = this.arrPanelList.get(i);
            if (!(taskBasePanel instanceof TaskMgmtOperationSelecPanel)) continue;
            SAMChangeEventReceiver.getInstance().unResigterForConfigChangeEvent((TaskMgmtOperationSelecPanel)taskBasePanel);
        }
        DCFrameWorkUtil.defaultCursor();
        super.closeDialog();
    }

    private boolean checkIsProxiedDevice() {
        THashSet<Resource> oResourcesList;
        int iSize;
        if (null != this.m_oTaskDataObj && null != this.m_oTaskDataObj.getSelectedDeviceType() && 0 < (iSize = (oResourcesList = this.m_oTaskDataObj.getSelectedDeviceType().getResources()).size())) {
            int[] iDevIds = new int[iSize];
            Iterator oResItor = oResourcesList.iterator();
            Resource oResource = null;
            int i = 0;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                iDevIds[i] = oResource.getDeviceID();
                ++i;
            }
            RouterDevInfoPanel oRouterDevInfoPanel = DCFrameWorkUtil.getRouterDevInfoPanel();
            if (null != oRouterDevInfoPanel) {
                return oRouterDevInfoPanel.checkIsContainProxiedDev(iDevIds);
            }
        }
        return false;
    }

    public ITask getTaskObj() {
        return this.m_oTaskDataObj;
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst deviceInfoList) {
        switch (iEventType) {
            case 1: {
                boolean isSelectDevDeleted = false;
                THashSet<Resource> oResHashSet = this.m_oTaskDataObj.getDeviceType().getResources();
                if (oResHashSet.size() == 0) break;
                AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
                block3: for (int i = 0; i < deviceInfoList.size(); ++i) {
                    oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)deviceInfoList.get(i);
                    for (Resource oRes : oResHashSet) {
                        if (oAsnDeviceInfo.oDeviceInfo.iDevId.intValue() != oRes.getDeviceID()) continue;
                        isSelectDevDeleted = true;
                        continue block3;
                    }
                }
                if (!isSelectDevDeleted) break;
                DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("CREATE_TASK_STOP"), DCFrameWorkUtil.getLocalizedString("SUGGESTION"), 1);
                this.doCleanUp();
                this.dispose();
                break;
            }
        }
    }
}

