/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.ASNDCFileInfoStruct;
import com.huawei.dc.common.asndatacenter.AsnDCGetASMDCInfoInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetDCInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirRsp;
import com.huawei.dc.common.asndatacenter.AsnDCTargetFileServerTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfoLst;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.deviceoperation.util.BrowseNameColComparator;
import com.huawei.dc.deviceoperation.util.DirFileCellRendrer;
import com.huawei.dc.deviceoperation.util.DirListNode;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.util.TaskOperCommonUtil;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import net.commustru.fstru.FStruct;

public class BrowsePanel
extends JPanel {
    private static final long serialVersionUID = -7159992501035752787L;
    private transient DCExtendedTable m_oTable = null;
    private transient DCSortableTableModel m_oTableModel = null;
    private String m_strPreviousPath = "";
    private final JTextField m_oSelectedPath = new JTextField();
    private JButton m_oUpOneLevel;
    private JComboBox m_oSelectType;
    private String strDirToGet;
    private boolean m_bFirstSort = true;
    private boolean m_bSortState;
    private String m_strRootPath = "";
    private String m_strTftpPath;
    private String m_strCurPath = null;
    private JLabel m_oSoftwareSelectTypeLabel;
    private JPanel m_oTablePanel;
    private JPanel m_oSelectPanel;
    private JScrollPane m_oTableScroller;
    private ImageIcon m_oUpIcon;
    private static final int BROWSEDLG_TYPE = 0;
    private static final int BROWSEDLG_MODEL_NAME = 1;
    private static final int BROWSEDLG_NAME = 0;
    private static final int BROWSEDLG_SIZE = 3;
    private static final String DIR_TYPE = "DIR";
    private static final String FILE_TYPE = "FILE";
    private Vector oFileStorage = null;
    private Vector oDirStorage = null;
    private JLabel selectedPathLabel;
    private String filterFileType;
    private int fileTypeNum;
    private AsnSAMFileInfoLst oFileInfoLst = null;
    private static final int PACKAGE = 1;
    private static final int SIMULATION = 2;
    private static final int PATCH = 3;
    private ITask oOperationData;
    private boolean bIsThridFTP = false;
    private String strThridFTPName;
    private SimpleProgressDlg m_oProgressDlg = null;
    private static int iErrCode = 0;

    public BrowsePanel(String m_strTftpPath, String filterFileType, int fileTypeNum) throws DCException {
        this.setRootPath(m_strTftpPath);
        this.m_strTftpPath = m_strTftpPath;
        this.filterFileType = filterFileType;
        this.fileTypeNum = fileTypeNum;
        this.setLayout(null);
        this.jbInit();
        this.init();
    }

    public BrowsePanel(String m_strTftpPath, String filterFileType, int fileTypeNum, ITask oTaskObj, String strInitPath) throws DCException {
        this.setRootPath(m_strTftpPath);
        this.oOperationData = oTaskObj;
        this.m_strCurPath = FileUtil.getPath(strInitPath);
        if (null != this.oOperationData && this.oOperationData.isThirdPartySupported()) {
            this.bIsThridFTP = true;
            this.strThridFTPName = m_strTftpPath;
        }
        this.m_strTftpPath = m_strTftpPath;
        this.filterFileType = filterFileType;
        this.fileTypeNum = fileTypeNum;
        this.setLayout(null);
        this.jbInit();
        this.init();
    }

    public void init() throws DCException {
        int iRow;
        iErrCode = 0;
        if (null == this.m_strCurPath || this.m_strCurPath.length() <= 0) {
            this.m_strCurPath = this.m_strTftpPath;
        }
        if (this.m_strCurPath.equalsIgnoreCase(this.m_strRootPath)) {
            this.m_strPreviousPath = this.m_strRootPath;
        } else if (this.m_strCurPath.contains("/") && this.m_strCurPath.indexOf("/") > 0) {
            int iIndex = this.m_strCurPath.lastIndexOf("/");
            this.m_strPreviousPath = this.m_strCurPath.substring(0, iIndex);
        }
        int iErrorCode = this.getDirectoryFromServer(this.m_strCurPath, false);
        if (iErrorCode != 0) {
            iErrCode = iErrorCode;
            DCDebugTracer.trace("BrowsePanel#iErrorCode:" + iErrorCode);
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        String selectFileType = this.m_oSelectType.getSelectedItem().toString();
        if (selectFileType != null) {
            this.searchFile(selectFileType);
        }
        if (-1 != (iRow = this.m_oTable.getSelectedRow())) {
            this.m_oTable.removeRowSelectionInterval(iRow, iRow);
        }
        this.setUpButtonEnable(this.m_strCurPath);
    }

    private void jbInit() {
        this.selectedPathLabel = new JLabel(ResourceManager.getInstance().getResString("SEARCH_PACKAGE"));
        this.m_oSelectedPath.setEditable(false);
        this.m_oSelectedPath.setName("TaskMgmt_BrowsePanel_m_oSelectedPath");
        this.m_oSelectedPath.addMouseMotionListener(this.getMouseMotionListener());
        this.m_oUpIcon = ResourceManager.getInstance().getImage("upfolder.gif");
        this.m_oUpOneLevel = new JButton("", this.m_oUpIcon);
        this.m_oUpOneLevel.setName("TaskMgmt_BrowsePanel_m_oUpOneLevel");
        this.m_oUpOneLevel.setToolTipText(ResourceManager.getInstance().getResString("BROWSEDLG_UP_ONE_LEVEL"));
        this.m_oUpOneLevel.addActionListener(this.getActionListener());
        this.m_oTablePanel = new JPanel();
        this.m_oTablePanel.setName("TaskMgmt_BrowsePanel_m_oTablePanel");
        this.m_oTablePanel.setLayout(null);
        this.initTable();
        this.m_oSelectPanel = new JPanel();
        this.m_oSelectPanel.setName("TaskMgmt_BrowseDlg_m_oSelectPanel");
        this.m_oSelectPanel.setLayout(null);
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), ResourceManager.getInstance().getResString("SELECT_SOFTWARE"));
        this.m_oSelectPanel.setBorder(oBorder);
        this.m_oTableScroller = new JScrollPane((Component)this.m_oTable);
        this.m_oTableScroller.setName("TaskMgmt_BrowseDlg_m_oTableScroller");
        this.m_oSelectPanel.add(this.m_oTableScroller);
        this.m_oSoftwareSelectTypeLabel = new JLabel(ResourceManager.getInstance().getResString("FILE_TYPE_LABEL"));
        Vector<String> fileType = new Vector<String>();
        IDeviceTypeConfigModel devTypeConfigInfo = TaskInfoUtil.getDevTypeConfigByTask(this.oOperationData);
        if (null == devTypeConfigInfo) {
            fileType.add(ResourceManager.getInstance().getResString("ALL_FILE_TYPE"));
        } else {
            IOperation oLoadSWOperationObj = devTypeConfigInfo.getOperationObj(1, 6);
            if (null != oLoadSWOperationObj) {
                IParaList oGetoPerationParaList = oLoadSWOperationObj.getoPerationParaList();
                Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
                if (null != arrParaVals) {
                    for (Object object : arrParaVals) {
                        this.initFileType(this.oOperationData.getTaskTypeId(), fileType, this.oOperationData.getDeviceType().getDeviceDomain(), object);
                    }
                }
                fileType.add(ResourceManager.getInstance().getResString("ALL_FILE_TYPE"));
            }
        }
        this.initSelectTypeCombo(fileType);
        this.add(this.m_oSoftwareSelectTypeLabel);
        this.add(this.m_oSelectType);
        this.add(this.m_oSelectPanel);
        this.add(this.m_oUpOneLevel);
        this.add(this.selectedPathLabel);
        this.add(this.m_oSelectedPath);
        MouseAdapter mouseListener = this.getMouseListener();
        this.m_oTable.addMouseListener((MouseListener)mouseListener);
    }

    private void initFileType(int taskType, Vector<String> fileType, int domain, Object object) {
        if (object instanceof ContentType) {
            if (4 == domain) {
                if (2 == taskType) {
                    this.addFileType(fileType, object, "PATCH");
                } else if (3 == taskType) {
                    this.addFileType(fileType, object, "SIMULATION");
                } else {
                    this.addFileType(fileType, object, "PACKAGE");
                }
            } else {
                this.addFileType(fileType, object, null);
            }
        }
    }

    private void addFileType(Vector<String> fileType, Object object, String contentTypeId) {
        String id = ((ContentType)object).getId();
        if (contentTypeId != null && !contentTypeId.equals(id)) {
            return;
        }
        String suffix = TaskOperCommonUtil.generateFilterSuffix(this.oOperationData.getDeviceType().getDeviceDomain(), id);
        fileType.add(ResourceManager.getInstance().getResFromDomainProperties(this.oOperationData.getDeviceType().getDeviceDomain(), id) + "(" + suffix + ")");
    }

    private void initSelectTypeCombo(Vector fileType) {
        this.m_oSelectType = new JComboBox(fileType);
        this.m_oSelectType.setName("TaskMgmt_BrowsePanel_m_oSelectType");
        this.m_oSelectType.setSelectedIndex(0);
        this.m_oSelectType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowsePanel.this.selectFileTypeActionPerformed();
            }
        });
    }

    private void initTable() {
        Object[] m_arrColheader = new String[]{ResourceManager.getInstance().getResString("BROWSE_DLG_TYPE"), ResourceManager.getInstance().getResString("BROWSE_DLG_NAME"), ResourceManager.getInstance().getResString("SAM_TABLE_COLUMN_VERSION"), ResourceManager.getInstance().getResString("SAM_TABLE_COLUMN_FILE_TYPE"), ResourceManager.getInstance().getResString("FILE_LIST_TABLE_FILE_SIZE")};
        this.m_oTableModel = new DCSortableTableModel(m_arrColheader, 0);
        this.initExtendedTable();
        this.alignTable();
        this.setTableProperties();
    }

    private void setTableProperties() {
        SortButtonRenderer sortButtonRenderer = new SortButtonRenderer();
        this.m_oTable.getColumnModel().getColumn(1).setHeaderRenderer((TableCellRenderer)sortButtonRenderer);
        boolean[] colEnable = new boolean[]{false, true, true, true, true};
        this.m_oTable.setColumnShowingEnable(colEnable);
        this.m_oTable.setSortableClickCount(1);
        this.m_oTable.setColumnSortable(3, true);
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTable.getTableHeader().addMouseListener(this.getTableHeaderMouseAdapter());
        this.m_oTable.setSelectionMode(0);
    }

    private void alignTable() {
        this.m_oTable.setColumnSelectionAllowed(false);
        this.m_oTable.setRowSelectionAllowed(true);
        this.m_oTable.setIntercellSpacing(new Dimension(0, 0));
        this.m_oTable.setShowGrid(false);
        this.m_oTable.setFocusable(false);
        this.m_oTable.getBackground().darker();
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 21));
        this.m_oTable.getColumnModel().getColumn(1).setCellRenderer(new DirFileCellRendrer());
    }

    private void initExtendedTable() {
        this.m_oTable = new DCExtendedTable((SortableTableModel)this.m_oTableModel){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oTable.setName("TaskMgmt_BrowsePanel_m_oTable");
    }

    private MouseAdapter getTableHeaderMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BrowsePanel.this.tableheaderMousePressed(e);
            }
        };
    }

    private MouseAdapter getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean bSelFile = false;
                int iSelectedRow = BrowsePanel.this.m_oTable.getSelectedRow();
                DirListNode node = (DirListNode)BrowsePanel.this.m_oTableModel.getValueAt(iSelectedRow, 1);
                if (1 == e.getClickCount() && !node.m_bIsDirectory) {
                    bSelFile = true;
                }
                if (2 == e.getClickCount() || bSelFile) {
                    if (BrowsePanel.this.m_strPreviousPath.equals("/")) {
                        if (node.m_strName.endsWith(":")) {
                            BrowsePanel.this.selectedPathSetText(node.m_strName);
                        } else {
                            BrowsePanel.this.selectedPathSetText("/" + node.m_strName);
                        }
                    } else if (BrowsePanel.this.m_strPreviousPath.startsWith(BrowsePanel.this.m_strTftpPath)) {
                        BrowsePanel.this.selectedPathSetText(BrowsePanel.this.m_strPreviousPath + "/" + node.m_strName);
                    } else {
                        BrowsePanel.this.selectedPathSetText(BrowsePanel.this.m_strPreviousPath + BrowsePanel.this.getFileSeperstor(BrowsePanel.this.m_strPreviousPath) + node.m_strName);
                    }
                    if (node.m_bIsDirectory) {
                        int iRow;
                        int errorCode = BrowsePanel.this.getDirectoryFromServer(BrowsePanel.this.m_oSelectedPath.getText(), false);
                        if (0 != errorCode) {
                            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getTaskMgmtOperationSelecPanel(), errorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
                            return;
                        }
                        String selectFileType = BrowsePanel.this.m_oSelectType.getSelectedItem().toString();
                        if (selectFileType != null) {
                            BrowsePanel.this.searchFile(selectFileType);
                        }
                        if (-1 != (iRow = BrowsePanel.this.m_oTable.getSelectedRow())) {
                            BrowsePanel.this.m_oTable.removeRowSelectionInterval(iRow, iRow);
                        }
                    }
                    BrowsePanel.this.m_oUpOneLevel.setEnabled(true);
                }
            }
        };
    }

    private ActionListener getActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectFileType;
                BrowsePanel.this.goUpOneLevel();
                BrowsePanel.this.getDirectoryFromServer(BrowsePanel.this.strDirToGet, false);
                int iRow = BrowsePanel.this.m_oTable.getSelectedRow();
                if (-1 != iRow) {
                    BrowsePanel.this.m_oTable.removeRowSelectionInterval(iRow, iRow);
                }
                if ((selectFileType = BrowsePanel.this.m_oSelectType.getSelectedItem().toString()) != null) {
                    BrowsePanel.this.searchFile(selectFileType);
                }
            }
        };
    }

    private MouseMotionListener getMouseMotionListener() {
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent me) {
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                BrowsePanel.this.showToolTipText();
            }
        };
    }

    private void selectFileTypeActionPerformed() {
        String selectFileType = this.m_oSelectType.getSelectedItem().toString();
        this.m_oSelectType.setToolTipText(selectFileType);
        this.searchFile(selectFileType);
    }

    private void searchFile(String selectFileType) {
        int startIndex = selectFileType.lastIndexOf(".");
        int lastIndex = selectFileType.lastIndexOf(")");
        String fileType = "";
        if (startIndex <= 0 || lastIndex <= 0) {
            return;
        }
        fileType = selectFileType.substring(startIndex + 1, lastIndex);
        this.removeAllRows();
        if (this.oDirStorage != null) {
            this.m_oTableModel.addRows(this.oDirStorage);
        }
        if (this.oFileStorage == null) {
            return;
        }
        if (Collator.getInstance().equals(fileType, "*")) {
            this.m_oTableModel.addRows(this.oFileStorage);
        } else {
            int fileSize = this.oFileStorage.size();
            for (int i = 0; i < fileSize; ++i) {
                String filePostfix;
                Vector fileInfo = (Vector)this.oFileStorage.get(i);
                DirListNode node = (DirListNode)fileInfo.get(1);
                String fileName = node.m_strName;
                int startInde = fileName.lastIndexOf(".");
                int lastInde = fileName.length();
                if (startInde == -1 || startInde >= lastInde || !(filePostfix = fileName.substring(startInde + 1, lastInde)).equalsIgnoreCase(fileType)) continue;
                this.m_oTableModel.addRow((Vector)this.oFileStorage.get(i));
            }
            this.m_oTable.clearSelection();
        }
    }

    private void removeAllRows() {
        while (this.m_oTable.getRowCount() != 0) {
            this.m_oTableModel.removeRow(0);
        }
    }

    public void removeAllPathInfo() {
        if (iErrCode != 0) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrCode);
            this.removeAllRows();
            this.m_oSelectedPath.setText("");
            this.m_strPreviousPath = "";
            this.m_oUpOneLevel.setEnabled(false);
        }
    }

    protected void showToolTipText() {
        this.m_oSelectedPath.setToolTipText(this.m_oSelectedPath.getText());
    }

    private void goUpOneLevel() {
        String strSelectedPath = this.m_oSelectedPath.getText();
        int iSelectedRow = this.m_oTable.getSelectedRow();
        if (iSelectedRow > -1) {
            DirListNode node = (DirListNode)this.m_oTableModel.getValueAt(iSelectedRow, 1);
            if (!node.m_bIsDirectory) {
                int lastIndex = strSelectedPath.lastIndexOf(this.getFileSeperstor(strSelectedPath));
                strSelectedPath = strSelectedPath.substring(0, lastIndex);
            }
        }
        if (strSelectedPath.startsWith(this.getRootPath()) || this.bIsThridFTP) {
            int lastIndex = strSelectedPath.lastIndexOf(this.getFileSeperstor(strSelectedPath));
            this.strDirToGet = this.m_strPreviousPath;
            if (-1 == lastIndex) {
                lastIndex = strSelectedPath.lastIndexOf(File.separator);
                this.strDirToGet = -1 != lastIndex ? strSelectedPath.substring(0, lastIndex) : (this.bIsThridFTP ? this.m_strPreviousPath : "/");
            } else {
                this.strDirToGet = strSelectedPath.substring(0, lastIndex);
                if (this.strDirToGet.equals("")) {
                    this.strDirToGet = "/";
                }
            }
        } else {
            this.strDirToGet = this.getRootPath();
        }
    }

    public int getDirectoryFromServer(String strPath, boolean isTargetVersion) {
        int i;
        int iErrorCode = 0;
        AsnDCGetDirRsp dirRsp = new AsnDCGetDirRsp();
        iErrorCode = this.updatetable(strPath, dirRsp);
        if (iErrorCode != 0) {
            return iErrorCode;
        }
        this.removeAllRows();
        if (0 < dirRsp.oDirectories.size()) {
            this.oDirStorage = new Vector();
            for (i = 0; i < dirRsp.oDirectories.size(); ++i) {
                DirListNode dir = new DirListNode(new String((byte[])dirRsp.oDirectories.elementAt(i)), true);
                Vector<Object> rows = new Vector<Object>();
                rows.add(DIR_TYPE);
                rows.add(dir);
                rows.add("");
                this.m_oTableModel.addRow(rows);
                this.oDirStorage.add(rows);
            }
        } else if (this.oDirStorage != null) {
            this.oDirStorage.removeAllElements();
        }
        if (0 < dirRsp.oFiles.size()) {
            this.oFileStorage = new Vector();
            for (i = 0; i < dirRsp.oFiles.size(); ++i) {
                ASNDCFileInfoStruct oAsnFileInfo = (ASNDCFileInfoStruct)dirRsp.oFiles.elementAt(i);
                if (this.isDCInfoFile(new String(oAsnFileInfo.strFilename))) continue;
                DirListNode dir = new DirListNode(new String(oAsnFileInfo.strFilename), false);
                Vector<Object> oFileInfoRow = new Vector<Object>();
                oFileInfoRow.add(FILE_TYPE);
                oFileInfoRow.add(dir);
                if (null != oAsnFileInfo.strVersion) {
                    oFileInfoRow.add(new String(oAsnFileInfo.strVersion));
                } else {
                    oFileInfoRow.add("");
                }
                if (null != oAsnFileInfo.iContent) {
                    oFileInfoRow.add(this.getFileType(oAsnFileInfo.iContent));
                } else {
                    oFileInfoRow.add("");
                }
                if (null != oAsnFileInfo.iFileSize) {
                    oFileInfoRow.add(oAsnFileInfo.iFileSize);
                } else {
                    oFileInfoRow.add("");
                }
                this.m_oTableModel.addRow(oFileInfoRow);
                this.oFileStorage.add(oFileInfoRow);
            }
        } else if (this.oFileStorage != null) {
            this.oFileStorage.removeAllElements();
        }
        if (isTargetVersion) {
            char strSep = this.getFileSeperstor(strPath);
            if (strPath.charAt(strPath.length() - 1) == strSep) {
                strPath = strPath.substring(0, strPath.length() - 1);
            }
            AsnDCGetDCInfoReq oAsnDCGetDCInfoReq = new AsnDCGetDCInfoReq();
            oAsnDCGetDCInfoReq.strSAMPathlst.add((Object)strPath.getBytes());
            ISAMManager oSAMManager = SAMManager.getInstance();
            AsnDCGetASMDCInfoInfoRsp oAsnDCGetASMDCInfoInfoRsp = oSAMManager.getSAMDCInfoFiles(oAsnDCGetDCInfoReq);
            iErrorCode = oAsnDCGetASMDCInfoInfoRsp.oErrorInfo.iErrorNo.intValue();
            if (iErrorCode != 0) {
                return iErrorCode;
            }
            if (null == oAsnDCGetASMDCInfoInfoRsp.oFileInfoLst) {
                DCDebugTracer.trace("BrowsePanel::getDirectoryFromServer::oFileInfoLst is null");
            } else if (0 == oAsnDCGetASMDCInfoInfoRsp.oFileInfoLst.size()) {
                DCDebugTracer.trace("BrowsePanel::getDirectoryFromServer::oFileInfoLst size is zero");
            } else {
                this.oFileInfoLst = (AsnSAMFileInfoLst)oAsnDCGetASMDCInfoInfoRsp.oFileInfoLst.get(0);
            }
        }
        this.m_strPreviousPath = strPath;
        this.selectedPathSetText(strPath);
        if (strPath.equals(this.getRootPath()) || strPath.equals("/")) {
            this.m_oUpOneLevel.setEnabled(false);
        }
        if (!this.m_bFirstSort) {
            this.sortTable(new BrowseNameColComparator(this.m_bSortState));
        }
        return iErrorCode;
    }

    private AsnDCGetDirReq getDirReq(String strPath) {
        AsnDCGetDirReq dirGetReq = new AsnDCGetDirReq();
        dirGetReq.oDeviceOperationType.value = 24;
        if (this.bIsThridFTP) {
            dirGetReq.oTargetFileServerType = new AsnDCTargetFileServerTypeEnum(1);
            if (null != TaskSrcDstVersionCheck.getInstance().getThirdFTPServerName()) {
                dirGetReq.strTargetFileServerName = TaskSrcDstVersionCheck.getInstance().getThirdFTPServerName().getBytes();
            }
            dirGetReq.strRootPath = this.strThridFTPName.equals(strPath) || StringUtils.isNullOrEmptyStr(strPath) ? "/".getBytes() : strPath.getBytes();
        } else {
            dirGetReq.oTargetFileServerType = new AsnDCTargetFileServerTypeEnum(0);
            dirGetReq.strRootPath = strPath.getBytes();
        }
        return dirGetReq;
    }

    private boolean isDCInfoFile(String fileName) {
        boolean isDCInfoFile = true;
        String m_strDCInfo = "DCInfo_";
        isDCInfoFile = fileName.indexOf("DCInfo_") == 0;
        return isDCInfoFile;
    }

    private String getFileType(BigInteger oFileType) {
        String strFileType = "";
        switch (oFileType.hashCode()) {
            case 1: {
                strFileType = ResourceManager.getInstance().getResString("PACKAGE_FILE_TYPE_BROWSE_TABLE");
                break;
            }
            case 2: {
                strFileType = ResourceManager.getInstance().getResString("SIMULATION_FILE_TYPE_BROWSE_TABLE");
                break;
            }
            case 3: {
                strFileType = ResourceManager.getInstance().getResString("PATCH_FILE_TYPE_BROWSE_TABLE");
                break;
            }
        }
        return strFileType;
    }

    private void tableheaderMousePressed(MouseEvent e) {
        int iCol = this.m_oTable.getTableHeader().columnAtPoint(e.getPoint());
        if (0 == iCol) {
            TableCellRenderer headRender = this.m_oTable.getColumnModel().getColumn(0).getHeaderRenderer();
            SortButtonRenderer sortRenderer = (SortButtonRenderer)headRender;
            boolean bl = this.m_bSortState = sortRenderer.getState(1) == 1;
            if (this.m_bFirstSort) {
                this.m_bFirstSort = false;
            }
            BrowseNameColComparator oNameColComparator = new BrowseNameColComparator(this.m_bSortState);
            this.sortTable(oNameColComparator);
            sortRenderer.setSelectedColumn(1);
            sortRenderer.repaint();
            this.m_oTable.getTableHeader().repaint();
            this.m_oTable.updateUI();
            this.m_oTable.repaint();
        }
    }

    private void sortTable(Comparator oComparator) {
        int l;
        Vector rowVector;
        int k;
        int iNosRows = this.m_oTable.getRowCount();
        Vector oTableData = this.m_oTableModel.getDataVector();
        ArrayList<String> oDiretories = new ArrayList<String>();
        ArrayList<String> oFiles = new ArrayList<String>();
        Vector[] oDirRows = null;
        Vector[] oFilesRows = null;
        for (int i = 0; i < iNosRows; ++i) {
            String strType = (String)this.m_oTableModel.getValueAt(i, 0);
            if (DIR_TYPE.equals(strType)) {
                oDiretories.add(this.m_oTableModel.getValueAt(i, 1).toString());
                continue;
            }
            if (!FILE_TYPE.equals(strType)) continue;
            oFiles.add(this.m_oTableModel.getValueAt(i, 1).toString());
        }
        if (0 != oDiretories.size()) {
            Collections.sort(oDiretories, oComparator);
            int iNoDirs = oDiretories.size();
            oDirRows = new Vector[iNoDirs];
            block1: for (int j = 0; j < iNoDirs; ++j) {
                String strSortedDirName = (String)oDiretories.get(j);
                for (k = 0; k < iNosRows; ++k) {
                    rowVector = (Vector)oTableData.elementAt(k);
                    String strDirName = rowVector.elementAt(1).toString();
                    if (!Collator.getInstance().equals(strSortedDirName, strDirName)) continue;
                    oDirRows[j] = (Vector)oTableData.elementAt(k);
                    continue block1;
                }
            }
        }
        if (0 != oFiles.size()) {
            Collections.sort(oFiles, oComparator);
            int iNoFiles = oFiles.size();
            oFilesRows = new Vector[iNoFiles];
            block3: for (int j = 0; j < iNoFiles; ++j) {
                String strSortedFileName = (String)oFiles.get(j);
                for (k = 0; k < iNosRows; ++k) {
                    rowVector = (Vector)oTableData.elementAt(k);
                    String strFileName = rowVector.elementAt(1).toString();
                    if (!Collator.getInstance().equals(strSortedFileName, strFileName)) continue;
                    oFilesRows[j] = (Vector)oTableData.elementAt(k);
                    continue block3;
                }
            }
        }
        this.removeAllRows();
        if (null != oDirRows) {
            for (l = 0; l < oDiretories.size(); ++l) {
                this.m_oTableModel.addRow(oDirRows[l]);
            }
        }
        if (null != oFilesRows) {
            for (l = 0; l < oFiles.size(); ++l) {
                this.m_oTableModel.addRow(oFilesRows[l]);
            }
        }
    }

    public void setSelectedPathLabeltBounds(int x, int y, int width, int high) {
        this.selectedPathLabel.setBounds(x, y, width, high);
    }

    public void setSelectedPathtBounds(int x, int y, int width, int high) {
        this.m_oSelectedPath.setBounds(x, y, width, high);
    }

    public void setUpOneLeveltBounds(int x, int y, int width, int high) {
        this.m_oUpOneLevel.setBounds(x, y, width, high);
    }

    public void setTablePaneltBounds(int x, int y, int width, int high) {
        this.m_oTablePanel.setBounds(x, y, width, high);
    }

    public void setSelectPaneltBounds(int x, int y, int width, int high) {
        this.m_oSelectPanel.setBounds(x, y, width, high);
    }

    public void setTableScrollertBounds(int x, int y, int width, int high) {
        this.m_oTableScroller.setBounds(x, y, width, high);
    }

    public void setSoftwareSelectTypeLabeltBounds(int x, int y, int width, int high) {
        this.m_oSoftwareSelectTypeLabel.setBounds(x, y, width, high);
    }

    public void setSelectTypetBounds(int x, int y, int width, int high) {
        this.m_oSelectType.setBounds(x, y, width, high);
    }

    public DCExtendedTable getTable() {
        return this.m_oTable;
    }

    public DCSortableTableModel getTableModel() {
        return this.m_oTableModel;
    }

    public JTextField getSelectPath() {
        return this.m_oSelectedPath;
    }

    public JComboBox getBrowseCheckBox() {
        return this.m_oSelectType;
    }

    public void setUpButtonEnable(String tftpPath) {
        if (tftpPath.equals(this.getRootPath())) {
            this.m_oUpOneLevel.setEnabled(false);
        } else {
            this.m_oUpOneLevel.setEnabled(true);
        }
    }

    public void setPathFiled(String text, boolean isTargetVersion) {
        String dirPath = "";
        String fileName = "";
        if (!isTargetVersion) {
            int index = text.lastIndexOf(this.getFileSeperstor(text));
            if (index == -1) {
                index = text.lastIndexOf("/");
            }
            if (index >= 0) {
                dirPath = text.substring(0, index);
            }
            fileName = text.substring(index + 1, text.length());
        } else {
            dirPath = text;
        }
        int iErrorCode = this.getDirectoryFromServer(dirPath, isTargetVersion);
        String newPathStr = iErrorCode != 0 && this.bIsThridFTP ? "/" : dirPath;
        this.setUpButtonEnable(dirPath);
        this.selectFileTypeActionPerformed();
        if (iErrorCode == 0 && !this.setLoadPath(isTargetVersion, fileName, newPathStr, text)) {
            this.searchFile(ResourceManager.getInstance().getResString("ALL_FILE_TYPE"));
            if (!this.setLoadPath(isTargetVersion, fileName, newPathStr, text)) {
                DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("THE_FILE_DOESNOT_EXIST"), true);
                this.selectedPathSetText(newPathStr);
            }
        }
    }

    public boolean setLoadPath(boolean isTargetVersion, String fileName, String dirPath, String text) {
        int i;
        String targetVersionFile = "";
        AsnSAMFileInfo oAsnSAMFileInfo = null;
        String strPath = null;
        if (this.oFileInfoLst != null) {
            for (int i2 = 0; i2 < this.oFileInfoLst.size(); ++i2) {
                oAsnSAMFileInfo = (AsnSAMFileInfo)this.oFileInfoLst.get(i2);
                if (oAsnSAMFileInfo.iFileType.hashCode() != 1) continue;
                targetVersionFile = new String(oAsnSAMFileInfo.strFileName);
                strPath = dirPath;
                this.getDirectoryFromServer(strPath, false);
                String selectFileType = this.m_oSelectType.getSelectedItem().toString();
                if (selectFileType == null) break;
                this.searchFile(selectFileType);
                break;
            }
        }
        boolean isSuccessful = true;
        int rowCount = this.m_oTable.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            String nodeType = (String)this.m_oTableModel.getValueAt(i, 0);
            if (!nodeType.equals(FILE_TYPE)) continue;
            DirListNode node = (DirListNode)this.m_oTableModel.getValueAt(i, 1);
            if (!isTargetVersion) {
                if (!Collator.getInstance().equals(node.m_strName, fileName)) continue;
                this.m_oTable.changeSelection(i, i, false, true);
                break;
            }
            if (!Collator.getInstance().equals(node.m_strName, targetVersionFile)) continue;
            fileName = null != oAsnSAMFileInfo && oAsnSAMFileInfo.iFileType.hashCode() == 1 ? strPath + this.getFileSeperstor(strPath) + targetVersionFile : dirPath + this.getFileSeperstor(strPath) + targetVersionFile;
            this.m_oTable.changeSelection(i, i, false, true);
            break;
        }
        if (i >= rowCount) {
            isSuccessful = false;
            this.selectedPathSetText(dirPath);
        } else if (!isTargetVersion) {
            this.selectedPathSetText(text);
        } else {
            this.selectedPathSetText(fileName);
        }
        return isSuccessful;
    }

    private char getFileSeperstor(String strPath) {
        int strFileSeperator = File.separatorChar;
        int charLength = strPath.length();
        for (int i = 0; i < charLength; ++i) {
            if (strPath.charAt(i) != '/') continue;
            strFileSeperator = 47;
            break;
        }
        return (char)strFileSeperator;
    }

    public void dispose() {
        if (this.m_oTable != null) {
            this.m_oTable.removeAll();
            this.m_oTable = null;
        }
        this.m_oTableModel = null;
        this.m_oTablePanel = null;
        this.m_oSelectPanel = null;
        this.m_oTableScroller = null;
    }

    private void selectedPathSetText(String path) {
        if (null != this.strThridFTPName && StringUtils.isIPV4(this.strThridFTPName)) {
            if (this.strThridFTPName.equals(path)) {
                this.m_oSelectedPath.setText("/");
            } else {
                int IPIndex = path.indexOf(this.strThridFTPName);
                if (-1 != IPIndex) {
                    this.m_oSelectedPath.setText(path.substring(this.strThridFTPName.length(), path.length()));
                } else {
                    this.m_oSelectedPath.setText(path);
                }
            }
        } else {
            this.m_oSelectedPath.setText(path);
        }
    }

    public void setRootPath(String path) {
        this.m_strRootPath = path;
    }

    private String getRootPath() {
        return this.m_strRootPath;
    }

    public synchronized void closeProgressDlg() {
        if (null != this.m_oProgressDlg) {
            DCDebugTracer.trace("Getting Directory End");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowsePanel.this.m_oProgressDlg.dispose();
                    BrowsePanel.this.m_oProgressDlg = null;
                }
            });
        }
    }

    private int updatetable(String strPath, AsnDCGetDirRsp dirRsp) {
        ValidationResult oValidResult = new ValidationResult();
        oValidResult.setErrorCode(0);
        this.closeProgressDlg();
        this.m_oProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("CONNECT_THIRDPARTY_SERVER_PROGRESS_DLG_TITLE"), true, ResourceManager.getInstance().getResString("CONNECT_THIRDPARTY_SERVER_PROGRESS_PROMPT")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                if (null == BrowsePanel.this.m_oProgressDlg) {
                    return;
                }
                BrowsePanel.this.closeProgressDlg();
            }
        };
        UpdateFileTable updateFileTableThread = new UpdateFileTable(strPath, dirRsp);
        updateFileTableThread.start();
        this.m_oProgressDlg.setVisible(true);
        oValidResult = updateFileTableThread.getValidateResult();
        if (null == oValidResult) {
            oValidResult = new ValidationResult();
        }
        return oValidResult.getErrorCode();
    }

    class UpdateFileTable
    extends Thread {
        private ValidationResult m_oResult = null;
        private String path;
        private AsnDCGetDirRsp dirLstRsp;

        public UpdateFileTable(String strPath, AsnDCGetDirRsp dirRsp) {
            this.path = strPath;
            this.dirLstRsp = dirRsp;
            this.setName("BrowsePanel#UpdateFileTable-Thread");
        }

        @Override
        public void run() {
            try {
                UpdateFileTable.sleep(700L);
            }
            catch (InterruptedException ex) {
                DCDebugTracer.trace(ex);
            }
            this.m_oResult = new ValidationResult();
            this.m_oResult.setErrorCode(0);
            int iErrorCode = 0;
            BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
            AsnDCGetDirReq dirGetReq = BrowsePanel.this.getDirReq(this.path);
            iErrorCode = commManager.sendSyncMsgWithSyncCommand(43842, (FStruct)dirGetReq, (FStruct)this.dirLstRsp);
            iErrorCode = this.dirLstRsp.oErrorInfo.iErrorNo.intValue();
            this.m_oResult.setErrorCode(iErrorCode);
            BrowsePanel.this.closeProgressDlg();
        }

        public ValidationResult getValidateResult() {
            return this.m_oResult;
        }
    }
}

