/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view.common;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckResultEle;
import com.huawei.dc.common.asndatacenter.AsnDCGetDetailResultRsp;
import com.huawei.dc.common.asndatacenter.AsnExtendCheckResult;
import com.huawei.dc.common.asndatacenter.AsnExtendCheckResultLst;
import com.huawei.dc.common.asndatacenter.AsnExtendCheckResultRowLst;
import com.huawei.dc.common.asndatacenter.AsnGetDCExtendCheckResultRsq;
import com.huawei.dc.common.asndatacenter.AsnUpgradeFeasibilityRsp;
import com.huawei.dc.common.components.dialog.ViewTableResultDlg;
import com.huawei.dc.common.components.treetable.model.CustomTableColumnModel;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TableColumnFitAdapter;
import com.huawei.dc.compare.CompareFileDialog;
import com.huawei.dc.compare.datasource.ConfigFileControl;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.UpgradeFeasibilityValidationManager;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.view.common.TreeTableLinkRenderer;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigInteger;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class AbstractTaskSubOperationTablePanel
extends JPanel {
    private static final long serialVersionUID = -9155004425005291867L;
    protected static final int COMMAND_INDEX = 1;
    protected static final int DESCRIPTION_INDEX = 7;
    protected static final int DEVICE_TYPE_INDEX = 3;
    protected static final int END_TIME_INDEX = 5;
    protected static final int NE_ID_INDEX = 2;
    protected static final int OPERATION_NAME_INDEX = 0;
    private static String POST_CHECK_OPER = DCFrameWorkUtil.getLocalizedString("UPGRADE_POSTCHECK");
    private static String PRE_CHECK_OPER = DCFrameWorkUtil.getLocalizedString("UPGRADE_PRECHECK");
    protected static final int RESULT_INDEX = 6;
    protected static final int START_TIME_INDEX = 4;
    protected static final int TABLE_COLUMN_COUNT = 8;
    private static String UFC_OPER = DCFrameWorkUtil.getLocalizedString("UFC_OPERATION");
    protected boolean m_bIsBoardLevel = false;
    protected int m_iCurrentOprID = -1;
    protected CustomTableColumnModel m_oCustomTableColumnModel = null;
    protected transient DCTreeTableCellRenderer m_oDefaultRenderer = null;
    protected TreeTableLinkRenderer m_oLinkRenderer = null;
    protected JScrollPane m_oOpResultScrollPane;
    protected DCSortableTreeTable m_oOpResultTreeTable;
    protected DCTreeTableModel m_oOpResultTreeTableModel;
    protected Resource m_oResource = null;
    protected ResourceManager m_oResourceMngr = ResourceManager.getInstance();
    protected TreeTableNode m_oRootNode;
    protected ITask m_oTaskObj = null;
    protected DCSortableTreeTable m_oTaskTreeTable;
    protected JTree m_oTree;
    private int MOUSE_MOVED_OVER_ROW = -1;
    private static String SAVE = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_15");
    private static String BACKUP = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_3");
    private static String ACTIVE = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_9");
    private static String ACTIVE_BEFORE = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_39");
    private static String ACTIVE_AFTER = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_40");
    private static String LOAD_SOFTWARE = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_8");
    private static String LOAD_PATCH = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_7");
    private static String DEL_PATCH = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_12");
    private static String UPDATE_PATCH = DCFrameWorkUtil.getLocalizedString("LOG_FILTER_DIALOG_OPERATION_TYPE_45");

    public final boolean compareID(TreeTableNode oNode, String oParentID) {
        int OPR_NAME = 0;
        boolean bState = false;
        TreeTableRowData oData = null;
        TreeTableCellData oCellData = null;
        String strCellData = "";
        oData = (TreeTableRowData)oNode.getUserObject();
        if (null != oData && oParentID.equals(strCellData = (String)(oCellData = oData.getColumnData(OPR_NAME)).getCellDataValue())) {
            bState = true;
        }
        return bState;
    }

    public AbstractTaskSubOperationTablePanel(DCSortableTreeTable oTaskTreeTable) {
        this.m_oTaskTreeTable = oTaskTreeTable;
        this.jinit();
        this.updateTableView();
    }

    protected void createDeviceNode(THashSet<Resource> oResList, boolean isTaskInprogress, TreeTableNode oOperationNode) {
        Resource oRes2 = null;
        ResourceProgressInfo oResourceProgressInfo = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        TreeTableRowData oRow = null;
        TreeTableCellData oDeviceName = null;
        TreeTableCellData oDeviceIP = null;
        TreeTableCellData oNEID = null;
        TreeTableCellData oDevType = null;
        TreeTableCellData oStartTime = null;
        TreeTableCellData oEndTime = null;
        TreeTableCellData oResult = null;
        TreeTableCellData oDesc = null;
        TreeTableNode oDeviceNode = null;
        DeviceInfo deviceInfo = null;
        String strDevInfo = "";
        String curOprId = OperationIdStore.getInstance().getOperationStrId(this.m_iCurrentOprID);
        DCDebugTracer.traceDetail("[record information] curOprId : " + curOprId);
        for (Resource oRes2 : oResList) {
            boolean bResInParse;
            deviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(oRes2.getDeviceID());
            if (null == deviceInfo) continue;
            oDeviceTypeInfo = deviceInfo.getDeviceTypeInfo();
            int iDevDomain = oDeviceTypeInfo.getDevDomain();
            if (3 == oRes2.getRoleType() && -1 != oRes2.getStackId()) continue;
            strDevInfo = oDeviceTypeInfo.getDevTypeName();
            if (4 != iDevDomain && !StringUtils.isNullOrEmptyStr(oDeviceTypeInfo.getDevTypeVersionName())) {
                strDevInfo = strDevInfo + "(" + oDeviceTypeInfo.getDevTypeVersionName() + ")";
            }
            if (null != (oResourceProgressInfo = isTaskInprogress ? oRes2.getProgressInfo() : oRes2.getOprResultInfo(curOprId))) {
                int currState = oRes2.getProgressInfo().getState();
                if (!oResourceProgressInfo.getCurrentOperationId().equals(curOprId) || currState != 1) {
                    oResourceProgressInfo = oRes2.getOprResultInfo(curOprId);
                }
            } else {
                oResourceProgressInfo = oRes2.getOprResultInfo(curOprId);
            }
            boolean bl = bResInParse = oRes2.getProgressInfo().getState() == 4;
            if (bResInParse && oRes2.getProgressInfo().getCurrentOperationId().equals(curOprId)) {
                oResourceProgressInfo = oRes2.getProgressInfo();
            }
            oRow = new TreeTableRowData(8, 2);
            oRow.setDevID(oRes2.getDeviceID());
            oDeviceName = new TreeTableCellData(oRes2.getDeviceName());
            oDeviceName.setNodeID(String.valueOf(oRes2.getDeviceID()));
            oDeviceIP = new TreeTableCellData(oRes2.getDeviceIP());
            oNEID = new TreeTableCellData("");
            oDevType = new TreeTableCellData(strDevInfo);
            oEndTime = new TreeTableCellData("");
            oStartTime = new TreeTableCellData("");
            oResult = new TreeTableCellData("");
            oDesc = new TreeTableCellData("");
            if (null != oResourceProgressInfo && oResourceProgressInfo.getCurrentOperationId().equals(curOprId)) {
                DCDebugTracer.traceDetail("[record information] oRes curOprId : " + oResourceProgressInfo.getCurrentOperationId());
                if (null != oResourceProgressInfo.getStartTime()) {
                    oStartTime = new TreeTableCellData(StringUtils.convertTimeToString(oResourceProgressInfo.getStartTime()));
                }
                if (0 != oResourceProgressInfo.getState() && 1 != oResourceProgressInfo.getState()) {
                    oResult = new TreeTableCellData(this.getResult(oResourceProgressInfo.getResult(), oResourceProgressInfo.getCurrentOperationId()));
                }
                if (null != oResourceProgressInfo.getEndTime()) {
                    oEndTime = new TreeTableCellData(StringUtils.convertTimeToString(oResourceProgressInfo.getEndTime()));
                    if (null != oResourceProgressInfo.getErrorInfo()) {
                        if (999293081 == oResourceProgressInfo.getErrorNo()) {
                            ErrorInfo oErrorInfo = null;
                            oErrorInfo = null != oRes2.getProgressInfo() ? new ErrorInfo(oResourceProgressInfo.getErrorNo(), oRes2.getProgressInfo().getErrorInfo()) : new ErrorInfo(oResourceProgressInfo.getErrorNo(), oResourceProgressInfo.getErrorInfo());
                            oDesc = new TreeTableCellData(oErrorInfo);
                        } else {
                            oDesc = 995098639 == oResourceProgressInfo.getErrorNo() ? new TreeTableCellData(DCCommonUtil.getFailureStr("", 995098639)) : new TreeTableCellData(oResourceProgressInfo.getErrorInfo());
                        }
                    }
                }
            } else {
                DCDebugTracer.traceDetail("[record information] oRes oResourceProgressInfo is null. ");
            }
            oRow.setColumnData(0, oDeviceName);
            oRow.setColumnData(1, oDeviceIP);
            if (4 == iDevDomain) {
                oNEID = new TreeTableCellData(this.getShowDevIdInfo(oRes2.getDeviceID()));
                oRow.setColumnData(2, oNEID);
            }
            oRow.setColumnData(3, oDevType);
            oRow.setColumnData(4, oStartTime);
            oRow.setColumnData(5, oEndTime);
            oRow.setColumnData(6, oResult);
            DCDebugTracer.traceDetail("[record information] oDesc : " + oDesc);
            oRow.setColumnData(7, oDesc);
            oDeviceNode = new TreeTableNode(oRow);
            oOperationNode.add(oDeviceNode);
        }
        DCDebugTracer.traceDetail("[record information] construct tree end..");
    }

    public TreeTableNode createTaskLevelOprNode() {
        String strOprName = this.getOperationNameBasedOnOprID();
        int iCount = this.m_oRootNode.getChildCount();
        for (int i = 0; i < iCount; ++i) {
            TreeTableNode oNode = (TreeTableNode)this.m_oRootNode.getChildAt(i);
            int OPR_NAME = 0;
            TreeTableRowData oData = null;
            TreeTableCellData oCellData = null;
            String strCellData = null;
            oData = (TreeTableRowData)oNode.getUserObject();
            if (null == oData || !strOprName.equals(strCellData = (String)(oCellData = oData.getColumnData(OPR_NAME)).getCellDataValue())) continue;
            return oNode;
        }
        TreeTableRowData oOprRow = new TreeTableRowData(8, 4);
        TreeTableCellData oOprNameCell = new TreeTableCellData(strOprName);
        oOprRow.setColumnData(0, oOprNameCell);
        TreeTableNode oNode = new TreeTableNode(oOprRow);
        return oNode;
    }

    private void createTreeTableModel() {
        String[] strColumnNames = new String[]{this.m_oResourceMngr.getResString("SUB_OPERATION"), this.m_oResourceMngr.getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"), this.m_oResourceMngr.getResString("NE_ID"), this.m_oResourceMngr.getResString("DEVICE_TYPE"), this.m_oResourceMngr.getResString("OPERATTION_RESULT_START_TIME"), this.m_oResourceMngr.getResString("OPERATTION_RESULT_END_TIME"), this.m_oResourceMngr.getResString("DEVICE_PROGRESS_TABLE_OPERATION_RESULT"), this.m_oResourceMngr.getResString("DETAILS_BUTTON")};
        Class[] oArrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        boolean[] oArrSortableColumns = new boolean[]{false, false, false, false, false, false, false, false};
        boolean[] oArrEditableColumns = new boolean[]{true, false, false, false, false, false, false, false};
        this.m_oOpResultTreeTableModel = new DCTreeTableModel(strColumnNames, oArrColumnTypes, oArrSortableColumns, oArrEditableColumns);
        this.m_oRootNode = this.m_oOpResultTreeTableModel.getRoot();
        this.m_oCustomTableColumnModel = new CustomTableColumnModel();
        oArrColumnTypes = null;
        oArrSortableColumns = null;
        oArrEditableColumns = null;
    }

    protected List<String> getCommandResultInfo(String strChkItem, int iReportType) {
        List<String> oTaskResultList = null;
        AsnDCGetDetailResultRsp oAsnDCGetDetailResultRsp = null;
        try {
            oAsnDCGetDetailResultRsp = TaskSyncCommController.getInstance().getDetailsResultList(this.m_oTaskObj.getTaskId(), this.m_oResource.getDeviceID(), iReportType, strChkItem);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("GET_COMMAND_RESULT_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return null;
        }
        if (3 != oAsnDCGetDetailResultRsp.enOperationId.value) {
            oTaskResultList = TaskCommUtil.getCommandResultList(oAsnDCGetDetailResultRsp.oAsnDCGetCommandResultRsp);
        }
        return oTaskResultList;
    }

    private List<String[]> getExtendResultInfo() {
        ArrayList<String[]> oTaskResultList = new ArrayList<String[]>();
        AsnGetDCExtendCheckResultRsq asnGetDCExtendCheckResultRsq = null;
        try {
            asnGetDCExtendCheckResultRsq = TaskSyncCommController.getInstance().getExtendDetailsResultList(this.m_oTaskObj.getTaskId(), this.m_oResource.getDeviceID());
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(989859153L), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return null;
        }
        AsnExtendCheckResult asnExtendCheckResult = asnGetDCExtendCheckResultRsq.oAsnExtendCheckResult;
        AsnExtendCheckResultLst asnExtendCheckResultLst = asnExtendCheckResult.oAsnExtendCheckResultLst;
        int k = 0;
        for (int i = 0; i < asnExtendCheckResultLst.size(); ++i) {
            AsnExtendCheckResultRowLst asnExtendCheckResultRowLst = (AsnExtendCheckResultRowLst)asnExtendCheckResultLst.get(i);
            String[] tmp = new String[asnExtendCheckResultRowLst.size() + 1];
            boolean isNeedToAdd = false;
            for (int j = 0; j < asnExtendCheckResultRowLst.size(); ++j) {
                AsnDCExtendCheckResultEle asnDCExtendCheckResultEle = (AsnDCExtendCheckResultEle)asnExtendCheckResultRowLst.get(j);
                tmp[j + 1] = new String(asnDCExtendCheckResultEle.strValue);
                String tmpStr = tmp[j + 1].trim().toUpperCase();
                if (!"(YES)".equals(tmpStr)) continue;
                isNeedToAdd = true;
            }
            if (i != 0 && !isNeedToAdd) continue;
            oTaskResultList.add(tmp);
            tmp[0] = String.valueOf(k);
            ++k;
            isNeedToAdd = false;
        }
        return oTaskResultList;
    }

    private TreeTableNode getNode(TreeTableNode oNode) {
        TreeTableNode oRequiredNode = null;
        int iCnt = oNode.getChildCount();
        TreeTableNode oChildNode = null;
        for (int i = 0; i < iCnt; ++i) {
            oChildNode = (TreeTableNode)oNode.getChildAt(i);
            if (0 == this.MOUSE_MOVED_OVER_ROW) {
                oRequiredNode = oChildNode;
                break;
            }
            --this.MOUSE_MOVED_OVER_ROW;
            oRequiredNode = this.getNode(oChildNode);
            if (null != oRequiredNode) break;
        }
        return oRequiredNode;
    }

    private int getNodeStatus(TreeTableRowData oNodeInfo) {
        int iStatus = -1;
        if (4 == this.m_iCurrentOprID || 16 == this.m_iCurrentOprID || 32 == this.m_iCurrentOprID || 33 == this.m_iCurrentOprID) {
            switch (oNodeInfo.getNodeStatus()) {
                case 1: {
                    iStatus = 1;
                    break;
                }
                case 2: {
                    iStatus = 2;
                    break;
                }
                case 4: {
                    iStatus = 4;
                    break;
                }
                case 3: {
                    iStatus = 3;
                    break;
                }
                default: {
                    iStatus = 0;
                    break;
                }
            }
        } else {
            switch (oNodeInfo.getNodeStatus()) {
                case 3: {
                    iStatus = 1;
                    break;
                }
                case 2: {
                    iStatus = 2;
                    break;
                }
                case 4: {
                    iStatus = 6;
                    break;
                }
                default: {
                    iStatus = 0;
                }
            }
        }
        return iStatus;
    }

    private String getOperationNameBasedOnOprID() {
        String strOperationName = "";
        List<ITaskDeviceOperation> oOprList = this.m_oTaskObj.getSupportedOperation();
        int iLen = oOprList.size();
        IOperation oObj = null;
        for (int i = 0; i < iLen; ++i) {
            oObj = oOprList.get(i);
            if (this.m_iCurrentOprID != oObj.getOperationId()) continue;
            strOperationName = oObj.getOperationName();
            break;
        }
        oObj = null;
        return strOperationName;
    }

    protected String getResult(int iOprResult, String sourceOper, boolean devLevel) {
        String str = "";
        switch (iOprResult) {
            case 0: {
                if (null != sourceOper) {
                    if (UFC_OPER.equals(sourceOper) || PRE_CHECK_OPER.equals(sourceOper) || "PreCheck".equals(sourceOper) || POST_CHECK_OPER.equals(sourceOper) || "PostCheck".equals(sourceOper)) {
                        str = DCConstants.OPEREATION_COMPLETE;
                        break;
                    }
                    if (4 == this.m_oTaskObj.getDeviceType().getDeviceDomain()) {
                        String alarmCheck = "ALARM";
                        String helalth = "HEALTH";
                        String extendCheck = "EXTENDCHECK";
                        if (0 == StringUtils.compareStr(PRE_CHECK_OPER, sourceOper) || 0 == StringUtils.compareStr(POST_CHECK_OPER, sourceOper) || 0 == StringUtils.compareStr(alarmCheck, sourceOper) || 0 == StringUtils.compareStr(helalth, sourceOper) || 0 == StringUtils.compareStr(extendCheck, sourceOper) || 0 == StringUtils.compareStr("PreCheck", sourceOper) || 0 == StringUtils.compareStr("PostCheck", sourceOper)) {
                            str = DCFrameWorkUtil.getLocalizedString("TASK_STATUS_0");
                            break;
                        }
                        str = DCFrameWorkUtil.getLocalizedString("TASK_SUCCESS_MESSAGE");
                        break;
                    }
                    if (devLevel && (SAVE.equals(sourceOper) || BACKUP.equals(sourceOper) || ACTIVE.equals(sourceOper) || ACTIVE_BEFORE.equals(sourceOper) || LOAD_SOFTWARE.equals(sourceOper) || ACTIVE_AFTER.equals(sourceOper))) {
                        str = DCFrameWorkUtil.getLocalizedString("TASK_SUCCESS_MESSAGE");
                        break;
                    }
                    if (devLevel && 2 == this.m_oTaskObj.getDeviceType().getDeviceDomain() && (LOAD_PATCH.equals(sourceOper) || DEL_PATCH.equals(sourceOper) || UPDATE_PATCH.equals(sourceOper))) {
                        str = DCFrameWorkUtil.getLocalizedString("TASK_SUCCESS_MESSAGE");
                        break;
                    }
                    DCDebugTracer.trace("AbstractTaskSubOperationTablePanel#getResult: iOprResult-->" + iOprResult + ";sourceOper-->" + sourceOper + ";devLevel-->" + devLevel + ";DeviceDomain-->" + this.m_oTaskObj.getDeviceType().getDeviceDomain());
                    str = DCFrameWorkUtil.getLocalizedString("TASK_SUCCESS_MESSAGE");
                    break;
                }
                str = DCFrameWorkUtil.getLocalizedString("TASK_SUCCESS_MESSAGE");
                break;
            }
            case 1: {
                str = DCFrameWorkUtil.getLocalizedString("TASK_FAILURE_MESSAGE");
                break;
            }
            case 2: {
                str = DCFrameWorkUtil.getLocalizedString("TASK_STATE_PAUSED");
                break;
            }
            case 3: {
                str = DCFrameWorkUtil.getLocalizedString("TASK_STATE_NOT_RUN");
                break;
            }
        }
        return str;
    }

    protected String getResult(int iOprResult, String sourceOper) {
        return this.getResult(iOprResult, sourceOper, false);
    }

    protected String getShowDevIdInfo(int iDevId) {
        DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevId);
        if (null == devInfo) {
            return DeviceInfoUtil.parseNEIDInt(iDevId);
        }
        if (2 == devInfo.getProtocol()) {
            return DeviceInfoUtil.parseNEIDInt(devInfo.getNEDevId());
        }
        return devInfo.getNeTId();
    }

    private AsnUpgradeFeasibilityRsp getUFCResultInfo(String strChkItem, int iReportType) {
        AsnDCGetDetailResultRsp oAsnDCGetDetailResultRsp = null;
        try {
            oAsnDCGetDetailResultRsp = TaskSyncCommController.getInstance().getDetailsResultList(this.m_oTaskObj.getTaskId(), this.m_oResource.getDeviceID(), iReportType, strChkItem);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResourceMngr.getResString("GET_COMMAND_RESULT_ERROR"), this.m_oResourceMngr.getResString("ERROR"), 0);
        }
        if (null == oAsnDCGetDetailResultRsp || 3 != oAsnDCGetDetailResultRsp.enOperationId.value) {
            return null;
        }
        return oAsnDCGetDetailResultRsp.oAsnUpgradeFeasibilityRsp;
    }

    private void initializeCellRenderers() {
        this.m_oTree.setCellRenderer(new TreeTableCustomRenderer());
        TableColumnModel oColumnModel = this.m_oOpResultTreeTable.getColumnModel();
        this.m_oDefaultRenderer = new DCTreeTableCellRenderer(this.m_oOpResultTreeTable, 2);
        this.m_oDefaultRenderer.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.gray));
        oColumnModel.getColumn(1).setCellRenderer(this.m_oDefaultRenderer);
        for (int i = 2; i <= 6; ++i) {
            oColumnModel.getColumn(i).setCellRenderer(this.m_oDefaultRenderer);
        }
        this.m_oLinkRenderer = new TreeTableLinkRenderer(this.m_oOpResultTreeTable, 2);
        this.m_oLinkRenderer.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Color.gray));
        oColumnModel.getColumn(7).setCellRenderer(this.m_oLinkRenderer);
        oColumnModel = null;
    }

    private void initializeTreeTable() {
        this.m_oTree = this.m_oOpResultTreeTable.getTree();
        this.m_oTree.setName("TaskMgmt_TaskTablePanelPanel_m_oTaskTree");
        this.m_oOpResultTreeTable.getTableHeader().setReorderingAllowed(false);
        TableColumn oFirstColumn = this.m_oCustomTableColumnModel.getColumn(0);
        oFirstColumn.setMinWidth(40);
        oFirstColumn.setPreferredWidth(150);
        oFirstColumn.setMaxWidth(800);
        this.m_oTree.setToggleClickCount(2);
        this.initializeCellRenderers();
        this.m_oOpResultTreeTable.setRowHeight(20);
        this.m_oOpResultTreeTable.setShowHorizontalLines(true);
        this.m_oOpResultTreeTable.setShowVerticalLines(false);
        this.m_oOpResultTreeTable.setColumnSelectionAllowed(false);
        this.m_oOpResultTreeTable.setRowSelectionAllowed(true);
        this.m_oOpResultTreeTable.getTableHeader().addMouseListener(new TableColumnFitAdapter());
    }

    protected boolean isShowLinkRender(int iCurrentOprID) {
        ResourceProgressInfo oResProgressInfo;
        if ((4 == iCurrentOprID || 16 == iCurrentOprID || 28 == iCurrentOprID || 29 == iCurrentOprID) && 1 != this.m_oTaskObj.getDeviceType().getDeviceDomain()) {
            return true;
        }
        return 8 == iCurrentOprID && null != this.m_oResource && null != (oResProgressInfo = this.m_oResource.getOprResultInfo("ActivateSoftware")) && 0 != oResProgressInfo.getErrorType();
    }

    protected boolean isTelnetDevicePresent(DeviceType oDevType) {
        boolean bTelnetSupported = false;
        int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        if (-1 == iSelectedRow) {
            return bTelnetSupported;
        }
        TreeTableNode oNode = null;
        TreeTableRowData oRowData = null;
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        if (null == oTreePath) {
            return bTelnetSupported;
        }
        oNode = (TreeTableNode)oTreePath.getLastPathComponent();
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return bTelnetSupported;
        }
        oRowData = (TreeTableRowData)oNode.getUserObject();
        if (!(oRowData.getUserObject() instanceof Resource)) {
            return bTelnetSupported;
        }
        Resource oRes = (Resource)oRowData.getUserObject();
        if (0 != (oRes.getUpgradeMode() & 0x1000)) {
            bTelnetSupported = true;
        }
        return bTelnetSupported;
    }

    protected void jinit() {
        this.createTreeTableModel();
        this.m_oOpResultTreeTable = new DCSortableTreeTable(this.m_oOpResultTreeTableModel);
        this.m_oOpResultTreeTable.setName("Tree_Table_taskmgmt.view.common");
        this.m_oOpResultTreeTable.setColumnModel(this.m_oCustomTableColumnModel);
        this.m_oOpResultTreeTable.createDefaultColumnsFromModel();
        this.m_oOpResultTreeTable.setShowHorizontalLines(true);
        this.m_oOpResultTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oOpResultTreeTable.setRowHeight(21);
        this.m_oOpResultTreeTable.getTableHeader().setPreferredSize(new Dimension(this.m_oOpResultTreeTable.getSize().width, 21));
        this.m_oOpResultTreeTable.setAutoCreateColumnsFromModel(false);
        this.m_oOpResultTreeTable.addMouseMotionListener(new OperationTableMouseMotionListener());
        this.m_oOpResultTreeTable.addMouseListener(new OperationTableMouseListener());
        this.m_oOpResultTreeTable.setRowSelectionAllowed(true);
        this.initializeTreeTable();
        this.m_oOpResultScrollPane = new JScrollPane((Component)((Object)this.m_oOpResultTreeTable));
        this.m_oOpResultScrollPane.setName("Tree_Table_Scrollpane_taskmgmt.view.common");
        this.m_oOpResultScrollPane.setName("TaskMgmt_TaskTablePanelPanel_m_oScrollPane");
        this.add(this.m_oOpResultScrollPane);
        this.setLayout(new GridLayout());
        this.setFocusable(true);
    }

    private void showCheckItemReport(String strCheckItem) {
        int iReportType = -1;
        if (this.m_iCurrentOprID == 4) {
            iReportType = 0;
        } else if (this.m_iCurrentOprID == 16) {
            iReportType = 1;
        } else if (this.m_iCurrentOprID == 28) {
            iReportType = 3;
        } else if (this.m_iCurrentOprID == 29) {
            iReportType = 4;
        }
        if (3 == iReportType) {
            AsnUpgradeFeasibilityRsp oAsnUpgradeFeasibilityRsp = this.getUFCResultInfo(strCheckItem, iReportType);
            UpgradeFeasibilityValidationManager.getInstance().showReportDlg(oAsnUpgradeFeasibilityRsp);
        } else if ("EXTENDCHECK".equals(strCheckItem)) {
            TreeTableCellData oCellData = (TreeTableCellData)this.m_oOpResultTreeTable.getValueAt(this.MOUSE_MOVED_OVER_ROW, 6);
            String oResult = (String)oCellData.getCellDataValue();
            if (this.m_oResourceMngr.getResString("FAILURE_RESULT").equals(oResult)) {
                List<String> oCmdResult = this.getCommandResultInfo(strCheckItem, iReportType);
                this.showCheckReportDlg(strCheckItem, iReportType, oCmdResult);
            } else {
                List<String[]> oExtendResult = this.getExtendResultInfo();
                if (oExtendResult.size() == 0) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("EXTEND_CHECK_SUCCESS_MSG"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
                    DCDebugTracer.trace("TaskSubOperationTablePanel#showCheckItemReport,oExtendResult is null.");
                    return;
                }
                String[] tableHeader = oExtendResult.get(0);
                oExtendResult.remove(0);
                ViewTableResultDlg dlg = new ViewTableResultDlg(tableHeader, oExtendResult);
                String dlgTitle = "";
                if (null != this.m_oResource) {
                    dlgTitle = "--" + this.m_oResource.getDeviceName();
                }
                dlg.setTitle(this.m_oResourceMngr.getResString("EXTENDCHECK") + dlgTitle);
                dlg.setVisible(true);
            }
        } else {
            List<String> oCmdResult = this.getCommandResultInfo(strCheckItem, iReportType);
            this.showCheckReportDlg(strCheckItem, iReportType, oCmdResult);
        }
    }

    private void showCheckReportDlg(String strCheckItem, int iReportType, List<String> oCmdResult) {
        String strContent = "";
        if (null != oCmdResult) {
            if (0 == iReportType || 1 == iReportType || 4 == iReportType) {
                strContent = oCmdResult.get(0);
            }
            ViewCommandResultDialog oDialog = null;
            int iDomain = this.m_oTaskObj.getDeviceType().getDeviceDomain();
            if (4 == iDomain) {
                String strChkItem = Normalizer.normalize(strCheckItem, Normalizer.Form.NFC);
                String strAlarmID = Normalizer.normalize("ALARM", Normalizer.Form.NFC);
                String strHealthID = Normalizer.normalize("HEALTH", Normalizer.Form.NFC);
                Collator oEquals = Collator.getInstance();
                if (oEquals.equals(strChkItem, strAlarmID) || oEquals.equals(strChkItem, strHealthID)) {
                    strCheckItem = strCheckItem + "_" + this.m_oResource.getDeviceName() + "_" + this.getShowDevIdInfo(this.m_oResource.getDeviceID());
                    oDialog = new ViewCommandResultDialog(strContent, strCheckItem);
                } else {
                    oDialog = new ViewCommandResultDialog(strContent);
                }
            } else {
                oDialog = new ViewCommandResultDialog(strContent);
            }
            oDialog.setTitle(this.m_oResourceMngr.getResString("VIEW_COMMAND_RESULT_TITLE"));
            oDialog.setVisible(true);
        }
    }

    private void showCompareResult() {
        List<String> oCmdResult = this.getCommandResultInfo("", 5);
        CompareFileDialog dialog = new CompareFileDialog((Frame)DCFrameWorkUtil.getMainFrame(), this.m_oResourceMngr.getResString("Activate_Command_Reports_Title"), true);
        dialog.setCompareContentAndInfo(this.m_oResourceMngr.getResString("PREACTIVATE_COMMAND_RESULT"), oCmdResult.get(0) + "", this.m_oResourceMngr.getResString("POSTACTIVATE_COMMAND_RESULT"), oCmdResult.get(1) + "");
        ConfigFileControl.releaseResource();
        dialog.setVisible(true);
    }

    protected int toView(int iColIndex) {
        int iCnt = this.m_oOpResultTreeTable.getColumnCount();
        TableColumn oCol = null;
        for (int i = 0; i < iCnt; ++i) {
            oCol = this.m_oCustomTableColumnModel.getColumn(i);
            if (oCol.getModelIndex() != iColIndex) continue;
            return i;
        }
        return -1;
    }

    protected void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getTableHeader().updateUI();
                AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.updateUI();
                AbstractTaskSubOperationTablePanel.this.m_oTree.updateUI();
            }
        });
    }

    class TreeTableCustomRenderer
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;

        TreeTableCustomRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree oTree, Object oValue, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int iRow, boolean bHasFocus) {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            oLabel.setIconTextGap(8);
            oLabel.setBorder(DCConstants.DEFAULT_TABLE_CELL_BORDER);
            TreeTableNode oNode = (TreeTableNode)oValue;
            TreeTableRowData oNodeInfo = (TreeTableRowData)oNode.getUserObject();
            if (oNodeInfo != null) {
                ImageIcon oSelectIcon = null;
                if (4 == oNodeInfo.getNodeType()) {
                    oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("ready.gif");
                } else if (5 == oNodeInfo.getNodeType()) {
                    switch (AbstractTaskSubOperationTablePanel.this.getNodeStatus(oNodeInfo)) {
                        case 0: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("play_red.gif");
                            break;
                        }
                        case 1: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("rpt_normal.gif");
                            break;
                        }
                        case 2: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("rpt_failure.gif");
                            break;
                        }
                        case 6: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("pause_red.gif");
                            break;
                        }
                        case 3: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("rpt_alarm.gif");
                            break;
                        }
                        case 5: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("rpt_noresult.gif");
                            break;
                        }
                        case 4: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("rpt_nocompare.gif");
                            break;
                        }
                        default: {
                            oSelectIcon = AbstractTaskSubOperationTablePanel.this.m_oResourceMngr.getImage("play_red.gif");
                            break;
                        }
                    }
                } else if (2 == oNodeInfo.getNodeType()) {
                    if (oNodeInfo.getUserObject() instanceof Resource) {
                        Resource oResource = (Resource)oNodeInfo.getUserObject();
                        int iDevID = oResource.getDeviceID();
                        oSelectIcon = ResourceManager.getInstance().getNeTypeImage(iDevID);
                    } else if (oNodeInfo instanceof TreeTableRowData) {
                        TreeTableRowData oRowData = oNodeInfo;
                        int iDevID = oRowData.getDevID();
                        oSelectIcon = ResourceManager.getInstance().getNeTypeImage(iDevID);
                    } else {
                        oSelectIcon = ResourceManager.getInstance().getImage("ic_device.gif");
                    }
                }
                oLabel.setIcon(oSelectIcon);
            }
            if (AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.isRowSelected(iRow)) {
                oLabel.setBackground(AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getSelectionBackground());
                oLabel.setForeground(Color.WHITE);
            } else {
                oLabel.setBackground(AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getBackground());
                oLabel.setForeground(AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getForeground());
            }
            oLabel.setText(oValue.toString());
            return oLabel;
        }
    }

    class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            if (-1 != AbstractTaskSubOperationTablePanel.this.toView(7) && AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.columnAtPoint(oPoint) == AbstractTaskSubOperationTablePanel.this.toView(7)) {
                AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW = 0;
                AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW = AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.rowAtPoint(oPoint);
                TreeTableNode oNode = AbstractTaskSubOperationTablePanel.this.getNode(AbstractTaskSubOperationTablePanel.this.m_oRootNode);
                TreeTableRowData oData = (TreeTableRowData)oNode.getUserObject();
                TreeTableCellData oCellData = oData.getColumnData(7);
                if (null == oCellData || String.valueOf(oCellData.getCellDataValue()).isEmpty()) {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(AbstractTaskSubOperationTablePanel.this.getParent(), cur);
                    return;
                }
                if (oCellData.getCellDataValue() instanceof String) {
                    String strCmd = (String)oCellData.getCellDataValue();
                    if (!strCmd.equals(DCFrameWorkUtil.getLocalizedString("CHECK_REPORT_VIEW_DETAIL")) && !ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(995098639L)).equals(strCmd)) {
                        Cursor cur = new Cursor(0);
                        DCFrameWorkUtil.setCursor(AbstractTaskSubOperationTablePanel.this.getParent(), cur);
                        return;
                    }
                    if (oCellData.getCellDataValue() instanceof ErrorInfo) {
                        Cursor oCur = new Cursor(12);
                        DCFrameWorkUtil.setCursor(AbstractTaskSubOperationTablePanel.this.getParent(), oCur);
                        return;
                    }
                    TableCellRenderer oRenderer = AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getCellRenderer(AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.rowAtPoint(oPoint), AbstractTaskSubOperationTablePanel.this.toView(7));
                    if (oRenderer instanceof TreeTableLinkRenderer) {
                        Cursor oCur = new Cursor(12);
                        DCFrameWorkUtil.setCursor(AbstractTaskSubOperationTablePanel.this.getParent(), oCur);
                    } else {
                        Cursor oCur = new Cursor(0);
                        DCFrameWorkUtil.setCursor(AbstractTaskSubOperationTablePanel.this.getParent(), oCur);
                    }
                } else {
                    Cursor oCur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(AbstractTaskSubOperationTablePanel.this.getParent(), oCur);
                }
            }
        }
    }

    class OperationTableMouseListener
    extends MouseAdapter {
        OperationTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent oMouseEvent) {
            String sLink;
            Point oPoint = oMouseEvent.getPoint();
            TableCellRenderer oRenderer = null;
            if (-1 != AbstractTaskSubOperationTablePanel.this.toView(7)) {
                oRenderer = AbstractTaskSubOperationTablePanel.this.m_oCustomTableColumnModel.getColumn(AbstractTaskSubOperationTablePanel.this.toView(7)).getCellRenderer();
            }
            if (null == oRenderer || AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.columnAtPoint(oPoint) != AbstractTaskSubOperationTablePanel.this.toView(7) || !(oRenderer instanceof TreeTableLinkRenderer)) {
                return;
            }
            AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW = AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getSelectedRow();
            String strChkItem = "";
            TreeTableCellData oCellData = (TreeTableCellData)AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getValueAt(AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW, 0);
            if (0 == AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW && (oCellData.toString().equals(ResourceManager.getInstance().getResString("UPGRADE_PRECHECK")) || oCellData.toString().equals(ResourceManager.getInstance().getResString("UPGRADE_POSTCHECK")))) {
                return;
            }
            oCellData = (TreeTableCellData)AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getValueAt(AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW, 7);
            TreeTableCellData oStartTimeCellData = (TreeTableCellData)AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getValueAt(AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW, 4);
            TreeTableCellData oEndTimeCellData = (TreeTableCellData)AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getValueAt(AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW, 5);
            if (null == oCellData || null == oStartTimeCellData || null == oEndTimeCellData) {
                return;
            }
            if (8 == AbstractTaskSubOperationTablePanel.this.m_iCurrentOprID && AbstractTaskSubOperationTablePanel.this.isShowLinkRender(AbstractTaskSubOperationTablePanel.this.m_iCurrentOprID)) {
                AbstractTaskSubOperationTablePanel.this.showCompareResult();
                return;
            }
            if (oCellData.getCellDataValue() instanceof String) {
                String strCmd = (String)oCellData.getCellDataValue();
                if (!strCmd.equals(DCFrameWorkUtil.getLocalizedString("CHECK_REPORT_VIEW_DETAIL")) && !ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(995098639L)).equals(strCmd)) {
                    return;
                }
            } else {
                if (oCellData.getCellDataValue() instanceof ErrorInfo) {
                    ErrorInfo oErrorInfo = (ErrorInfo)oCellData.getCellDataValue();
                    String strMessage = oErrorInfo.toString();
                    if (999293081 == oErrorInfo.getErrorCode()) {
                        ViewCommandResultDialog dialog = new ViewCommandResultDialog(strMessage);
                        dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                        dialog.getContentTextArea().setLineWrap(true);
                        dialog.setVisible(true);
                    }
                    return;
                }
                return;
            }
            if (1 == AbstractTaskSubOperationTablePanel.this.m_oTaskObj.getDeviceType().getDeviceDomain()) {
                return;
            }
            oCellData = (TreeTableCellData)AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getValueAt(AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW, 0);
            if (null != oCellData) {
                strChkItem = oCellData.getNodeID();
            }
            if (null == (sLink = ((TreeTableCellData)AbstractTaskSubOperationTablePanel.this.m_oOpResultTreeTable.getValueAt(AbstractTaskSubOperationTablePanel.this.MOUSE_MOVED_OVER_ROW, 7)).toString()) || "".equals(sLink)) {
                return;
            }
            AbstractTaskSubOperationTablePanel.this.showCheckItemReport(strChkItem);
        }

        @Override
        public void mouseExited(MouseEvent oMouseEvent) {
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        }
    }
}

