/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnProtocolEnum;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSetting;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSettingInfo;
import com.huawei.dc.common.asndatacenter.AsnThirdPartyFTPServerSettingLst;
import com.huawei.dc.common.components.DCDateChooser;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.system.SystemSettingUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.configuration.system.ProtocolConfigInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationType;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.ActivationPackageDlg;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.GroupingActiveForDevDlg;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.backup.TaskBackupOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PostcheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PrecheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.LoadDataOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.updatedata.UpdateConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.updatedata.UpdateDataOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradefeasibility.UpgradeFeasibilityOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeswitch.SetWorkModeOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.ITaskTypeConfiguration;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.CreateTaskDialog;
import com.huawei.dc.taskmgmt.view.model.OperationDetailsObj;
import com.huawei.dc.taskmgmt.view.model.TaskMgmtOperationSelecModel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public final class TaskMgmtOperationSelecPanelHelper {
    private static final String strProtocolType = ResourceManager.getInstance().getResString("FTP");

    public static void updateCellEditorValue(int iOperationId, JTable m_oOperationTable) {
        int iTotalRows = m_oOperationTable.getRowCount();
        for (int i = 0; i < iTotalRows; ++i) {
            OperationDetailsObj oDetailsObj = (OperationDetailsObj)m_oOperationTable.getValueAt(i, 0);
            if (iOperationId != oDetailsObj.getOperationId()) continue;
            oDetailsObj.setIsOperationSelected(false);
        }
    }

    public static void updateWorkMode(ITaskDeviceOperation oTaskDevOP, JTable m_oOperationTable) {
        ITaskDeviceOperation oSetWorkModeOp;
        ITask oTask;
        boolean bIsOperationAvailable;
        ActivationOperation oTaskActivateOperation;
        boolean isSetOperSelected;
        if (oTaskDevOP instanceof SetWorkModeOperation) {
            ITask oTask2;
            boolean bIsOperationAvailable2;
            SetWorkModeOperation oSetWorkModeOp2 = (SetWorkModeOperation)oTaskDevOP;
            boolean isSetOperSelected2 = oSetWorkModeOp2.isSelected();
            if (isSetOperSelected2 && (bIsOperationAvailable2 = TaskCommUtil.isOperationAvailable((oTask2 = oSetWorkModeOp2.getOperationData()).getSupportedOperation(), "ActivateSoftware"))) {
                ActivationOperation oTaskActivateOperation2 = (ActivationOperation)TaskCommUtil.getTaskOperation(oTask2.getSupportedOperation(), "ActivateSoftware");
                if (!oTaskActivateOperation2.isSelected()) {
                    oTaskActivateOperation2.setSelected(true);
                    TaskMgmtOperationSelecPanelHelper.updateCellEditorValue(oTaskActivateOperation2.getOperationId(), m_oOperationTable);
                } else {
                    String strSelectedActivateType = oTaskActivateOperation2.getActivateConfigPara().getSelectedActivateType().getParaValue().getId();
                    if (!"ISSU".equals(strSelectedActivateType)) {
                        ActivationConfigPara activationConfigPara = oTaskActivateOperation2.getActivateConfigPara();
                        ActivationType activationTyper = activationConfigPara.getActivationTypePara("ISSU");
                        oTaskActivateOperation2.getActivateConfigPara().setSelectedActivateType(activationTyper);
                        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ACTIVATE_OPERATION_CONFIG_DEPENDS_ON_SETWORK_MODE"));
                    }
                }
            }
        } else if (oTaskDevOP instanceof ActivationOperation && !(isSetOperSelected = (oTaskActivateOperation = (ActivationOperation)oTaskDevOP).isSelected()) && (bIsOperationAvailable = TaskCommUtil.isOperationAvailable((oTask = oTaskActivateOperation.getOperationData()).getSupportedOperation(), "SetWorkMode")) && (oSetWorkModeOp = TaskCommUtil.getTaskOperation(oTask.getSupportedOperation(), "SetWorkMode")).isSelected()) {
            oSetWorkModeOp.setSelected(false);
            TaskMgmtOperationSelecPanelHelper.updateCellEditorValue(oSetWorkModeOp.getOperationId(), m_oOperationTable);
        }
    }

    public static boolean isSelectTargetStep(int operationId, TaskMgmtOperationSelecModel m_oTaskPanelModel) {
        DCDebugTracer.trace("method isSelectTargetStep start");
        DCDebugTracer.trace("operationId : " + operationId);
        boolean isSel = false;
        ITaskDeviceOperation oTaskDevOP = m_oTaskPanelModel.getTaskOpObj(operationId);
        if (null != oTaskDevOP) {
            isSel = oTaskDevOP.isSelected();
        }
        DCDebugTracer.trace("is sel : " + isSel);
        DCDebugTracer.trace("method isSelectTargetStep end..");
        return isSel;
    }

    public static ValidationResult validateOperationSelection(ITask m_oTaskDataObj) {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        List<ITaskDeviceOperation> oSuppOpLst = m_oTaskDataObj.getSupportedOperation();
        int iRows = oSuppOpLst.size();
        boolean bIsOperationSelected = false;
        for (int i = 0; i < iRows; ++i) {
            ITaskDeviceOperation oTaskOp = oSuppOpLst.get(i);
            if (!oTaskOp.isSelected()) continue;
            bIsOperationSelected = true;
            break;
        }
        if (!bIsOperationSelected) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("SELECT_ANY_OPERATION"));
        }
        return oValidationResult;
    }

    private static void checkTime(Object oObj, ValidationResult oValidationResult, JCheckBox m_oStartTimeCheckbox, DCDateChooser m_ostartTimeTxt, String m_strDefaultTImeString) {
        GroupingActiveForDevDlg oGroupingActiveForDevDlg = null;
        ActivationPackageDlg oActivationPackageDlg = null;
        Calendar oStartTime = null;
        if (oObj instanceof GroupingActiveForDevDlg) {
            oGroupingActiveForDevDlg = (GroupingActiveForDevDlg)((Object)oObj);
            oStartTime = oGroupingActiveForDevDlg.getMainPan().getActivateTime();
        } else {
            oActivationPackageDlg = (ActivationPackageDlg)((Object)oObj);
            oStartTime = oActivationPackageDlg.getMainPan().getActivateTime();
        }
        if (m_oStartTimeCheckbox.isSelected() && !Collator.getInstance().equals(m_ostartTimeTxt.getTextField().getText(), m_strDefaultTImeString) && null != oStartTime && null != m_ostartTimeTxt.getCalendar() && oStartTime.before(m_ostartTimeTxt.getCalendar())) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(DCFrameWorkUtil.getLocalizedString("ACTIVATION_TIME_LESSER_START_TIME"));
        }
    }

    public static ValidationResult validateOperationConfigured(ITask m_oTaskDataObj, JCheckBox m_oStartTimeCheckbox, DCDateChooser m_ostartTimeTxt, String m_strDefaultTImeString) {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        List<ITaskDeviceOperation> oSuppOpLst = m_oTaskDataObj.getSupportedOperation();
        int iRows = oSuppOpLst.size();
        for (int i = 0; i < iRows; ++i) {
            ITaskDeviceOperation oTaskOp = oSuppOpLst.get(i);
            if (!oTaskOp.isSelected()) continue;
            oValidationResult = oTaskOp.validateOperationConfigurations();
            if (-1 != oValidationResult.getErrorCode() && oTaskOp instanceof ActivationOperation) {
                TaskMgmtOperationSelecPanelHelper.validateStartTimeAndActivateTime((ActivationOperation)oTaskOp, oValidationResult, m_oStartTimeCheckbox, m_ostartTimeTxt, m_strDefaultTImeString);
            }
            if (-1 == oValidationResult.getErrorCode()) break;
        }
        return oValidationResult;
    }

    private static void validateStartTimeAndActivateTime(ActivationOperation oOperation, ValidationResult oValidationResult, JCheckBox m_oStartTimeCheckbox, DCDateChooser m_ostartTimeTxt, String m_strDefaultTImeString) {
        GroupingActiveForDevDlg oGroupingActiveForDevDlg = null;
        ActivationPackageDlg oActivationPackageDlg = null;
        if (oOperation.getGroupingActivationPan() instanceof GroupingActiveForDevDlg) {
            oGroupingActiveForDevDlg = (GroupingActiveForDevDlg)((Object)oOperation.getGroupingActivationPan());
            if (oGroupingActiveForDevDlg != null) {
                TaskMgmtOperationSelecPanelHelper.checkTime((Object)oGroupingActiveForDevDlg, oValidationResult, m_oStartTimeCheckbox, m_ostartTimeTxt, m_strDefaultTImeString);
            }
        } else if (oOperation.getGroupingActivationPan() instanceof ActivationPackageDlg && (oActivationPackageDlg = (ActivationPackageDlg)((Object)oOperation.getGroupingActivationPan())) != null) {
            TaskMgmtOperationSelecPanelHelper.checkTime((Object)oActivationPackageDlg, oValidationResult, m_oStartTimeCheckbox, m_ostartTimeTxt, m_strDefaultTImeString);
        }
    }

    public static void selectedTaskDeviceOperation(ITaskDeviceOperation oTaskOp, int iTypeId) {
        if (oTaskOp.isEnabled()) {
            if (oTaskOp instanceof UpgradeFeasibilityOperation) {
                if (CreateTaskDialog.isProxied()) {
                    oTaskOp.setEnabled(false);
                    oTaskOp.setSelected(false);
                } else {
                    oTaskOp.setSelected(true);
                }
            } else if (oTaskOp instanceof LoadSoftwareOperation) {
                oTaskOp.setSelected(true);
            } else if (oTaskOp instanceof TaskBackupOperation) {
                if (2 == iTypeId) {
                    oTaskOp.setSelected(false);
                } else {
                    oTaskOp.setSelected(true);
                }
            } else if (oTaskOp instanceof LoadDataOperation) {
                oTaskOp.setSelected(false);
            } else {
                oTaskOp.setSelected(true);
            }
        } else {
            oTaskOp.setSelected(false);
        }
    }

    public static boolean isMultiDevTypeTask(ITask m_oTaskDataObj) {
        return m_oTaskDataObj.getDeviceTypes().size() > 1;
    }

    public static void fillRowData(Vector oRowDataVector, ITaskDeviceOperation oTaskOp) {
        OperationDetailsObj oOperationObj = new OperationDetailsObj(oTaskOp.getOperationId(), oTaskOp.getOperationName(), oTaskOp.isSelected());
        oRowDataVector.add(oOperationObj);
        oRowDataVector.add(oTaskOp.getOperationDesc());
        oRowDataVector.add(oTaskOp.isPauseBeforeCurOp());
    }

    public static void updateWorkModeOperation(SetWorkModeOperation oSetWorkModeOp, THashSet<Resource> oResources, ITask m_oTaskDataObj) {
        if (null == oResources || 0 >= oResources.size()) {
            return;
        }
        boolean bEnableOperation = true;
        Iterator oResItor = oResources.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            int iUpgradeMode = oRes.getUpgradeMode();
            if (0 != (iUpgradeMode & 0x80)) continue;
            bEnableOperation = false;
            break;
        }
        if (null != oSetWorkModeOp) {
            if (!bEnableOperation) {
                oSetWorkModeOp.setSelected(false);
                oSetWorkModeOp.setEnabled(false);
            } else {
                oSetWorkModeOp.setEnabled(true);
            }
        } else {
            TaskMgmtOperationSelecPanelHelper.updateSpecifiedOperation(22, bEnableOperation, m_oTaskDataObj);
        }
    }

    public static void enableAllOperations(boolean bEnable, ITask m_oTaskDataObj) {
        List<ITaskDeviceOperation> oOperationLst = m_oTaskDataObj.getSupportedOperation();
        int iOpCount = oOperationLst.size();
        for (int i = 0; i < iOpCount; ++i) {
            boolean isPTNDevice;
            ITaskDeviceOperation oDevOperation = oOperationLst.get(i);
            if (!oDevOperation.isEnabled() || (isPTNDevice = TaskInfoUtil.isContainsPTNDevices(m_oTaskDataObj)) && oDevOperation instanceof UpgradeFeasibilityOperation) continue;
            oDevOperation.setEnabled(bEnable);
        }
    }

    public static void updateSpecifiedOperation(int iOperationId, boolean bEnable, ITask m_oTaskDataObj) {
        List<ITaskDeviceOperation> oOperationLst = m_oTaskDataObj.getSupportedOperation();
        int iOpCount = oOperationLst.size();
        for (int i = 0; i < iOpCount; ++i) {
            ITaskDeviceOperation oDevOperation = oOperationLst.get(i);
            if (iOperationId != oDevOperation.getOperationId()) continue;
            if (iOperationId == 33) {
                PostUpgradeOperation oPostOper = (PostUpgradeOperation)oDevOperation;
                List<IUpgradeSubOperation> oSubOPerLst = oPostOper.getUpgradeSubOperationList();
                if (null == oSubOPerLst) continue;
                for (int j = 0; j < oSubOPerLst.size(); ++j) {
                    IUpgradeSubOperation oSubOper = oSubOPerLst.get(j);
                    if ("UpdatePackage".equals(oSubOper.getOperationIdString())) continue;
                    oSubOper.setSelected(bEnable);
                }
                continue;
            }
            if (!bEnable) {
                oDevOperation.setSelected(false);
                oDevOperation.setEnabled(bEnable);
                break;
            }
            oDevOperation.setEnabled(true);
            break;
        }
    }

    public static String generateOplinkDesc(ITaskDeviceOperation oTaskDeviceOperation, ITask oTaskObj, TaskMgmtOperationSelecModel oTaskPanelModel, ComboBoxWithToolTip oTargetVersionComboBox) {
        if (null == oTaskDeviceOperation) {
            return "";
        }
        String desc = oTaskDeviceOperation.getOperationDesc();
        String opeId = oTaskDeviceOperation.getOperationIdString().trim();
        String strOplink = null;
        DCDebugTracer.trace("TaskMgmtOperationSelecPanelHelper#generateOplinkDesc#opeId:" + opeId);
        strOplink = "UpdateData".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForUpdateData(oTaskDeviceOperation, oTaskPanelModel) : ("LoadSoftware".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForLoadSoft(oTaskDeviceOperation, oTaskObj) : ("LoadPatch".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForLoadPatch(oTaskDeviceOperation, oTargetVersionComboBox) : ("LoadData".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForLoadData(oTaskDeviceOperation) : ("ActivateSoftware".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForActivateSoft(oTaskDeviceOperation, oTaskObj) : ("Recover".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForRecover(oTaskDeviceOperation, oTaskObj) : ("PrepareUpgrade".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForPrepareUpgrade(oTaskDeviceOperation, oTaskObj) : ("PostUpgrade".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForPostUpgrade(oTaskDeviceOperation, oTaskObj) : ("PreCheck".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForPreCheck(oTaskDeviceOperation, oTaskObj) : ("PostCheck".equals(opeId) ? TaskMgmtOperationSelecPanelHelper.generateLinkForPostCheck(oTaskDeviceOperation, oTaskObj) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true))))))))));
        DCDebugTracer.trace("TaskMgmtOperationSelecPanelHelper#generateOplinkDesc#strOplink:" + strOplink);
        return strOplink;
    }

    private static String generateLinkForPostCheck(ITaskDeviceOperation oTaskDeviceOperation, ITask oTaskObj) {
        String strOplink = "";
        PostcheckOperation postCheckOpe = (PostcheckOperation)oTaskDeviceOperation;
        strOplink = postCheckOpe.isSelected() ? (oTaskObj.isBMSDomain() ? (postCheckOpe.isSelectAnyCheckItem() ? TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), true) : TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), false)) : TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), true)) : oTaskDeviceOperation.getOperationDesc();
        return strOplink;
    }

    private static String generateLinkForPreCheck(ITaskDeviceOperation oTaskDeviceOperation, ITask oTaskObj) {
        String strOplink = "";
        PrecheckOperation preCheckOpe = (PrecheckOperation)oTaskDeviceOperation;
        strOplink = preCheckOpe.isSelected() ? (oTaskObj.isBMSDomain() ? (preCheckOpe.isSelectAnyCheckItem() ? TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), true) : TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), false)) : TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), true)) : oTaskDeviceOperation.getOperationDesc();
        return strOplink;
    }

    private static String generateLinkForPostUpgrade(ITaskDeviceOperation oTaskDeviceOperation, ITask oTaskObj) {
        String strOplink = "";
        PostUpgradeOperation oPostOper = (PostUpgradeOperation)oTaskDeviceOperation;
        if (oPostOper.isSelected()) {
            List<IUpgradeSubOperation> oSubOprLst = oPostOper.getUpgradeSubOperationList();
            boolean isBlue = false;
            for (IUpgradeSubOperation oSubOpr : oSubOprLst) {
                if (null == oSubOpr || !oSubOpr.isSelected()) continue;
                isBlue = true;
                break;
            }
            strOplink = TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), isBlue);
        } else {
            strOplink = TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), oPostOper.isSomeSubOperationSelected());
        }
        return strOplink;
    }

    private static String generateLinkForPrepareUpgrade(ITaskDeviceOperation oTaskDeviceOperation, ITask oTaskObj) {
        String strOplink = "";
        PrepareUpgradeOperation oPrepare = (PrepareUpgradeOperation)oTaskDeviceOperation;
        strOplink = TaskMgmtOperationSelecPanelHelper.getLinkString(oTaskDeviceOperation.getOperationDesc(), oPrepare.isSomeSubOperationSelected());
        return strOplink;
    }

    private static String generateLinkForUpdateData(ITaskDeviceOperation oTaskDeviceOperation, TaskMgmtOperationSelecModel oTaskPanelModel) {
        String strOplink = "";
        String desc = oTaskDeviceOperation.getOperationDesc();
        UpdateDataOperation updateDataOpe = (UpdateDataOperation)oTaskDeviceOperation;
        UpdateConfigParam updateConfigParam = (UpdateConfigParam)updateDataOpe.getConfiguredPara();
        strOplink = updateConfigParam.isDefaultSelected() || !StringUtils.isNullOrEmptyStr(updateConfigParam.getUpdateToolPathSelected()) ? TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false);
        return strOplink;
    }

    private static String generateLinkForLoadSoft(ITaskDeviceOperation oTaskDeviceOperation, ITask m_oTaskDataObj) {
        String strOplink = "";
        String desc = oTaskDeviceOperation.getOperationDesc();
        boolean isNotConfig = true;
        if (m_oTaskDataObj.getTaskTypeId() == 3) {
            LoadSimPackageInfo loadSimPackageInfo = m_oTaskDataObj.getLoadSimPackageInfo();
            if (loadSimPackageInfo != null) {
                isNotConfig = 0 == loadSimPackageInfo.getDevList().size();
            }
        } else {
            LoadFileInfoListParam loadFileInfoListParam = (LoadFileInfoListParam)oTaskDeviceOperation.getConfiguredPara();
            boolean bSelectUFC = DCCommonUtil.isOprSelected(m_oTaskDataObj, 28);
            boolean bHaveProgramFile = DCCommonUtil.isHaveTargetFileType(loadFileInfoListParam.getLoadFileInfoList(), "PROGRAM");
            boolean bHavePackageFile = DCCommonUtil.isHaveTargetFileType(loadFileInfoListParam.getLoadFileInfoList(), "PACKAGE");
            boolean bHavePackageFileCode = DCCommonUtil.isHaveTargetFileType(loadFileInfoListParam.getLoadFileInfoList(), 25);
            boolean bHavePacketFile = DCCommonUtil.isHaveTargetFileType(loadFileInfoListParam.getLoadFileInfoList(), "PACKETFILE");
            isNotConfig = bSelectUFC ? !bSelectUFC || !bHaveProgramFile && !bHavePackageFile && !bHavePackageFileCode && !bHavePacketFile : 0 == loadFileInfoListParam.getNumberOfFiles();
        }
        strOplink = isNotConfig ? TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true);
        return strOplink;
    }

    private static String generateLinkForLoadPatch(ITaskDeviceOperation oTaskDeviceOperation, ComboBoxWithToolTip oTargetVersionComboBox) {
        String strOplink = "";
        String desc = oTaskDeviceOperation.getOperationDesc();
        boolean isNotConfig = true;
        LoadFileInfoListParam loadFileInfoListParam = (LoadFileInfoListParam)oTaskDeviceOperation.getConfiguredPara();
        boolean bl = isNotConfig = 0 == loadFileInfoListParam.getNumberOfFiles();
        strOplink = isNotConfig ? (TaskMgmtOperationSelecPanelHelper.isSelectTargetVersion(oTargetVersionComboBox) ? TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false)) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true);
        return strOplink;
    }

    public static boolean isSelectTargetVersion(ComboBoxWithToolTip oTargetVersionComboBox) {
        boolean isSel = false;
        if (null == oTargetVersionComboBox) {
            return isSel;
        }
        if (null == oTargetVersionComboBox.getSelectedItem()) {
            return isSel;
        }
        String strTargetVersion = oTargetVersionComboBox.getSelectedItem().toString();
        if (!StringUtils.isNullOrEmptyStr(strTargetVersion.trim())) {
            isSel = true;
        }
        return isSel;
    }

    private static String generateLinkForLoadData(ITaskDeviceOperation oTaskDeviceOperation) {
        String strOplink = "";
        String desc = oTaskDeviceOperation.getOperationDesc();
        LoadFileInfoListParam loadFileInfoListParam = (LoadFileInfoListParam)oTaskDeviceOperation.getConfiguredPara();
        boolean isNotHaveLoadFile = true;
        List<LoadFileInfo> m_oLoadFileInfoList = loadFileInfoListParam.getLoadFileInfoList();
        if (null != m_oLoadFileInfoList && 0 != m_oLoadFileInfoList.size()) {
            int configureFileCount = 0;
            for (LoadFileInfo fileInfo : m_oLoadFileInfoList) {
                if (StringUtils.isNullOrEmptyStr(fileInfo.getFileName()) && !fileInfo.isLoadDefaultFile()) continue;
                ++configureFileCount;
            }
            isNotHaveLoadFile = configureFileCount != m_oLoadFileInfoList.size();
        }
        strOplink = isNotHaveLoadFile ? TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true);
        return strOplink;
    }

    private static String generateLinkForActivateSoft(ITaskDeviceOperation oTaskDeviceOperation, ITask m_oTaskDataObj) {
        int innerTaskTypeId;
        String strOplink = "";
        String desc = oTaskDeviceOperation.getOperationDesc();
        strOplink = m_oTaskDataObj.getTaskTypeId() == 3 || m_oTaskDataObj.getTaskTypeId() == 5 ? TaskMgmtOperationSelecPanelHelper.getLinkStringWithMiniCAndDiffTask(desc, m_oTaskDataObj) : (13 == m_oTaskDataObj.getTaskTypeId() || 4 == m_oTaskDataObj.getTaskTypeId() ? TaskMgmtOperationSelecPanelHelper.getLinkStringWithPackageTask(desc, m_oTaskDataObj) : (-1 != TaskInfoUtil.getInnerTaskTypeIDByTaskObj(m_oTaskDataObj) && m_oTaskDataObj.getTaskTypeId() != TaskInfoUtil.getInnerTaskTypeIDByTaskObj(m_oTaskDataObj) ? ((innerTaskTypeId = TaskInfoUtil.getInnerTaskTypeIDByTaskObj(m_oTaskDataObj)) == 3 || innerTaskTypeId == 5 ? TaskMgmtOperationSelecPanelHelper.getLinkStringWithMiniCAndDiffTask(desc, m_oTaskDataObj) : (13 == innerTaskTypeId || 4 == innerTaskTypeId ? TaskMgmtOperationSelecPanelHelper.getLinkStringWithPackageTask(desc, m_oTaskDataObj) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true))) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true)));
        return strOplink;
    }

    private static String getLinkStringWithPackageTask(String desc, ITask m_oTaskDataObj) {
        ActivationOperation oTaskActivateOperation = (ActivationOperation)TaskCommUtil.getTaskOperation(m_oTaskDataObj.getSupportedOperation(), "ActivateSoftware");
        ActivationConfigPara oActivationConfigPara = oTaskActivateOperation.getActivateConfigPara();
        if (null != oActivationConfigPara && oActivationConfigPara.getActivateGroupInfoLst().size() > 0) {
            return TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true);
        }
        return TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false);
    }

    private static String getLinkStringWithMiniCAndDiffTask(String desc, ITask m_oTaskDataObj) {
        if (m_oTaskDataObj.getTaskTypeId() == 5 && 1 == m_oTaskDataObj.getUpgradeLevel()) {
            ActivationOperation oTaskActivateOperation = (ActivationOperation)TaskCommUtil.getTaskOperation(m_oTaskDataObj.getSupportedOperation(), "ActivateSoftware");
            if (oTaskActivateOperation.isConfigActiveGroup()) {
                return TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true);
            }
            return TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false);
        }
        ActiveInfo activeInfo = m_oTaskDataObj.getActivationInfo();
        if (null != activeInfo && activeInfo.getGroupList().size() > 0) {
            return TaskMgmtOperationSelecPanelHelper.getLinkString(desc, true);
        }
        return TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false);
    }

    public static String generateLinkForRecover(ITaskDeviceOperation oTaskDeviceOperation, ITask m_oTaskDataObj) {
        String strOplink = "";
        String desc = oTaskDeviceOperation.getOperationDesc();
        RecoverDBOperation updateDataOpe = (RecoverDBOperation)oTaskDeviceOperation;
        RecoverDBConfigPara updateConfigParam = (RecoverDBConfigPara)updateDataOpe.getConfiguredPara();
        List<ActivationGroupInfo> activationGroupInfoLst = null;
        List<RecoverElementInfo> recoverElementInfoLst = null;
        if (null != updateConfigParam) {
            activationGroupInfoLst = updateConfigParam.getActivateGroupInfoLst();
            recoverElementInfoLst = updateConfigParam.getRecoverElementInfoLst();
        }
        strOplink = 13 == m_oTaskDataObj.getTaskTypeId() && null != recoverElementInfoLst && recoverElementInfoLst.size() > 0 ? TaskMgmtOperationSelecPanelHelper.getLinkString(desc, TaskMgmtOperationSelecPanelHelper.isRecoverElementValid(recoverElementInfoLst)) : (activationGroupInfoLst != null && activationGroupInfoLst.size() > 0 && recoverElementInfoLst != null && recoverElementInfoLst.size() > 0 ? TaskMgmtOperationSelecPanelHelper.getLinkString(desc, TaskMgmtOperationSelecPanelHelper.isRecoverElementValid(recoverElementInfoLst)) : TaskMgmtOperationSelecPanelHelper.getLinkString(desc, false));
        return strOplink;
    }

    public static String getLinkString(String desc, boolean isBule) {
        DCDebugTracer.trace("TaskMgmtOperationSelecPanelHelper#getLinkString:" + desc + "->isBule:" + isBule);
        String strOplink = isBule ? "<html><a href=\"x\">" + desc + "</a>" + "</html>" : "<html><a href=\"x\" color = 'red'>" + desc + "</a>" + "</html>";
        return strOplink;
    }

    public static void updateBackupConfigParamForFTP(ITask oTaskDataObj, ContentConfigParam oBackupCfParam) {
        if (oTaskDataObj.isThirdPartySupported()) {
            Object[] oContentTypeArray = oBackupCfParam.getContentTypeList();
            ContentType oContentType = null;
            for (int i = 0; i < oContentTypeArray.length; ++i) {
                oContentType = (ContentType)oContentTypeArray[i];
                if (Collator.getInstance().equals(oContentType.getId(), "Log") || Collator.getInstance().equals(oContentType.getId(), "Trap")) {
                    oContentType.setSelected(false);
                    oContentType.setEnabled(false);
                }
                oContentType.setDestination("BackupFolder");
                oContentTypeArray[i] = oContentType;
            }
            List<ContentType> oContentTypeList = oBackupCfParam.getSelectedContentType();
            for (int i = oContentTypeList.size() - 1; i >= 0; --i) {
                oContentType = oContentTypeList.get(i);
                if (Collator.getInstance().equals(oContentType.getId(), "Log") || Collator.getInstance().equals(oContentType.getId(), "Trap")) {
                    oContentTypeList.remove(i);
                }
                oContentType.setDestination("BackupFolder");
            }
        } else {
            ContentConfigParam oParam = new ContentConfigParam(oBackupCfParam.getParaList());
            if (oTaskDataObj.getTaskTypeId() == 2) {
                oParam.setSelectedContentTypeId("PATCH");
            }
            if (oTaskDataObj.getTaskDeviceOperation(2) instanceof TaskBackupOperation) {
                ((TaskBackupOperation)oTaskDataObj.getTaskDeviceOperation(2)).setConfiguredPara(oParam);
            }
        }
    }

    public static boolean isRecoverElementValid(List<RecoverElementInfo> oRecoverEleLst) {
        boolean bValid = true;
        if (null == oRecoverEleLst) {
            return false;
        }
        for (RecoverElementInfo oRecoverEleInfo : oRecoverEleLst) {
            if (null == oRecoverEleInfo || !StringUtils.isNullOrEmptyStr(oRecoverEleInfo.getRecoverFilePath())) continue;
            bValid = false;
            break;
        }
        return bValid;
    }

    public static boolean checkIfUpgradeTypeChanged(ITask oTaskObj, String strContentType) {
        boolean bCheckIfChanged = false;
        if (null == oTaskObj.getTaskContentType()) {
            return false;
        }
        bCheckIfChanged = !Collator.getInstance().equals(strContentType, oTaskObj.getTaskContentType().getId());
        return bCheckIfChanged;
    }

    public static boolean checkIfViewTypeChanged(ITask oTaskObj, int iTaskViewType) {
        boolean bViewTypeChanged = true;
        if (!(1 != iTaskViewType && 3 != iTaskViewType || 1 != oTaskObj.getTaskViewType() && 3 != oTaskObj.getTaskViewType())) {
            bViewTypeChanged = false;
        } else if (!(2 != iTaskViewType && 4 != iTaskViewType || 2 != oTaskObj.getTaskViewType() && 4 != oTaskObj.getTaskViewType())) {
            bViewTypeChanged = false;
        } else if (5 == iTaskViewType) {
            bViewTypeChanged = false;
        }
        return bViewTypeChanged;
    }

    public static void checkIfXMLConfigExists(ITask oTaskDataObj) throws DCException {
        DCDebugTracer.trace("Method TaskMgmtOperationSelecPanel#checkIfXMLConfigExists start");
        IDeviceTypeConfigModel oDevTypeModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oTaskDataObj.getSelectedDeviceType());
        if (null == oDevTypeModel) {
            DCDebugTracer.trace("Method TaskMgmtOperationSelecPanel#checkIfXMLConfigExists Exception oDevTypeModel is null");
            throw new DCException(ResourceManager.getInstance().getResString("SUPPORTED_OPERATION_NOT_CONFIGURED"));
        }
        ITaskTypeConfiguration oTaskConfigurations = oDevTypeModel.getTaskTaskTypeConfiguration();
        List oSuportedOpList = oTaskConfigurations.getCloneTaskOperations(oTaskDataObj.getTaskTypeId(), oTaskDataObj);
        if (null == oSuportedOpList) {
            String msg = ResourceManager.getInstance().getResString("TASK_SUPPORTED_OPERATION_NOT_CONFIGURED");
            String hitMsg = MessageFormat.format(msg, "" + oTaskDataObj.getSelectedDeviceType().getDeviceTypeName(), "" + oTaskDataObj.getTaskTypeName());
            DCDebugTracer.trace("Method TaskMgmtOperationSelecPanel#checkIfXMLConfigExists Exception oSuportedOpList is null");
            throw new DCException(hitMsg);
        }
        DCDebugTracer.trace("Method TaskMgmtOperationSelecPanel#checkIfXMLConfigExists end..");
    }

    public static void clearDataForT2000Task(ITask oTaskObj) {
        if (oTaskObj.getTaskTypeId() == 3 || oTaskObj.getTaskTypeId() == 5 || oTaskObj.getTaskTypeId() == 4 || oTaskObj.getTaskTypeId() == 12 || oTaskObj.getTaskTypeId() == 13) {
            oTaskObj.setLoadSimPackageInfo(null);
            oTaskObj.setLoadFileInfoListParam(null);
            oTaskObj.setActivationInfo(null);
            oTaskObj.setStartTime(null);
            oTaskObj.setTargetVersion(null);
        }
    }

    public static void updateActivationOperation(ITaskDeviceOperation oTaskOp, ITask oTaskDataObj) {
        boolean bIsOperationAvailable = TaskCommUtil.isOperationAvailable(oTaskDataObj.getSupportedOperation(), "SetWorkMode");
        if (bIsOperationAvailable) {
            ActivationOperation activationOper = (ActivationOperation)oTaskOp;
            ActivationConfigPara activationConfigPara = activationOper.getActivateConfigPara();
            activationConfigPara.setSelectedActivateType(activationConfigPara.getActivationTypePara("ISSU"));
        }
    }

    public static boolean checkIsResourceListChanged(THashSet<Resource> resources, THashSet<Resource> prevResourceList) {
        boolean bIsChanged = false;
        int iSize = resources.size();
        int iPrevSize = prevResourceList.size();
        Resource oRes2 = null;
        if (iSize != iPrevSize) {
            bIsChanged = true;
        } else {
            for (Resource oRes2 : resources) {
                if (prevResourceList.contains((Object)oRes2)) continue;
                bIsChanged = true;
                break;
            }
        }
        return bIsChanged;
    }

    public static void validateDestinationVersion(ITask m_oTaskDataObj) {
        TaskSrcDstVersionCheck.getInstance().validateDestinationVersion(m_oTaskDataObj);
    }

    public static ValidationResult checkFtpStatus() {
        DCDebugTracer.trace("check checkFtpStatus start");
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        SystemManager sysManager = new SystemManager();
        SystemSettingUtil oSystemSettingUtil = new SystemSettingUtil();
        FTSInfo ftpInfo = null;
        try {
            AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = sysManager.getSystemSettingInfo();
            ftpInfo = oSystemSettingUtil.getProtocolConfiguration(oAsnSystemSettingInfoRsp.oFTSInfo);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        ProtocolConfigInfo oProtocolConfigInfo = new ProtocolConfigInfo();
        oProtocolConfigInfo.setProtocolType(new AsnProtocolEnum(1));
        String strProtocolType = ResourceManager.getInstance().getResString("FTP");
        if (null != ftpInfo) {
            oProtocolConfigInfo.setUserName(ftpInfo.getFTPUserName());
            oProtocolConfigInfo.setPassword(ftpInfo.getFTPPassword());
            oProtocolConfigInfo.setPortNumber(ftpInfo.getFTPPortNumber());
            int iErrorCode = sysManager.testProtocolSetting(oProtocolConfigInfo, ftpInfo.getRootDirectory());
            if (iErrorCode != 0) {
                oValidationResult.setErrorCode(iErrorCode);
                String strMesg = MessageFormat.format(DCFrameWorkUtil.getLocalizedString("CHEKC_FTP_MESSAGE"), strProtocolType, strProtocolType);
                oValidationResult.setErrorMessage(strMesg);
                oValidationResult.setErrorType(1);
            }
        }
        DCDebugTracer.trace("check checkFtpStatus start end ");
        return oValidationResult;
    }

    public static ValidationResult checkThirdPartyFtpStatus(String strThirdPartyFtpName) {
        DCDebugTracer.trace("check checkFtpStatus start");
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        SystemManager sysManager = new SystemManager();
        ProtocolConfigInfo oProtocolConfigInfo = null;
        try {
            AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = sysManager.getSystemSettingInfo();
            AsnThirdPartyFTPServerSettingInfo thirdPartyFtpSettingInfo = oAsnSystemSettingInfoRsp.oThirdPartyFTPSetting;
            AsnThirdPartyFTPServerSettingLst thirdPartyFtpSettingList = thirdPartyFtpSettingInfo.oAsnThirdPartyFTPInfoLst;
            for (int index = 0; index < thirdPartyFtpSettingList.size(); ++index) {
                AsnThirdPartyFTPServerSetting asnThirdPartyFTPServerSetting = (AsnThirdPartyFTPServerSetting)thirdPartyFtpSettingList.get(index);
                if (!Arrays.equals(strThirdPartyFtpName.getBytes(), asnThirdPartyFTPServerSetting.strServerName)) continue;
                oProtocolConfigInfo = new ProtocolConfigInfo();
                oProtocolConfigInfo.setServerIP(DCCommonUtil.convertByteArrayToStr(asnThirdPartyFTPServerSetting.strServerIP));
                oProtocolConfigInfo.setUserName(DCCommonUtil.convertByteArrayToStr(asnThirdPartyFTPServerSetting.strUserName));
                oProtocolConfigInfo.setPassword(DCCommonUtil.convertByteArrayToChar(asnThirdPartyFTPServerSetting.strPassword));
                oProtocolConfigInfo.setPortNumber(asnThirdPartyFTPServerSetting.iPortNum.intValue());
                oProtocolConfigInfo.setProtocolType(asnThirdPartyFTPServerSetting.enProtocolType);
                oProtocolConfigInfo.setServerName(strThirdPartyFtpName);
                break;
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        if (null == oProtocolConfigInfo) {
            return oValidationResult;
        }
        int iErrorCode = sysManager.testProtocolSetting(oProtocolConfigInfo, "");
        if (iErrorCode != 0) {
            oValidationResult.setErrorCode(iErrorCode);
            String strMesg = MessageFormat.format(DCFrameWorkUtil.getLocalizedString("THIRDPARTY_FTP_CHECK"), strThirdPartyFtpName);
            oValidationResult.setErrorMessage(strMesg);
            oValidationResult.setErrorType(1);
        }
        DCDebugTracer.trace("check checkFtpStatus start end ");
        return oValidationResult;
    }
}

