/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.util;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnCheckUpgradeDevInfo;
import com.huawei.dc.common.asndatacenter.AsnCheckUpgradeDevInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceType;
import com.huawei.dc.common.asndatacenter.AsnDCIsSnmpEnum;
import com.huawei.dc.common.asndatacenter.AsnDcDevDomainEnum;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfo;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeReq;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeRsp;
import com.huawei.dc.common.asndatacenter.AsnUpgradeDevVersionInfo;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import gnu.trove.THashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class UpgradeModeUtil {
    private static HashMap<Integer, HashMap<String, List<Resource>>> parseResouce(THashSet<Resource> oResourcesLst) {
        HashMap<Integer, HashMap<String, List<Resource>>> oDevMap = new HashMap<Integer, HashMap<String, List<Resource>>>();
        HashMap<Object, Object> oResMap = null;
        String strVersion = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        IDeviceInfoManager oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        int iDevTypeId = -1;
        for (Resource oResource : oResourcesLst) {
            List<Resource> resList;
            oDeviceTypeInfo = oDeviceInfoManager.getDevice(oResource.getDeviceID()).getDeviceTypeInfo();
            if (null == oDeviceTypeInfo) continue;
            iDevTypeId = oDeviceTypeInfo.getDevTypeID();
            if (oDevMap.containsKey(iDevTypeId)) {
                oResMap = oDevMap.get(iDevTypeId);
            } else {
                oResMap = new HashMap();
                oDevMap.put(iDevTypeId, oResMap);
            }
            strVersion = oResource.getDeviceVersion();
            if (oResMap.containsKey(strVersion)) {
                resList = (List)oResMap.get(strVersion);
            } else {
                resList = new ArrayList();
                oResMap.put(strVersion, resList);
            }
            resList.add(oResource);
        }
        return oDevMap;
    }

    private static AsnDCDeviceType getAsnDCDeviceType(int iDevID) {
        AsnDCDeviceType oAsnDCDeviceType = null;
        DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevID).getDeviceTypeInfo();
        if (null != oDeviceTypeInfo) {
            String strDevTypeVersionName = oDeviceTypeInfo.getDevTypeVersionName();
            String strDevTypeName = oDeviceTypeInfo.getDevTypeName();
            if (null != strDevTypeVersionName && null != strDevTypeName) {
                oAsnDCDeviceType = new AsnDCDeviceType();
                oAsnDCDeviceType.iDevTypeId = BigInteger.valueOf(oDeviceTypeInfo.getDevTypeID());
                oAsnDCDeviceType.strDevTypeName = strDevTypeName.getBytes();
                oAsnDCDeviceType.iDevVersionId = BigInteger.valueOf(oDeviceTypeInfo.getDevTypeVersionId());
                oAsnDCDeviceType.strDevVersionName = strDevTypeVersionName.getBytes();
                oAsnDCDeviceType.enDeviceDomain = new AsnDcDevDomainEnum(oDeviceTypeInfo.getDevDomain());
                oAsnDCDeviceType.enSnmpType = new AsnDCIsSnmpEnum(oDeviceTypeInfo.getDeviceType());
                oAsnDCDeviceType.iType = BigInteger.valueOf(0L);
            }
        }
        return oAsnDCDeviceType;
    }

    public static AsnGetDevUpgradeModeReq getDevUpgradeModeReqest(ITask oTask) {
        AsnGetDevUpgradeModeReq asnDevUpgradeModeReq = new AsnGetDevUpgradeModeReq();
        DeviceType oDeviceType = oTask.getDeviceType();
        HashMap<Integer, HashMap<String, List<Resource>>> oDevMap = UpgradeModeUtil.parseResouce(oDeviceType.getResources());
        Iterator<Integer> oIterator = oDevMap.keySet().iterator();
        while (oIterator.hasNext()) {
            HashMap<String, List<Resource>> oResMap = oDevMap.get(oIterator.next());
            Iterator<String> oIteratorxx = oResMap.keySet().iterator();
            AsnCheckUpgradeDevInfo asnCheckUpgradeDevInfo = null;
            AsnUpgradeDevVersionInfo oAsnDevVersionfo = null;
            AsnDevSetInfoLst oAsnDCDeviceLst = null;
            AsnDCDeviceType oAsnDCDeviceType = null;
            while (oIteratorxx.hasNext()) {
                asnCheckUpgradeDevInfo = new AsnCheckUpgradeDevInfo();
                oAsnDevVersionfo = new AsnUpgradeDevVersionInfo();
                List<Resource> oResourcesLst = oResMap.get(oIteratorxx.next());
                oAsnDCDeviceLst = UpgradeModeUtil.getAsnDevSetInfoLst(oResourcesLst);
                oAsnDevVersionfo.strDeviceSWVer = oResourcesLst.get(0).getDeviceVersion().getBytes();
                oAsnDCDeviceType = UpgradeModeUtil.getAsnDCDeviceType(oResourcesLst.get(0).getDeviceID());
                if (null != oAsnDCDeviceType) {
                    oAsnDevVersionfo.oDevTypeInfo = oAsnDCDeviceType;
                    asnCheckUpgradeDevInfo.oDevVersion = oAsnDevVersionfo;
                    asnCheckUpgradeDevInfo.oDevSetInfoLst = oAsnDCDeviceLst;
                }
                asnDevUpgradeModeReq.oCheckUpgradeDevInfoLst.add((Object)asnCheckUpgradeDevInfo);
            }
        }
        return asnDevUpgradeModeReq;
    }

    private static AsnDevSetInfoLst getAsnDevSetInfoLst(List<Resource> oResourcesLst) {
        AsnDevSetInfoLst oAsnDCDeviceLst = new AsnDevSetInfoLst();
        int iNumDevices = oResourcesLst.size();
        for (int i = 0; i < iNumDevices; ++i) {
            Resource oResource = oResourcesLst.get(i);
            AsnDevSetInfo oAsnDevSetInfo = new AsnDevSetInfo();
            oAsnDevSetInfo.iDevId = BigInteger.valueOf(oResource.getDeviceID());
            oAsnDCDeviceLst.add((Object)oAsnDevSetInfo);
        }
        return oAsnDCDeviceLst;
    }

    public static void checkUpgradeMode(DeviceType oDeviceType, ValidationResult oValidationResult, int iUpgradeMode, String strMsg) {
        if (!oDeviceType.isUpgradeModeSupportedByAllDevices(iUpgradeMode)) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(strMsg);
        }
    }

    public static List<AsnGetDevUpgradeModeReq> getDevUpgradeModeReq(ITask oTask) {
        ArrayList<AsnGetDevUpgradeModeReq> oReqList = new ArrayList<AsnGetDevUpgradeModeReq>();
        DeviceType oDeviceType = oTask.getDeviceType();
        HashMap<Integer, HashMap<String, List<Resource>>> oDevMap = UpgradeModeUtil.parseResouce(oDeviceType.getResources());
        Iterator<Integer> oIterator = oDevMap.keySet().iterator();
        while (oIterator.hasNext()) {
            HashMap<String, List<Resource>> oResMap = oDevMap.get(oIterator.next());
            AsnGetDevUpgradeModeReq asnGetDevUpgradeModeReq = UpgradeModeUtil.getAsnGetDevUpgradeModeReq(oResMap);
            oReqList.add(asnGetDevUpgradeModeReq);
        }
        return oReqList;
    }

    private static AsnGetDevUpgradeModeReq getAsnGetDevUpgradeModeReq(HashMap<String, List<Resource>> oResMap) {
        AsnCheckUpgradeDevInfoLst oCheckUpgradeDevInfoLst;
        AsnGetDevUpgradeModeReq oDevUpgradeModeRequest = new AsnGetDevUpgradeModeReq();
        oDevUpgradeModeRequest.oCheckUpgradeDevInfoLst = oCheckUpgradeDevInfoLst = new AsnCheckUpgradeDevInfoLst();
        Iterator<String> oIterator = oResMap.keySet().iterator();
        while (oIterator.hasNext()) {
            AsnCheckUpgradeDevInfo oCheckUpgradeDevInfo = new AsnCheckUpgradeDevInfo();
            AsnUpgradeDevVersionInfo oAsnDevVersionfo = new AsnUpgradeDevVersionInfo();
            List<Resource> oResourcesLst = oResMap.get(oIterator.next());
            AsnDevSetInfoLst oAsnDCDeviceLst = UpgradeModeUtil.getAsnDevSetInfoLst(oResourcesLst);
            oAsnDevVersionfo.strDeviceSWVer = oResourcesLst.get(0).getDeviceVersion().getBytes();
            AsnDCDeviceType oAsnDCDeviceType = UpgradeModeUtil.getAsnDCDeviceType(oResourcesLst.get(0).getDeviceID());
            if (null == oAsnDCDeviceType) continue;
            oAsnDevVersionfo.oDevTypeInfo = oAsnDCDeviceType;
            oCheckUpgradeDevInfo.oDevVersion = oAsnDevVersionfo;
            oCheckUpgradeDevInfo.oDevSetInfoLst = oAsnDCDeviceLst;
            oCheckUpgradeDevInfoLst.add((Object)oCheckUpgradeDevInfo);
        }
        return oDevUpgradeModeRequest;
    }

    public static void updateDevUpgradeModeResponse(AsnGetDevUpgradeModeRsp oResponse, ITask oTask) throws DCException {
        DCDebugTracer.trace("[upgrade mode] updateDevUpgradeModeResponse start");
        AsnDevUpgrModeInfoLst oDevUpgrModeInfoLst = oResponse.oDevUpgrModeInfoLst;
        int iSize = oDevUpgrModeInfoLst.size();
        if (0 == iSize) {
            DCDebugTracer.trace("[upgrade mode] updateDevUpgradeModeResponse end : oDevUpgrModeInfoLst.size( ) is zero.");
            throw new DCException(ResourceManager.getInstance().getResString("UPGRADE_MODE_REQUEST_FAIL"));
        }
        int iUpgradeMode = 0;
        if (oTask == null) {
            DCDebugTracer.trace("[upgrade mode] updateDevUpgradeModeResponse end(oTask = null)..");
            return;
        }
        DeviceType oDeviceType = oTask.getDeviceType();
        for (int i = 0; i < iSize; ++i) {
            AsnDevUpgrModeInfo oDevUpgrModeInfo = (AsnDevUpgrModeInfo)oDevUpgrModeInfoLst.get(i);
            iUpgradeMode = oDevUpgrModeInfo.iUpgradeMode.intValue();
            AsnCheckUpgradeDevInfo oCheckUpgradeDevInfo = oDevUpgrModeInfo.oCheckUpgradeDevInfo;
            UpgradeModeUtil.updateUpgradeMode(oCheckUpgradeDevInfo.oDevSetInfoLst, iUpgradeMode, oDeviceType);
        }
        DCDebugTracer.trace("[upgrade mode] updateDevUpgradeModeResponse end..");
    }

    public static void updateUpgradeMode(AsnDevSetInfoLst asnDevSetInfoLst, int iUpgradeMode, DeviceType oDeviceType) {
        if (null != asnDevSetInfoLst) {
            int iDevSize = asnDevSetInfoLst.size();
            for (int j = 0; j < iDevSize; ++j) {
                int iDevId = ((AsnDevSetInfo)asnDevSetInfoLst.get((int)j)).iDevId.intValue();
                Resource oResource = oDeviceType.getResource(iDevId);
                if (null != oResource) {
                    oResource.setUpgradeMode(iUpgradeMode);
                    DCDebugTracer.trace("TaskCommUtil#updateUpgradeMode iUpgradeMode( " + oResource.getDeviceID() + " ): " + iUpgradeMode);
                    DeviceInfoUtil.updateUpgradeModeForDevice(oResource);
                    continue;
                }
                DCDebugTracer.trace("TaskCommUtil#updateUpgradeMode the res is null, and it's id is " + iDevId);
            }
        }
    }
}

