/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.util;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageDevInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SubOperationObject;
import com.huawei.dc.taskmgmt.model.SubOprCheckItemDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaskSubOperationUtil {
    private TaskSubOperationUtil() {
    }

    public static SubOprCheckItemDetails addTaskSubOprNode(String strNodeTitle) {
        SubOprCheckItemDetails oSubOprCheckItemDetails = new SubOprCheckItemDetails();
        HashMap<String, SubOperationObject> oNodeList = oSubOprCheckItemDetails.getNodeList();
        ArrayList<String> oOrderList = oSubOprCheckItemDetails.getOrderList();
        SubOperationObject oSubOperationObject = new SubOperationObject();
        oSubOperationObject.setParentID("");
        oSubOperationObject.setNodeID(ResourceManager.getInstance().getResString(strNodeTitle));
        oNodeList.put(oSubOperationObject.getParentID() + oSubOperationObject.getNodeID(), oSubOperationObject);
        oOrderList.add(oSubOperationObject.getParentID() + oSubOperationObject.getNodeID());
        oSubOprCheckItemDetails.setNodeList(oNodeList);
        oSubOprCheckItemDetails.setOrderList(oOrderList);
        return oSubOprCheckItemDetails;
    }

    public static SubOprCheckItemDetails addTaskSubOprNode(SubOprCheckItemDetails oSubOprCheckItemDetails, ITask oTaskObj, ITaskDeviceOperation oTaskDevOp) {
        SubOprCheckItemDetails tempItemDetails = oSubOprCheckItemDetails;
        HashMap<String, SubOperationObject> oNodeList = tempItemDetails.getNodeList();
        ArrayList<String> oOrderList = tempItemDetails.getOrderList();
        LoadFileInfoListParam oPara = (LoadFileInfoListParam)oTaskDevOp.getConfiguredPara();
        List<LoadFileInfo> oLoadFileList = oPara.getLoadFileInfoList();
        if (oLoadFileList.isEmpty() && oTaskDevOp instanceof LoadSoftwareOperation) {
            oLoadFileList = TaskSubOperationUtil.getFileList(oTaskObj, oTaskDevOp);
        }
        SubOperationObject oSubOperationObject = null;
        LoadFileInfo oLoadFileInfo = null;
        int iLen = oLoadFileList.size();
        if (0 != iLen && 0 == oLoadFileList.get(0).getDeviceId()) {
            tempItemDetails = TaskSubOperationUtil.addSubOprNodesDuringcreateTask(oLoadFileList, tempItemDetails, oTaskObj, oTaskDevOp);
            return tempItemDetails;
        }
        int iDevID = TaskSubOperationUtil.getTaskDevID(oTaskDevOp);
        for (int i = 0; i < iLen; ++i) {
            oLoadFileInfo = oLoadFileList.get(i);
            if (1 == oLoadFileInfo.getFileSelectionLevel() && oLoadFileInfo.getDeviceId() != iDevID) continue;
            String subTitle = TaskSubOperationUtil.getSubTitle(oTaskDevOp);
            oSubOperationObject = TaskSubOperationUtil.getSubOperationObj(oLoadFileInfo, i + 1, subTitle);
            int iLoadFileDevID = oLoadFileInfo.getDeviceId();
            String strKey = oSubOperationObject.getParentID() + oLoadFileInfo.getDeviceId() + oLoadFileInfo.getFileSelectionLevel() + oLoadFileInfo.getSequenceNo();
            if (0 != iLoadFileDevID) {
                if (iDevID != iLoadFileDevID) continue;
                oNodeList.put(strKey, oSubOperationObject);
                if (oOrderList.contains(strKey)) continue;
                oOrderList.add(strKey);
                continue;
            }
            oNodeList.put(strKey, oSubOperationObject);
            oOrderList.add(strKey);
        }
        tempItemDetails.setNodeList(oNodeList);
        tempItemDetails.setOrderList(oOrderList);
        return tempItemDetails;
    }

    public static SubOprCheckItemDetails addSubOprNodesDuringcreateTask(List<LoadFileInfo> oLoadFileList, SubOprCheckItemDetails oSubOprCheckItemDetails, ITask oTaskObj, ITaskDeviceOperation oTaskDevOp) {
        SubOperationObject oSubOperationObject = null;
        LoadFileInfo oLoadFileInfo = null;
        SubOprCheckItemDetails tempItemDetails = oSubOprCheckItemDetails;
        HashMap<String, SubOperationObject> oNodeList = tempItemDetails.getNodeList();
        ArrayList<String> oOrderList = tempItemDetails.getOrderList();
        Iterator oResItor = oTaskObj.getDeviceType().getResources().iterator();
        boolean bIsConfigured = false;
        int seqNo = 0;
        while (oResItor.hasNext()) {
            Resource oRes = (Resource)oResItor.next();
            if (bIsConfigured) break;
            int iTaskDevID = TaskSubOperationUtil.getTaskDevID(oTaskDevOp);
            if (oRes.getDeviceID() == iTaskDevID) {
                for (int i = 0; i < oLoadFileList.size(); ++i) {
                    oLoadFileInfo = oLoadFileList.get(i);
                    if (1 == oLoadFileInfo.getFileSelectionLevel() && oLoadFileInfo.getDeviceId() != oRes.getDeviceID()) continue;
                    String subTitle = TaskSubOperationUtil.getSubTitle(oTaskDevOp);
                    oSubOperationObject = TaskSubOperationUtil.getSubOperationObj(oLoadFileInfo, seqNo, subTitle);
                    String strKey = oSubOperationObject.getParentID() + oRes.getDeviceID() + oLoadFileInfo.getFileSelectionLevel() + oLoadFileInfo.getSequenceNo();
                    oNodeList.put(strKey, oSubOperationObject);
                    oOrderList.add(strKey);
                }
                bIsConfigured = true;
            }
            ++seqNo;
        }
        tempItemDetails.setNodeList(oNodeList);
        tempItemDetails.setOrderList(oOrderList);
        return tempItemDetails;
    }

    private static String getSubTitle(ITaskDeviceOperation oTaskDevOp) {
        String subTitle = "";
        if (oTaskDevOp instanceof LoadPatchOperation) {
            subTitle = "LOG_FILTER_DIALOG_OPERATION_TYPE_7";
        }
        if (oTaskDevOp instanceof LoadSoftwareOperation) {
            subTitle = "LOG_FILTER_DIALOG_OPERATION_TYPE_8";
        }
        return subTitle;
    }

    private static SubOperationObject getSubOperationObj(LoadFileInfo oLoadFileInfo, int oriSeqNo, String title) {
        String oNode = oLoadFileInfo.getFileName();
        oNode = TaskSubOperationUtil.extractFileName(oNode);
        SubOperationObject tempSubObj = new SubOperationObject();
        tempSubObj.setParentID(title);
        tempSubObj.setNodeID(oNode);
        tempSubObj.getOprNodeAttributes().setNodeName(oNode);
        if (null != oLoadFileInfo.getContentType()) {
            tempSubObj.getOprNodeAttributes().setCommand(oLoadFileInfo.getContentType().getStrContentType());
            tempSubObj.getOprNodeAttributes().setDescription(oLoadFileInfo.getContentType().getStrContentType());
        }
        tempSubObj.getOprNodeAttributes().setStatus(0);
        tempSubObj.getOprNodeAttributes().setSequenceNo(oriSeqNo + 1);
        return tempSubObj;
    }

    private static int getTaskDevID(ITaskDeviceOperation tempTaskDevOp) {
        int iTaskDevID = 0;
        if (tempTaskDevOp instanceof LoadPatchOperation) {
            iTaskDevID = ((LoadPatchOperation)tempTaskDevOp).getDevID();
        }
        if (tempTaskDevOp instanceof LoadSoftwareOperation) {
            iTaskDevID = ((LoadSoftwareOperation)tempTaskDevOp).getDevID();
        }
        return iTaskDevID;
    }

    public static String extractFileName(String strFullPath) {
        Pattern filePat = Pattern.compile(".*?([^\\\\/]+)$");
        Matcher fileMat = filePat.matcher(strFullPath);
        String fileName = fileMat.find() ? fileMat.group(1) : "";
        return fileName;
    }

    private static List<LoadFileInfo> getFileList(ITask oTaskObj, ITaskDeviceOperation oTaskDevOp) {
        ArrayList<LoadFileInfo> oLoadFileList = new ArrayList<LoadFileInfo>();
        LoadSimPackageInfo oSimPackageInfo = oTaskObj.getLoadSimPackageInfo();
        if (null != oSimPackageInfo) {
            Vector oDevList = oSimPackageInfo.getDevList();
            int iSize = oDevList.size();
            String strFilePath = "";
            LoadSimPackageDevInfo oDevInfo = null;
            for (int i = 0; i < iSize; ++i) {
                oDevInfo = (LoadSimPackageDevInfo)oDevList.get(i);
                if (oDevInfo.getDevId() != ((LoadSoftwareOperation)oTaskDevOp).getDevID()) continue;
                strFilePath = oDevInfo.getFileName();
                LoadFileInfo oLoadFileInfo = new LoadFileInfo(0, strFilePath, null);
                oLoadFileInfo.setDeviceId(oDevInfo.getDevId());
                oLoadFileList.add(oLoadFileInfo);
            }
        }
        return oLoadFileList;
    }
}

