/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.util;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnProtocolEnum;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingInfoRsp;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.system.SystemSettingUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.configuration.system.ProtocolConfigInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.patchoperation.ViewModifyPatchPanel;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import java.awt.Component;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.border.TitledBorder;

public class TaskOperCommonUtil {
    public static Component getView(int context, String operationName) {
        ViewModifyPatchPanel oNoConfigView = null;
        switch (context) {
            case 0: {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_CONFIGURATION_REQUIRED"), operationName, 1);
                break;
            }
            case 1: {
                ViewModifyPatchPanel m_oModifyPanel = new ViewModifyPatchPanel();
                TitledBorder oModifyTitledBorder = new TitledBorder(operationName);
                m_oModifyPanel.setBorder(oModifyTitledBorder);
                m_oModifyPanel.setBounds(140, 100, 345, 163);
                oNoConfigView = m_oModifyPanel;
                break;
            }
            case 2: {
                ViewModifyPatchPanel m_oViewPanel = new ViewModifyPatchPanel();
                TitledBorder oViewTitledBorder = new TitledBorder(operationName);
                m_oViewPanel.setBorder(oViewTitledBorder);
                m_oViewPanel.setBounds(140, 100, 345, 163);
                oNoConfigView = m_oViewPanel;
                break;
            }
        }
        return oNoConfigView;
    }

    public static String noConfigStr() {
        String BlankSpace = "  ";
        StringBuffer strBuffer = new StringBuffer(0);
        strBuffer.append(System.getProperty("line.separator"));
        strBuffer.append("  ");
        strBuffer.append(ResourceManager.getInstance().getResString("NO_CONFIGURATION_REQUIRED"));
        return strBuffer.toString();
    }

    public static ValidationResult checkxFtpStatus(ITask oTaskObj) {
        DCDebugTracer.trace("check checkFtpStatus start");
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        SystemManager sysManager = new SystemManager();
        SystemSettingUtil oSystemSettingUtil = new SystemSettingUtil();
        FTSInfo ftpInfo = null;
        try {
            AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = sysManager.getSystemSettingInfo();
            ftpInfo = oSystemSettingUtil.getProtocolConfiguration(oAsnSystemSettingInfoRsp.oFTSInfo);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        ProtocolConfigInfo oProtocolConfigInfo = new ProtocolConfigInfo();
        int iLoadSWType = oTaskObj.getLoadSoftwareType();
        String strProtocolType = "";
        if (null != ftpInfo) {
            boolean isTest = true;
            if (1 == iLoadSWType) {
                oProtocolConfigInfo.setProtocolType(new AsnProtocolEnum(ftpInfo.getFTPType()));
                oProtocolConfigInfo.setUserName(ftpInfo.getFTPUserName());
                oProtocolConfigInfo.setPassword(ftpInfo.getFTPPassword());
                oProtocolConfigInfo.setPortNumber(ftpInfo.getFTPPortNumber());
                strProtocolType = ResourceManager.getInstance().getResString("TYPE_FTP");
            } else if (2 == iLoadSWType) {
                oProtocolConfigInfo.setProtocolType(new AsnProtocolEnum(2));
                oProtocolConfigInfo.setUserName(ftpInfo.getSFTPUserName());
                oProtocolConfigInfo.setPassword(ftpInfo.getSFTPPassword());
                oProtocolConfigInfo.setPortNumber(ftpInfo.getSFTPPortNumber());
                strProtocolType = ResourceManager.getInstance().getResString("TYPE_SFTP");
            } else {
                isTest = false;
                DCDebugTracer.trace("don't support the load software type, the type is " + iLoadSWType);
            }
            List<DeviceTypeInfo> deviceTypeInfo = oTaskObj.getDeviceTypeLst();
            boolean isT2000Domain = false;
            for (int i = 0; i < deviceTypeInfo.size(); ++i) {
                if (!deviceTypeInfo.get(i).isT2000Domain()) continue;
                isT2000Domain = true;
                break;
            }
            if (!isT2000Domain) {
                isTest = false;
            } else if (!DCCommonUtil.isIncludeTL1Device(oTaskObj)) {
                if (oTaskObj.getTaskTypeId() != 5 && oTaskObj.getTaskTypeId() != 13 && oTaskObj.getTaskTypeId() != 14 && oTaskObj.getTaskTypeId() != 4) {
                    isTest = false;
                } else if (DCFrameWorkUtil.getIsSingleClient()) {
                    List<ITaskDeviceOperation> m_oTaskOpLst = null;
                    m_oTaskOpLst = oTaskObj.getSupportedOperation();
                    for (int i = 0; i < m_oTaskOpLst.size(); ++i) {
                        if (m_oTaskOpLst.get(i).getOperationId() != 6 && m_oTaskOpLst.get(i).getOperationId() != 7 && m_oTaskOpLst.get(i).getOperationId() != 9 || m_oTaskOpLst.get(i).isEnabled() && m_oTaskOpLst.get(i).isSelected()) continue;
                        isTest = false;
                        break;
                    }
                }
            }
            if (isTest) {
                int iErrorCode;
                if (DCFrameWorkUtil.getIsSingleClient() && oTaskObj.isThirdPartySupported()) {
                    oProtocolConfigInfo.setServerIP(ftpInfo.getServerIP());
                }
                if ((iErrorCode = sysManager.testProtocolSetting(oProtocolConfigInfo, ftpInfo.getRootDirectory())) != 0) {
                    if (oTaskObj.isT2000Domain()) {
                        oValidationResult.setErrorCode(-1);
                        String strMesg = MessageFormat.format(DCFrameWorkUtil.getLocalizedString("CHEKC_FTP_MESSAGE"), strProtocolType, strProtocolType);
                        oValidationResult.setErrorMessage(strMesg);
                        oValidationResult.setErrorType(0);
                    } else {
                        oValidationResult.setErrorCode(-1);
                        String strMesg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
                        oValidationResult.setErrorMessage(strMesg);
                        oValidationResult.setErrorType(0);
                    }
                }
            }
        }
        DCDebugTracer.trace("check checkFtpStatus start end ");
        return oValidationResult;
    }

    public static String generateFilterSuffix(int iDevDomain, String sFileContentType) {
        StringBuffer filterFileSuffex = new StringBuffer();
        if (4 == iDevDomain) {
            filterFileSuffex.append("*.pkg");
        } else if (2 == iDevDomain) {
            if ("PROGRAM".equals(sFileContentType)) {
                filterFileSuffex.append("*.cc");
            } else if ("PATCH".equals(sFileContentType)) {
                filterFileSuffex.append("*.pat");
            } else if ("PACKAGE".equals(sFileContentType)) {
                filterFileSuffex.append("*.cc");
            } else {
                filterFileSuffex.append("*.txt");
            }
        } else if ("PROGRAM".equals(sFileContentType)) {
            filterFileSuffex.append("*.lma");
        } else if ("PACKETFILE".equals(sFileContentType)) {
            filterFileSuffex.append("*.bin");
            filterFileSuffex.append("; ");
            filterFileSuffex.append("*.Packet");
            filterFileSuffex.append("; ");
            filterFileSuffex.append("*.zip");
        } else if ("DBUPDATE".equals(sFileContentType)) {
            filterFileSuffex.append("*.zip");
        } else {
            filterFileSuffex.append("*.*");
        }
        return filterFileSuffex.toString();
    }

    public static void getFileTypeSufficString(Vector<String> fileType, ITask oOperationData) {
        IDeviceTypeConfigModel devTypeConfigInfo = TaskInfoUtil.getDevTypeConfigByTask(oOperationData);
        if (null == devTypeConfigInfo) {
            fileType.add(ResourceManager.getInstance().getResString("ALL_FILE_TYPE"));
        } else {
            IOperation oLoadSWOperationObj = devTypeConfigInfo.getOperationObj(1, 6);
            if (null != oLoadSWOperationObj) {
                IParaList oGetoPerationParaList = oLoadSWOperationObj.getoPerationParaList();
                Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
                if (null != arrParaVals) {
                    for (Object object : arrParaVals) {
                        if (!(object instanceof ContentType)) continue;
                        String contentTypeId = ((ContentType)object).getId();
                        String suffix = TaskOperCommonUtil.generateFilterSuffix(oOperationData.getDeviceType().getDeviceDomain(), contentTypeId);
                        fileType.add(ResourceManager.getInstance().getResFromDomainProperties(oOperationData.getDeviceType().getDeviceDomain(), contentTypeId) + "(" + suffix + ")");
                    }
                }
                fileType.add(ResourceManager.getInstance().getResString("ALL_FILE_TYPE"));
            }
        }
    }
}

