/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.util;

import com.huawei.dc.common.asndatacenter.AsnDCConnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCNodeAttr;
import com.huawei.dc.common.asndatacenter.AsnDCNodeAttrEx;
import com.huawei.dc.common.asndatacenter.AsnDCNodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCNodeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCSmallFileTransfer;
import com.huawei.dc.common.asndatacenter.AsnTaskCheckOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskCheckTypeInfo;
import com.huawei.dc.common.configtree.ConfigNodeAttr;
import com.huawei.dc.common.configtree.ConfigNodeAttrEx;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.devicemanagement.connectivity.view.ConnectTestInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckOperationConfigParam;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ConfigTreeUtil {
    public static ConfigTreeNodeInfo getConnectivityNode(ICheckOperationConfigParam aCheckParam) {
        ConfigTreeNodeInfo oConfigTreeNodeInfo = null;
        if (null == aCheckParam) {
            return oConfigTreeNodeInfo;
        }
        ConfigTreeNodeInfo treeInfo = aCheckParam.getConfigTreeNode();
        if (null == treeInfo) {
            return oConfigTreeNodeInfo;
        }
        List<ConfigTreeNodeInfo> allNodeList = treeInfo.getNodeInfoLst();
        if (null == allNodeList) {
            return oConfigTreeNodeInfo;
        }
        for (ConfigTreeNodeInfo configTreeNodeInfo : allNodeList) {
            if (configTreeNodeInfo.getNodeID().indexOf("Connectivity") == -1) continue;
            oConfigTreeNodeInfo = configTreeNodeInfo;
        }
        return oConfigTreeNodeInfo;
    }

    public static void addDeviceToTreeNode(ConfigTreeNodeInfo aConnNode, ITask aTask) {
        DeviceType l_devType = aTask.getDeviceType();
        if (null != l_devType) {
            THashSet<Resource> l_resources = l_devType.getResources();
            ConfigTreeNodeInfo l_connNode = null;
            if (null != l_resources) {
                Resource l_res = null;
                ConnectTestInfo l_connTestInfo = null;
                ConfigNodeAttr l_nodeAttr = null;
                ArrayList<ConfigTreeNodeInfo> l_nodeList = new ArrayList<ConfigTreeNodeInfo>();
                HashMap<Integer, ConfigTreeNodeInfo> devIdMap = ConfigTreeUtil.getOrigNodeMap(aConnNode);
                Iterator oResItor = l_resources.iterator();
                int i = 0;
                while (oResItor.hasNext()) {
                    l_res = (Resource)oResItor.next();
                    if (null != devIdMap && null != devIdMap.get(l_res.getDeviceID())) {
                        l_nodeList.add(devIdMap.get(l_res.getDeviceID()));
                        ++i;
                        continue;
                    }
                    l_connNode = new ConfigTreeNodeInfo();
                    l_connNode.setParentID("Connectivity");
                    l_connNode.setNodeID(l_res.getDeviceIP());
                    l_connNode.setSeqNumber(i + 1);
                    l_nodeAttr = new ConfigNodeAttr();
                    l_nodeAttr.setNodeName(l_res.getDeviceIP());
                    l_connNode.setConfigNodeAttr(l_nodeAttr);
                    l_connTestInfo = new ConnectTestInfo();
                    l_connTestInfo.setDeviceId(l_res.getDeviceID());
                    l_connTestInfo.setCheckContent("");
                    l_connNode.setConfigNodeConnInfo(l_connTestInfo);
                    l_nodeList.add(l_connNode);
                    ++i;
                }
                aConnNode.setNodeInfoLst(l_nodeList);
            }
        }
    }

    private static HashMap<Integer, ConfigTreeNodeInfo> getOrigNodeMap(ConfigTreeNodeInfo aConnNode) {
        HashMap<Integer, ConfigTreeNodeInfo> devIdMap = null;
        List<ConfigTreeNodeInfo> l_nodeList = aConnNode.getNodeInfoLst();
        if (null == l_nodeList) {
            return null;
        }
        int iDevId = -1;
        devIdMap = new HashMap<Integer, ConfigTreeNodeInfo>();
        for (ConfigTreeNodeInfo node : l_nodeList) {
            iDevId = node.getConfigNodeConnInfo().getDeviceId();
            devIdMap.put(iDevId, node);
        }
        return devIdMap;
    }

    public static ConfigTreeNodeInfo getTreeNodeInfoFromAsn(AsnDCNodeInfo oAsnDCNodeInfo) {
        AsnDCNodeInfoLst l_asnNodeList;
        AsnDCNodeAttrEx l_asnAttrEx;
        AsnDCNodeAttr oAsnDCNodeAttr;
        AsnDCConnInfo l_asnDCConnInfo;
        boolean isSelect;
        AsnDCSmallFileTransfer oExtendCheckFile;
        ConfigTreeNodeInfo l_ConfigTreeNodeInfo = new ConfigTreeNodeInfo();
        String strNodeId = new String(oAsnDCNodeInfo.strNodeID);
        String strParentId = new String(oAsnDCNodeInfo.strParentID);
        int iSeqNumber = oAsnDCNodeInfo.iSeqNumber.intValue();
        l_ConfigTreeNodeInfo.setParentID(strParentId);
        l_ConfigTreeNodeInfo.setNodeID(strNodeId);
        l_ConfigTreeNodeInfo.setSeqNumber(iSeqNumber);
        if (strNodeId.equals("EXTENDCHECK") && (oExtendCheckFile = oAsnDCNodeInfo.oExtendCheckFile) != null) {
            String strExtendCheckFile = new String(oExtendCheckFile.oSourcePathAndFileName);
            l_ConfigTreeNodeInfo.setExetendCheckFile(strExtendCheckFile);
        }
        l_ConfigTreeNodeInfo.setNeedCompare(oAsnDCNodeInfo.bIsNeedCompare);
        if (null != oAsnDCNodeInfo.strCompareParam) {
            l_ConfigTreeNodeInfo.setCompareParam(new String(oAsnDCNodeInfo.strCompareParam));
        }
        if (null != oAsnDCNodeInfo.iCompareType && -1 != oAsnDCNodeInfo.iCompareType.intValue()) {
            l_ConfigTreeNodeInfo.setCompareType(oAsnDCNodeInfo.iCompareType.intValue());
        }
        if (isSelect = oAsnDCNodeInfo.bIsSelected) {
            l_ConfigTreeNodeInfo.setNodeSelectedState(0);
        }
        if (null != (l_asnDCConnInfo = oAsnDCNodeInfo.oAsnDCConnInfo)) {
            ConnectTestInfo l_connTestInfo = new ConnectTestInfo();
            l_connTestInfo.setCheckContent(new String(l_asnDCConnInfo.strContent));
            l_connTestInfo.setCheckMode(l_asnDCConnInfo.iCheckMode.intValue());
            l_connTestInfo.setDeviceId(l_asnDCConnInfo.iDevId.intValue());
            l_ConfigTreeNodeInfo.setConfigNodeConnInfo(l_connTestInfo);
        }
        if (null != (oAsnDCNodeAttr = oAsnDCNodeInfo.oAsnDCNodeAttr)) {
            ConfigNodeAttr l_configNodeAttr = new ConfigNodeAttr();
            l_configNodeAttr.setCmd(new String(oAsnDCNodeAttr.strCmd));
            l_configNodeAttr.setDesc(new String(oAsnDCNodeAttr.strDesc));
            l_configNodeAttr.setNodeName(new String(oAsnDCNodeAttr.strName));
            l_ConfigTreeNodeInfo.setConfigNodeAttr(l_configNodeAttr);
        }
        if (null != (l_asnAttrEx = oAsnDCNodeInfo.oAsnDCNodeAttrEx)) {
            ConfigNodeAttrEx l_nodeEx = new ConfigNodeAttrEx();
            if (null != l_asnAttrEx.strCmdResult) {
                l_nodeEx.setCmdResult(new String(l_asnAttrEx.strCmdResult));
            }
            l_nodeEx.setStartTime(l_asnAttrEx.oStartTime);
            l_nodeEx.setEndTime(l_asnAttrEx.oEndTime);
            l_nodeEx.setStatus(l_asnAttrEx.oCheckResultTypeEnum.value);
        }
        if ((l_asnNodeList = oAsnDCNodeInfo.oAsnDCNodeInfoLst) != null) {
            int l_nodeSize = l_asnNodeList.size();
            AsnDCNodeInfo l_AsnSubNode = null;
            ConfigTreeNodeInfo l_configNode = null;
            ArrayList<ConfigTreeNodeInfo> l_confNodeList = new ArrayList<ConfigTreeNodeInfo>();
            for (int i = 0; i < l_nodeSize; ++i) {
                l_AsnSubNode = (AsnDCNodeInfo)l_asnNodeList.get(i);
                l_configNode = ConfigTreeUtil.getTreeNodeInfoFromAsn(l_AsnSubNode);
                l_confNodeList.add(l_configNode);
            }
            l_ConfigTreeNodeInfo.setNodeInfoLst(l_confNodeList);
        }
        return l_ConfigTreeNodeInfo;
    }

    public static void updateConnectivityNodeInfo(ICheckOperation oCheckOp, ITask oTask) {
        if (null == oCheckOp) {
            return;
        }
        ICheckOperationConfigParam checkOperationConfig = oCheckOp.getCheckOperationConfig();
        ConfigTreeNodeInfo l_treeNode = checkOperationConfig.getConfigTreeNode();
        List<ConfigTreeNodeInfo> l_nodeList = l_treeNode.getNodeInfoLst();
        for (ConfigTreeNodeInfo oNode : l_nodeList) {
            if (!Collator.getInstance().equals(oNode.getNodeID(), "Connectivity")) continue;
            if (null != oNode.getNodeInfoLst() && !oNode.getNodeInfoLst().isEmpty()) break;
            ConfigTreeUtil.addDeviceToTreeNode(oNode, oTask);
            break;
        }
    }

    public static void updateCheckOpData(AsnTaskCheckOpInfo oCheckOpInfoList, ICheckOperation oCheckOperation) {
        AsnTaskCheckTypeInfo oAsnTaskCheckTypeInfo = null;
        ICheckOperationConfigParam checkOperationConfig = oCheckOperation.getCheckOperationConfig();
        ConfigTreeNodeInfo l_configTreeInfo = new ConfigTreeNodeInfo();
        l_configTreeInfo.setNodeID("");
        l_configTreeInfo.setNodeSelectedState(0);
        if (null != oCheckOpInfoList) {
            ArrayList<ConfigTreeNodeInfo> l_nodeList = new ArrayList<ConfigTreeNodeInfo>();
            for (int i = 0; i < oCheckOpInfoList.size(); ++i) {
                oAsnTaskCheckTypeInfo = (AsnTaskCheckTypeInfo)oCheckOpInfoList.get(i);
                l_nodeList.add(ConfigTreeUtil.getTreeNodeInfoFromAsn(oAsnTaskCheckTypeInfo.oAsnDCNodeInfo));
            }
            l_configTreeInfo.setNodeInfoLst(l_nodeList);
            ConfigTreeUtil.setNodeSelectedState(l_configTreeInfo);
        }
        if (null != checkOperationConfig) {
            checkOperationConfig.setConfigTreeNode(l_configTreeInfo);
        }
    }

    public static void setNodeSelectedState(ConfigTreeNodeInfo aParentNode) {
        if (null == aParentNode) {
            return;
        }
        List<ConfigTreeNodeInfo> aNodeList = aParentNode.getNodeInfoLst();
        if (null == aNodeList || aNodeList.isEmpty()) {
            return;
        }
        int count = 0;
        for (ConfigTreeNodeInfo conTreeNodeInfo : aNodeList) {
            ConfigTreeUtil.setNodeSelectedState(conTreeNodeInfo);
            if (0 != conTreeNodeInfo.getNodeSelectedState() && 1 != conTreeNodeInfo.getNodeSelectedState()) continue;
            ++count;
        }
        if (count == aNodeList.size()) {
            aParentNode.setNodeSelectedState(0);
        } else if (count > 0) {
            aParentNode.setNodeSelectedState(1);
        }
    }

    public static boolean isSelectAnyCheckItem(ICheckOperationConfigParam checkOperationConfigParam) {
        boolean isSel = false;
        if (null == checkOperationConfigParam) {
            return isSel;
        }
        ConfigTreeNodeInfo oConfigTreeNodeInfo = checkOperationConfigParam.getConfigTreeNode();
        if (null == oConfigTreeNodeInfo) {
            return isSel;
        }
        List<ConfigTreeNodeInfo> allNodeList = oConfigTreeNodeInfo.getNodeInfoLst();
        for (ConfigTreeNodeInfo configTreeNodeInfo : allNodeList) {
            if (0 != configTreeNodeInfo.getNodeSelectedState() && 1 != configTreeNodeInfo.getNodeSelectedState()) continue;
            isSel = true;
            break;
        }
        return isSel;
    }
}

