/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.util;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.asndatacenter.AsnActivationElementInfo;
import com.huawei.dc.common.asndatacenter.AsnActivationElementInfoLst;
import com.huawei.dc.common.asndatacenter.AsnActivationGroupInfo;
import com.huawei.dc.common.asndatacenter.AsnActivationGroupInfoLst;
import com.huawei.dc.common.asndatacenter.AsnActivationReq;
import com.huawei.dc.common.asndatacenter.AsnContentTypeInfo;
import com.huawei.dc.common.asndatacenter.AsnContentTypeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnLoadDataOpInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadFileInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadFileLst;
import com.huawei.dc.common.asndatacenter.AsnOperationInfo;
import com.huawei.dc.common.asndatacenter.AsnOperationInfoLst;
import com.huawei.dc.common.asndatacenter.AsnResourceProgressInfo;
import com.huawei.dc.common.asndatacenter.AsnResourceProgressInfoLst;
import com.huawei.dc.common.asndatacenter.AsnStartupConfigOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskCommonInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskRecoverDBOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskRecoverElementInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskRecoverElementInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResourceLst;
import com.huawei.dc.common.asndatacenter.AsnUpgradeOpInfo;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.loaddata.LoadDataOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.updatedata.UpdateConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.ITaskTypeConfiguration;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskAsnSupportUtilities;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.LoadSimPackageBoardInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageDevInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SwitchTaskAndAsn;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.util.ConfigTreeUtil;
import gnu.trove.THashSet;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class AsnTaskInfoUtil {
    public static Resource populateResourceFromAsnTaskResource(AsnTaskResource oTaskResource, ITask oTask) {
        DeviceType oDeviceType = oTask.getSelectedDeviceType();
        THashSet<Resource> oResourceList = oDeviceType.getResources();
        if (null == oResourceList) {
            return null;
        }
        Iterator oResItor = oResourceList.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            int iDeviceId = oTaskResource.iDeviceId.intValue();
            int iFrameId = TaskCommUtil.converBigIntToint(oTaskResource.iFrameId);
            int iSlotId = TaskCommUtil.converBigIntToint(oTaskResource.iSlotId);
            int iSubSlotId = TaskCommUtil.converBigIntToint(oTaskResource.iSubSlotId);
            int iStackId = TaskCommUtil.converBigIntToint(oTaskResource.iStackId);
            if (oResource.getDeviceID() != iDeviceId || oResource.getFrameId() != iFrameId || oResource.getSlotId() != iSlotId || oResource.getSubSlotId() != iSubSlotId || oResource.getStackId() != iStackId) continue;
            return oResource;
        }
        return null;
    }

    public static ITask populateTaskFromAsnTask(AsnTaskInfo oAsnTaskInfo, int iAutoTaskType) {
        int iTaskProgress;
        List oSuportedOpList;
        boolean isSuccess;
        Task oTask = new Task();
        if (oAsnTaskInfo.oLoadSimulationPackageInfo != null) {
            SwitchTaskAndAsn.getSwitchTaskAndAsn().switchAsnToTaskByLoad(oAsnTaskInfo.oLoadSimulationPackageInfo, oTask);
        }
        AsnTaskCommonInfo oAsnCommonTaskInfo = oAsnTaskInfo.oTaskCommonInfo;
        int iTaskID = null != oAsnCommonTaskInfo.iTaskId ? oAsnCommonTaskInfo.iTaskId.intValue() : -1;
        oTask.setTaskId(iTaskID);
        oTask.setTaskName(new String(oAsnCommonTaskInfo.strTaskName));
        oTask.setTaskTypeId(TaskCommUtil.getTaskTypeFrmAsn(oAsnCommonTaskInfo.enTaskType.value));
        AsnTaskInfoUtil.processAsnTaskInfo(oAsnTaskInfo, oTask, oAsnCommonTaskInfo);
        oTask.setIsOffLineTask(oAsnCommonTaskInfo.bOfflineTask);
        Calendar oTaskStartTimeCal = Calendar.getInstance();
        if (null != oAsnCommonTaskInfo.oStartTime) {
            oTaskStartTimeCal.setTime(oAsnCommonTaskInfo.oStartTime.getTime());
            DCTimeDateUtil.switchToLocalCalendar(oTaskStartTimeCal);
            oTask.setStartTime(oTaskStartTimeCal);
        }
        Calendar oTaskEndTimeCal = Calendar.getInstance();
        if (null != oAsnCommonTaskInfo.oEndTime) {
            oTaskEndTimeCal.setTime(oAsnCommonTaskInfo.oEndTime.getTime());
            DCTimeDateUtil.switchToLocalCalendar(oTaskEndTimeCal);
            oTask.setEndTime(oTaskEndTimeCal);
        }
        if (!(isSuccess = AsnTaskInfoUtil.populateDeviceTypeFromAsnResourceList(oAsnTaskInfo, oTask, false))) {
            DCDebugTracer.trace("DC::task can not show in dc taskName=" + oTask.getTaskName());
            return null;
        }
        DeviceType oDeviceType = oTask.getSelectedDeviceType();
        IDeviceTypeConfigModel oDevTypeModel = null;
        oDevTypeModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceType);
        if (null == oDevTypeModel) {
            DCDebugTracer.trace("DC::task can not show in dc taskName=" + oTask.getTaskName() + " because can not get DevTypeModel");
            return null;
        }
        ITaskTypeConfiguration oTaskConfigurations = oDevTypeModel.getTaskTaskTypeConfiguration();
        int iTaskType = IsolationCommonOperation.getCommonTaskTypeId(oAsnCommonTaskInfo.enTaskType.value);
        if (iTaskType == 6) {
            iTaskType = 0;
        }
        if (13 == iTaskType) {
            boolean DOWNGRADE_DELDB = true;
            int DOWNGRADE_RECDB = 2;
            boolean DOWNGRADE_DELETE_DB = true;
            boolean DOWNGRADE_REVOCER_DB = false;
            AsnOperationInfoLst oAsnOperationInfoLst = oAsnTaskInfo.oTaskOperationLst;
            for (int i = 0; i < oAsnOperationInfoLst.size(); ++i) {
                AsnOperationInfo oAsnOperationInfo = (AsnOperationInfo)oAsnOperationInfoLst.get(i);
                String strOper = new String(oAsnOperationInfo.strOperationId);
                if (1 == iAutoTaskType || "DeleteDatabase".equals(strOper)) {
                    TaskSrcDstVersionCheck.getInstance().setDownGradeType(1, oTask);
                    iTaskType = TaskSrcDstVersionCheck.getInstance().iTaskTypeKey(iTaskType, oTask);
                    break;
                }
                if (2 != iAutoTaskType && !"Recover".equals(strOper)) continue;
                TaskSrcDstVersionCheck.getInstance().setDownGradeType(0, oTask);
                iTaskType = TaskSrcDstVersionCheck.getInstance().iTaskTypeKey(iTaskType, oTask);
                break;
            }
        }
        if (null == (oSuportedOpList = oTaskConfigurations.getCloneTaskOperations(iTaskType, oTask))) {
            DCDebugTracer.trace("[task disappear] DC::task can not show in dc taskName=" + oTask.getTaskName() + " because oSuportedOpList is  null");
            DCDebugTracer.trace("[task disappear] oDeviceType type" + oDeviceType.toString());
            DCDebugTracer.trace("[task disappear] TaskType " + TaskCommUtil.getTaskTypeFrmAsn(oAsnCommonTaskInfo.enTaskType.value));
            return null;
        }
        AsnTaskInfoUtil.updateLstWithParentTask(oSuportedOpList, oTask);
        oTask.setSupportedOperation(oSuportedOpList);
        AsnTaskInfoUtil.checkOpLstBasedOnViewType(oTask);
        oTask.setTaskContentType(AsnTaskInfoUtil.getTaskContentTyprFrmAsn(oAsnCommonTaskInfo.enContentType.value, oTaskConfigurations, oTask.getTaskTypeId()));
        AsnTaskInfoUtil.checkOpLstBasedOnTaskContentType(oTask);
        TaskProgressInfo oTaskProgress = oTask.getTaskProgressInfo();
        oTaskProgress.setState(TaskCommUtil.getStatusFromAsnStatus(oAsnCommonTaskInfo.enTaskStatus));
        if (4 == oTask.getTaskProgressInfo().getState()) {
            if (oAsnTaskInfo.oActivationGroupInfo != null) {
                BigInteger oVal = oAsnTaskInfo.oActivationGroupInfo.iCurrentGroup;
                if (null != oVal) {
                    oTaskProgress.setPausedActivateGrpID(oVal.intValue());
                } else {
                    oTaskProgress.setPausedActivateGrpID(-1);
                }
            }
        } else {
            oTaskProgress.setPausedActivateGrpID(-1);
        }
        int n = iTaskProgress = null != oAsnCommonTaskInfo.iTaskProgress ? oAsnCommonTaskInfo.iTaskProgress.intValue() : 0;
        if (oTaskProgress.getState() == 1 || oTaskProgress.getState() == 2) {
            oTaskProgress.setProgress(iTaskProgress);
        }
        if (null != oAsnCommonTaskInfo.enTaskResult) {
            oTaskProgress.setResult(oAsnCommonTaskInfo.enTaskResult.value);
        }
        AsnTaskInfoUtil.populateAllTaskOperationsInTask(oAsnTaskInfo, oTask);
        IsolationCommonOperation.fillIsolationBoards(oTask, oAsnTaskInfo);
        AsnResourceProgressInfoLst oAsnResourceProgressList = oAsnTaskInfo.oAsnResourceProgressInfoLst;
        if (null != oAsnResourceProgressList && 0 != oAsnResourceProgressList.size()) {
            THashSet<Resource> srcRsrcHashSet = oTask.getDeviceType().getResources();
            int iResourceCount = oAsnResourceProgressList.size();
            for (int i = 0; i < iResourceCount; ++i) {
                AsnResourceProgressInfo oAsnResourceProgress = (AsnResourceProgressInfo)oAsnResourceProgressList.get(i);
                Resource oResource = TaskCommUtil.getResourceFromDeviceType(oAsnResourceProgress.oAsnTaskResource, oTask.getSelectedDeviceType());
                if (null == oResource) continue;
                AsnTaskInfoUtil.fillSlotLabelToResources(oResource, oTask);
                TaskCommUtil.updateResourceProgress(oAsnResourceProgress, oResource, oDeviceType, oTask);
                Iterator itor = srcRsrcHashSet.iterator();
                Resource oTempResource = null;
                while (itor.hasNext()) {
                    oTempResource = (Resource)itor.next();
                    if (oTempResource.getDeviceID() != oResource.getDeviceID() || oTempResource.getSlotId() != oResource.getSlotId()) continue;
                    TaskCommUtil.updateResourceProgress(oAsnResourceProgress, oTempResource, oDeviceType, oTask);
                    break;
                }
                String strOperationID = new String(oAsnResourceProgress.strCurrentOperationId);
                IsolationCommonOperation.fillResourceToIsolationBoardInfo(strOperationID, oResource, oTask);
                oTask.getTemporaryDevType().addResource(oResource);
            }
        }
        return oTask;
    }

    private static void processAsnTaskInfo(AsnTaskInfo oAsnTaskInfo, ITask oTask, AsnTaskCommonInfo oAsnCommonTaskInfo) {
        if (oAsnTaskInfo.oActivationGroupInfo != null) {
            SwitchTaskAndAsn.getSwitchTaskAndAsn().switchAsnToTaskByActive(oAsnTaskInfo.oActivationGroupInfo, oTask);
        }
        if (oAsnTaskInfo.oLoadSimulationPackageInfo != null) {
            SwitchTaskAndAsn.getSwitchTaskAndAsn().switchAsnToTaskByLoad(oAsnTaskInfo.oLoadSimulationPackageInfo, oTask);
        }
        int iTaskViewType = AsnTaskInfoUtil.getTaskLevel(oAsnCommonTaskInfo.enViewLevel.value, oAsnCommonTaskInfo.bBoardLevel);
        oTask.setTaskViewType(iTaskViewType);
        if (oTask.getTaskTypeId() == 5 || oTask.getTaskTypeId() == 12) {
            oTask.setUpgradeLevel(oAsnCommonTaskInfo.iDiffusionUpgradLevel.intValue());
        }
        oTask.setHighefficiencyMode(oAsnCommonTaskInfo.enHighefficiencyMode.value);
        oTask.setbAutoTask(oAsnCommonTaskInfo.bIsAutoTask);
        if (oAsnTaskInfo.oTaskCommonInfo.strThirdPartyFTPName != null) {
            String strThirdServerName = new String(oAsnTaskInfo.oTaskCommonInfo.strThirdPartyFTPName);
            oTask.setThirdPartyServerName(strThirdServerName);
            if (!"".equals(strThirdServerName.trim())) {
                oTask.setThirdPartySupported(true);
            }
        } else {
            oTask.setThirdPartySupported(false);
        }
    }

    private static int getTaskLevel(int iAsnTaskViewTypeEnum, boolean isBoardLevel) {
        int iTaskViewType = 1;
        switch (iAsnTaskViewTypeEnum) {
            case 0: {
                if (isBoardLevel) {
                    iTaskViewType = 2;
                    break;
                }
                iTaskViewType = 1;
                break;
            }
            case 1: {
                if (isBoardLevel) {
                    iTaskViewType = 4;
                    break;
                }
                iTaskViewType = 3;
                break;
            }
        }
        return iTaskViewType;
    }

    private static void checkOpLstBasedOnTaskContentType(ITask oTask) {
        List<ITaskDeviceOperation> oSuppOpLst = oTask.getSupportedOperation();
        if (null == oSuppOpLst) {
            return;
        }
        int iSizeOfLst = oSuppOpLst.size();
        ITaskDeviceOperation oTaskDevOp = null;
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            oTaskDevOp = oSuppOpLst.get(i);
            if (null != oTask.getTaskContentType() && Collator.getInstance().equals("CONFIGURATIONFILE", oTask.getTaskContentType().getId()) && 5 == oTaskDevOp.getOperationId()) {
                oSuppOpLst.remove(i);
                continue;
            }
            if (8 == oTaskDevOp.getOperationId()) {
                ActivationConfigPara oActivateConfigPara = (ActivationConfigPara)oTaskDevOp.getConfiguredPara();
                if (null == oTask.getTaskContentType()) {
                    oActivateConfigPara.setCurrentActivationTypeLst("", oTask.getTaskViewType(), oTask);
                    continue;
                }
                oActivateConfigPara.setCurrentActivationTypeLst(oTask.getTaskContentType().getId(), oTask.getTaskViewType(), oTask);
                continue;
            }
            if (null != oTask.getTaskContentType() && 2 == oTaskDevOp.getOperationId()) {
                ContentConfigParam oBackupConfigPara = (ContentConfigParam)oTaskDevOp.getConfiguredPara();
                oBackupConfigPara.setSelectedContentTypeId(oTask.getTaskContentType().getId());
                continue;
            }
            if (null == oTask.getTaskContentType() || 1 != oTaskDevOp.getOperationId()) continue;
            ContentConfigParam oSaveConfigPara = (ContentConfigParam)oTaskDevOp.getConfiguredPara();
            oSaveConfigPara.setSelectedContentTypeId(oTask.getTaskContentType().getId());
        }
    }

    private static void checkOpLstBasedOnViewType(ITask oTask) {
        int iTaskViewType = oTask.getTaskViewType();
        switch (iTaskViewType) {
            case 2: 
            case 4: {
                AsnTaskInfoUtil.updateTaskOperationList(oTask);
                break;
            }
        }
    }

    private static ContentType getTaskContentTyprFrmAsn(int iAsnTaskTypeEnum, ITaskTypeConfiguration oTaskTypeConfiguration, int iTaskType) {
        ContentType oContentType = null;
        String strTaskTypeContentType = null;
        switch (iAsnTaskTypeEnum) {
            case 0: {
                strTaskTypeContentType = "CONFIGURATIONFILE";
                break;
            }
            case 1: {
                strTaskTypeContentType = "DATAFILE";
                break;
            }
            case 2: {
                strTaskTypeContentType = null;
                break;
            }
            default: {
                strTaskTypeContentType = null;
            }
        }
        if (null != strTaskTypeContentType) {
            IParaList oParaList = oTaskTypeConfiguration.getParaList(iTaskType);
            Object[] oContentObj = ParamUtil.getInstance().getContentTypeList(oParaList);
            oContentType = ParamUtil.getInstance().getContentType(oContentObj, strTaskTypeContentType);
        }
        return oContentType;
    }

    private static void populateAllTaskOperationsInTask(AsnTaskInfo oAsnTaskInfo, ITask oTask) {
        List<ITaskDeviceOperation> oOperationList = oTask.getSupportedOperation();
        AsnTaskInfoUtil.updateOperationSelectionFrmAsn(oOperationList, oAsnTaskInfo.oTaskOperationLst);
        oTask.setTargetVersion(new String(oAsnTaskInfo.oTaskCommonInfo.strTargetVersion));
        TaskCommUtil.updateUpgradeSwitchOp(oAsnTaskInfo, oOperationList);
        if (null != oAsnTaskInfo.oSaveOpInfo) {
            AsnTaskInfoUtil.updateSaveOperation(oAsnTaskInfo, oOperationList);
        }
        if (null != oAsnTaskInfo.oBackupOpInfo) {
            AsnTaskInfoUtil.updateBackupOperation(oAsnTaskInfo, oOperationList);
        }
        if (null != oAsnTaskInfo.oUpdateOpInfo) {
            AsnTaskInfoUtil.updateUpdateDataOperation(oAsnTaskInfo, oOperationList);
        }
        if (null != oAsnTaskInfo.oLoadSWOpInfo) {
            AsnTaskInfoUtil.updateLoadSoftwareOperation(oAsnTaskInfo, oOperationList, oTask);
        }
        if (null != oAsnTaskInfo.oLoadDataOpInfolst) {
            AsnTaskInfoUtil.updateLoadDataOperation(oAsnTaskInfo, oOperationList);
        }
        if (null != oAsnTaskInfo.oLoadPatchOpInfo) {
            AsnTaskInfoUtil.updateLoadPatchOperation(oAsnTaskInfo, oOperationList, oTask);
        }
        if (null != oAsnTaskInfo.oActivationOpReq) {
            AsnTaskInfoUtil.updateActivateOperation(oAsnTaskInfo, oTask, oOperationList);
        }
        if (null != oAsnTaskInfo.oAsnTaskRecoverDBOpInfo) {
            AsnTaskInfoUtil.updateRecoverDBOperation(oAsnTaskInfo, oOperationList);
        }
        AsnTaskInfoUtil.updateCheckOperation(oAsnTaskInfo, oOperationList, oTask);
        if (null != oAsnTaskInfo.oAsnPrepareUpgradeOpInfo) {
            AsnTaskInfoUtil.updatePrepareUpgradeOperation(oAsnTaskInfo, oOperationList);
        }
        if (null != oAsnTaskInfo.oAsnPostUpgradeOpInfo) {
            AsnTaskInfoUtil.updatePostUpgradeOperation(oAsnTaskInfo, oOperationList);
        }
        oTask.setSupportedOperation(oOperationList);
    }

    private static void updateActivateOperation(AsnTaskInfo oAsnTaskInfo, ITask oTask, List oOperationList) {
        ITaskDeviceOperation oTaskActivateOp = null;
        oTaskActivateOp = TaskCommUtil.getOperationFromLst(8, oOperationList);
        if (null != oTaskActivateOp) {
            AsnTaskInfoUtil.updateActivateConfigInfo(oTask, oTaskActivateOp, oAsnTaskInfo.oActivationOpReq);
        }
    }

    private static void updateBackupOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ITaskDeviceOperation oTaskBackupOp = TaskCommUtil.getOperationFromLst(2, oOperationList);
        if (null != oTaskBackupOp) {
            ContentConfigParam oConfiguredPara = (ContentConfigParam)oTaskBackupOp.getConfiguredPara();
            AsnContentTypeInfoLst l_asnTypeList = oAsnTaskInfo.oBackupOpInfo.oBackupContentTypeLst;
            ArrayList<Integer> l_contentTypeIdList = new ArrayList<Integer>();
            if (null != l_asnTypeList) {
                AsnContentTypeInfo l_asnTypeInfo = null;
                for (int i = 0; i < l_asnTypeList.size(); ++i) {
                    l_asnTypeInfo = (AsnContentTypeInfo)l_asnTypeList.get(i);
                    l_contentTypeIdList.add(l_asnTypeInfo.iContentType.intValue());
                }
            }
            oConfiguredPara.setSelectedContentTypeId(l_contentTypeIdList);
        }
    }

    private static void updateCheckOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList, ITask oTask) {
        AsnTaskInfoUtil.updataPrecheckOp(oAsnTaskInfo, oOperationList);
        AsnTaskInfoUtil.updatePostCheckOp(oAsnTaskInfo, oOperationList);
        ICheckOperation oCheckOp = (ICheckOperation)TaskCommUtil.getOperationFromLst(4, oOperationList);
        ConfigTreeUtil.updateConnectivityNodeInfo(oCheckOp, oTask);
        oCheckOp = (ICheckOperation)TaskCommUtil.getOperationFromLst(16, oOperationList);
        ConfigTreeUtil.updateConnectivityNodeInfo(oCheckOp, oTask);
    }

    private static void updataPrecheckOp(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ICheckOperation oCheckOp = (ICheckOperation)TaskCommUtil.getOperationFromLst(4, oOperationList);
        if (null != oCheckOp && null != oAsnTaskInfo.oPreCheckOpInfo) {
            ConfigTreeUtil.updateCheckOpData(oAsnTaskInfo.oPreCheckOpInfo, oCheckOp);
        }
    }

    private static void updateActivateConfigInfo(ITask oTask, ITaskDeviceOperation taskActivateOp, AsnActivationReq oAsnActivationOpReq) {
        ActivationConfigPara oConfiguredPara = (ActivationConfigPara)taskActivateOp.getConfiguredPara();
        oConfiguredPara.setIsBoardLevel(oAsnActivationOpReq.oAsnActivationInfo.bBoardLevel);
        if (null != oAsnActivationOpReq.oAsnActivationInfo.oActivationType) {
            String strActivationTypeId = TaskAsnSupportUtilities.getOperationTypeId(oAsnActivationOpReq.oAsnActivationInfo.oActivationType.value);
            oConfiguredPara.setActivationType(oTask.getTaskContentType(), strActivationTypeId, oTask.getTaskViewType());
        }
        if (null != oAsnActivationOpReq.oAsnActivationInfo.oScheduledActivateTime) {
            oConfiguredPara.setScheduledActivationTime(oAsnActivationOpReq.oAsnActivationInfo.oScheduledActivateTime);
        }
        if (null != oAsnActivationOpReq.oAsnActivationInfo.oAsnOperationModeEnum) {
            String strOpModeId = TaskAsnSupportUtilities.getOperationModeId(oAsnActivationOpReq.oAsnActivationInfo.oAsnOperationModeEnum.value);
            oConfiguredPara.setActivationMode(strOpModeId);
        }
        if (null != oAsnActivationOpReq.oAsnActivationInfo.oActivationTime) {
            oConfiguredPara.setActivationUTCTime(oAsnActivationOpReq.oAsnActivationInfo.oActivationTime);
            oConfiguredPara.setIsTimeSelected(true);
        }
        if (null != oAsnActivationOpReq.oAsnActivationInfo.iDelayRebootTime) {
            oConfiguredPara.setM_oDelayTime(oAsnActivationOpReq.oAsnActivationInfo.iDelayRebootTime.intValue());
            oConfiguredPara.setM_bIsDelayTimeSelected(true);
        }
        AsnTaskInfoUtil.updateElementInfoLst(oTask, oConfiguredPara, oAsnActivationOpReq.oAsnActivationElementInfoLst);
        if (null != oAsnActivationOpReq.oAsnActivationGroupInfoLst) {
            AsnTaskInfoUtil.updateGroupInfoLst(oConfiguredPara, oAsnActivationOpReq.oAsnActivationGroupInfoLst);
        }
    }

    private static void updateTaskOperationList(ITask oTask) {
        List<ITaskDeviceOperation> oOperationList = oTask.getSupportedOperation();
        int iSizeOfLst = oOperationList.size();
        ITaskDeviceOperation oTaskDevOp = null;
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            oTaskDevOp = oOperationList.get(i);
            if (0 != oTaskDevOp.getOperationLevel()) continue;
            oOperationList.remove(i);
        }
    }

    private static void updateUpdateDataOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ITaskDeviceOperation oTaskUpdateDataOp = TaskCommUtil.getOperationFromLst(5, oOperationList);
        if (null != oTaskUpdateDataOp) {
            UpdateConfigParam oUpdatePara = (UpdateConfigParam)oTaskUpdateDataOp.getConfiguredPara();
            oUpdatePara.setDefaultSelected(oAsnTaskInfo.oUpdateOpInfo.bDefaultUpdatePath);
            if (null != oAsnTaskInfo.oUpdateOpInfo.strUpdateToolPath) {
                oUpdatePara.setSelectedUpdateType(new String(oAsnTaskInfo.oUpdateOpInfo.strUpdateToolPath));
            }
        }
    }

    static void updateElementInfoLst(ITask oTask, ActivationConfigPara configuredPara, AsnActivationElementInfoLst asnActivationElementInfoLst) {
        int iSizeOfLst = asnActivationElementInfoLst.size();
        ArrayList oActivateElementInfoLst = new ArrayList(8);
        AsnTaskInfoUtil.fillActivateInfoLst(oActivateElementInfoLst, oTask);
        int iSizeOfResourceLst = oActivateElementInfoLst.size();
        AsnActivationElementInfo oAsnElementInfo = null;
        ActivationElementInfo oActivationElementInfo = null;
        Resource oTempRes = null;
        AsnTaskResource oAsnTaskRes = null;
        block0: for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnElementInfo = (AsnActivationElementInfo)asnActivationElementInfoLst.get(i);
            configuredPara.setIsConfSendToBoard(oAsnElementInfo._bDeliverToBoard | oAsnElementInfo.bDeliverToBoard);
            oAsnTaskRes = oAsnElementInfo.oResource;
            oTempRes = new Resource();
            oTempRes.setDeviceID(oAsnTaskRes.iDeviceId.intValue());
            if (null != oAsnTaskRes.iFrameId) {
                oTempRes.setFrameId(oAsnTaskRes.iFrameId.intValue());
            }
            if (null != oAsnTaskRes.iSlotId) {
                oTempRes.setSlotId(oAsnTaskRes.iSlotId.intValue());
            }
            if (null != oAsnTaskRes.iSubSlotId) {
                oTempRes.setSubSlotId(oAsnTaskRes.iSubSlotId.intValue());
            }
            if (null != oAsnTaskRes.strSWversion) {
                oTempRes.setDeviceVersion(new String(oAsnTaskRes.strSWversion));
            }
            if (null != oAsnTaskRes.iDevTypeId && null != oAsnTaskRes.iDevTypeVerId) {
                DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oAsnTaskRes.iDevTypeId.intValue(), oAsnTaskRes.iDevTypeVerId.intValue());
                oTempRes.setStackDevTypeInfo(oDevTypeInfo);
            }
            for (int j = 0; j < iSizeOfResourceLst; ++j) {
                oActivationElementInfo = (ActivationElementInfo)oActivateElementInfoLst.get(j);
                if (!oTempRes.equals(oActivationElementInfo.getResource())) continue;
                oActivationElementInfo.setSelected(true);
                if (null != oAsnElementInfo.iGroupId) {
                    oActivationElementInfo.setGroupId(oAsnElementInfo.iGroupId.intValue());
                }
                if (null == oAsnElementInfo.iSequenceId) continue block0;
                oActivationElementInfo.setSequenceId(oAsnElementInfo.iSequenceId.intValue());
                continue block0;
            }
        }
        configuredPara.setElementInfoLst(oActivateElementInfoLst);
    }

    static void updateGroupInfoLst(ActivationConfigPara configuredPara, AsnActivationGroupInfoLst asnActivationGroupInfoLst) {
        ArrayList<ActivationGroupInfo> oActivationGroupInfoLst = new ArrayList<ActivationGroupInfo>(8);
        int iSizeOfLst = asnActivationGroupInfoLst.size();
        ActivationGroupInfo oActivateGroupInfo = null;
        AsnActivationGroupInfo oAsnActivateGroupInfo = null;
        String strGroupName = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oActivateGroupInfo = new ActivationGroupInfo();
            oAsnActivateGroupInfo = (AsnActivationGroupInfo)asnActivationGroupInfoLst.get(i);
            oActivateGroupInfo.setGroupId(oAsnActivateGroupInfo.iGroupId.intValue());
            strGroupName = new String(oAsnActivateGroupInfo.strGroupName);
            oActivateGroupInfo.setGroupName(strGroupName);
            oActivationGroupInfoLst.add(oActivateGroupInfo);
        }
        configuredPara.setActivateGroupInfoLst(oActivationGroupInfoLst);
    }

    static void updateLoadSoftwareOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList, ITask oTask) {
        ITaskDeviceOperation oTaskLoadSWOp = TaskCommUtil.getOperationFromLst(6, oOperationList);
        if (null != oTaskLoadSWOp) {
            LoadFileInfoListParam oLoadFilesConfigured = (LoadFileInfoListParam)oTaskLoadSWOp.getConfiguredPara();
            AsnLoadFileLst oAsnFileLst = oAsnTaskInfo.oLoadSWOpInfo.oLoadFileLst;
            boolean bAutoDelImage = oAsnTaskInfo.oLoadSWOpInfo.bAutoDelImage;
            oLoadFilesConfigured.setbAutoDelImage(bAutoDelImage);
            int iPacketCustomizedResult = 0;
            if (null != oAsnTaskInfo.oTaskCommonInfo.enPacketCustomizedType) {
                iPacketCustomizedResult = oAsnTaskInfo.oTaskCommonInfo.enPacketCustomizedType.value;
            }
            DCDebugTracer.trace("DC::TaskCommUtil/updateLoadSoftwareOperation:Get packet customized result:" + iPacketCustomizedResult);
            oLoadFilesConfigured.setPacketCustomizedResult(iPacketCustomizedResult);
            int iSizeLst = oAsnFileLst.size();
            LoadFileInfo oLoadFileInfo = null;
            ContentType oContentType = null;
            DeviceTypeInfo oDevTypeInfo = null;
            ArrayList<LoadFileInfo> oLoadFileInfoLst = new ArrayList<LoadFileInfo>(10);
            String strFileName = null;
            LoadFileInfoListParam m_oLoadParam = new LoadFileInfoListParam();
            LoadFileInfo[] fileList = new LoadFileInfo[iSizeLst];
            for (int j = 0; j < iSizeLst; ++j) {
                AsnLoadFileInfo oAsnLoadInfo = (AsnLoadFileInfo)oAsnFileLst.get(j);
                oLoadFileInfo = new LoadFileInfo();
                Object[] arrContentType = null;
                Object[] arrDeviceLevelContentType = null;
                ArrayList<Object> oFinalList = new ArrayList<Object>(0);
                if (6 == oAsnTaskInfo.oTaskCommonInfo.enTaskType.value) {
                    int iDeviceId = ((AsnTaskResource)oAsnTaskInfo.oTaskResourceLst.get((int)0)).iDeviceId.intValue();
                    DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDeviceId);
                    oDevTypeInfo = oDevInfo.getDeviceTypeInfo();
                    int[] iDeviceIdLst = new int[]{oDevInfo.getDevId()};
                    arrContentType = TaskCommUtil.getContentTypesFromXMLConfig(oDevTypeInfo, iDeviceIdLst).toArray();
                } else {
                    arrContentType = ParamUtil.getInstance().getContentTypeList(oTaskLoadSWOp.getoPerationParaList());
                    arrDeviceLevelContentType = ParamUtil.getInstance().getContentTypeListForDeviceLevelLoad(oTaskLoadSWOp.getoPerationParaList());
                    oFinalList.addAll(Arrays.asList(arrContentType));
                    oFinalList.addAll(Arrays.asList(arrDeviceLevelContentType));
                    arrContentType = oFinalList.toArray();
                }
                oContentType = DCConstants.PACKET_TOOL_CONTENT_TYPE.getContentTypeCode() == oAsnLoadInfo.iContentType.intValue() ? DCConstants.PACKET_TOOL_CONTENT_TYPE : ParamUtil.getInstance().getContentType(arrContentType, oAsnLoadInfo.iContentType.intValue());
                if (null != oAsnLoadInfo.iDevTypeId && null != oAsnLoadInfo.iDevTypeVerId) {
                    oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oAsnLoadInfo.iDevTypeId.intValue(), oAsnLoadInfo.iDevTypeVerId.intValue());
                }
                if (null != oContentType) {
                    oLoadFilesConfigured.setContentTypeRequired(true);
                    oLoadFileInfo.setContentType(oContentType);
                }
                if (null != oDevTypeInfo) {
                    oLoadFilesConfigured.setDeviceTypeInfoRequired(true);
                    oLoadFileInfo.setDeviceTypeInfo(oDevTypeInfo);
                }
                strFileName = new String(oAsnLoadInfo.strFileName);
                if (null != oAsnLoadInfo.iDevId) {
                    oLoadFileInfo.setDeviceId(oAsnLoadInfo.iDevId.intValue());
                } else {
                    oLoadFileInfo.setDeviceId(0);
                }
                oLoadFileInfo.setFileName(strFileName);
                if (null != oAsnLoadInfo.iSequence) {
                    oLoadFileInfo.setSequenceNo(oAsnLoadInfo.iSequence.intValue());
                }
                if (null != oAsnLoadInfo.iFileSelectLevelEnum) {
                    oLoadFileInfo.setFileSelectionLevel(oAsnLoadInfo.iFileSelectLevelEnum.value);
                } else {
                    oLoadFileInfo.setFileSelectionLevel(0);
                }
                oLoadFileInfoLst.add(oLoadFileInfo);
                fileList[j] = oLoadFileInfo;
            }
            oLoadFilesConfigured.setLoadFileInfoList(oLoadFileInfoLst);
            if ((oTask.getTaskTypeId() == 5 || oTask.getTaskTypeId() == 4 || oTask.getTaskTypeId() == 12 || oTask.getTaskTypeId() == 13) && iSizeLst > 0) {
                m_oLoadParam.addServerFiles(fileList);
                oTask.setLoadFileInfoListParam(m_oLoadParam);
            }
            if (null != oAsnTaskInfo.oLoadSWOpInfo.iFtpType) {
                oTask.setLoadSoftwareType(oAsnTaskInfo.oLoadSWOpInfo.iFtpType.intValue());
            }
        }
    }

    static void updateLstWithParentTask(List suportedOpList, final ITask oTask) {
        if (null == suportedOpList) {
            return;
        }
        int iSizeOfList = suportedOpList.size();
        for (int i = 0; i < iSizeOfList; ++i) {
            final ITaskDeviceOperation oTaskDevOp = (ITaskDeviceOperation)suportedOpList.get(i);
            if (oTaskDevOp instanceof LoadDataOperation) {
                Thread oTmpThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        oTaskDevOp.setOperationData(oTask);
                    }
                });
                oTmpThread.start();
                continue;
            }
            oTaskDevOp.setOperationData(oTask);
        }
    }

    static void updateOperationSelectionFrmAsn(List oOperationList, AsnOperationInfoLst oAsnTaskOperationLst) {
        if (null == oOperationList) {
            return;
        }
        int iSizeOfAsnLst = oAsnTaskOperationLst.size();
        AsnOperationInfo oAsnOperationInfo = null;
        String strOPerationId = null;
        int iSizeOfTaskLst = oOperationList.size();
        ITaskDeviceOperation oTaskDevOperation = null;
        block0: for (int j = 0; j < iSizeOfTaskLst; ++j) {
            oTaskDevOperation = (ITaskDeviceOperation)oOperationList.get(j);
            for (int i = 0; i < iSizeOfAsnLst; ++i) {
                oAsnOperationInfo = (AsnOperationInfo)oAsnTaskOperationLst.get(i);
                strOPerationId = new String(oAsnOperationInfo.strOperationId);
                int iOperationId = OperationIdStore.getInstance().getOperationId(strOPerationId);
                if (iOperationId != oTaskDevOperation.getOperationId()) continue;
                oTaskDevOperation.setSelected(oAsnOperationInfo.isSelected);
                oTaskDevOperation.setIsPauseBeforeCurOp(oAsnOperationInfo.bPauseConfigured);
                continue block0;
            }
        }
    }

    static void updatePostCheckOp(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ICheckOperation oCheckOp = (ICheckOperation)TaskCommUtil.getOperationFromLst(16, oOperationList);
        if (null != oCheckOp && null != oAsnTaskInfo.oPostCheckOpInfo) {
            ConfigTreeUtil.updateCheckOpData(oAsnTaskInfo.oPostCheckOpInfo, oCheckOp);
        }
    }

    static void updatePostUpgradeOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ITaskDeviceOperation oPostUpgradeOp = null;
        oPostUpgradeOp = TaskCommUtil.getOperationFromLst(33, oOperationList);
        if (null != oPostUpgradeOp) {
            TaskCommUtil.updatePostUpgradeInfo(oPostUpgradeOp, oAsnTaskInfo.oAsnPostUpgradeOpInfo);
        }
    }

    static void updatePrepareUpgradeOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ITaskDeviceOperation oPrepareUpgradeOp = null;
        oPrepareUpgradeOp = TaskCommUtil.getOperationFromLst(32, oOperationList);
        if (null != oPrepareUpgradeOp) {
            AsnTaskInfoUtil.updatePrepareUpgradeInfo(oPrepareUpgradeOp, oAsnTaskInfo.oAsnPrepareUpgradeOpInfo);
        }
    }

    static void updateRecoverDBOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ITaskDeviceOperation oTaskRecoverOp = null;
        oTaskRecoverOp = TaskCommUtil.getOperationFromLst(3, oOperationList);
        if (null != oTaskRecoverOp) {
            AsnTaskInfoUtil.updateRecoverDBInfo(oTaskRecoverOp, oAsnTaskInfo.oAsnTaskRecoverDBOpInfo);
        }
    }

    static void updateSaveOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ITaskDeviceOperation oTaskSaveOp = TaskCommUtil.getOperationFromLst(1, oOperationList);
        if (null != oTaskSaveOp) {
            ContentConfigParam oConfiguredPara = (ContentConfigParam)oTaskSaveOp.getConfiguredPara();
            oConfiguredPara.setSelectedContentTypeId(oAsnTaskInfo.oSaveOpInfo.iContentType.intValue());
        }
    }

    static void updateLoadDataOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        ITaskDeviceOperation oTaskLoadDataOp = TaskCommUtil.getOperationFromLst(7, oOperationList);
        if (null != oTaskLoadDataOp) {
            LoadFileInfoListParam oLoadFilesConfigured = (LoadFileInfoListParam)oTaskLoadDataOp.getConfiguredPara();
            int iSizeOfLst = oAsnTaskInfo.oLoadDataOpInfolst.size();
            LoadFileInfo oLoadFileInfo = null;
            ContentType oContentType = null;
            ArrayList<LoadFileInfo> oLoadFileInfoLst = new ArrayList<LoadFileInfo>(10);
            String m_strFileName = null;
            for (int i = 0; i < iSizeOfLst; ++i) {
                AsnLoadDataOpInfo oAsnLoadDataOpInfo = (AsnLoadDataOpInfo)oAsnTaskInfo.oLoadDataOpInfolst.get(i);
                oLoadFileInfo = new LoadFileInfo();
                oLoadFileInfo.setLoadDefaultFile(oAsnLoadDataOpInfo.bIsDefault);
                oLoadFileInfo.setDeviceId(oAsnLoadDataOpInfo.iDeviceId.intValue());
                if (null != oAsnLoadDataOpInfo.oLoadOpInfo.strFileName) {
                    m_strFileName = new String(oAsnLoadDataOpInfo.oLoadOpInfo.strFileName);
                }
                oLoadFileInfo.setFileName(m_strFileName);
                Object[] arrContentType = ParamUtil.getInstance().getContentTypeList(oTaskLoadDataOp.getoPerationParaList());
                oContentType = ParamUtil.getInstance().getContentType(arrContentType, oAsnLoadDataOpInfo.oLoadOpInfo.iContentType.intValue());
                if (null != oContentType) {
                    oLoadFileInfo.setContentType(oContentType);
                }
                oLoadFileInfoLst.add(oLoadFileInfo);
            }
            oLoadFilesConfigured.setLoadFileInfoList(oLoadFileInfoLst);
        }
    }

    static void updateLoadPatchOperation(AsnTaskInfo oAsnTaskInfo, List oOperationList, ITask oTask) {
        ITaskDeviceOperation oTaskLoadPatchOp = TaskCommUtil.getOperationFromLst(9, oOperationList);
        if (null != oTaskLoadPatchOp) {
            if (null != oAsnTaskInfo.oLoadPatchOpInfo.iFtpType) {
                oTask.setLoadSoftwareType(oAsnTaskInfo.oLoadPatchOpInfo.iFtpType.intValue());
            }
            LoadFileInfoListParam oLoadFilesConfigured = (LoadFileInfoListParam)oTaskLoadPatchOp.getConfiguredPara();
            AsnLoadFileLst oAsnFileLst = oAsnTaskInfo.oLoadPatchOpInfo.oLoadOpInfolst;
            int iSizeLst = oAsnFileLst.size();
            LoadFileInfo oLoadFileInfo = null;
            ContentType oContentType = null;
            DeviceTypeInfo oDevTypeInfo = null;
            ArrayList<LoadFileInfo> oLoadFileInfoLst = new ArrayList<LoadFileInfo>(10);
            String strFileName = null;
            for (int j = 0; j < iSizeLst; ++j) {
                AsnLoadFileInfo oAsnLoadInfo = (AsnLoadFileInfo)oAsnFileLst.get(j);
                oLoadFileInfo = new LoadFileInfo();
                Object[] arrContentType = ParamUtil.getInstance().getContentTypeList(oTaskLoadPatchOp.getoPerationParaList());
                oContentType = ParamUtil.getInstance().getContentType(arrContentType, oAsnLoadInfo.iContentType.intValue());
                if (null != oAsnLoadInfo.iDevTypeId && null != oAsnLoadInfo.iDevTypeVerId) {
                    oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oAsnLoadInfo.iDevTypeId.intValue(), oAsnLoadInfo.iDevTypeVerId.intValue());
                }
                if (null != oContentType) {
                    oLoadFilesConfigured.setContentTypeRequired(true);
                    oLoadFileInfo.setContentType(oContentType);
                }
                if (null != oDevTypeInfo) {
                    oLoadFilesConfigured.setDeviceTypeInfoRequired(true);
                    oLoadFileInfo.setDeviceTypeInfo(oDevTypeInfo);
                }
                strFileName = new String(oAsnLoadInfo.strFileName);
                oLoadFileInfo.setFileName(strFileName);
                oLoadFileInfo.setSequenceNo(oAsnLoadInfo.iSequence.intValue());
                oLoadFileInfo.setStartTime(oAsnLoadInfo.oStartTime);
                oLoadFileInfo.setEndTime(oAsnLoadInfo.oEndTime);
                if (null != oAsnLoadInfo.oErrorInfo) {
                    oLoadFileInfo.setErrMsg(ErrorCodeReader.getInstance().getErrorDesc(oAsnLoadInfo.oErrorInfo.iErrorNo));
                }
                if (null != oAsnLoadInfo.iDevId) {
                    oLoadFileInfo.setDeviceId(oAsnLoadInfo.iDevId.intValue());
                }
                oLoadFileInfoLst.add(oLoadFileInfo);
            }
            oLoadFilesConfigured.setLoadFileInfoList(oLoadFileInfoLst);
        }
    }

    static void updatePrepareUpgradeInfo(ITaskDeviceOperation oPrepareUpgradeOp, AsnUpgradeOpInfo oAsnUpgradeOpInfo) {
        AsnOperationInfoLst oAsnOperationInfoLst = oAsnUpgradeOpInfo.oSubOperationLst;
        List oUpgradeSubOprList = (List)oPrepareUpgradeOp.getConfiguredPara();
        int iSizeOfAsnLst = oAsnOperationInfoLst.size();
        AsnOperationInfo oAsnOperationInfo = null;
        String strOPerationId = null;
        int iSizeOfOprLst = oUpgradeSubOprList.size();
        IUpgradeSubOperation oSubOperation = null;
        for (int j = 0; j < iSizeOfOprLst; ++j) {
            oSubOperation = (IUpgradeSubOperation)oUpgradeSubOprList.get(j);
            boolean bFound = false;
            for (int i = 0; i < iSizeOfAsnLst; ++i) {
                oAsnOperationInfo = (AsnOperationInfo)oAsnOperationInfoLst.get(i);
                strOPerationId = new String(oAsnOperationInfo.strOperationId);
                if (!Collator.getInstance().equals(strOPerationId, oSubOperation.getOperationIdString())) continue;
                bFound = true;
                oSubOperation.setSelected(oAsnOperationInfo.isSelected);
                break;
            }
            if (bFound) continue;
            oSubOperation.setSelected(false);
        }
        if (null != oAsnUpgradeOpInfo.oAsnStartupConfigOpInfo) {
            AsnTaskInfoUtil.updateStartupConfigInfo(oPrepareUpgradeOp, oAsnUpgradeOpInfo.oAsnStartupConfigOpInfo);
        }
    }

    static void updateRecoverDBInfo(ITaskDeviceOperation oTaskRecoverOp, AsnTaskRecoverDBOpInfo oAsnTaskRecoverDBOpInfo) {
        RecoverDBConfigPara oConfiguredPara = (RecoverDBConfigPara)oTaskRecoverOp.getConfiguredPara();
        ArrayList<RecoverElementInfo> oElementInfoLst = new ArrayList<RecoverElementInfo>(0);
        ArrayList<ActivationGroupInfo> oGroupInfoLst = new ArrayList<ActivationGroupInfo>(0);
        AsnActivationGroupInfoLst oAsnActivationGroupInfoLst = oAsnTaskRecoverDBOpInfo.oAsnActivationGroupInfoLst;
        int iSize = oAsnActivationGroupInfoLst.size();
        AsnActivationGroupInfo oAsnActivationGroupInfo = null;
        ActivationGroupInfo oActivationGroupInfo = null;
        String strGroupName = null;
        for (int i = 0; i < iSize; ++i) {
            oActivationGroupInfo = new ActivationGroupInfo();
            oAsnActivationGroupInfo = (AsnActivationGroupInfo)oAsnActivationGroupInfoLst.get(i);
            int iGroupID = oAsnActivationGroupInfo.iGroupId.intValue();
            strGroupName = new String(oAsnActivationGroupInfo.strGroupName);
            oActivationGroupInfo.setGroupId(iGroupID);
            oActivationGroupInfo.setGroupName(strGroupName);
            if (null == oGroupInfoLst) continue;
            oGroupInfoLst.add(oActivationGroupInfo);
        }
        AsnTaskRecoverElementInfoLst oAsnTaskRecoverElementInfoLst = oAsnTaskRecoverDBOpInfo.oAsnTaskRecoverElementInfoLst;
        iSize = oAsnTaskRecoverElementInfoLst.size();
        RecoverElementInfo oRecoverElementInfo = null;
        AsnTaskRecoverElementInfo oAsnTaskRecoverElementInfo = null;
        String strFilePath = null;
        for (int i = 0; i < iSize; ++i) {
            oRecoverElementInfo = new RecoverElementInfo();
            oAsnTaskRecoverElementInfo = (AsnTaskRecoverElementInfo)oAsnTaskRecoverElementInfoLst.get(i);
            int iGroupID = oAsnTaskRecoverElementInfo.iGroupID.intValue();
            boolean bDeliverToBoard = oAsnTaskRecoverElementInfo.bDeliverToBoard;
            int iDevID = oAsnTaskRecoverElementInfo.iDeviceID.intValue();
            int iSequenceID = oAsnTaskRecoverElementInfo.iSequenceId.intValue();
            strFilePath = new String(oAsnTaskRecoverElementInfo.strFilePath);
            oRecoverElementInfo.setDeliverToBoard(bDeliverToBoard);
            oRecoverElementInfo.setGroupID(iGroupID);
            oRecoverElementInfo.setRecoverFilePath(strFilePath);
            oRecoverElementInfo.setResource(DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID));
            oRecoverElementInfo.setSequenceID(iSequenceID);
            oElementInfoLst.add(oRecoverElementInfo);
        }
        if (null != oGroupInfoLst && 0 != oGroupInfoLst.size()) {
            oConfiguredPara.setActivateGroupInfoLst(oGroupInfoLst);
        }
        oConfiguredPara.setRecoverElementInfoLst(oElementInfoLst);
    }

    static void fillActivateInfoLst(List activateElementInfoLst, ITask task) {
        THashSet<Resource> oResourceLst = task.getSelectedDeviceType().getResources();
        Resource oResourceInfo2 = null;
        ActivationElementInfo oElementInfo = null;
        for (Resource oResourceInfo2 : oResourceLst) {
            oElementInfo = new ActivationElementInfo();
            oElementInfo.setResource(oResourceInfo2);
            activateElementInfoLst.add(oElementInfo);
        }
    }

    public static void updateIsolationTaskFromAsnTask(AsnTaskInfo oAsnTaskInfo, ITask oTask) {
        int iTaskProgress;
        boolean isSuccess;
        AsnTaskCommonInfo oAsnCommonTaskInfo = oAsnTaskInfo.oTaskCommonInfo;
        Calendar oTaskStartTimeCal = Calendar.getInstance();
        if (null != oAsnCommonTaskInfo.oStartTime) {
            oTaskStartTimeCal.setTime(oAsnCommonTaskInfo.oStartTime.getTime());
            DCTimeDateUtil.switchToLocalCalendar(oTaskStartTimeCal);
            oTask.setStartTime(oTaskStartTimeCal);
        }
        Calendar oTaskEndTimeCal = Calendar.getInstance();
        if (null != oAsnCommonTaskInfo.oEndTime) {
            oTaskEndTimeCal.setTime(oAsnCommonTaskInfo.oEndTime.getTime());
            DCTimeDateUtil.switchToLocalCalendar(oTaskEndTimeCal);
            oTask.setEndTime(oTaskEndTimeCal);
        }
        if (!(isSuccess = AsnTaskInfoUtil.populateDeviceTypeFromAsnResourceList(oAsnTaskInfo, oTask, true))) {
            return;
        }
        DeviceType oDeviceType = oTask.getSelectedDeviceType();
        TaskProgressInfo oTaskProgress = oTask.getTaskProgressInfo();
        oTaskProgress.setState(TaskCommUtil.getStatusFromAsnStatus(oAsnCommonTaskInfo.enTaskStatus));
        int n = iTaskProgress = null != oAsnCommonTaskInfo.iTaskProgress ? oAsnCommonTaskInfo.iTaskProgress.intValue() : 0;
        if (oTaskProgress.getState() == 1 || oTaskProgress.getState() == 2) {
            oTaskProgress.setProgress(iTaskProgress);
        }
        if (null != oAsnCommonTaskInfo.enTaskResult) {
            oTaskProgress.setResult(oAsnCommonTaskInfo.enTaskResult.value);
        }
        IsolationCommonOperation.fillIsolationBoards(oTask, oAsnTaskInfo);
        AsnResourceProgressInfoLst oAsnResourceProgressList = oAsnTaskInfo.oAsnResourceProgressInfoLst;
        if (null != oAsnResourceProgressList && 0 != oAsnResourceProgressList.size()) {
            THashSet<Resource> srcRsrcLst = oTask.getDeviceType().getResources();
            int iResourceCount = oAsnResourceProgressList.size();
            for (int i = 0; i < iResourceCount; ++i) {
                AsnResourceProgressInfo oAsnResourceProgress = (AsnResourceProgressInfo)oAsnResourceProgressList.get(i);
                Resource oResource = TaskCommUtil.getResourceFromDeviceType(oAsnResourceProgress.oAsnTaskResource, oTask.getSelectedDeviceType());
                AsnTaskInfoUtil.fillSlotLabelToResources(oResource, oTask);
                TaskCommUtil.updateResourceProgress(oAsnResourceProgress, oResource, oDeviceType, oTask);
                for (Resource oTempResource : srcRsrcLst) {
                    if (oTempResource.getDeviceID() != oResource.getDeviceID() || oTempResource.getSlotId() != oResource.getSlotId()) continue;
                    TaskCommUtil.updateResourceProgress(oAsnResourceProgress, oTempResource, oDeviceType, oTask);
                }
                String strOperationID = new String(oAsnResourceProgress.strCurrentOperationId);
                IsolationCommonOperation.fillResourceToIsolationBoardInfo(strOperationID, oResource, oTask);
                oTask.getTemporaryDevType().addResource(oResource);
            }
        }
    }

    public static void updateTaskModelFromAsnTask(AsnTaskInfo oAsnTaskInfo) {
        if (null == oAsnTaskInfo) {
            return;
        }
        ITaskDataModel oTaskDataModel = TaskDataModel.getInstance();
        AsnTaskCommonInfo oTaskCommonInfo = oAsnTaskInfo.oTaskCommonInfo;
        int iDevTypeId = oTaskCommonInfo.oAsnDevVersionInfo.iDeviceTypeID.intValue();
        DeviceTypeInfo[] oSupportedDevTypes = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfoByTypeID(iDevTypeId);
        if (null == oSupportedDevTypes || 0 >= oSupportedDevTypes.length) {
            return;
        }
        ITask oTask = oTaskDataModel.getTask(oTaskCommonInfo.iTaskId.intValue());
        if (null != oTask) {
            if (IsolationCommonOperation.isIsolationTask(oAsnTaskInfo.oTaskCommonInfo.enTaskType.value)) {
                AsnTaskInfoUtil.updateIsolationTaskFromAsnTask(oAsnTaskInfo, oTask);
            }
            return;
        }
        oTask = AsnTaskInfoUtil.populateTaskFromAsnTask(oAsnTaskInfo, 0);
        if (null == oTask) {
            return;
        }
        AsnTaskInfoUtil.updateDataOperation(oTask);
        ITaskGroup oTaskGroup = oTaskDataModel.getTaskGroupForTaskOperation(oTask.getTaskTypeId());
        if (null != oTaskGroup) {
            oTaskGroup.addTask(oTask);
        }
    }

    static void updateDataOperation(ITask oTaskObj) {
        String strTargetVersion = oTaskObj.getTargetVersion();
        if (null == strTargetVersion || 0 == strTargetVersion.length()) {
            List<ITaskDeviceOperation> oTaskDevOpLst = oTaskObj.getSupportedOperation();
            for (int i = 0; i < oTaskDevOpLst.size(); ++i) {
                ITaskDeviceOperation oTaskDevOp = oTaskDevOpLst.get(i);
                if (oTaskDevOp.getOperationId() != 5) continue;
                oTaskDevOp.setEnabled(false);
            }
        }
    }

    private static boolean populateDeviceTypeFromAsnResourceList(AsnTaskInfo oAsnTaskInfo, ITask oTask, boolean isUpdate) {
        AsnTaskResourceLst oAsnResourceList = oAsnTaskInfo.oTaskResourceLst;
        if (null == oAsnResourceList || 0 == oAsnResourceList.size()) {
            return false;
        }
        int iFirstDeviceID = ((AsnTaskResource)oAsnResourceList.get((int)0)).iDeviceId.intValue();
        DeviceType oDeviceType = null;
        oDeviceType = isUpdate ? oTask.getDeviceType() : DeviceModelAdapter.populateDeviceTypeFromDeviceID(iFirstDeviceID);
        if (null == oDeviceType) {
            DCDebugTracer.trace("DC::device is not found in task devid=" + iFirstDeviceID);
            return false;
        }
        AsnResourceProgressInfoLst oAsnResourceProgressList = oAsnTaskInfo.oAsnResourceProgressInfoLst;
        boolean isHaveProgress = false;
        if (null != oAsnResourceProgressList) {
            isHaveProgress = true;
        }
        boolean isPause = false;
        if (4 == oTask.getTaskProgressInfo().getState()) {
            isPause = true;
        }
        int iResourceCount = oAsnResourceList.size();
        ArrayList<Resource> oTmpResList = new ArrayList<Resource>(iResourceCount);
        THashSet<Resource> oResourceHashSet = oDeviceType.getResources();
        for (int i = 0; i < iResourceCount; ++i) {
            AsnTaskResource oTaskResource = (AsnTaskResource)oAsnResourceList.get(i);
            Resource oResource = DeviceModelAdapter.populateResourceFromDeviceID(oTaskResource.iDeviceId.intValue());
            if (null == oResource) continue;
            int iSlotId = TaskCommUtil.converBigIntToint(oTaskResource.iSlotId);
            oResource.setSlotId(iSlotId);
            int iFrameId = TaskCommUtil.converBigIntToint(oTaskResource.iFrameId);
            oResource.setFrameId(iFrameId);
            int iSubSlotId = TaskCommUtil.converBigIntToint(oTaskResource.iSubSlotId);
            oResource.setSubSlotId(iSubSlotId);
            int iStackId = TaskCommUtil.converBigIntToint(oTaskResource.iStackId);
            oResource.setStackId(iStackId);
            int iParentDeviceId = TaskCommUtil.converBigIntToint(oTaskResource.iParentDevId);
            oResource.setParentDevId(iParentDeviceId);
            if (null != oTaskResource.strSWversion) {
                oResource.setDeviceVersion(new String(oTaskResource.strSWversion));
            }
            if (null != oTaskResource.iDevTypeId && null != oTaskResource.iDevTypeVerId) {
                DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oTaskResource.iDevTypeId.intValue(), oTaskResource.iDevTypeVerId.intValue());
                oResource.setStackDevTypeInfo(oDevTypeInfo);
            }
            String sOriginalVer = null != oTaskResource.sOriginalVersion ? new String(oTaskResource.sOriginalVersion) : "";
            String sUpgradeVer = null != oTaskResource.sUpgradeVersion ? new String(oTaskResource.sUpgradeVersion) : "";
            int iUpMode = null != oTaskResource.iUpgradeMode ? oTaskResource.iUpgradeMode.intValue() : 0;
            int iUpConfigMode = null != oTaskResource.iUpgradeModeConfig ? oTaskResource.iUpgradeModeConfig.intValue() : 0;
            oResource.setOriginalVersion(sOriginalVer);
            oResource.setUpgradeVersion(sUpgradeVer);
            oResource.setUpgradeMode(iUpMode);
            oResource.setUpgradeModeConfig(iUpConfigMode);
            AsnTaskInfoUtil.fillSlotLabelToResources(oResource, oTask);
            if (null != oAsnResourceProgressList && isHaveProgress && i <= oAsnResourceProgressList.size() - 1) {
                AsnResourceProgressInfo oAsnResourceProgress = (AsnResourceProgressInfo)oAsnResourceProgressList.get(i);
                TaskCommUtil.updateResourceProgress(oAsnResourceProgress, oResource, oDeviceType, oTask);
            }
            if (isPause) {
                String strCurrentOpr = oResource.getProgressInfo().getCurrentOperationId();
                if (strCurrentOpr.equals("ActivateSoftware")) {
                    if (null != oAsnTaskInfo.oActivationGroupInfo && null != oAsnTaskInfo.oActivationGroupInfo.iCurrentGroup) {
                        oTask.getTaskProgressInfo().setPausedActivateGrpID(oAsnTaskInfo.oActivationGroupInfo.iCurrentGroup.intValue());
                        break;
                    }
                    oTask.getTaskProgressInfo().setPausedActivateGrpID(-1);
                } else {
                    oTask.getTaskProgressInfo().setPausedActivateGrpID(-1);
                }
            }
            if (null != oTaskResource.enBoardNum) {
                oResource.setMainBoardNum(oTaskResource.enBoardNum.value);
            }
            oResourceHashSet.add((Object)oResource);
            if (!isHaveProgress) continue;
            oTmpResList.add(oResource);
        }
        oTask.setDeviceType(oDeviceType);
        return true;
    }

    static void fillSlotLabelToResources(Resource oResource, ITask oTask) {
        ActiveInfo oActiveInfo = oTask.getActivationInfo();
        LoadSimPackageInfo oLoadSimPackageInfo = oTask.getLoadSimPackageInfo();
        if (oActiveInfo != null) {
            oResource.setSlotLabel(AsnTaskInfoUtil.getSlotLabelByActivaInfo(oActiveInfo, oResource));
        } else if (oLoadSimPackageInfo != null) {
            oResource.setSlotLabel(AsnTaskInfoUtil.getSlotLabeleByLoadSimPackageInfo(oLoadSimPackageInfo, oResource));
        }
    }

    private static String getSlotLabelByActivaInfo(ActiveInfo oActiveInfo, Resource oResource) {
        String m_strSlotLabel = "";
        Vector<ActiveGroupInfo> groupList = oActiveInfo.getGroupList();
        int groupCount = groupList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActiveGroupInfo groupInfo = groupList.get(i);
            Vector devList = groupInfo.getActivationInfoLst();
            int devCount = devList.size();
            for (int j = 0; j < devCount; ++j) {
                ActiveDevInfo devInfo = (ActiveDevInfo)devList.get(j);
                int devId = devInfo.getDevId();
                Vector boardList = devInfo.getBoardList();
                int boardCount = boardList.size();
                for (int z = 0; z < boardCount; ++z) {
                    ActiveBoardInfo boardInfo = (ActiveBoardInfo)boardList.get(z);
                    if (devId != oResource.getDeviceID() || boardInfo.getSlotId() != oResource.getSlotId()) continue;
                    m_strSlotLabel = boardInfo.getSlotLabel();
                    z = boardCount;
                    j = devCount;
                    i = groupCount;
                    return m_strSlotLabel;
                }
            }
        }
        return m_strSlotLabel;
    }

    private static String getSlotLabeleByLoadSimPackageInfo(LoadSimPackageInfo oLoadSimPackageInfo, Resource oResource) {
        String m_strSlotLabel = "";
        Vector devList = oLoadSimPackageInfo.getDevList();
        int devCount = devList.size();
        for (int i = 0; i < devCount; ++i) {
            LoadSimPackageDevInfo devInfo = (LoadSimPackageDevInfo)devList.get(i);
            int devId = devInfo.getDevId();
            Vector boardList = devInfo.getBoardList();
            int boardCount = boardList.size();
            for (int j = 0; j < boardCount; ++j) {
                LoadSimPackageBoardInfo boardInfo = (LoadSimPackageBoardInfo)boardList.get(j);
                if (devId != oResource.getDeviceID() || boardInfo.getSlotId() != oResource.getSlotId()) continue;
                m_strSlotLabel = boardInfo.getSlotLabel();
                j = boardCount;
                i = devCount;
                return m_strSlotLabel;
            }
        }
        return m_strSlotLabel;
    }

    private static void updateStartupConfigInfo(ITaskDeviceOperation oPrepareUpgradeOp, AsnStartupConfigOpInfo oAsnStartupConfigOpInfo) {
        List oUpgradeSubOprList = (List)oPrepareUpgradeOp.getConfiguredPara();
        int iSizeOfOprLst = oUpgradeSubOprList.size();
        IUpgradeSubOperation oSubOperation = null;
        StartupConfigParam oStartupConfigParam = null;
        for (int j = 0; j < iSizeOfOprLst; ++j) {
            oSubOperation = (IUpgradeSubOperation)oUpgradeSubOprList.get(j);
            if (!Collator.getInstance().equals(oSubOperation.getOperationIdString(), "StartupConfig")) continue;
            oStartupConfigParam = (StartupConfigParam)oSubOperation.getUpgradeSubOperationConfig();
            if (null == oStartupConfigParam) {
                oStartupConfigParam = new StartupConfigParam();
                oStartupConfigParam.setParaList(oSubOperation.getoPerationParaList());
                oSubOperation.setUpgradeSubOperationConfig(oStartupConfigParam);
            }
            if (1 == oAsnStartupConfigOpInfo.enStartupType.value) {
                oStartupConfigParam.setStartupType(2);
            } else if (2 == oAsnStartupConfigOpInfo.enStartupType.value) {
                oStartupConfigParam.setStartupType(3);
            } else {
                oStartupConfigParam.setStartupType(1);
            }
            oStartupConfigParam.setDeviceLoadFileInfoMap(AsnTaskInfoUtil.getDeviceFileMap(oAsnStartupConfigOpInfo.oLoadFileLst, oStartupConfigParam.getContentTypeList()));
            break;
        }
    }

    private static HashMap<Integer, List<LoadFileInfo>> getDeviceFileMap(AsnLoadFileLst oFileLst, Object[] oContentTypeArr) {
        if (null == oFileLst) {
            return null;
        }
        HashMap<Integer, List<LoadFileInfo>> oHashMap = new HashMap<Integer, List<LoadFileInfo>>(0);
        int iSize = oFileLst.size();
        AsnLoadFileInfo oAsnLoadFileInfo = null;
        List<LoadFileInfo> oLoadFileList = null;
        LoadFileInfo oLoadFileInfo = null;
        for (int i = 0; i < iSize; ++i) {
            oAsnLoadFileInfo = (AsnLoadFileInfo)oFileLst.get(i);
            if (null == oAsnLoadFileInfo.iDevId || null == oAsnLoadFileInfo.strFileName || null == oAsnLoadFileInfo.iContentType) continue;
            int iDevId = oAsnLoadFileInfo.iDevId.intValue();
            oLoadFileList = oHashMap.get(iDevId);
            if (null == oLoadFileList) {
                oLoadFileList = new ArrayList<LoadFileInfo>(0);
                oHashMap.put(iDevId, oLoadFileList);
            }
            oLoadFileInfo = new LoadFileInfo();
            oLoadFileInfo.setFileName(new String(oAsnLoadFileInfo.strFileName));
            oLoadFileInfo.setContentType(AsnTaskInfoUtil.getContentType(oAsnLoadFileInfo.iContentType.intValue(), oContentTypeArr));
            oLoadFileList.add(oLoadFileInfo);
        }
        return oHashMap;
    }

    private static ContentType getContentType(int iContentType, Object[] arrContentType) {
        ContentType oContentType = null;
        ContentType oTempContentType = null;
        for (int i = 0; i < arrContentType.length; ++i) {
            oTempContentType = (ContentType)arrContentType[i];
            if (iContentType != oTempContentType.getContentTypeCode()) continue;
            oContentType = oTempContentType;
            break;
        }
        return oContentType;
    }
}

