/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.view;

import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleProgressDlg
extends ProgressDlg {
    private static final long serialVersionUID = -6146727476181458410L;

    public SimpleProgressDlg(String reportName, String opeName) {
        super(reportName, opeName);
    }

    protected void initOpenFolderBtn() {
        String OPEN_FOLDER_ACTION = "openFolder";
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strCmd = e.getActionCommand();
                if ("openFolder".equals(strCmd)) {
                    int index = SimpleProgressDlg.this.m_oResultTable.getSelectedRow();
                    List taskFilePathNameLst = (List)SimpleProgressDlg.this.getUserObject();
                    if (null == taskFilePathNameLst || index < 0) {
                        return;
                    }
                    String sFilePath = (String)taskFilePathNameLst.get(index);
                    SimpleProgressDlg.this.openPath(sFilePath);
                }
            }
        };
        this.openFolderBtn = new JButton();
        String openFolder = ResourceManager.getInstance().getResString("GENERATE_TASK_REPORT_OPEN_FOLDER");
        String openText = ResourceManager.getInstance().getResString("GENERATE_TASK_REPORT_OPEN_BTN");
        this.openFolderBtn.setText(openText);
        this.openFolderBtn.setToolTipText(openFolder);
        this.openFolderBtn.addActionListener(listener);
        this.openFolderBtn.setMnemonic('O');
        this.openFolderBtn.setName("Components_ProgressDlg_openFolderBtn");
        this.openFolderBtn.setBounds(268, 50, 100, 21);
        this.openFolderBtn.setActionCommand("openFolder");
        this.openFolderBtn.setEnabled(false);
    }

    @Override
    protected void addComponentsToContainer() {
        this.getContentPane().add((Component)this.m_progressBar, null);
        this.getContentPane().add((Component)this.m_closeBtn, null);
        this.initOpenFolderBtn();
        this.getContentPane().add((Component)this.openFolderBtn, null);
        this.m_oResultTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.getContentPane().add((Component)this.m_oScrollPane, null);
    }

    private void changeButtonStatus() {
        if (null == this.openFolderBtn) {
            return;
        }
        int index = this.m_oResultTable.getSelectedRowCount();
        if (1 != index) {
            this.openFolderBtn.setEnabled(false);
        }
    }

    protected void openPath(String strPath) {
        String[] execString = new String[2];
        String filePath = null;
        if (StringUtils.isWinSystem()) {
            execString[0] = "explorer";
            try {
                filePath = strPath.replace("/", "\\");
            }
            catch (Exception ex) {
                DCDebugTracer.traceError(ex.getMessage());
                filePath = strPath;
            }
        } else {
            execString[0] = "netscape";
            filePath = strPath;
        }
        execString[1] = filePath;
        try {
            Runtime.getRuntime().exec(execString);
        }
        catch (Exception ex) {
            DCDebugTracer.traceError(ex.getMessage());
            return;
        }
    }

    @Override
    public void updateProgress(int iProgress) {
        ListSelectionModel oSelectionModel = this.m_oResultTable.getSelectionModel();
        int iSelectedRow = this.m_oResultTable.getRowCount() - 1;
        oSelectionModel.setSelectionInterval(iSelectedRow, iSelectedRow);
        super.updateProgress(iProgress);
        if (100 == iProgress) {
            this.openFolderBtn.setEnabled(true);
        } else {
            this.openFolderBtn.setEnabled(false);
        }
        this.changeButtonStatus();
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent arg) {
            if (arg.getValueIsAdjusting()) {
                SimpleProgressDlg.this.changeButtonStatus();
            }
        }
    }
}

