/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ReportProgressDlg;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.report.tasklevel.TaskReportCreater;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.view.TaskReportPanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TaskReportDlg
extends DCModalDialog
implements ActionListener {
    private static final long serialVersionUID = 3887043407309406435L;
    private static final String CANCEL_ACTION = "cancelAction";
    private static final String CONFIGURE_ACTION = "configure";
    private JButton configureBtn = null;
    private JPanel defConfBtnPanel = null;
    private ResourceManager m_resMgr = ResourceManager.getInstance();
    private ITask[] oITaskLst = null;
    private static final String OK_ACTION = "okAction";
    private JPanel okCancelPanel = null;
    private ReportProgressDlg progressDlg = null;
    private static final String RESTORE_ACTION = "restore";
    private JButton restoreDefaultBtn = null;
    private static final int ROWHIGHT = 21;
    private List<TaskReportFileInfo> taskReportFileInfoLst = null;
    private int m_iTotalDevCount = 0;
    private TaskReportPanel taskReportPanel = null;

    public TaskReportDlg(ITask[] oTaskLst, String dialogName) throws DCException {
        this.oITaskLst = oTaskLst;
        this.setLayout(new GridBagLayout());
        this.initDefaultConfigureButtonPanel();
        this.checkAllBtnstatus();
        this.add(this.defConfBtnPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(12, 12, 0, 8), 0, 0));
        this.fillTaskToReportInfoLst();
        this.taskReportPanel = new TaskReportPanel(this.taskReportFileInfoLst);
        this.add(this.taskReportPanel, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.7, 10, 1, new Insets(5, 12, 0, 12), 0, 0));
        this.initOkCancelButtonPanel();
        this.add(this.okCancelPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 15, 2, new Insets(5, 12, 12, 8), 0, 0));
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.setTitle(dialogName);
        this.setSize(800, 450);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String strCmd = e.getActionCommand();
        if (OK_ACTION.equalsIgnoreCase(strCmd)) {
            this.okActionPerformed();
        }
        if (CANCEL_ACTION.equalsIgnoreCase(strCmd)) {
            this.closeActionPerformed();
        }
        if (RESTORE_ACTION.equalsIgnoreCase(strCmd)) {
            this.taskReportPanel.restoreDefaultConfigure();
        }
    }

    private void checkAllBtnstatus() {
        if (null == this.configureBtn) {
            return;
        }
        int itaskCount = this.oITaskLst.length;
        if (itaskCount <= 1) {
            this.configureBtn.setEnabled(false);
        } else {
            this.configureBtn.setEnabled(true);
        }
    }

    public void closeActionPerformed() {
        this.closeDialog();
    }

    @Override
    public void closeDialog() {
        this.setToNull();
        this.dispose();
    }

    private void fillTaskToReportInfoLst() {
        if (this.oITaskLst == null || this.oITaskLst.length == 0) {
            return;
        }
        this.taskReportFileInfoLst = new Vector<TaskReportFileInfo>(this.oITaskLst.length);
        this.m_iTotalDevCount = 0;
        TaskReportFileInfo taskReportFileInfo = null;
        for (ITask task : this.oITaskLst) {
            if (null == task) continue;
            String taskName = task.getTaskName();
            int taskType = task.getTaskTypeId();
            String strTaskType = TaskCommUtil.converTaskTypeToStr(taskType);
            if (IsolationCommonOperation.isIsolationTask(taskType)) {
                strTaskType = strTaskType + "(" + ResourceManager.getInstance().getResString("ISOLATION_TASK_TYPE_POSTFIX") + ")";
            }
            String fileName = strTaskType + "_" + taskName + "_" + StringUtils.getStrNowTime("yyyyMMddHHmmss");
            fileName = FileUtil.getFileName(fileName);
            taskReportFileInfo = new TaskReportFileInfo(taskName, strTaskType, fileName);
            taskReportFileInfo.setSelect(true);
            taskReportFileInfo.setFilePath(TaskReportFileInfo.getDefaultFilePath());
            taskReportFileInfo.setFiletype(TaskReportFileInfo.getDefaultFileType());
            this.taskReportFileInfoLst.add(taskReportFileInfo);
            int iResCountInTask = task.getDeviceType().getResources().size();
            this.m_iTotalDevCount += iResCountInTask;
        }
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_TASK_VIEW_REPORT";
    }

    private void initCancelButton() {
        if (null == this.m_oCancelBtn) {
            this.m_oCancelBtn = new JButton();
        }
        this.m_oCancelBtn.setMaximumSize(new Dimension(90, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(90, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(90, 21));
        this.m_oCancelBtn.setText(this.m_resMgr.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oCancelBtn.setActionCommand(CANCEL_ACTION);
        this.m_oCancelBtn.addActionListener(this);
        this.m_oCancelBtn.setName("TaskReportDlg_m_oCancelBtn");
    }

    private void initConfigureBtn() {
        if (null == this.configureBtn) {
            this.configureBtn = new JButton();
        }
        this.configureBtn.setMaximumSize(new Dimension(200, 21));
        this.configureBtn.setMinimumSize(new Dimension(200, 21));
        this.configureBtn.setPreferredSize(new Dimension(200, 21));
        this.configureBtn.setText(this.m_resMgr.getResString("SAME_AS_FIRST_LINE_CONF_BTN"));
        this.configureBtn.setEnabled(true);
        this.configureBtn.setMnemonic('S');
        this.configureBtn.setActionCommand(CONFIGURE_ACTION);
        this.configureBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (0 != (0x10 & e.getModifiers())) {
                    TaskReportDlg.this.taskReportPanel.setTheSameAsTheFirstLine();
                }
            }
        });
        this.configureBtn.setName("TaskReportDlg_configureBtn");
    }

    private void initDefaultConfigureButtonPanel() {
        this.defConfBtnPanel = new JPanel();
        this.defConfBtnPanel.setPreferredSize(new Dimension(800, 33));
        this.defConfBtnPanel.setMinimumSize(new Dimension(800, 33));
        FlowLayout flowLayout = new FlowLayout(2);
        this.defConfBtnPanel.setLayout(flowLayout);
        this.initRestoreDefaultBtn();
        this.defConfBtnPanel.add(this.restoreDefaultBtn);
        this.initConfigureBtn();
        this.defConfBtnPanel.add(this.configureBtn);
    }

    private void initOkButton() {
        if (null == this.m_oOKBtn) {
            this.m_oOKBtn = new JButton();
        }
        this.m_oOKBtn.setMaximumSize(new Dimension(90, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(90, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(90, 21));
        this.m_oOKBtn.setText(this.m_resMgr.getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oOKBtn.setActionCommand(OK_ACTION);
        this.m_oOKBtn.addActionListener(this);
        this.m_oOKBtn.setName("TaskReportDlg_m_oOKBtn");
    }

    private void initOkCancelButtonPanel() {
        this.initOkButton();
        this.initCancelButton();
        this.okCancelPanel = new JPanel();
        this.okCancelPanel.setPreferredSize(new Dimension(800, 33));
        this.okCancelPanel.setMinimumSize(new Dimension(800, 33));
        this.okCancelPanel.setName("TaskReportDlg_okCancelPanel");
        FlowLayout flowLayout = new FlowLayout(2);
        this.okCancelPanel.setLayout(flowLayout);
        this.okCancelPanel.add(this.m_oOKBtn);
        this.okCancelPanel.add(this.m_oCancelBtn);
    }

    private void initRestoreDefaultBtn() {
        if (null == this.restoreDefaultBtn) {
            this.restoreDefaultBtn = new JButton();
        }
        this.restoreDefaultBtn.setMaximumSize(new Dimension(150, 21));
        this.restoreDefaultBtn.setMinimumSize(new Dimension(150, 21));
        this.restoreDefaultBtn.setPreferredSize(new Dimension(150, 21));
        this.restoreDefaultBtn.setText(this.m_resMgr.getResString("RESTORE_DEFAULT_BTN"));
        this.restoreDefaultBtn.setEnabled(true);
        this.restoreDefaultBtn.setMnemonic('R');
        this.restoreDefaultBtn.setActionCommand(RESTORE_ACTION);
        this.restoreDefaultBtn.addActionListener(this);
        this.restoreDefaultBtn.setName("TaskReportDlg_restoreDefaultBtn");
    }

    public void okActionPerformed() {
        DCDebugTracer.trace(this.getClass().getName() + " [task report] okActionPerformed start");
        boolean bHasError = this.taskReportPanel.validateDataSelection();
        if (bHasError) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] validateDataSelection error.");
            return;
        }
        int tReportSize = this.taskReportFileInfoLst.size();
        TaskReportData[] arrTaskReportData = new TaskReportData[tReportSize];
        ArrayList<TaskReportFileInfo> taskRepFlLstClone = new ArrayList<TaskReportFileInfo>(0);
        TaskReportFileInfo tReport = null;
        int j = 0;
        for (int i = 0; i < tReportSize; ++i) {
            tReport = this.taskReportFileInfoLst.get(i);
            if (!tReport.isSelect()) continue;
            arrTaskReportData[j] = new TaskReportData(this.oITaskLst[i], tReport);
            TaskReportFileInfo cloneFileInfo = (TaskReportFileInfo)CloneUtil.getClone(tReport);
            taskRepFlLstClone.add(cloneFileInfo);
            ++j;
        }
        final ArrayList<TaskReportData> taskReportDataLst = new ArrayList<TaskReportData>(0);
        for (TaskReportData tempTReportData : arrTaskReportData) {
            if (null == tempTReportData) continue;
            taskReportDataLst.add(tempTReportData);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskReportDlg.this.setVisible(false);
                TaskReportDlg.this.closeDialog();
            }
        });
        String reportName = this.m_resMgr.getResString("GENERATE_TASK_REPORT_REPORT_DEFAULT_NAME");
        String opeName = this.m_resMgr.getResString("OPERATION_RESOULT_SUTO_PROGRESS");
        String strTitle = this.getTitle();
        this.progressDlg = new ReportProgressDlg(reportName, opeName);
        DCHelpManager.getInstance().enableF1HelpKey(this.progressDlg.getContentPane(), this.getCurrentContext());
        this.progressDlg.setTitle(strTitle);
        this.progressDlg.setUserObject(taskRepFlLstClone);
        this.progressDlg.showDetailInfo();
        Thread reportThread = new Thread(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskReportDlg.this.progressDlg.setVisible(true);
                    }
                });
                TaskReportCreater taskReportCreater = new TaskReportCreater(taskReportDataLst, TaskReportDlg.this.m_iTotalDevCount, TaskReportDlg.this.progressDlg);
                taskReportCreater.createTasksReport();
            }
        };
        reportThread.setName("reportThread");
        reportThread.start();
        DCDebugTracer.trace(this.getClass().getName() + " [task report] okActionPerformed end..");
    }

    public void setToNull() {
        DCCleanupUtil.cleanupComponent(this.okCancelPanel);
        this.okCancelPanel = null;
        DCCleanupUtil.cleanupComponent(this.configureBtn);
        this.configureBtn = null;
        DCCleanupUtil.cleanupComponent(this.restoreDefaultBtn);
        this.restoreDefaultBtn = null;
        DCCleanupUtil.cleanupComponent(this.defConfBtnPanel);
        this.defConfBtnPanel = null;
        if (null != this.taskReportPanel) {
            this.taskReportPanel.setToNull();
        }
        this.taskReportPanel = null;
    }
}

