/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.util;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResult;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResultLst;
import com.huawei.dc.common.asndatacenter.AsnTaskResultRsp;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ContentConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckOperationConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckType;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDetailBean;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.ReportDataHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UpgradeInfoHelper {
    private int successResCount = 0;
    private int totalResCount = 0;
    private Calendar startTime;
    private Calendar endTime;
    private int failResCount = 0;
    private Resource[] resLst = null;
    private IDeviceInfoManager devInfoImpl;
    private AsnTaskResultRsp asnTaskResultRsp;
    private List<ITaskDeviceOperation> selectOPerLst = null;
    private ITask taskInfo;
    private boolean isDeleteDBTask = false;
    private boolean isRecoverDBTask = false;

    public UpgradeInfoHelper(ITask taskInfo) throws DCException {
        this.taskInfo = taskInfo;
        this.devInfoImpl = DeviceInfoManagerImpl.getInstance();
    }

    public void prepareData() throws DCException {
        this.initSelectTaskSetpLst();
        this.getTaskResultData();
        this.fillTaskResultRspToResLst();
    }

    private void getTaskResultData() throws DCException {
        this.asnTaskResultRsp = new AsnTaskResultRsp();
        ReportDataHelper.getInstance().prepareData(this.taskInfo, this.asnTaskResultRsp);
    }

    private void fillTaskResultRspToResLst() {
        AsnTaskDevResultLst asnTaskResultLst = this.asnTaskResultRsp.oTaskDevResultLst;
        this.totalResCount = asnTaskResultLst.size();
        this.resLst = new Resource[this.totalResCount];
        int iPauseResCount = 0;
        boolean isFailed = false;
        boolean isPause = false;
        int iErrorNum = 0;
        int iOprCount = 0;
        String strErrMsg = null;
        String strOprName = null;
        for (int i = 0; i < this.totalResCount; ++i) {
            AsnTaskDevResult asnDevResult = (AsnTaskDevResult)asnTaskResultLst.get(i);
            this.resLst[i] = new Resource();
            this.fillResBasicInfo(i, asnDevResult);
            this.setResourceUpgradeVersion(this.resLst[i]);
            AsnTaskDevOpInfoLst asnOprInfoLst = asnDevResult.oTaskDevOpInfoLst;
            iOprCount = asnOprInfoLst.size();
            isFailed = false;
            isPause = false;
            boolean isOther = false;
            ResourceProgressInfo resInfo = null;
            for (int j = iOprCount - 1; j >= 0; --j) {
                AsnTaskDevOpInfo asnOprInfo = (AsnTaskDevOpInfo)asnOprInfoLst.get(j);
                resInfo = new ResourceProgressInfo();
                resInfo.setCurrentOperationId(new String(asnOprInfo.strOpId));
                if (null != asnOprInfo.enOpStatus) {
                    resInfo.setState(asnOprInfo.enOpStatus.value);
                }
                if (null != asnOprInfo.enOpResult) {
                    resInfo.setResult(asnOprInfo.enOpResult.value);
                    if (1 == asnOprInfo.enOpResult.value) {
                        if (!(isPause || isFailed || isOther)) {
                            isFailed = true;
                        }
                    } else if (2 == asnOprInfo.enOpResult.value) {
                        if (!(isPause || isFailed || isOther)) {
                            isPause = true;
                        }
                    } else {
                        isOther = true;
                    }
                }
                strOprName = TaskCommUtil.getDisplayNameForOperation(this.taskInfo.getSelectedDeviceType(), resInfo.getCurrentOperationId());
                resInfo.setCurrentOperationName(strOprName);
                if (null != asnOprInfo.stErrorInfo.strResult) {
                    strErrMsg = new String(asnOprInfo.stErrorInfo.strResult);
                }
                if (0 == resInfo.getResult()) {
                    iErrorNum = 0;
                    if (StringUtils.isNullOrEmptyStr(strErrMsg) && null != asnOprInfo.stErrorInfo.iErrorNo && 0 != asnOprInfo.stErrorInfo.iErrorNo.intValue()) {
                        strErrMsg = ErrorCodeReader.getInstance().getErrorDesc(asnOprInfo.stErrorInfo.iErrorNo);
                    }
                } else {
                    iErrorNum = asnOprInfo.stErrorInfo.iErrorNo.intValue();
                }
                resInfo.setErrorInfo(iErrorNum, strErrMsg);
                resInfo.setFailureReason(new String(asnOprInfo.stErrorInfo.strResult));
                resInfo.setStartTime(asnOprInfo.oOprStartTime);
                resInfo.setStrStartTime(StringUtils.convertTimeToString(asnOprInfo.oOprStartTime));
                resInfo.setEndTime(asnOprInfo.oOprEndTime);
                resInfo.setStrEndTime(StringUtils.convertTimeToString(asnOprInfo.oOprEndTime));
                this.resLst[i].addOprResultInfo(resInfo.getCurrentOperationId(), resInfo);
            }
            if (isFailed) {
                this.resLst[i].setUpgradeResult(1);
                ++this.failResCount;
            }
            if (!isPause) continue;
            this.resLst[i].setUpgradeResult(2);
            ++iPauseResCount;
        }
        this.successResCount = this.totalResCount - this.failResCount - iPauseResCount;
        this.startTime = this.asnTaskResultRsp.oTaskStartTime;
        this.endTime = this.asnTaskResultRsp.oTaskEndTime;
    }

    private void setResourceUpgradeVersion(Resource res) {
        if (null == res) {
            return;
        }
        int iDeviceID = res.getDeviceID();
        String originalVersion = "";
        String sDestVession = "";
        DeviceType deviceType = this.taskInfo.getDeviceType();
        Resource tempRes = deviceType.getResource(iDeviceID);
        if (null != tempRes) {
            originalVersion = tempRes.getDeviceVersion();
            sDestVession = tempRes.getUpgradeVersion();
        }
        res.setOriginalVersion(originalVersion);
        res.setUpgradeVersion(sDestVession);
    }

    private void fillResBasicInfo(int index, AsnTaskDevResult asnDevResult) {
        int iDevID = asnDevResult.oResourceInfo.iDeviceId.intValue();
        this.resLst[index].setDeviceID(iDevID);
        DeviceInfo devInfo = this.devInfoImpl.getDevice(iDevID);
        this.resLst[index].setDeviceName(devInfo.getDevName());
        this.resLst[index].setDeviceIP(devInfo.getDevIPAddress());
        DeviceTypeInfo deviceTypeInfo = devInfo.getDeviceTypeInfo();
        if (null != deviceTypeInfo) {
            this.resLst[index].setDevTypeId(deviceTypeInfo.getDevTypeID());
        }
        if (null != asnDevResult.oResourceInfo.iFrameId) {
            this.resLst[index].setFrameId(asnDevResult.oResourceInfo.iFrameId.intValue());
        }
        if (null != asnDevResult.oResourceInfo.iSlotId) {
            this.resLst[index].setSlotId(asnDevResult.oResourceInfo.iSlotId.intValue());
        }
        if (null != asnDevResult.oResourceInfo.iSubSlotId) {
            this.resLst[index].setSubSlotId(asnDevResult.oResourceInfo.iSubSlotId.intValue());
        }
    }

    private void initSelectTaskSetpLst() {
        List<ITaskDeviceOperation> devOprList = this.taskInfo.getSupportedOperation();
        int iAllTaskStep = devOprList.size();
        this.selectOPerLst = new ArrayList<ITaskDeviceOperation>(0);
        for (int i = 0; i < iAllTaskStep; ++i) {
            ITaskDeviceOperation devOpr = devOprList.get(i);
            if (null == devOpr || !devOpr.isSelected()) continue;
            this.selectOPerLst.add(devOpr);
        }
    }

    public Map<String, List<TaskReportDetailBean>> getTaskStepInfo(Resource resource) {
        HashMap<String, List<TaskReportDetailBean>> allStepInfoMap = new HashMap<String, List<TaskReportDetailBean>>();
        if (null == resource) {
            return allStepInfoMap;
        }
        int iOprCount = this.selectOPerLst.size();
        int iTaskTypeId = this.taskInfo.getTaskTypeId();
        Object oprParaObj = null;
        for (int i = 0; i < iOprCount; ++i) {
            ITaskDeviceOperation devOpr = this.selectOPerLst.get(i);
            oprParaObj = new Object();
            oprParaObj = this.getStepParam(iTaskTypeId, devOpr, resource);
            List<TaskReportDetailBean> oneStepInfoVec = this.getOneStepInfo(devOpr, resource, oprParaObj);
            allStepInfoMap.put(devOpr.getOperationIdString(), oneStepInfoVec);
        }
        return allStepInfoMap;
    }

    private Object getStepParam(int iTaskTypeId, ITaskDeviceOperation devOpr, Resource resource) {
        boolean isActivateOprInDeleteDB;
        boolean isUpgradeOperation;
        Vector oprParaObj = new Vector();
        int operationId = devOpr.getOperationId();
        boolean isCheckOpe = 4 == operationId || 16 == operationId;
        boolean isSaveOrBacup = 1 == operationId || 2 == operationId;
        boolean isAcvite = 8 == operationId && this.isHaveActiveInfo(iTaskTypeId);
        boolean isIssuOrFeasibility = 28 == operationId || 29 == operationId;
        boolean bl = isUpgradeOperation = 32 == operationId || 33 == operationId;
        if (!this.isRecoverDBTask) {
            boolean bl2 = this.isRecoverDBTask = 13 == iTaskTypeId && 3 == operationId;
        }
        if (!this.isDeleteDBTask) {
            this.isDeleteDBTask = 13 == iTaskTypeId && 30 == operationId;
        }
        boolean isActivateOprInRecoverDB = this.isRecoverDBTask && 13 == iTaskTypeId && 8 == operationId;
        boolean bl3 = isActivateOprInDeleteDB = this.isDeleteDBTask && 13 == iTaskTypeId && 8 == operationId;
        if (isIssuOrFeasibility) {
            oprParaObj = new Vector(0);
        } else if (isCheckOpe) {
            oprParaObj = this.getCheckTypeInfo(devOpr.getConfiguredPara());
        } else if (isSaveOrBacup) {
            oprParaObj = this.getContentConfigInfo(devOpr.getConfiguredPara());
        } else if (6 == operationId || 9 == operationId) {
            oprParaObj = this.getLoadFilesInfo(devOpr.getConfiguredPara());
        } else if (7 == operationId) {
            oprParaObj = this.getDataFilesInfo(devOpr.getConfiguredPara());
        } else if (isAcvite) {
            oprParaObj = this.getActivationInfo(devOpr.getConfiguredPara());
        } else if (isUpgradeOperation) {
            oprParaObj = this.getUpgradeInfo(devOpr.getConfiguredPara());
        } else if (isActivateOprInRecoverDB) {
            oprParaObj = this.getActivateInfoForRecoverDB(devOpr.getConfiguredPara());
            this.isRecoverDBTask = false;
        } else if (this.isRecoverDBTask) {
            oprParaObj = this.getRecoverInfo(devOpr.getConfiguredPara(), resource);
        } else if (isActivateOprInDeleteDB) {
            oprParaObj = this.getActivateInfoForDeleteDB(devOpr.getConfiguredPara());
            this.isDeleteDBTask = false;
        } else {
            oprParaObj = new Vector(0);
        }
        return oprParaObj;
    }

    private Object getActivateInfoForDeleteDB(Object oOprPara) {
        Vector<String[]> oSubOprVec = new Vector<String[]>(0);
        if (null == oOprPara) {
            return oSubOprVec;
        }
        ActivationConfigPara activationConfigPara = (ActivationConfigPara)oOprPara;
        String strConfSendToBoardRst = ResourceManager.getInstance().getResString("FALSE");
        boolean bIsConfSendToBoard = activationConfigPara.isConfSendToBoard();
        if (bIsConfSendToBoard) {
            strConfSendToBoardRst = ResourceManager.getInstance().getResString("TRUE");
        }
        String[] strConfSendToBoard = new String[]{ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT"), strConfSendToBoardRst};
        oSubOprVec.add(strConfSendToBoard);
        String strActiveType = activationConfigPara.getoActivationType();
        boolean bIsForceParallelActive = strActiveType.equals("OSSU");
        String strForceParallelActiveRst = ResourceManager.getInstance().getResString("FALSE");
        if (bIsForceParallelActive) {
            strForceParallelActiveRst = ResourceManager.getInstance().getResString("TRUE");
        }
        String[] strForceParallelActive = new String[]{ResourceManager.getInstance().getResString("FORCE_PARALLEL_ACTIVE_CHK"), strForceParallelActiveRst};
        oSubOprVec.add(strForceParallelActive);
        return oSubOprVec;
    }

    private Object getActivateInfoForRecoverDB(Object oOprPara) {
        Vector<String[]> oSubOprVec = new Vector<String[]>(0);
        if (null == oOprPara) {
            return oSubOprVec;
        }
        ActivationConfigPara activationConfigPara = (ActivationConfigPara)oOprPara;
        String strActiveType = activationConfigPara.getoActivationType();
        boolean bIsForceParallelActive = strActiveType.equals("OSSU");
        String strForceParallelActiveRst = ResourceManager.getInstance().getResString("FALSE");
        if (bIsForceParallelActive) {
            strForceParallelActiveRst = ResourceManager.getInstance().getResString("TRUE");
        }
        String[] strForceParallelActive = new String[]{ResourceManager.getInstance().getResString("FORCE_PARALLEL_ACTIVE_CHK"), strForceParallelActiveRst};
        oSubOprVec.add(strForceParallelActive);
        return oSubOprVec;
    }

    private Object getRecoverInfo(Object oOprPara, Resource resource) {
        Vector<String[]> oSubOprVec = new Vector<String[]>(0);
        if (null == oOprPara) {
            return oSubOprVec;
        }
        RecoverDBConfigPara oRecoverDBConfigPara = (RecoverDBConfigPara)oOprPara;
        String strFileNameLab = TaskReportConstant.TASK_REPORT_FILE_NAME;
        boolean bIsConfSendToBoard = false;
        List<RecoverElementInfo> oRecoverElementInfolst = oRecoverDBConfigPara.getRecoverElementInfoLst();
        RecoverElementInfo oRecoverElementInfo = null;
        for (int i = 0; i < oRecoverElementInfolst.size(); ++i) {
            oRecoverElementInfo = oRecoverElementInfolst.get(i);
            bIsConfSendToBoard = oRecoverElementInfo.isDeliverToBoard();
            String[] fileName = new String[]{strFileNameLab, oRecoverElementInfo.getRecoverFilePath(), String.valueOf(oRecoverElementInfo.getResource().getDeviceID())};
            oSubOprVec.add(fileName);
            String strConfSendToBoardRst = ResourceManager.getInstance().getResString("FALSE");
            if (bIsConfSendToBoard) {
                strConfSendToBoardRst = ResourceManager.getInstance().getResString("TRUE");
            }
            String[] strConfSendToBoard = new String[]{ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT"), strConfSendToBoardRst, String.valueOf(oRecoverElementInfo.getResource().getDeviceID())};
            oSubOprVec.add(strConfSendToBoard);
        }
        return oSubOprVec;
    }

    private Object getUpgradeInfo(Object oOprPara) {
        Vector<String[]> oSubOprVec = new Vector<String[]>(0);
        if (null == oOprPara) {
            return oSubOprVec;
        }
        List oSubOperationList = (List)oOprPara;
        int iSize = oSubOperationList.size();
        String strSubOperation = TaskReportConstant.TASK_REPORT_TABLE_UPGARDE_SUB_OPERATION;
        int iSubOprNum = 0;
        String[] arrSubOprInfo = null;
        for (int i = 0; i < iSize; ++i) {
            IUpgradeSubOperation oUpgradeSubOperation = (IUpgradeSubOperation)oSubOperationList.get(i);
            if (null == oUpgradeSubOperation || !oUpgradeSubOperation.isSelected()) continue;
            arrSubOprInfo = new String[]{strSubOperation + " " + ++iSubOprNum, oUpgradeSubOperation.getOperationName()};
            oSubOprVec.add(arrSubOprInfo);
        }
        return oSubOprVec;
    }

    private boolean isHaveActiveInfo(int iTaskTypeId) {
        boolean isHaveActiveInfo = iTaskTypeId == 3 || iTaskTypeId == 5 && this.taskInfo.getUpgradeLevel() == 2;
        return isHaveActiveInfo;
    }

    private List getCheckTypeInfo(Object oOprPara) {
        Vector<String[]> checkTypeVec = new Vector<String[]>(0);
        if (oOprPara == null) {
            return checkTypeVec;
        }
        if (!(oOprPara instanceof ICheckOperationConfigParam)) {
            return checkTypeVec;
        }
        ICheckOperationConfigParam checkConfigPara = (ICheckOperationConfigParam)oOprPara;
        int iCheckTypeCount = checkConfigPara.getNumOfCheckType();
        String strCheckType = TaskReportConstant.TASK_REPORT_TABLE_CHECK_TYPE;
        int iCheckTypeNum = 0;
        String[] checkTypeInfo = null;
        for (int i = 0; i < iCheckTypeCount; ++i) {
            ICheckType checkType = checkConfigPara.getCheckType(i);
            if (null == checkType || !checkType.isSelected()) continue;
            checkTypeInfo = new String[]{strCheckType + " " + ++iCheckTypeNum, checkType.getDisplayName()};
            checkTypeVec.add(checkTypeInfo);
        }
        return checkTypeVec;
    }

    private List<String[]> getContentConfigInfo(Object oOprPara) {
        Vector<String[]> contentTypeVec = new Vector<String[]>();
        if (!(oOprPara instanceof ContentConfigParam)) {
            return contentTypeVec;
        }
        ContentConfigParam contentPara = (ContentConfigParam)oOprPara;
        List<ContentType> contentTypelst = contentPara.getSelectedContentType();
        for (ContentType contentType : contentTypelst) {
            if (contentType == null) continue;
            String[] contentTypeInfo = null;
            if (!contentPara.isContentTypeRequired()) continue;
            contentTypeInfo = new String[]{TaskReportConstant.TASK_REPORT_CONTENT_TYPE, contentType.getStrContentType()};
            contentTypeVec.add(contentTypeInfo);
        }
        return contentTypeVec;
    }

    private Map<String, List<String[]>> getDataFilesInfo(Object oOprPara) {
        HashMap<String, List<String[]>> loadFilesMap = new HashMap<String, List<String[]>>();
        if (!(oOprPara instanceof LoadFileInfoListParam)) {
            return loadFilesMap;
        }
        LoadFileInfoListParam loadFilesInfo = (LoadFileInfoListParam)oOprPara;
        List<LoadFileInfo> loadFileLst = loadFilesInfo.getLoadFileInfoList();
        String strFileNameLab = TaskReportConstant.TASK_REPORT_FILE_NAME;
        String strContentTypeLab = TaskReportConstant.TASK_REPORT_CONTENT_TYPE;
        String strSeqNoLab = TaskReportConstant.TASK_REPORT_SEQUENCE_NO;
        int iFileCount = loadFileLst.size();
        LoadFileInfo tmpLoadFileInfo = null;
        Vector<String[]> loadFilesVec = null;
        String devId = null;
        for (int i = 0; i < iFileCount; ++i) {
            loadFilesVec = new Vector<String[]>();
            tmpLoadFileInfo = loadFilesInfo.getLoadFileInfo(i);
            devId = String.valueOf(tmpLoadFileInfo.getDeviceId());
            String[] fileName = new String[]{strFileNameLab, tmpLoadFileInfo.getFileName(), devId};
            loadFilesVec.add(fileName);
            String[] contentType = new String[]{strContentTypeLab, tmpLoadFileInfo.getContentType().toString(), devId};
            loadFilesVec.add(contentType);
            String[] seqNo = new String[]{strSeqNoLab, tmpLoadFileInfo.getSequenceNo() + "", devId};
            loadFilesVec.add(seqNo);
            String strDevId = String.valueOf(tmpLoadFileInfo.getDeviceId());
            if (loadFilesMap.containsKey(strDevId)) {
                List tmpVec = (List)loadFilesMap.get(strDevId);
                tmpVec.addAll(loadFilesVec);
            } else {
                loadFilesMap.put(strDevId, loadFilesVec);
            }
            loadFilesVec = null;
        }
        return loadFilesMap;
    }

    private Map getActivationInfo(Object oOprPara) {
        ParaValue activationMode;
        HashMap activationParaMap = new HashMap();
        Vector<String[]> activationParaVec = new Vector<String[]>();
        if (!(oOprPara instanceof ActivationConfigPara)) {
            return activationParaMap;
        }
        ActivationConfigPara activationConfigPara = (ActivationConfigPara)oOprPara;
        if (activationConfigPara.isActivationTimeRequired() && null != activationConfigPara.getActivationUTCTime()) {
            String[] activeTime = new String[]{TaskReportConstant.TASK_REPORT_ACTIVATE_TIME, DCTimeDateUtil.getLocaleDisplayTime(activationConfigPara.getActivationUTCTime())};
            activationParaVec.add(activeTime);
        }
        if (activationConfigPara.isActivationTypeRequired() && null != activationConfigPara.getSelectedActivateType()) {
            String[] activationType = new String[]{TaskReportConstant.TASK_REPORT_ACTIVATION_TYPE, activationConfigPara.getSelectedActivateType().toString()};
            activationParaVec.add(activationType);
        }
        if (null != (activationMode = activationConfigPara.getSelectedActivationMode())) {
            String[] activationModeName = new String[]{TaskReportConstant.TASK_REPORT_ACTIVATION_MODE, activationMode.getDisplayName()};
            activationParaVec.add(activationModeName);
        }
        List elementInfoLst = activationConfigPara.getElementInfoLst();
        int iElementCount = elementInfoLst.size();
        Vector<String[]> groupNameVec = null;
        for (int i = 0; i < iElementCount; ++i) {
            String strDevId;
            groupNameVec = new Vector<String[]>();
            groupNameVec.addAll(activationParaVec);
            ActivationElementInfo oElementInfo = null;
            oElementInfo = (ActivationElementInfo)elementInfoLst.get(i);
            if (activationConfigPara.getSelectedActivationMode().getId().equals("GroupActivation")) {
                ActivationGroupInfo activationGroupInfo = activationConfigPara.getGroupForId(oElementInfo.getGroupId());
                String[] groupName = new String[]{TaskReportConstant.TASK_REPORT_TABLE_GROUP_NAME, activationGroupInfo.getGroupName()};
                groupNameVec.add(groupName);
            }
            if (activationParaMap.containsKey(strDevId = String.valueOf(oElementInfo.getResource().getDeviceID()))) {
                Vector tmpVec = (Vector)activationParaMap.get(strDevId);
                tmpVec.addAll(groupNameVec);
            } else {
                activationParaMap.put(strDevId, groupNameVec);
            }
            groupNameVec = null;
        }
        return activationParaMap;
    }

    private List<String[]> getLoadFilesInfo(Object oOprPara) {
        Vector<String[]> loadFilesVec = new Vector<String[]>();
        if (!(oOprPara instanceof LoadFileInfoListParam)) {
            return loadFilesVec;
        }
        LoadFileInfoListParam loadFilesInfo = (LoadFileInfoListParam)oOprPara;
        List<LoadFileInfo> loadFileLst = loadFilesInfo.getLoadFileInfoList();
        String strFileNameLab = TaskReportConstant.TASK_REPORT_FILE_NAME;
        String strContentTypeLab = TaskReportConstant.TASK_REPORT_CONTENT_TYPE;
        String strSeqNoLab = TaskReportConstant.TASK_REPORT_SEQUENCE_NO;
        LoadFileInfo oPacketTool = loadFilesInfo.getPacketTool();
        if (null != oPacketTool) {
            String strPacketToolLab = TaskReportConstant.PACKET_TOOL_LABEL;
            String[] arrPacketToolInfo = new String[]{strPacketToolLab, oPacketTool.getFileName()};
            loadFilesVec.add(arrPacketToolInfo);
        }
        int iFileCount = loadFileLst.size();
        String devId = null;
        for (int i = 0; i < iFileCount; ++i) {
            String[] contentType;
            LoadFileInfo tmpLoadFileInfo = loadFilesInfo.getLoadFileInfo(i);
            devId = String.valueOf(tmpLoadFileInfo.getDeviceId());
            if (DCConstants.PACKET_TOOL_CONTENT_TYPE.equals(tmpLoadFileInfo.getContentType())) continue;
            String[] fileName = new String[]{strFileNameLab, tmpLoadFileInfo.getFileName(), devId};
            loadFilesVec.add(fileName);
            if (null != tmpLoadFileInfo.getContentType()) {
                contentType = new String[]{strContentTypeLab, tmpLoadFileInfo.getContentType().toString(), devId};
                loadFilesVec.add(contentType);
            } else if (4 == this.taskInfo.getDeviceType().getDeviceDomain()) {
                contentType = new String[]{strContentTypeLab, DCFrameWorkUtil.getLocalizedString("PACKAGE_FILE"), devId};
                loadFilesVec.add(contentType);
            } else {
                contentType = new String[]{strContentTypeLab, "", devId};
                loadFilesVec.add(contentType);
            }
            if (4 == this.taskInfo.getDeviceType().getDeviceDomain()) continue;
            String[] seqNo = new String[]{strSeqNoLab, tmpLoadFileInfo.getSequenceNo() + "", devId};
            loadFilesVec.add(seqNo);
        }
        return loadFilesVec;
    }

    private List<TaskReportDetailBean> getOneStepInfo(ITaskDeviceOperation devOpr, Resource res, Object oprParaObj) {
        Vector<TaskReportDetailBean> dataVec = new Vector<TaskReportDetailBean>();
        ResourceProgressInfo resProInfo = res.getOprResultInfo(devOpr.getOperationIdString());
        if (null == resProInfo) {
            return dataVec;
        }
        Vector oprParaVec = null;
        if (oprParaObj instanceof Vector) {
            oprParaVec = (Vector)oprParaObj;
        } else if (oprParaObj instanceof HashMap) {
            oprParaVec = (Vector)((HashMap)oprParaObj).get(String.valueOf(res.getDeviceID()));
        }
        if (null == oprParaVec) {
            return dataVec;
        }
        TaskReportDetailBean taskReportDetailBean = null;
        for (int j = -1; j < oprParaVec.size(); ++j) {
            taskReportDetailBean = new TaskReportDetailBean();
            if (j < 0) {
                taskReportDetailBean.setOOperationName(resProInfo.getCurrentOperationName());
                taskReportDetailBean.setOIsPause(devOpr.isPauseBeforeCurOp());
                taskReportDetailBean.setODependOn(this.getDepandStr(devOpr));
            } else {
                String[] strConfigInfo = (String[])oprParaVec.get(j);
                taskReportDetailBean.setOConfItem(strConfigInfo[0]);
                taskReportDetailBean.setOConfValue(strConfigInfo[1]);
                if (TaskReportConstant.TASK_REPORT_FILE_NAME.equals(strConfigInfo[0])) {
                    String strFileName = strConfigInfo[1];
                    if (devOpr instanceof LoadPatchOperation) {
                        LoadFileInfoListParam oLoadFilesConfigured = (LoadFileInfoListParam)devOpr.getConfiguredPara();
                        List<LoadFileInfo> oFileInfos = oLoadFilesConfigured.getLoadFileInfoList();
                        for (LoadFileInfo oFileInfo : oFileInfos) {
                            if (!strFileName.equals(oFileInfo.getFileName())) continue;
                            taskReportDetailBean.setOStartTime(oFileInfo.getStrStartTime());
                            taskReportDetailBean.setOEndTime(oFileInfo.getStrEndTime());
                            taskReportDetailBean.setOResult(oFileInfo.getErrMsg());
                            break;
                        }
                    }
                }
                if (strConfigInfo.length == 3) {
                    taskReportDetailBean.setDevId(strConfigInfo[2]);
                }
            }
            dataVec.add(taskReportDetailBean);
        }
        return dataVec;
    }

    private String getDepandStr(ITaskDeviceOperation devOpr) {
        List<Integer> dependOnOprLst = devOpr.getDependentOperation();
        if (null == dependOnOprLst) {
            if (devOpr.getDependsOnOperation() != -1) {
                return this.getOpreationName(devOpr.getDependsOnOperation(), this.taskInfo.getSelectedDeviceType());
            }
            return "";
        }
        StringBuffer sbDependOnOprs = new StringBuffer("");
        int idevOprId = 0;
        DeviceType tmpDevType = null;
        for (int n = 0; n < dependOnOprLst.size(); ++n) {
            idevOprId = dependOnOprLst.get(n);
            tmpDevType = this.taskInfo.getSelectedDeviceType();
            if (n == 0) {
                sbDependOnOprs.append(this.getOpreationName(idevOprId, tmpDevType));
                continue;
            }
            sbDependOnOprs.append("; ");
            sbDependOnOprs.append(this.getOpreationName(idevOprId, tmpDevType));
        }
        return sbDependOnOprs.toString();
    }

    private String getOpreationName(int iOprId, DeviceType devType) {
        IOperation oOperation;
        IDeviceTypeConfigModel oDevTypeModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(devType);
        if (null != oDevTypeModel && null != (oOperation = oDevTypeModel.getOperationObj(1, iOprId))) {
            return oOperation.getOperationName();
        }
        return "";
    }

    public int getSuccessResCount() {
        return this.successResCount;
    }

    public int getTotalResCount() {
        return this.totalResCount;
    }

    public int getFailResCount() {
        return this.failResCount;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public Resource[] getResLst() {
        return this.resLst;
    }

    public List<ITaskDeviceOperation> getSelectOPerLst() {
        return this.selectOPerLst;
    }

    private List<String> getSelOpeLst() {
        ArrayList<String> selOpeLst = new ArrayList<String>();
        List<ITaskDeviceOperation> oSuppOpLst = this.taskInfo.getSupportedOperation();
        int iRows = oSuppOpLst.size();
        ITaskDeviceOperation oTaskOp = null;
        for (int i = 0; i < iRows; ++i) {
            oTaskOp = oSuppOpLst.get(i);
            if (null == oTaskOp || !oTaskOp.isSelected()) continue;
            selOpeLst.add(oTaskOp.getOperationIdString());
        }
        return selOpeLst;
    }

    public String getUpgradeTimeInfo(Resource res) {
        if (null == res) {
            return "";
        }
        List<String> selOpeLst = this.getSelOpeLst();
        if (selOpeLst.isEmpty()) {
            return "";
        }
        boolean FIRST_OPERATION_INDEX = false;
        ResourceProgressInfo opePro = res.getOprResultInfo(selOpeLst.get(0));
        Calendar calStartTime = opePro.getStartTime();
        StringBuilder timeInfo = new StringBuilder();
        timeInfo.append(opePro.getStrStartTime());
        timeInfo.append("~");
        int LAST_OPERATION_INDEX = selOpeLst.size() - 1;
        opePro = res.getOprResultInfo(selOpeLst.get(LAST_OPERATION_INDEX));
        Calendar calEndTime = opePro.getEndTime();
        timeInfo.append(opePro.getStrEndTime());
        timeInfo.append("(");
        timeInfo.append(StringUtils.subDateStr(calStartTime, calEndTime));
        timeInfo.append(")");
        return timeInfo.toString();
    }

    public String getUpgradeResult(Resource res) {
        String strSesult = "";
        strSesult = res.isUpgradeFail() ? TaskReportConstant.TASK_REPORT_UPGRADE_FAILED : TaskReportConstant.TASK_REPORT_UPGRADE_SUCCESS;
        return strSesult;
    }

    public String getCompareResult(int status) {
        boolean FAIL = false;
        boolean SUCCESS = true;
        int NO_NEED = 2;
        String strSesult = "";
        if (0 == status) {
            strSesult = ResourceManager.getInstance().getResString("COMPARE_FAIL");
        } else if (1 == status) {
            strSesult = ResourceManager.getInstance().getResString("COMPARE_SUCCESS");
        } else if (2 == status) {
            strSesult = ResourceManager.getInstance().getResString("NO_NEED_COMPARE");
        }
        return strSesult;
    }

    public static String convertEmptyToUnSupportFlag(String str) {
        if (null == str) {
            return "";
        }
        if ("".equals(str.trim()) || "-".equals(str.trim())) {
            return " --";
        }
        if (str.length() > 16384) {
            return str.substring(0, 16381) + "...";
        }
        return str;
    }
}

