/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.util;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDevBoardInfoList;
import com.huawei.dc.common.asndatacenter.AsnTaskReportBoardDetailInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportNotifier;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ICheckReportNotificationListener;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ReportNotificationEvent;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeader;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeaderElement;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportDevInfoMap;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDetailBean;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDevType;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.util.ReportDataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import gnu.trove.THashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class T2000DataHelper
implements ICheckReportNotificationListener {
    private int failResCount = 0;
    private int successResCount = 0;
    private int totalResCount = 0;
    private Calendar startTime = null;
    private Calendar endTime = null;
    private Map<TaskReportDevType, List<Resource>> devTypeResMap = null;
    private Object synObj = new Object();
    private boolean isWait = true;
    private boolean isRecOK = false;
    private Resource[] resLst = null;
    private List<ITaskDeviceOperation> selectOPerLst = null;
    private String trgtVsn;
    private ITask taskInfo;
    private TaskReportFileInfo tskRprtFlInfo;
    private int checkReportType = -1;
    private TaskReportData taskReportData;
    boolean isPackDiffTask = false;
    private List<TaskReportDevType> devTypeIdLst = null;
    private Map<String, List<TaskReportDetailBean>> stepInfo = null;
    public String allDeviceTypesName = null;
    public AsnTaskReportBoardDetailInfoRsp oBoardDetailInfo = null;
    public Map<Integer, DevCheckInfo> allCheckInfo = null;

    synchronized boolean iswait() {
        return this.isWait;
    }

    synchronized void setWait(boolean isWait) {
        this.isWait = isWait;
    }

    public T2000DataHelper(TaskReportData taskReportData, int checkReportType) {
        this.checkReportType = checkReportType;
        this.taskInfo = taskReportData.getTaskInformation();
        this.trgtVsn = this.taskInfo.getTargetVersion();
        this.taskReportData = taskReportData;
        this.tskRprtFlInfo = taskReportData.getTaskReportFileInfo();
        CheckReportNotifier.getInstance().addCheckReportNotificationListener(this);
        DCDebugTracer.trace(this.getClass().getName() + " [task report] addCheckReportNotificationListener ");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tskRprtFlInfo == null ? 0 : this.tskRprtFlInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        T2000DataHelper other = (T2000DataHelper)obj;
        return !(this.tskRprtFlInfo == null ? other.tskRprtFlInfo != null : !this.tskRprtFlInfo.equals(other.tskRprtFlInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initALLReportData() throws DCException {
        this.devTypeResMap = new HashMap<TaskReportDevType, List<Resource>>(0);
        this.isPackDiffTask = this.taskInfo.getTaskId() == 5;
        UpgradeInfoHelper upgradeInfoHelper = new UpgradeInfoHelper(this.taskInfo);
        upgradeInfoHelper.prepareData();
        this.selectOPerLst = upgradeInfoHelper.getSelectOPerLst();
        this.resLst = upgradeInfoHelper.getResLst();
        this.stepInfo = upgradeInfoHelper.getTaskStepInfo(this.resLst[0]);
        this.startTime = upgradeInfoHelper.getStartTime();
        this.endTime = upgradeInfoHelper.getEndTime();
        this.totalResCount = upgradeInfoHelper.getTotalResCount();
        this.successResCount = upgradeInfoHelper.getSuccessResCount();
        this.failResCount = upgradeInfoHelper.getFailResCount();
        this.initTaskDevTypeInfo();
        if (-1 != this.checkReportType) {
            this.setRecOK(false);
            THashSet oresLst = new THashSet(this.resLst.length);
            for (int i = 0; i < this.resLst.length; ++i) {
                oresLst.add((Object)this.resLst[i]);
            }
            ReportDataHelper.getInstance().getCheckReportDetails(this.taskInfo.getTaskId(), (THashSet<Resource>)oresLst, this.checkReportType);
            this.setWait(true);
            try {
                while (this.iswait()) {
                    Object i = this.synObj;
                    synchronized (i) {
                        this.synObj.wait(50L);
                    }
                }
            }
            catch (InterruptedException ex) {
                DCDebugTracer.traceError(ex.getMessage());
            }
            if (!this.isRecOK()) {
                throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
            }
        } else {
            this.allCheckInfo = new HashMap<Integer, DevCheckInfo>();
        }
        ArrayList<BigInteger> devIdLst = new ArrayList<BigInteger>(this.resLst.length);
        Resource[] arr$ = this.resLst;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                this.oBoardDetailInfo = ReportDataHelper.getInstance().getBoardVerDetail(this.taskInfo.getTaskId(), devIdLst);
                return;
            }
            Resource res = arr$[i$];
            devIdLst.add(BigInteger.valueOf(res.getDeviceID()));
            ++i$;
        }
    }

    private void initTaskDevTypeInfo() {
        this.devTypeIdLst = new ArrayList<TaskReportDevType>(0);
        DeviceTypeInfo devTypeInfo = null;
        TaskReportDevType taskReportDevType = null;
        for (int i = 0; i < this.totalResCount; ++i) {
            DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(this.resLst[i].getDeviceID());
            devTypeInfo = devInfo.getDeviceTypeInfo();
            taskReportDevType = new TaskReportDevType(devTypeInfo.getDevTypeID(), devTypeInfo.getDevTypeName());
            if (this.devTypeIdLst.contains(taskReportDevType)) continue;
            this.devTypeIdLst.add(taskReportDevType);
        }
        this.devTypeResMap = new HashMap<TaskReportDevType, List<Resource>>(0);
        String verticalLine = "|";
        StringBuilder strBuilder = new StringBuilder();
        ArrayList<Resource> oneDevTypeResLst = null;
        for (TaskReportDevType taskRepDevType : this.devTypeIdLst) {
            oneDevTypeResLst = new ArrayList<Resource>(0);
            strBuilder.append(taskRepDevType.getDevTypeName());
            strBuilder.append("|");
            this.setResLstByDevType(taskRepDevType, oneDevTypeResLst);
            this.devTypeResMap.put(taskRepDevType, oneDevTypeResLst);
        }
        int index = strBuilder.lastIndexOf("|");
        if (-1 != index) {
            this.allDeviceTypesName = strBuilder.substring(0, index);
        }
    }

    public void setResLstByDevType(TaskReportDevType taskRepDevType, List<Resource> oneDevTypeResLst) {
        int failResCount = 0;
        int successResCount = 0;
        int devTypeId = 0;
        for (Resource res : this.resLst) {
            devTypeId = res.getDevTypeId();
            if (devTypeId != taskRepDevType.getDevTypeId()) continue;
            oneDevTypeResLst.add(res);
            if (res.getUpgradeResult() == 1) {
                ++failResCount;
                continue;
            }
            if (res.getUpgradeResult() != 0) continue;
            ++successResCount;
        }
        taskRepDevType.setTotalResCount(oneDevTypeResLst.size());
        taskRepDevType.setFailResCount(failResCount);
        taskRepDevType.setSuccessResCount(successResCount);
    }

    public void addDevTypeIdToLst(TaskReportDevType taskReportDevType) {
        if (this.devTypeIdLst.contains(taskReportDevType)) {
            return;
        }
        this.devTypeIdLst.add(taskReportDevType);
    }

    public void setToNull() {
        CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
        List<TaskReportDetailBean> beanLst = null;
        int iOprCount = this.selectOPerLst.size();
        for (int i = 0; i < iOprCount; ++i) {
            ITaskDeviceOperation devOpr = this.selectOPerLst.get(i);
            beanLst = this.stepInfo.get(devOpr.getOperationIdString());
            if (null == beanLst) continue;
            for (TaskReportDetailBean bean : beanLst) {
                bean.setToNull();
                bean = null;
            }
        }
        this.stepInfo.clear();
        this.stepInfo = null;
        for (Resource res : this.resLst) {
            res.clearOperationResults();
            res = null;
        }
        this.selectOPerLst.clear();
        this.selectOPerLst = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckItemInfo() {
        DCDebugTracer.trace(this.getClass().getName() + "[task report] updateCheckItemInfo  start");
        this.allCheckInfo = ReportDevInfoMap.getInstance().getDevCheckReportInfo();
        Object object = this.synObj;
        synchronized (object) {
            this.synObj.notifyAll();
        }
        this.setWait(false);
        this.setRecOK(true);
        DCDebugTracer.trace(this.getClass().getName() + "[task report] updateCheckItemInfo  end..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCheckReportProgressNotification(ReportNotificationEvent event) {
        if (null == event) {
            return;
        }
        if (event.isLastMsg()) {
            CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
            DCDebugTracer.trace(this.getClass().getName() + " [task report] removeTaskNotificationListener : " + this.hashCode());
            if (event.getProgressErrorCode() == 0) {
                this.updateCheckItemInfo();
                DCDebugTracer.trace(this.getClass().getName() + " [task report] receive msg server succcsess , Thread name : " + Thread.currentThread().getName());
            } else {
                DCDebugTracer.traceError(this.getClass().getName() + " [task report] receive msg server failed : " + event.getProgressErrorCode());
                Object object = this.synObj;
                synchronized (object) {
                    this.synObj.notifyAll();
                }
                this.setWait(false);
                this.setRecOK(false);
                return;
            }
        }
    }

    public List<String> getBdVerOrder(String key) {
        String[] boardList;
        String boardVerOrder = ResourceManager.getInstance().getResString(key, "config");
        ArrayList<String> bdLst = new ArrayList<String>();
        if (StringUtils.isNullOrEmptyStr(boardVerOrder)) {
            return bdLst;
        }
        for (String bdver : boardList = boardVerOrder.split(",")) {
            bdLst.add(bdver);
        }
        return bdLst;
    }

    public List<String> getAllAffectUpgradeAlarms() {
        String[] arrAlms;
        String allAffectUpAlms = ResourceManager.getInstance().getResString("AFFECT_UPGRADE_ALARMS", "config");
        ArrayList<String> almLst = new ArrayList<String>();
        if (StringUtils.isNullOrEmptyStr(allAffectUpAlms)) {
            return almLst;
        }
        for (String alarm : arrAlms = allAffectUpAlms.split(",")) {
            almLst.add(alarm);
        }
        return almLst;
    }

    public List<AsnDevBoardInfo> getDevBoardInfo(int devID) {
        ArrayList<AsnDevBoardInfo> oDevBoardInfoLst = new ArrayList<AsnDevBoardInfo>();
        if (null == this.oBoardDetailInfo) {
            return oDevBoardInfoLst;
        }
        AsnDevBoardInfoList oDevBoardInfoList = this.oBoardDetailInfo.oAsnDevBoardInfoList;
        if (null == oDevBoardInfoList) {
            return oDevBoardInfoLst;
        }
        int length = oDevBoardInfoList.size();
        AsnTaskResource oTaskResource = null;
        AsnDevBoardInfo oBoardInfo = null;
        for (int i = 0; i < length; ++i) {
            oBoardInfo = (AsnDevBoardInfo)oDevBoardInfoList.get(i);
            oTaskResource = oBoardInfo.oAsnTaskResource;
            if (devID != oTaskResource.iDeviceId.intValue()) continue;
            oDevBoardInfoLst.add(oBoardInfo);
        }
        return oDevBoardInfoLst;
    }

    public DevCheckNodeInfo getCheckItemInfo(int iDevId, String target) {
        DevCheckInfo devCheckInfo = this.allCheckInfo.get(iDevId);
        if (null == devCheckInfo) {
            return new DevCheckNodeInfo();
        }
        return devCheckInfo.getCheckItemInfo(target);
    }

    public int getFailResCount() {
        return this.failResCount;
    }

    public int getSuccessResCount() {
        return this.successResCount;
    }

    public int getTotalResCount() {
        return this.totalResCount;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public Map<TaskReportDevType, List<Resource>> getDevTypeResMap() {
        return this.devTypeResMap;
    }

    public Resource[] getResLst() {
        return this.resLst;
    }

    public List<ITaskDeviceOperation> getSelectOPerLst() {
        return this.selectOPerLst;
    }

    public String getTrgtVsn() {
        return this.trgtVsn;
    }

    public ITask getTaskInfo() {
        return this.taskInfo;
    }

    public TaskReportFileInfo getTskRprtFlInfo() {
        return this.tskRprtFlInfo;
    }

    public int getCheckReportType() {
        return this.checkReportType;
    }

    public TaskReportData getTaskReportData() {
        return this.taskReportData;
    }

    public boolean isPackDiffTask() {
        return this.isPackDiffTask;
    }

    public List<TaskReportDevType> getDevTypeIdLst() {
        return this.devTypeIdLst;
    }

    public Map<String, List<TaskReportDetailBean>> getStepInfo() {
        return this.stepInfo;
    }

    public String getAllDeviceTypesName() {
        return this.allDeviceTypesName;
    }

    public AsnTaskReportBoardDetailInfoRsp getOBoardDetailInfo() {
        return this.oBoardDetailInfo;
    }

    public Map<Integer, DevCheckInfo> getAllCheckInfo() {
        return this.allCheckInfo;
    }

    public DevCheckInfo getCheckInfo(int devId) {
        return this.allCheckInfo.get(devId);
    }

    synchronized boolean isRecOK() {
        return this.isRecOK;
    }

    synchronized void setRecOK(boolean isRecOK) {
        this.isRecOK = isRecOK;
    }

    public boolean isHaveAffectUpgradeAlarm(Resource res) {
        List<String> armLst = this.getAllAffectUpgradeAlarms();
        boolean isHaveAffectUpgradeAlarm = false;
        int iDevId = res.getDeviceID();
        DevCheckNodeInfo devCheckNodeInfo = this.getCheckItemInfo(iDevId, "ALARM");
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            return isHaveAffectUpgradeAlarm;
        }
        int rowCount = checkReportTable.getRowCount();
        ICheckReportTableModel oReportTableModel = checkReportTable.getModel();
        String strAlarmId = null;
        for (int i = 0; i < rowCount; ++i) {
            ICheckReportTableCell reportTableCell = oReportTableModel.getValueAt(i, 2);
            strAlarmId = reportTableCell.getValue();
            if (!armLst.contains(strAlarmId)) continue;
            isHaveAffectUpgradeAlarm = true;
            break;
        }
        return isHaveAffectUpgradeAlarm;
    }

    public String[] getTableHeaderColumns(DevCheckNodeInfo nodeInfo) {
        ICheckReportHeader reportHeader;
        String[] columns = new String[]{};
        CheckReportTable table = nodeInfo.getCheckReportTable();
        if (null != table && null != (reportHeader = table.getTableHeader())) {
            List<ICheckReportHeaderElement> oHeadLst = reportHeader.getHeaderElementList();
            if (null == oHeadLst || oHeadLst.isEmpty()) {
                return columns;
            }
            columns = new String[oHeadLst.size()];
            CheckReportTableCell oTableCell = null;
            for (int i = 0; i < oHeadLst.size(); ++i) {
                oTableCell = (CheckReportTableCell)((Object)oHeadLst.get(i));
                if (null == oTableCell) continue;
                columns[i] = oTableCell.getValue();
            }
        }
        return columns;
    }

    public boolean isTaskComplete(Resource res) {
        boolean isComplete = false;
        boolean bIsolationTask = IsolationCommonOperation.isIsolationTask(this.taskInfo.getTaskTypeId());
        if (bIsolationTask) {
            return this.isResourceComplete(res);
        }
        TaskProgressInfo taskProgressInfo = this.taskInfo.getTaskProgressInfo();
        int iTaskOpState = taskProgressInfo.getState();
        if (3 == iTaskOpState) {
            isComplete = true;
        }
        return isComplete;
    }

    private boolean isResourceComplete(Resource res) {
        return !res.isUpgradeFail();
    }

    public boolean isSelLdSftwOpe() {
        boolean isSel = false;
        if (null == this.selectOPerLst) {
            return isSel;
        }
        for (ITaskDeviceOperation taskDeviceOperation : this.selectOPerLst) {
            if (!(taskDeviceOperation instanceof LoadSoftwareOperation)) continue;
            isSel = true;
        }
        return isSel;
    }
}

