/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.util;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnTaskReportBoardDetailInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskResultRsp;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ITaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import gnu.trove.THashSet;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class ReportDataHelper {
    private final ITaskSyncCommController oTaskController = TaskSyncCommController.getInstance();

    private ReportDataHelper() {
    }

    public void prepareData(ITask task, AsnTaskResultRsp asnTaskResultRsp) throws DCException {
        this.oTaskController.getTaskResultFrmServer(task.getTaskId(), asnTaskResultRsp);
    }

    public static ReportDataHelper getInstance() {
        return InstanceHolder.instance;
    }

    public int getCheckReportDetails(int iTaskID, Resource res, int checkReportType) throws DCException {
        THashSet resourceList = new THashSet(1);
        resourceList.add((Object)res);
        return this.oTaskController.getCheckReportDetails(iTaskID, (THashSet<Resource>)resourceList, checkReportType);
    }

    public int getCheckReportDetails(int iTaskID, THashSet<Resource> resourceList, int checkReportType) throws DCException {
        return this.oTaskController.getCheckReportDetails(iTaskID, resourceList, checkReportType);
    }

    public int getCheckReportDetails(int iTaskID, THashSet<Resource> resourceList) throws DCException {
        return this.oTaskController.getCheckReportDetails(iTaskID, resourceList);
    }

    public AsnTaskReportBoardDetailInfoRsp getBoardVerDetail(int taskId, List<BigInteger> devIdLst) throws DCException {
        return this.oTaskController.getBoardVerDetail(taskId, devIdLst);
    }

    public String getT2000DevId(Resource res) {
        String strDevID = "";
        if (null == res) {
            return strDevID;
        }
        DeviceInfo deviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(res.getDeviceID());
        if (null == deviceInfo) {
            return strDevID;
        }
        DCDebugTracer.trace(" device name : " + deviceInfo.getDevName());
        if (2 == deviceInfo.getProtocol()) {
            int iNEDevId = deviceInfo.getNEDevId();
            strDevID = DeviceInfoUtil.parseNEIDInt(iNEDevId);
        } else if (4 == deviceInfo.getProtocol()) {
            strDevID = deviceInfo.getNeTId();
        } else {
            DCDebugTracer.trace("error Protocol type : " + deviceInfo.getProtocol());
        }
        return strDevID;
    }

    public String getResUpgradeResult(List<ITaskDeviceOperation> selectOPerLst, Resource res) {
        int opeCnt = selectOPerLst.size();
        ITaskDeviceOperation taskOpe = null;
        ResourceProgressInfo resProInfo = null;
        for (int i = opeCnt - 1; i > -1 && 0 == (resProInfo = res.getOprResultInfo((taskOpe = selectOPerLst.get(i)).getOperationIdString())).getState(); --i) {
        }
        String result = null;
        result = null != resProInfo ? resProInfo.getErrorInfo() : "";
        return result;
    }

    public String getResUpgradeResult(Resource res) {
        String strSesult = "";
        int iResult = res.getUpgradeResult();
        if (1 == iResult) {
            strSesult = TaskReportConstant.TASK_REPORT_UPGRADE_FAILED;
            DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(res.getDeviceID());
            if (oDeviceInfo.getDeviceTypeInfo().getDevDomain() == 4) {
                String strErrMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(995098636L));
                Map<String, ResourceProgressInfo> oHashResProgressInfo = res.getOprResultInfoMap();
                if (oHashResProgressInfo.toString().contains(strErrMsg)) {
                    strSesult = ResourceManager.getInstance().getResString("TASK_REPORT_UPGRADE_STOP");
                }
            }
        } else if (0 == iResult) {
            strSesult = TaskReportConstant.TASK_REPORT_UPGRADE_SUCCESS;
        } else if (2 == iResult) {
            strSesult = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855882L));
        }
        return strSesult;
    }

    private static class InstanceHolder {
        private static ReportDataHelper instance = new ReportDataHelper();

        private InstanceHolder() {
        }
    }
}

