/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.impl;

import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.ExcelFileWtiterHelper;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDetailBean;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.impl.T2000ExcelFileWriter;
import com.huawei.dc.taskmgmt.report.tasklevel.util.T2000DataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jxl.write.WritableSheet;

public class T2000ExcelFileWriterUtil
extends T2000ExcelFileWriter {
    public T2000ExcelFileWriterUtil(TaskReportData taskReportData, int checkReportType) {
        super(taskReportData, checkReportType);
    }

    public static int createSheetColDesc(WritableSheet detailInfoSheet, int startIndex, ExcelFileWtiterHelper excelHelper) {
        int lineNumber = startIndex;
        int[][] position = new int[][]{{0, 0, 2}, {0, 0, 2, 3, 3, 7}, {0, 0, 2, 3, 3, 7}, {0, 0, 2, 3, 3, 7}};
        ExcelFileWtiterHelper.addCell(position[0][0], lineNumber, TaskReportConstant.TASK_REPORT_COLOR_DESCRIPTION, excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[0][1], lineNumber, position[0][2], lineNumber);
        ExcelFileWtiterHelper.addCell(position[1][0], ++lineNumber, "", excelHelper.getBuleFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[1][1], lineNumber, position[1][2], lineNumber);
        ExcelFileWtiterHelper.addDataStrCell(position[1][3], lineNumber, TaskReportConstant.TASK_REPORT_PRE_CONTENT, detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[1][4], lineNumber, position[1][5], lineNumber);
        ExcelFileWtiterHelper.addCell(position[2][0], ++lineNumber, "", excelHelper.getRedFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[2][1], lineNumber, position[2][2], lineNumber);
        ExcelFileWtiterHelper.addDataStrCell(position[2][3], lineNumber, TaskReportConstant.TASK_REPORT_POST_CONTENT, detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[2][4], lineNumber, position[2][5], lineNumber);
        ExcelFileWtiterHelper.addCell(position[3][0], ++lineNumber, "", excelHelper.getBlackFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[3][1], lineNumber, position[3][2], lineNumber);
        ExcelFileWtiterHelper.addDataStrCell(position[3][3], lineNumber, TaskReportConstant.TASK_REPORT_PRE_POST_CONTENT, detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[3][4], lineNumber, position[3][5], lineNumber);
        return T2000ExcelFileWriterUtil.addBlankLine(lineNumber);
    }

    public static int createSheetColDescForBoardVerChk(WritableSheet detailInfoSheet, int startIndex, ExcelFileWtiterHelper excelHelper) {
        int lineNumber = startIndex;
        int[][] position = new int[][]{{0, 0, 2}, {0, 0, 2, 3, 3, 7}, {0, 0, 2, 3, 3, 7}, {0, 0, 2, 3, 3, 7}};
        ExcelFileWtiterHelper.addCell(position[0][0], lineNumber, TaskReportConstant.TASK_REPORT_COLOR_DESCRIPTION, excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[0][1], lineNumber, position[0][2], lineNumber);
        ExcelFileWtiterHelper.addCell(position[2][0], ++lineNumber, "", excelHelper.getRedFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[2][1], lineNumber, position[2][2], lineNumber);
        ExcelFileWtiterHelper.addDataStrCell(position[2][3], lineNumber, ResourceManager.getInstance().getResString("TASK_REPORT_VERSION_AFTER_UPGRADE_DSTVER_NO_SAME"), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[2][4], lineNumber, position[2][5], lineNumber);
        return T2000ExcelFileWriterUtil.addBlankLine(lineNumber);
    }

    public static int createUpgradeStepInfo(WritableSheet detailInfoSheet, Resource res, int startIndex, List<ITaskDeviceOperation> selectOPerLst, T2000DataHelper dataHelper) {
        if (null == res) {
            return startIndex;
        }
        DCDebugTracer.trace("T2000ExcelFileWriterUtil [task report] createStepInfo start ");
        DCDebugTracer.traceDetail("T2000ExcelFileWriterUtil [task report] res : " + res);
        DCDebugTracer.traceDetail("T2000ExcelFileWriterUtil [task report] startIndex : " + startIndex);
        int lineNumber = startIndex;
        int iSupportedOperation = selectOPerLst.size();
        ResourceProgressInfo resProInfo = null;
        List<TaskReportDetailBean> stepArgument = null;
        boolean isStepArg = false;
        Map<String, List<TaskReportDetailBean>> stepInfo = dataHelper.getStepInfo();
        String devId = null;
        for (int i = 0; i < iSupportedOperation; ++i) {
            ITaskDeviceOperation devOpr = selectOPerLst.get(i);
            resProInfo = res.getOprResultInfo(devOpr.getOperationIdString());
            if (null == resProInfo) continue;
            TaskReportDetailBean detailBean = null;
            stepArgument = stepInfo.get(devOpr.getOperationIdString());
            Iterator<TaskReportDetailBean> ite = stepArgument.iterator();
            if (null == ite) continue;
            devId = String.valueOf(res.getDeviceID());
            isStepArg = false;
            while (ite.hasNext()) {
                detailBean = ite.next();
                if (null != detailBean.getDevId() && !devId.equals(detailBean.getDevId())) continue;
                ExcelFileWtiterHelper.addDataStrCell(0, lineNumber, res.getDeviceName(), detailInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(1, lineNumber, res.getDeviceIP(), detailInfoSheet);
                if (isStepArg) {
                    ExcelFileWtiterHelper.addDataStrCell(2, lineNumber, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(3, lineNumber, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(7, lineNumber, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(8, lineNumber, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(9, lineNumber, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(5, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfItem()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(6, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfValue()), detailInfoSheet);
                } else {
                    ExcelFileWtiterHelper.addDataStrCell(2, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOOperationName()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(3, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getStrStartTime()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getStrEndTime()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(7, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOIsPause()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(8, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getODependOn()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(9, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getResultFoReport()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(5, lineNumber, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(6, lineNumber, " --", detailInfoSheet);
                }
                ++lineNumber;
                isStepArg = true;
            }
        }
        DCDebugTracer.trace("T2000ExcelFileWriterUtil [task report] createStepInfo end.. ");
        return lineNumber;
    }

    public static int createUpgradeCheckItemInfo(WritableSheet detailInfoSheet, Resource res, int startIndex, String checkItem, boolean bNeedHeader, T2000DataHelper dataHelper, ExcelFileWtiterHelper excelHelper) {
        int lineNumber = startIndex;
        if (null == res || StringUtils.isNullOrEmptyStr(checkItem)) {
            return lineNumber;
        }
        int iDevId = res.getDeviceID();
        DevCheckNodeInfo devCheckNodeInfo = dataHelper.getCheckItemInfo(iDevId, checkItem);
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            return lineNumber;
        }
        String[] headerLstTmp = dataHelper.getTableHeaderColumns(devCheckNodeInfo);
        String[] headerLst = new String[headerLstTmp.length + 2];
        String strResName = ResourceManager.getInstance().getResString("TASK_REPORT_RESOURCE_NAME");
        String strNEIP = ResourceManager.getInstance().getResString("TASK_REPORT_HEADER_GATEWAY_IP");
        headerLst[0] = strResName;
        headerLst[1] = strNEIP;
        for (int i = 2; i < headerLst.length; ++i) {
            headerLst[i] = headerLstTmp[i - 2];
        }
        int rowCount = checkReportTable.getRowCount();
        int colCount = headerLst.length;
        if ("HEALTH".equals(checkItem)) {
            --colCount;
        }
        if (bNeedHeader) {
            int iColumn = 0;
            for (int i = 0; i < colCount; ++i) {
                ExcelFileWtiterHelper.addCell(iColumn, lineNumber, headerLst[i], excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.mergeCells(detailInfoSheet, iColumn, lineNumber, iColumn + 1, lineNumber);
                iColumn += 2;
            }
            ++lineNumber;
        }
        ICheckReportTableModel oReportTableModel = checkReportTable.getModel();
        for (int i = 0; i < rowCount; ++i) {
            int iColumn = 0;
            CheckReportTableCell oCheckReportTableCell = (CheckReportTableCell)CloneUtil.getClone((CheckReportTableCell)oReportTableModel.getValueAt(i, 0));
            oCheckReportTableCell.setValue(res.getDeviceName());
            if ("HEALTH".equals(checkItem)) {
                ExcelFileWtiterHelper.addHealthCellData(iColumn, lineNumber, oCheckReportTableCell, detailInfoSheet);
            } else {
                ExcelFileWtiterHelper.addAlarmCellData(iColumn, lineNumber, oCheckReportTableCell, detailInfoSheet);
            }
            ExcelFileWtiterHelper.mergeCells(detailInfoSheet, iColumn++, lineNumber, iColumn, lineNumber);
            oCheckReportTableCell.setValue(res.getDeviceIP());
            if ("HEALTH".equals(checkItem)) {
                ExcelFileWtiterHelper.addHealthCellData(++iColumn, lineNumber, oCheckReportTableCell, detailInfoSheet);
            } else {
                ExcelFileWtiterHelper.addAlarmCellData(++iColumn, lineNumber, oCheckReportTableCell, detailInfoSheet);
            }
            ExcelFileWtiterHelper.mergeCells(detailInfoSheet, iColumn++, lineNumber, iColumn, lineNumber);
            for (int j = 2; j < colCount; ++j) {
                oCheckReportTableCell = (CheckReportTableCell)oReportTableModel.getValueAt(i, j - 2);
                if ("HEALTH".equals(checkItem)) {
                    ExcelFileWtiterHelper.addHealthCellData(++iColumn, lineNumber, oCheckReportTableCell, detailInfoSheet);
                } else {
                    ExcelFileWtiterHelper.addAlarmCellData(++iColumn, lineNumber, oCheckReportTableCell, detailInfoSheet);
                }
                ExcelFileWtiterHelper.mergeCells(detailInfoSheet, iColumn++, lineNumber, iColumn, lineNumber);
            }
            ++lineNumber;
            iColumn = 0;
        }
        return lineNumber;
    }

    public static int createUpgradeCheckResultInfo(WritableSheet detailInfoSheet, Resource res, int startIndex, ExcelFileWtiterHelper excelHelper, T2000DataHelper dataHelper) {
        int lineNumber = startIndex;
        if (null == res) {
            return lineNumber;
        }
        DevCheckNodeInfo devCheckNodeInfo = dataHelper.getCheckItemInfo(res.getDeviceID(), "HEALTH");
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            return lineNumber;
        }
        devCheckNodeInfo = dataHelper.getCheckItemInfo(res.getDeviceID(), "ALARM");
        checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            return lineNumber;
        }
        boolean isHaveAffectUpgradeAlarm = dataHelper.isHaveAffectUpgradeAlarm(res);
        ExcelFileWtiterHelper.addCell(0, lineNumber, TaskReportConstant.TASK_REPORT_PRE_POST_CHECK, excelHelper.getTeaFormat(), detailInfoSheet);
        if (isHaveAffectUpgradeAlarm) {
            ExcelFileWtiterHelper.addDataStrCell(1, lineNumber, TaskReportConstant.TASK_REPORT_CHECK_NG, detailInfoSheet);
        } else {
            ExcelFileWtiterHelper.addDataStrCell(1, lineNumber, TaskReportConstant.TASK_REPORT_CHECK_OK, detailInfoSheet);
        }
        return lineNumber + 1;
    }

    private static int addBlankLine(int startIndex) {
        return startIndex + 2;
    }
}

