/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.impl;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnT2000Board;
import com.huawei.dc.common.asndatacenter.AsnT2000BoardList;
import com.huawei.dc.common.asndatacenter.AsndetailedVersion;
import com.huawei.dc.common.asndatacenter.AsndetailedVersionList;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.ExcelFileWtiterHelper;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.LinkCellInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDevType;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.impl.T2000ExcelFileWriterUtil;
import com.huawei.dc.taskmgmt.report.tasklevel.util.ReportDataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.T2000DataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class T2000ExcelFileWriter
implements IFileWriter {
    protected static final int SEQUENCE_NO_COL = 0;
    private static final int DEV_ID_COL = 1;
    private static final int GATEWAY_IP_COL = 2;
    private static final int DEVICE_TYPE_COL = 3;
    private static final int DEVICE_TYPE_COL_2 = 4;
    private static final int VERSION_BEFORE_UPGRADE_COL = 5;
    private static final int VERSION_AFTER_UPGRADE_COL = 6;
    private static final int START_TIME_COL = 7;
    private static final int END_TIME_COL = 8;
    private static final int COST_TIME_COL = 9;
    protected static final int DETAIL_RESOURCE_NAME_COL = 0;
    protected static final int DETAIL_DEVICE_IP_COL = 1;
    protected static final int DETAIL_OPERATION_NAME_COL = 2;
    protected static final int DETAIL_START_TIME_COL = 3;
    protected static final int DETAIL_END_TIME_COL = 4;
    protected static final int DETAIL_CONFIGURATION_ITEM_COL = 5;
    protected static final int DETAIL_CONFIGURATION_VALUE_COL = 6;
    protected static final int DETAIL_PAUSE_BEFORE_CURRENT_OPERATION_COL = 7;
    protected static final int DETAIL_DEPEND_ON_COL = 8;
    protected static final int DETAIL_RESULT_COL = 9;
    private static final int COL_INDEX = 0;
    protected static final int ADD_TWO_COLUMN = 2;
    private static final int MERAGE_START_INDEX = 1;
    private static final int MERAGE_END_INDEX = 2;
    private T2000DataHelper dataHelper = null;
    private ITask taskInfo;
    private Resource[] resLst = null;
    private TaskReportFileInfo tskRprtFlInfo;
    private boolean m_isIsolationTask = false;
    private ExcelFileWtiterHelper excelHelper = null;
    private WritableWorkbook workbook;
    private int[][] BOARD_POS = new int[][]{{6, 6, 7}, {8, 8, 9}, {10, 10, 11}, {12, 12, 13}, {14, 14, 15}, {16, 16, 17}, {18, 18, 19}, {20, 20, 21}, {22, 22, 23}};
    private static final int BEFORE_UPGRADE = 0;
    private static final int AFTER_UPGRADE = 1;
    private static final int PKG_UPGRADE = 2;
    private List<ITaskDeviceOperation> selectOPerLst = null;
    private List<LinkCellInfo> linkLst;
    private IReportCreater m_oTaskReportCreater = null;

    public T2000ExcelFileWriter(TaskReportData taskReportData, int checkReportType) {
        this.dataHelper = new T2000DataHelper(taskReportData, checkReportType);
        this.taskInfo = this.dataHelper.getTaskInfo();
        this.tskRprtFlInfo = this.dataHelper.getTskRprtFlInfo();
        this.excelHelper = new ExcelFileWtiterHelper();
        this.linkLst = new ArrayList<LinkCellInfo>(0);
        this.m_isIsolationTask = IsolationCommonOperation.isIsolationTask(this.taskInfo.getTaskTypeId());
    }

    private void buildDetailInformation(String sheetName, int seq) throws RowsExceededException, WriteException {
        int sheetNumber = seq;
        int toltalSheetNumber = this.dataHelper.getTotalResCount() / 3000 + 1;
        WritableSheet detailsheet = null;
        for (int i = 0; i < toltalSheetNumber; ++i) {
            if (!this.isNeedToCreateSheet(sheetName)) {
                return;
            }
            detailsheet = this.workbook.createSheet(sheetName, sheetNumber);
            detailsheet.getSettings().setShowGridLines(false);
            if (i > 0) {
                this.buildOneSheetDetailInfo(detailsheet, sheetName + sheetNumber, (double)(i + 1) / (double)toltalSheetNumber);
            } else {
                this.buildOneSheetDetailInfo(detailsheet, sheetName, (double)(i + 1) / (double)toltalSheetNumber);
            }
            ++sheetNumber;
        }
    }

    public boolean isNeedToCreateSheet(String sheetName) {
        boolean bNeedToCreateSheet = false;
        for (Resource res : this.resLst) {
            String checkItem = "";
            if (sheetName.equals(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO)) {
                return true;
            }
            if (sheetName.equals(TaskReportConstant.TASK_REPORT_HEALTH)) {
                checkItem = "HEALTH";
            } else if (sheetName.equals(TaskReportConstant.TASK_REPORT_ALARM)) {
                checkItem = "ALARM";
            } else if (sheetName.equals(TaskReportConstant.TASK_REPORT_EXTCHECK)) {
                checkItem = "EXTENDCHECK";
            } else {
                if (sheetName.equals(TaskReportConstant.TASK_REPORT_CHECK_BOARD_VERSION)) {
                    List<AsnDevBoardInfo> oDevBoardInfoLst;
                    if (4 == this.taskInfo.getTaskTypeId() || 13 == this.taskInfo.getTaskTypeId() || 14 == this.taskInfo.getTaskTypeId() || 11 == this.taskInfo.getTaskTypeId() || 12 == this.taskInfo.getTaskTypeId() || 5 == this.taskInfo.getTaskTypeId() || (oDevBoardInfoLst = this.dataHelper.getDevBoardInfo(res.getDeviceID())).isEmpty()) continue;
                    return true;
                }
                if (sheetName.equals(TaskReportConstant.ISOLATION_TASK_BOARD_INFO)) {
                    List<IsolationTaskInfoObj> oIsolationBoardLst = this.dataHelper.getTaskInfo().getIsolationBoardLst(res.getDeviceID());
                    if (null == oIsolationBoardLst || 0 >= oIsolationBoardLst.size()) continue;
                    return true;
                }
            }
            DevCheckNodeInfo devCheckNodeInfo = this.dataHelper.getCheckItemInfo(res.getDeviceID(), checkItem);
            CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
            if (checkReportTable == null) continue;
            return true;
        }
        return bNeedToCreateSheet;
    }

    private void buildGeneralInformation(WritableSheet upgradeInfoSheet) throws WriteException {
        int iRow = 0;
        DCDebugTracer.trace(this.getClass().getName() + " [task report] buildGeneralInformation start");
        ExcelFileWtiterHelper.addCell(0, iRow, TaskReportConstant.TASK_REPORT_USER_NAME, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, iRow, 1, iRow);
        String userName = DCFrameWorkUtil.getUserName();
        ExcelFileWtiterHelper.addDataStrCell(2, iRow, UpgradeInfoHelper.convertEmptyToUnSupportFlag(userName), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, iRow, TaskReportConstant.TASK_REPORT_SAVE_TIME_OF_REPORT, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 3, iRow, 4, iRow);
        ExcelFileWtiterHelper.addDataStrCell(5, iRow, StringUtils.getClietNowTime(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 5, iRow, 9, iRow);
        ExcelFileWtiterHelper.addCell(0, ++iRow, TaskReportConstant.TASK_REPORT_TASK_TYPE, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, iRow, 1, iRow);
        ExcelFileWtiterHelper.addDataStrCell(2, iRow, this.tskRprtFlInfo.getTaskType(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, iRow, TaskReportConstant.TASK_REPORT_TASK_NAME, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 3, iRow, 4, iRow);
        ExcelFileWtiterHelper.addDataStrCell(5, iRow, this.tskRprtFlInfo.getTaskName(), upgradeInfoSheet);
        if (this.m_isIsolationTask) {
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 5, iRow, 9, iRow);
        } else {
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 5, iRow, 6, iRow);
            ExcelFileWtiterHelper.addCell(7, iRow, TaskReportConstant.TASK_REPORT_DEVICE_TYPE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(8, iRow, this.dataHelper.getAllDeviceTypesName(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 8, iRow, 9, iRow);
            ExcelFileWtiterHelper.addCell(0, ++iRow, TaskReportConstant.TASK_REPORT_START_TIME_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, iRow, 1, iRow);
            ExcelFileWtiterHelper.addDataStrCell(2, iRow, UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.convertTimeToString(this.dataHelper.getStartTime())), upgradeInfoSheet);
            ExcelFileWtiterHelper.addCell(3, iRow, TaskReportConstant.TASK_REPORT_END_TIME_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 3, iRow, 4, iRow);
            ExcelFileWtiterHelper.addDataStrCell(5, iRow, UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.convertTimeToString(this.dataHelper.getEndTime())), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 5, iRow, 6, iRow);
            ExcelFileWtiterHelper.addCell(7, iRow, TaskReportConstant.TASK_REPORT_TOTAL_TIME_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(8, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.subDateStr(this.dataHelper.getStartTime(), this.dataHelper.getEndTime())), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 8, 2, 9, 2);
            ExcelFileWtiterHelper.addCell(0, ++iRow, TaskReportConstant.TASK_REPORT_TARGET_VERSION_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, iRow, 1, iRow);
            ExcelFileWtiterHelper.addDataStrCell(2, iRow, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.dataHelper.getTrgtVsn()), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 2, iRow, 9, iRow);
            ExcelFileWtiterHelper.addCell(0, ++iRow, TaskReportConstant.TASK_REPORT_TASK_RESULT_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, iRow, 1, iRow);
            ExcelFileWtiterHelper.addDataStrCell(2, iRow, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.taskInfo.getTaskProgressInfo().toString()), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 2, iRow, 9, iRow);
        }
        ExcelFileWtiterHelper.addCell(0, ++iRow, TaskReportConstant.TASK_REPORT_TOTAL_DEVICE, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, iRow, 1, iRow);
        ExcelFileWtiterHelper.addDataNumberCell(2, iRow, String.valueOf(this.dataHelper.getTotalResCount()), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, iRow, TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 3, iRow, 4, iRow);
        ExcelFileWtiterHelper.addDataNumberCell(5, iRow, String.valueOf(this.dataHelper.getSuccessResCount()), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 5, iRow, 6, iRow);
        ExcelFileWtiterHelper.addCell(7, iRow, TaskReportConstant.TASK_REPORT_FAILED_DEVICE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataNumberCell(8, iRow, String.valueOf(this.dataHelper.getFailResCount()), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 8, iRow, 9, iRow);
        int startIndex = iRow;
        if (!this.m_isIsolationTask) {
            startIndex += 3;
        }
        List<TaskReportDevType> devTypeIdLst = this.dataHelper.getDevTypeIdLst();
        DCDebugTracer.trace(this.getClass().getName() + " [task report] buildOneDevTypeBasicUpgradeInfo start");
        for (TaskReportDevType taskRepDevType : devTypeIdLst) {
            startIndex = this.buildOneDevTypeBasicUpgradeInfo(upgradeInfoSheet, taskRepDevType, startIndex);
            startIndex = this.addBlankLine(startIndex);
        }
        DCDebugTracer.trace(this.getClass().getName() + " [task report] buildOneDevTypeBasicUpgradeInfo end..");
        this.setbasicSheetColWidth(upgradeInfoSheet);
        DCDebugTracer.trace(this.getClass().getName() + " [task report] buildGeneralInformation end..");
    }

    private int addBlankLine(int startIndex) {
        return startIndex + 2;
    }

    private int buildOneDevTypeBasicUpgradeInfo(WritableSheet upgradeInfoSheet, TaskReportDevType taskRepDevType, int startIndex) {
        int index = startIndex;
        if (taskRepDevType == null) {
            return index;
        }
        Map<TaskReportDevType, List<Resource>> devTypeResMap = this.dataHelper.getDevTypeResMap();
        List<Resource> resLst = devTypeResMap.get(taskRepDevType);
        if (resLst == null || resLst.isEmpty()) {
            return index;
        }
        String targetVersion = UpgradeInfoHelper.convertEmptyToUnSupportFlag(resLst.get(0).getUpgradeVersion());
        int totalResCnt = taskRepDevType.getTotalResCount();
        int succResCnt = taskRepDevType.getSuccessResCount();
        int failResCnt = taskRepDevType.getFailResCount();
        if (!this.m_isIsolationTask) {
            ExcelFileWtiterHelper.addCell(0, index, TaskReportConstant.TASK_REPORT_DEVICE_TYPE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, index, 1, index);
            String strDeviceTypeName = "";
            strDeviceTypeName = taskRepDevType.getDevTypeName();
            ExcelFileWtiterHelper.addDataStrCell(2, index, strDeviceTypeName, upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 2, index, 3, index);
            ExcelFileWtiterHelper.addCell(4, index, TaskReportConstant.TASK_REPORT_TARGET_VERSION_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 4, index, 5, index);
            ExcelFileWtiterHelper.addDataStrCell(6, index, targetVersion, upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 6, index, 9, index);
            ExcelFileWtiterHelper.addCell(0, ++index, TaskReportConstant.TASK_REPORT_TOTAL_DEVICE, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, index, 1, index);
            ExcelFileWtiterHelper.addDataNumberCell(2, index, String.valueOf(totalResCnt), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 2, index, 3, index);
            ExcelFileWtiterHelper.addCell(4, index, TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 4, index, 5, index);
            ExcelFileWtiterHelper.addDataNumberCell(6, index, String.valueOf(succResCnt), upgradeInfoSheet);
            ExcelFileWtiterHelper.addCell(7, index, TaskReportConstant.TASK_REPORT_FAILED_DEVICE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(8, index, String.valueOf(failResCnt), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 8, index, 9, index);
        }
        index = this.addBlankLine(index);
        if (failResCnt > 0) {
            ExcelFileWtiterHelper.addCell(0, index, TaskReportConstant.TASK_REPORT_FAILED_DEVICE_1, this.excelHelper.getRedFormat(), upgradeInfoSheet);
            this.createGeneralInfoTableHeader(upgradeInfoSheet, ++index);
            index = this.fillGeneralInfoTableData(upgradeInfoSheet, index, resLst, true);
        }
        if (succResCnt > 0) {
            if (failResCnt > 0) {
                ++index;
                ++index;
            }
            ExcelFileWtiterHelper.addCell(0, index, TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_1, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            this.createGeneralInfoTableHeader(upgradeInfoSheet, ++index);
            index = this.fillGeneralInfoTableData(upgradeInfoSheet, index, resLst, false);
        }
        return index;
    }

    private void buildOneSheetDetailInfo(WritableSheet detailInfoSheet, String sheetName, double iSheet) throws RowsExceededException, WriteException {
        DCDebugTracer.trace(this.getClass().getName() + " [task report] buildOneSheetDetailInfo start");
        DCDebugTracer.traceDetail(this.getClass().getName() + " [task report] sheetName : " + sheetName);
        int lineNumber = 0;
        if (sheetName.equals(TaskReportConstant.TASK_REPORT_HEALTH) || sheetName.equals(TaskReportConstant.TASK_REPORT_ALARM)) {
            lineNumber = this.createSheetColorDesc(detailInfoSheet, lineNumber);
        } else if (sheetName.equals(TaskReportConstant.TASK_REPORT_CHECK_BOARD_VERSION)) {
            lineNumber = this.createSheetColorDescForBoardVerChk(detailInfoSheet, lineNumber);
        }
        boolean bNeedTableHeader = true;
        for (Resource res : this.resLst) {
            if (sheetName.equals(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO) && bNeedTableHeader) {
                lineNumber = this.createDetailInfoTableHeader(detailInfoSheet, res, lineNumber);
            }
            if (sheetName.equals(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO)) {
                lineNumber = this.createStepInfo(detailInfoSheet, res, lineNumber);
            } else if (sheetName.equals(TaskReportConstant.TASK_REPORT_HEALTH)) {
                lineNumber = this.createCheckItemInfo(detailInfoSheet, res, lineNumber, "HEALTH", bNeedTableHeader);
            } else if (sheetName.equals(TaskReportConstant.TASK_REPORT_ALARM)) {
                lineNumber = this.createCheckItemInfo(detailInfoSheet, res, lineNumber, "ALARM", bNeedTableHeader);
            } else if (sheetName.equals(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO)) {
                lineNumber = this.createCheckItemInfo(detailInfoSheet, res, lineNumber, "EXTENDCHECK", bNeedTableHeader);
            } else if (sheetName.equals(TaskReportConstant.TASK_REPORT_CHECK_BOARD_VERSION)) {
                lineNumber = this.createBoardInfo(detailInfoSheet, res, lineNumber, bNeedTableHeader);
            } else if (sheetName.equals(TaskReportConstant.ISOLATION_TASK_BOARD_INFO)) {
                lineNumber = this.createIsolationBoardInfo(detailInfoSheet, res, lineNumber, bNeedTableHeader);
            }
            bNeedTableHeader = false;
        }
        ++lineNumber;
        boolean bNeedAlarmSummaryInfoHeader = true;
        if (sheetName.equals(TaskReportConstant.TASK_REPORT_ALARM)) {
            for (Resource res : this.resLst) {
                lineNumber = this.createCheckAlarmSummaryInfo(detailInfoSheet, res, lineNumber, bNeedAlarmSummaryInfoHeader);
                bNeedAlarmSummaryInfoHeader = false;
            }
        }
        this.setdetailSheetColWidth(detailInfoSheet);
        DCDebugTracer.trace(this.getClass().getName() + " [task report] buildOneSheetDetailInfo end..");
    }

    private int createSheetColorDesc(WritableSheet detailInfoSheet, int startIndex) {
        return T2000ExcelFileWriterUtil.createSheetColDesc(detailInfoSheet, startIndex, this.excelHelper);
    }

    private int createSheetColorDescForBoardVerChk(WritableSheet detailInfoSheet, int startIndex) {
        return T2000ExcelFileWriterUtil.createSheetColDescForBoardVerChk(detailInfoSheet, startIndex, this.excelHelper);
    }

    private int createStepInfo(WritableSheet detailInfoSheet, Resource res, int startIndex) {
        return T2000ExcelFileWriterUtil.createUpgradeStepInfo(detailInfoSheet, res, startIndex, this.selectOPerLst, this.dataHelper);
    }

    private int createCheckResultInfo(WritableSheet detailInfoSheet, Resource res, int startIndex) {
        return T2000ExcelFileWriterUtil.createUpgradeCheckResultInfo(detailInfoSheet, res, startIndex, this.excelHelper, this.dataHelper);
    }

    private int createCheckAlarmSummaryInfo(WritableSheet detailInfoSheet, Resource res, int startIndex, boolean bNeedAlarmSummaryInfo) {
        int lineNumber = startIndex;
        if (null == res) {
            return lineNumber;
        }
        DevCheckInfo devCheckInfo = this.dataHelper.getCheckInfo(res.getDeviceID());
        int checkReportType = this.dataHelper.getCheckReportType();
        String strResName = ResourceManager.getInstance().getResString("TASK_REPORT_RESOURCE_NAME");
        String strNEIP = ResourceManager.getInstance().getResString("TASK_REPORT_HEADER_GATEWAY_IP");
        if (0 == checkReportType) {
            if (bNeedAlarmSummaryInfo) {
                ExcelFileWtiterHelper.addCell(0, lineNumber, strResName, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(1, lineNumber, strNEIP, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(2, lineNumber, TaskReportConstant.TASK_REPORT_ALARM_BEF, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ++lineNumber;
            }
            ExcelFileWtiterHelper.addDataNumberCell(0, lineNumber, res.getDeviceName(), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(1, lineNumber, res.getDeviceIP(), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(2, lineNumber, String.valueOf(devCheckInfo.getiNumOfPreCheckAlarm()), detailInfoSheet);
        } else if (1 == checkReportType) {
            if (bNeedAlarmSummaryInfo) {
                ExcelFileWtiterHelper.addCell(0, lineNumber, strResName, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(1, lineNumber, strNEIP, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(2, lineNumber, TaskReportConstant.TASK_REPORT_ALARM_AFT, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ++lineNumber;
            }
            ExcelFileWtiterHelper.addDataNumberCell(0, lineNumber, res.getDeviceName(), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(1, lineNumber, res.getDeviceIP(), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(2, lineNumber, String.valueOf(devCheckInfo.getiNumOfPostCheckAlarm()), detailInfoSheet);
        } else if (2 == checkReportType) {
            int iColumnHeader = 0;
            int iColumnValue = 0;
            if (bNeedAlarmSummaryInfo) {
                ExcelFileWtiterHelper.addCell(iColumnHeader++, lineNumber, strResName, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(iColumnHeader++, lineNumber, strNEIP, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(iColumnHeader++, lineNumber, TaskReportConstant.TASK_REPORT_ALARM_BEF, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(iColumnHeader++, lineNumber, TaskReportConstant.TASK_REPORT_ALARM_AFT, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(iColumnHeader++, lineNumber, TaskReportConstant.TASK_REPORT_NEW_ALARM, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(iColumnHeader++, lineNumber, TaskReportConstant.TASK_REPORT_DEL_ALARM, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.addCell(iColumnHeader++, lineNumber, TaskReportConstant.TASK_REPORT_SAME_ALARM, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ++lineNumber;
            }
            ExcelFileWtiterHelper.addDataNumberCell(iColumnValue++, lineNumber, res.getDeviceName(), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(iColumnValue++, lineNumber, res.getDeviceIP(), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(iColumnValue++, lineNumber, String.valueOf(devCheckInfo.getiNumOfPreCheckAlarm()), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(iColumnValue++, lineNumber, String.valueOf(devCheckInfo.getiNumOfPostCheckAlarm()), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(iColumnValue++, lineNumber, String.valueOf(devCheckInfo.getINumOfNewCheckAlarm()), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(iColumnValue++, lineNumber, String.valueOf(devCheckInfo.getINumOfDelCheckAlarm()), detailInfoSheet);
            ExcelFileWtiterHelper.addDataNumberCell(iColumnValue++, lineNumber, String.valueOf(devCheckInfo.getINumOfOldCheckAlarm()), detailInfoSheet);
        }
        return lineNumber + 1;
    }

    private int createCheckItemInfo(WritableSheet detailInfoSheet, Resource res, int startIndex, String checkItem, boolean bNeedHeader) {
        return T2000ExcelFileWriterUtil.createUpgradeCheckItemInfo(detailInfoSheet, res, startIndex, checkItem, bNeedHeader, this.dataHelper, this.excelHelper);
    }

    private int createBoardInfo(WritableSheet detailInfoSheet, Resource res, int startIndex, boolean bNeedTableHeader) {
        int lineNumber = startIndex;
        if (4 == this.taskInfo.getTaskTypeId() || 13 == this.taskInfo.getTaskTypeId() || 14 == this.taskInfo.getTaskTypeId() || 11 == this.taskInfo.getTaskTypeId() || 12 == this.taskInfo.getTaskTypeId() || 5 == this.taskInfo.getTaskTypeId()) {
            return startIndex;
        }
        List<AsnDevBoardInfo> oDevBoardInfoLst = this.dataHelper.getDevBoardInfo(res.getDeviceID());
        if (oDevBoardInfoLst.isEmpty()) {
            return startIndex;
        }
        if (bNeedTableHeader) {
            lineNumber = this.createBoardTitleInfo(detailInfoSheet, lineNumber, res);
        }
        List<String> bdOrderLst = this.dataHelper.getBdVerOrder("CHECK_BOARD_VER_ORDER");
        int iBdOrderLen = bdOrderLst.size();
        AsnDevBoardInfo devBoardInfo = null;
        boolean isTaskComplete = this.dataHelper.isTaskComplete(res);
        boolean isSelLdSftwOpe = this.dataHelper.isSelLdSftwOpe();
        if (bNeedTableHeader) {
            for (AsnDevBoardInfo oDevBoardInfo : oDevBoardInfoLst) {
                AsnT2000BoardList oAsnT2000BoardList = oDevBoardInfo.oAsnT2000BoardList;
                if (0 == oAsnT2000BoardList.size()) continue;
                devBoardInfo = oDevBoardInfo;
                String slotName = null;
                for (int i = 0; i < iBdOrderLen; ++i) {
                    slotName = UpgradeInfoHelper.convertEmptyToUnSupportFlag(bdOrderLst.get(i));
                    ExcelFileWtiterHelper.addCell(this.BOARD_POS[i][0], lineNumber, slotName, this.excelHelper.getTeaFormat(), detailInfoSheet);
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, this.BOARD_POS[i][1], lineNumber, this.BOARD_POS[i][2], lineNumber);
                    if (isTaskComplete) {
                        ExcelFileWtiterHelper.addCell(this.BOARD_POS[i + iBdOrderLen][0], lineNumber, slotName, this.excelHelper.getTeaFormat(), detailInfoSheet);
                        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, this.BOARD_POS[i + iBdOrderLen][1], lineNumber, this.BOARD_POS[i + iBdOrderLen][2], lineNumber);
                    }
                    if (!isSelLdSftwOpe) continue;
                    if (isTaskComplete) {
                        ExcelFileWtiterHelper.addCell(this.BOARD_POS[i + iBdOrderLen + iBdOrderLen][0], lineNumber, slotName, this.excelHelper.getTeaFormat(), detailInfoSheet);
                        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, this.BOARD_POS[i + iBdOrderLen + iBdOrderLen][1], lineNumber, this.BOARD_POS[i + iBdOrderLen + iBdOrderLen][2], lineNumber);
                        continue;
                    }
                    ExcelFileWtiterHelper.addCell(this.BOARD_POS[i + iBdOrderLen][0], lineNumber, slotName, this.excelHelper.getTeaFormat(), detailInfoSheet);
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, this.BOARD_POS[i + iBdOrderLen][1], lineNumber, this.BOARD_POS[i + iBdOrderLen][2], lineNumber);
                }
                ++lineNumber;
                break;
            }
        }
        int[] colorMark = this.getBoardColorMark(oDevBoardInfoLst);
        String strResName = res.getDeviceName();
        String strNEIP = res.getDeviceIP();
        for (AsnDevBoardInfo oDevBoardInfo : oDevBoardInfoLst) {
            AsnT2000BoardList oAsnT2000BoardList = oDevBoardInfo.oAsnT2000BoardList;
            if (0 == oAsnT2000BoardList.size()) continue;
            int iBdLength = oAsnT2000BoardList.size();
            AsnT2000Board oAsnT2000Board = null;
            for (int i = 0; i < iBdLength; ++i) {
                oAsnT2000Board = (AsnT2000Board)oAsnT2000BoardList.get(i);
                if (colorMark.length > 0 && i < colorMark.length && 1 == colorMark[i]) {
                    T2000ExcelFileWriter t2000ExcelFileWriter = this;
                    ExcelFileWtiterHelper.addCell(0, lineNumber + i, UpgradeInfoHelper.convertEmptyToUnSupportFlag(strResName), t2000ExcelFileWriter.excelHelper.getRedFormatFG(), detailInfoSheet);
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 0, lineNumber + i, 1, lineNumber + i);
                    T2000ExcelFileWriter t2000ExcelFileWriter2 = this;
                    ExcelFileWtiterHelper.addCell(2, lineNumber + i, UpgradeInfoHelper.convertEmptyToUnSupportFlag(strNEIP), t2000ExcelFileWriter2.excelHelper.getRedFormatFG(), detailInfoSheet);
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 2, lineNumber + i, 3, lineNumber + i);
                    T2000ExcelFileWriter t2000ExcelFileWriter3 = this;
                    ExcelFileWtiterHelper.addCell(4, lineNumber + i, UpgradeInfoHelper.convertEmptyToUnSupportFlag(new String(oAsnT2000Board.strSlotName)), t2000ExcelFileWriter3.excelHelper.getRedFormatFG(), detailInfoSheet);
                } else {
                    ExcelFileWtiterHelper.addDataStrCell(0, lineNumber + i, UpgradeInfoHelper.convertEmptyToUnSupportFlag(strResName), detailInfoSheet);
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 0, lineNumber + i, 1, lineNumber + i);
                    ExcelFileWtiterHelper.addDataStrCell(2, lineNumber + i, UpgradeInfoHelper.convertEmptyToUnSupportFlag(strNEIP), detailInfoSheet);
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 2, lineNumber + i, 3, lineNumber + i);
                    ExcelFileWtiterHelper.addDataStrCell(4, lineNumber + i, UpgradeInfoHelper.convertEmptyToUnSupportFlag(new String(oAsnT2000Board.strSlotName)), detailInfoSheet);
                }
                ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber + i, 5, lineNumber + i);
            }
        }
        int iWriteDataIndex = lineNumber;
        int iUpgradeType = -1;
        for (AsnDevBoardInfo oDevBoardInfo : oDevBoardInfoLst) {
            lineNumber = iWriteDataIndex;
            AsnT2000BoardList oAsnT2000BoardList = oDevBoardInfo.oAsnT2000BoardList;
            iUpgradeType = oDevBoardInfo.iBoardInfoType.intValue();
            if (0 == iUpgradeType) {
                lineNumber = this.createUpgBdInfo(detailInfoSheet, lineNumber, oAsnT2000BoardList, devBoardInfo, 0, colorMark);
                continue;
            }
            if (1 == iUpgradeType) {
                lineNumber = this.createUpgBdInfo(detailInfoSheet, lineNumber, oAsnT2000BoardList, devBoardInfo, iBdOrderLen, colorMark);
                continue;
            }
            if (2 == iUpgradeType) {
                if (isTaskComplete) {
                    lineNumber = this.createUpgBdInfo(detailInfoSheet, lineNumber, oAsnT2000BoardList, devBoardInfo, iBdOrderLen + iBdOrderLen, colorMark);
                    continue;
                }
                lineNumber = this.createUpgBdInfo(detailInfoSheet, lineNumber, oAsnT2000BoardList, devBoardInfo, iBdOrderLen, colorMark);
                continue;
            }
            DCDebugTracer.traceError("iUpgradeType Error :" + iUpgradeType);
        }
        return lineNumber;
    }

    private int createIsolationBoardInfo(WritableSheet detailInfoSheet, Resource res, int startIndex, boolean bNeedTableHeader) {
        List<IsolationTaskInfoObj> oIsolationBoardLst = this.dataHelper.getTaskInfo().getIsolationBoardLst(res.getDeviceID());
        if (null == oIsolationBoardLst || 0 >= oIsolationBoardLst.size()) {
            return startIndex;
        }
        int lineNumber = startIndex;
        if (bNeedTableHeader) {
            int j = 0;
            String strResName = ResourceManager.getInstance().getResString("TASK_REPORT_RESOURCE_NAME");
            String strNEIP = ResourceManager.getInstance().getResString("TASK_REPORT_HEADER_GATEWAY_IP");
            ExcelFileWtiterHelper.addCell(j++, lineNumber, strResName, this.excelHelper.getTeaFormat(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, strNEIP, this.excelHelper.getTeaFormat(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, TaskReportConstant.ISOLATION_TASK_BOARD_NAME, this.excelHelper.getTeaFormat(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, TaskReportConstant.ISOLATION_TASK_IS_ISOLATION_BOARD, this.excelHelper.getTeaFormat(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, TaskReportConstant.ISOLATION_TASK_BOARD_CURRENT_OPR, this.excelHelper.getTeaFormat(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, TaskReportConstant.ISOLATION_TASK_BOARD_OPR_RESULT, this.excelHelper.getTeaFormat(), detailInfoSheet);
            ++lineNumber;
        }
        int iBoardCount = oIsolationBoardLst.size();
        for (int i = 0; i < iBoardCount; ++i) {
            int j = 0;
            IsolationTaskInfoObj oBoardInfo = oIsolationBoardLst.get(i);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, res.getDeviceName(), this.excelHelper.getLeftAlign(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, res.getDeviceIP(), this.excelHelper.getLeftAlign(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oBoardInfo.toString()), this.excelHelper.getLeftAlign(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oBoardInfo.getIsolationBoardState()), this.excelHelper.getLeftAlign(), detailInfoSheet);
            ExcelFileWtiterHelper.addCell(j++, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oBoardInfo.getCurrentOperation()), this.excelHelper.getLeftAlign(), detailInfoSheet);
            String strOprResult = null == oBoardInfo.getProgressInfo() ? "" : oBoardInfo.getProgressInfo().getToolTipText();
            ExcelFileWtiterHelper.addCell(j++, lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(strOprResult), this.excelHelper.getLeftAlign(), detailInfoSheet);
            ++lineNumber;
        }
        return lineNumber;
    }

    private int[] getBoardColorMark(List<AsnDevBoardInfo> oDevBoardInfoLst) {
        int iUpgradeType = -1;
        AsnT2000BoardList oAfterUpgradeBoardList = null;
        AsnT2000BoardList oPkgBoardList = null;
        for (AsnDevBoardInfo oDevBoardInfo : oDevBoardInfoLst) {
            iUpgradeType = oDevBoardInfo.iBoardInfoType.intValue();
            if (1 == iUpgradeType) {
                oAfterUpgradeBoardList = oDevBoardInfo.oAsnT2000BoardList;
                continue;
            }
            if (2 != iUpgradeType) continue;
            oPkgBoardList = oDevBoardInfo.oAsnT2000BoardList;
        }
        int iAfterCnt = 0;
        if (null != oAfterUpgradeBoardList) {
            iAfterCnt = oAfterUpgradeBoardList.size();
        }
        int ibeforeCnt = 0;
        if (null != oPkgBoardList) {
            ibeforeCnt = oPkgBoardList.size();
        }
        int boardCount = Math.min(iAfterCnt, ibeforeCnt);
        int[] colorMark = new int[boardCount];
        if (null == oAfterUpgradeBoardList || null == oPkgBoardList) {
            return colorMark;
        }
        AsnT2000Board oAfterUpgradeBoard = null;
        AsnT2000Board oPkgBoard = null;
        String afterUpdBdName = null;
        String pkgUpdBdName = null;
        AsndetailedVersionList oAfterUpgradeVerLst = null;
        AsndetailedVersionList oPkgVerLst = null;
        List<String> bdOrderLst = this.dataHelper.getBdVerOrder("CHECK_BOARD_VER_DATA");
        int iBdOrderLen = bdOrderLst.size();
        AsndetailedVersion oAfterUpgradedtlVer = null;
        AsndetailedVersion oPkgdtlVer = null;
        String tmpName = null;
        boolean isDiff = false;
        int pkgCnt = 0;
        for (int i = 0; i < boardCount; ++i) {
            oAfterUpgradeBoard = (AsnT2000Board)oAfterUpgradeBoardList.get(i);
            afterUpdBdName = new String(oAfterUpgradeBoard.strSlotName);
            for (int j = 0; j < ibeforeCnt; ++j) {
                oPkgBoard = (AsnT2000Board)oPkgBoardList.get(j);
                pkgUpdBdName = new String(oPkgBoard.strSlotName);
                if (afterUpdBdName.equals(pkgUpdBdName)) break;
            }
            oAfterUpgradeVerLst = oAfterUpgradeBoard.oAsndetailedVersionList;
            if (null != oPkgBoard) {
                oPkgVerLst = oPkgBoard.oAsndetailedVersionList;
            }
            String bdName = null;
            isDiff = false;
            if (null != oPkgVerLst) {
                pkgCnt = oPkgVerLst.size();
            }
            for (int j = 0; j < iBdOrderLen; ++j) {
                String strPkgdtlVer;
                String strAfterUpgradedtlVer;
                bdName = bdOrderLst.get(j);
                for (int k = 0; k < iAfterCnt; ++k) {
                    oAfterUpgradedtlVer = (AsndetailedVersion)oAfterUpgradeVerLst.get(k);
                    tmpName = new String(oAfterUpgradedtlVer.strKeyname);
                    if (bdName.equals(tmpName)) break;
                }
                for (int h = 0; h < pkgCnt; ++h) {
                    if (null == oPkgVerLst) continue;
                    oPkgdtlVer = (AsndetailedVersion)oPkgVerLst.get(h);
                    tmpName = new String(oPkgdtlVer.strKeyname);
                    if (bdName.equals(tmpName)) break;
                }
                if (null == oAfterUpgradedtlVer || null == oPkgdtlVer || (strAfterUpgradedtlVer = new String(oAfterUpgradedtlVer.strValue)).equals(strPkgdtlVer = new String(oPkgdtlVer.strValue))) continue;
                isDiff = true;
                break;
            }
            if (!isDiff) continue;
            colorMark[i] = 1;
        }
        return colorMark;
    }

    private int createUpgBdInfo(WritableSheet detailInfoSheet, int startIndex, AsnT2000BoardList oAsnT2000BoardList, AsnDevBoardInfo candidateBoardInfo, int setp, int[] colorMark) {
        int lineNumber = startIndex;
        int iBdLength = oAsnT2000BoardList.size();
        AsnT2000Board oAsnT2000Board = null;
        AsndetailedVersionList oVerLst = null;
        List<String> bdOrderLst = this.dataHelper.getBdVerOrder("CHECK_BOARD_VER_DATA");
        int iBdOrderLen = bdOrderLst.size();
        if (iBdLength == 0) {
            iBdLength = candidateBoardInfo.oAsnT2000BoardList.size();
            for (int i = 0; i < iBdLength; ++i) {
                for (int j = 0; j < iBdOrderLen; ++j) {
                    ExcelFileWtiterHelper.addDataStrCell(this.BOARD_POS[j + setp][0], lineNumber, "--", detailInfoSheet);
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, this.BOARD_POS[j + setp][1], lineNumber, this.BOARD_POS[j + setp][2], lineNumber);
                }
            }
            return ++lineNumber;
        }
        int verLstLng = 0;
        for (int i = 0; i < iBdLength; ++i) {
            oAsnT2000Board = (AsnT2000Board)oAsnT2000BoardList.get(i);
            oVerLst = oAsnT2000Board.oAsndetailedVersionList;
            verLstLng = oVerLst.size();
            String bdName = null;
            for (int j = 0; j < iBdOrderLen; ++j) {
                bdName = bdOrderLst.get(j);
                AsndetailedVersion detailedVersion = null;
                String tmpName = null;
                for (int k = 0; k < verLstLng; ++k) {
                    detailedVersion = (AsndetailedVersion)oVerLst.get(k);
                    tmpName = new String(detailedVersion.strKeyname);
                    if (bdName.equals(tmpName)) break;
                }
                if (StringUtils.isNullOrEmptyStr(tmpName)) {
                    tmpName = "-";
                }
                if (null != detailedVersion) {
                    if (colorMark.length > 0 && i < colorMark.length && 1 == colorMark[i]) {
                        T2000ExcelFileWriter t2000ExcelFileWriter = this;
                        ExcelFileWtiterHelper.addCell(this.BOARD_POS[j + setp][0], lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(new String(detailedVersion.strValue)), t2000ExcelFileWriter.excelHelper.getRedFormatFG(), detailInfoSheet);
                    } else {
                        ExcelFileWtiterHelper.addDataStrCell(this.BOARD_POS[j + setp][0], lineNumber, UpgradeInfoHelper.convertEmptyToUnSupportFlag(new String(detailedVersion.strValue)), detailInfoSheet);
                    }
                }
                ExcelFileWtiterHelper.mergeCells(detailInfoSheet, this.BOARD_POS[j + setp][1], lineNumber, this.BOARD_POS[j + setp][2], lineNumber);
            }
            ++lineNumber;
        }
        return lineNumber;
    }

    private int createBoardTitleInfo(WritableSheet detailInfoSheet, int startIndex, Resource res) {
        int lineNumber = startIndex;
        String strResName = ResourceManager.getInstance().getResString("TASK_REPORT_RESOURCE_NAME");
        String strNEIP = ResourceManager.getInstance().getResString("TASK_REPORT_HEADER_GATEWAY_IP");
        ExcelFileWtiterHelper.addCell(0, lineNumber, strResName, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 0, lineNumber, 1, lineNumber + 1);
        ExcelFileWtiterHelper.addCell(2, lineNumber, strNEIP, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 2, lineNumber, 3, lineNumber + 1);
        ExcelFileWtiterHelper.addCell(4, lineNumber, TaskReportConstant.TASK_REPORT_BOARD, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber, 5, lineNumber + 1);
        ExcelFileWtiterHelper.addCell(6, lineNumber, TaskReportConstant.TASK_REPORT_VERSION_BEFORE_UPGRADE, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 6, lineNumber, 11, lineNumber);
        if (this.dataHelper.isTaskComplete(res)) {
            ExcelFileWtiterHelper.addCell(12, lineNumber, TaskReportConstant.TASK_REPORT_VERSION_AFTER_UPGRADE, this.excelHelper.getTeaFormat(), detailInfoSheet);
            ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 12, lineNumber, 17, lineNumber);
        }
        if (this.dataHelper.isSelLdSftwOpe()) {
            if (this.dataHelper.isTaskComplete(res)) {
                ExcelFileWtiterHelper.addCell(18, lineNumber, TaskReportConstant.TASK_REPORT_TARGET_VERSION_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 18, lineNumber, 23, lineNumber);
            } else {
                ExcelFileWtiterHelper.addCell(12, lineNumber, TaskReportConstant.TASK_REPORT_TARGET_VERSION_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
                ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 12, lineNumber, 17, lineNumber);
            }
        }
        return ++lineNumber;
    }

    private int createDetailInfoTableHeader(WritableSheet detailInfoSheet, Resource res, int startIndex) {
        if (null == res) {
            return startIndex;
        }
        DCDebugTracer.trace(this.getClass().getName() + " [task report] createDetailInfoTableHeader start ");
        DCDebugTracer.traceDetail(this.getClass().getName() + " [task report] res : " + res);
        DCDebugTracer.traceDetail(this.getClass().getName() + " [task report] startIndex : " + startIndex);
        int lineNumber = startIndex;
        ExcelFileWtiterHelper.addCell(0, lineNumber, TaskReportConstant.TASK_REPORT_RESOURCE_NAME, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(1, lineNumber, TaskReportConstant.TASK_REPORT_HEADER_GATEWAY_IP, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(2, lineNumber, TaskReportConstant.TASK_REPORT_OPERATION_NAME, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(3, lineNumber, TaskReportConstant.TASK_REPORT_START_TIME_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(4, lineNumber, TaskReportConstant.TASK_REPORT_END_TIME_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(5, lineNumber, TaskReportConstant.TASK_REPORT_CONFIGURATION_ITEM, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(6, lineNumber, TaskReportConstant.TASK_REPORT_CONFIGURATION_VALUE, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(7, lineNumber, TaskReportConstant.TASK_REPORT_PAUSE_BEFORE_CURRENT_OPERATION, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(8, lineNumber, TaskReportConstant.TASK_REPORT_DEPEND_ON, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(9, lineNumber, TaskReportConstant.TASK_REPORT_RESULT_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
        DCDebugTracer.trace(this.getClass().getName() + " [task report] createDetailInfoTableHeader end.. ");
        return ++lineNumber;
    }

    private void createGeneralInfoTableHeader(WritableSheet upgradeInfoSheet, int startIndex) {
        ExcelFileWtiterHelper.addCell(0, startIndex, TaskReportConstant.TASK_REPORT_SEQUENCE_NO, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(1, startIndex, TaskReportConstant.TASK_REPORT_HEADER_DEV_ID, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, startIndex, TaskReportConstant.TASK_REPORT_HEADER_GATEWAY_IP, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, startIndex, TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 3, startIndex, 4, startIndex);
        ExcelFileWtiterHelper.addCell(5, startIndex, TaskReportConstant.TASK_REPORT_VERSION_BEFORE_UPGRADE, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(6, startIndex, TaskReportConstant.TASK_REPORT_VERSION_AFTER_UPGRADE, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(7, startIndex, TaskReportConstant.TASK_REPORT_START_TIME_1, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(8, startIndex, TaskReportConstant.TASK_REPORT_END_TIME_1, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(9, startIndex, TaskReportConstant.TASK_REPORT_TOTAL_TIME_1, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
    }

    private int fillGeneralInfoTableData(WritableSheet upgradeInfoSheet, int startIndex, List<Resource> resLst, boolean isfail) {
        int seq = 0;
        int index = startIndex;
        Calendar calStartTime = null;
        Calendar calEndTime = null;
        for (Resource res : resLst) {
            if (isfail != res.isUpgradeFail()) continue;
            ExcelFileWtiterHelper.addDataStrCell(0, ++index, String.valueOf(++seq), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(1, index, res.getDeviceName(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(2, index, res.getDeviceIP(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(3, index, res.getDeviceType(), upgradeInfoSheet);
            ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 3, index, 4, index);
            ExcelFileWtiterHelper.addDataStrCell(5, index, res.getOriginalVersion(), upgradeInfoSheet);
            if (StringUtils.isNullOrEmptyStr(this.dataHelper.getTrgtVsn())) {
                ExcelFileWtiterHelper.addDataStrCell(6, index, res.getUpgradeVersion(), upgradeInfoSheet);
            } else {
                ExcelFileWtiterHelper.addDataStrCell(6, index, this.dataHelper.getTrgtVsn(), upgradeInfoSheet);
            }
            ResourceProgressInfo resProInfo = null;
            int iOprCount = this.selectOPerLst.size();
            ITaskDeviceOperation devOpr = this.selectOPerLst.get(0);
            resProInfo = res.getOprResultInfo(devOpr.getOperationIdString());
            calStartTime = resProInfo.getStartTime();
            ExcelFileWtiterHelper.addDataStrCell(7, index, resProInfo.getStrStartTime(), upgradeInfoSheet);
            for (int iCurOpr = iOprCount; iCurOpr > 0 && null == (calEndTime = (resProInfo = res.getOprResultInfo((devOpr = this.selectOPerLst.get(iCurOpr - 1)).getOperationIdString())).getEndTime()); --iCurOpr) {
            }
            ExcelFileWtiterHelper.addDataStrCell(8, index, resProInfo.getStrEndTime(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(9, index, StringUtils.subDateStr(calStartTime, calEndTime), upgradeInfoSheet);
        }
        return index++;
    }

    private String generateLinkStr(Resource res) {
        int devId = res.getDeviceID();
        LinkCellInfo linkCellInfo = null;
        for (LinkCellInfo cellInfo : this.linkLst) {
            if (devId != cellInfo.getDevId()) continue;
            linkCellInfo = cellInfo;
            break;
        }
        String text = "";
        try {
            if (null != linkCellInfo) {
                text = "HYPERLINK(\"[" + this.getSimpleFileName() + "] " + "'" + linkCellInfo.getSheetName() + "'!" + linkCellInfo.getNameBox() + "\", \" " + ReportDataHelper.getInstance().getT2000DevId(res) + "\")";
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            text = ReportDataHelper.getInstance().getT2000DevId(res);
        }
        return text;
    }

    @Override
    public void saveFile(IReportCreater oTaskReportCreater, int iRange, int iMaxProgress) throws DCException {
        DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile start");
        this.m_oTaskReportCreater = oTaskReportCreater;
        int THREE_PART = 6;
        int iStep = iRange / 6;
        int iBegin = iMaxProgress - iRange;
        File reportFile = null;
        boolean isHaveException = false;
        try {
            this.dataHelper.initALLReportData();
            this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
            iBegin += iStep;
            this.resLst = this.dataHelper.getResLst();
            this.selectOPerLst = this.dataHelper.getSelectOPerLst();
            WorkbookSettings ws = new WorkbookSettings();
            ws.setLocale(DCResourceMng.getInstance().getLocale());
            String filePath = this.tskRprtFlInfo.getFilePath();
            FileUtil.mkDir(filePath, TaskReportConstant.DIRECTORY_TASK_CREATION_FAILED);
            reportFile = new File(this.getFileName());
            this.workbook = Workbook.createWorkbook((File)reportFile, (WorkbookSettings)ws);
            WritableSheet upgradeInfoSheet = this.workbook.createSheet(TaskReportConstant.TASK_REPORT_SHEET_UPGRADE_REPORT_INFO, 0);
            upgradeInfoSheet.getSettings().setShowGridLines(false);
            int iSheetNo = 1;
            this.buildDetailInformation(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO, iSheetNo++);
            this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
            this.buildDetailInformation(TaskReportConstant.TASK_REPORT_HEALTH, iSheetNo++);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
            this.buildDetailInformation(TaskReportConstant.TASK_REPORT_ALARM, iSheetNo++);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
            this.buildDetailInformation(TaskReportConstant.TASK_REPORT_EXTCHECK, iSheetNo++);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
            this.buildDetailInformation(TaskReportConstant.TASK_REPORT_CHECK_BOARD_VERSION, iSheetNo++);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
            this.buildDetailInformation(TaskReportConstant.ISOLATION_TASK_BOARD_INFO, iSheetNo++);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
            this.buildGeneralInformation(upgradeInfoSheet);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
            iBegin += iStep;
            boolean bIsMemoryAvailable = true;
            long lFreeMemoryAvail = 0L;
            long lFileSize = 0L;
            if (null != reportFile) {
                lFreeMemoryAvail = reportFile.getFreeSpace();
            }
            lFileSize = this.excelHelper.getExcelFileContentSize(this.workbook);
            if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
                isHaveException = true;
                bIsMemoryAvailable = false;
            }
            if (!bIsMemoryAvailable) {
                throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_INSUFFICIENT_MEMORY"));
            }
            this.workbook.write();
            this.dataHelper.setToNull();
        }
        catch (DCException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            isHaveException = true;
            FileUtil.deleteReportFile(reportFile, this.workbook);
            throw new DCException(e.getMessage());
        }
        catch (Exception e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            isHaveException = true;
            FileUtil.deleteReportFile(reportFile, this.workbook);
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
        }
        finally {
            if (!isHaveException) {
                FileUtil.freeExcelReference(this.workbook);
            }
            this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
        }
        DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile end..");
    }

    private String getFileName() {
        String filename = this.tskRprtFlInfo.getFileName();
        String filePath = this.tskRprtFlInfo.getFilePath();
        return filePath + File.separator + filename + ".xls";
    }

    private String getSimpleFileName() {
        return this.tskRprtFlInfo.getFileName() + ".xls";
    }

    private void setbasicSheetColWidth(WritableSheet upgradeInfoSheet) {
        upgradeInfoSheet.setColumnView(0, 6);
        upgradeInfoSheet.setColumnView(1, 6);
        upgradeInfoSheet.setColumnView(2, 13);
        upgradeInfoSheet.setColumnView(3, 7);
        upgradeInfoSheet.setColumnView(4, 7);
        upgradeInfoSheet.setColumnView(5, 9);
        upgradeInfoSheet.setColumnView(6, 9);
        upgradeInfoSheet.setColumnView(7, 10);
        upgradeInfoSheet.setColumnView(8, 10);
        upgradeInfoSheet.setColumnView(9, 7);
    }

    private void setdetailSheetColWidth(WritableSheet detailInfoSheet) {
        detailInfoSheet.setColumnView(0, 9);
        detailInfoSheet.setColumnView(1, 9);
        detailInfoSheet.setColumnView(2, 9);
        detailInfoSheet.setColumnView(3, 9);
        detailInfoSheet.setColumnView(4, 9);
        detailInfoSheet.setColumnView(5, 9);
        detailInfoSheet.setColumnView(6, 9);
        detailInfoSheet.setColumnView(7, 9);
        detailInfoSheet.setColumnView(8, 9);
        detailInfoSheet.setColumnView(9, 9);
        detailInfoSheet.setColumnView(10, 9);
    }
}

