/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.impl;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnT2000Board;
import com.huawei.dc.common.asndatacenter.AsnT2000BoardList;
import com.huawei.dc.common.asndatacenter.AsndetailedVersion;
import com.huawei.dc.common.asndatacenter.AsndetailedVersionList;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDetailBean;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.ReportDataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.T2000DataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class T2000CSVFileWriter
implements IFileWriter {
    private String csvFileSavePath = null;
    private T2000DataHelper dataHelper = null;
    private Resource[] resLst = null;
    private ITask taskInfo;
    private TaskReportFileInfo tskRprtFlInfo;
    private boolean m_isIsolationTask = false;
    private IReportCreater m_oTaskReportCreater = null;

    public T2000CSVFileWriter(TaskReportData taskReportData, int checkReportType) {
        this.dataHelper = new T2000DataHelper(taskReportData, checkReportType);
        this.taskInfo = this.dataHelper.getTaskInfo();
        this.tskRprtFlInfo = this.dataHelper.getTskRprtFlInfo();
        this.m_isIsolationTask = IsolationCommonOperation.isIsolationTask(this.taskInfo.getTaskTypeId());
    }

    private void buildDetailInformation(String fileName) throws IOException, DCException {
        int toltalSheetNumber = this.dataHelper.getTotalResCount() / 3000 + 1;
        for (int i = 0; i < toltalSheetNumber; ++i) {
            if (i > 0) {
                this.buildOneSheetDetailInfo(fileName + i, (double)(i + 1) / (double)toltalSheetNumber);
                continue;
            }
            this.buildOneSheetDetailInfo(fileName, (double)(i + 1) / (double)toltalSheetNumber);
        }
    }

    private void buildGeneralInformation(String fileName) throws IOException, DCException {
        FileOutputStream oStream = null;
        OutputStreamWriter oFileWriter = null;
        BufferedWriter oBufferedWriter = null;
        StringBuilder strBuild = null;
        File file = null;
        try {
            file = new File(this.csvFileSavePath + File.separator + fileName + ".csv");
            oStream = new FileOutputStream(file);
            oFileWriter = new OutputStreamWriter((OutputStream)oStream, FileUtil.getSystemEncoding());
            strBuild = new StringBuilder();
            oBufferedWriter = new BufferedWriter(oFileWriter);
            strBuild.append(TaskReportConstant.TASK_REPORT_USER_NAME);
            strBuild.append(",");
            String userName = DCFrameWorkUtil.getUserName();
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(userName));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_SAVE_TIME_OF_REPORT);
            strBuild.append(",");
            strBuild.append(StringUtils.getClietNowTime());
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_TASK_TYPE);
            strBuild.append(",");
            strBuild.append(this.tskRprtFlInfo.getTaskType());
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_TASK_NAME);
            strBuild.append(",");
            strBuild.append(this.tskRprtFlInfo.getTaskName());
            strBuild.append(",");
            if (!this.m_isIsolationTask) {
                strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_TYPE_0);
                strBuild.append(",");
                DeviceType devType = this.taskInfo.getSelectedDeviceType();
                String strDeviceType = devType.getDeviceTypeName();
                strBuild.append(strDeviceType);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                strBuild.append(TaskReportConstant.TASK_REPORT_START_TIME_0);
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.convertTimeToString(this.dataHelper.getStartTime())));
                strBuild.append(",");
                strBuild.append(TaskReportConstant.TASK_REPORT_END_TIME_0);
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.convertTimeToString(this.dataHelper.getEndTime())));
                strBuild.append(",");
                strBuild.append(TaskReportConstant.TASK_REPORT_TOTAL_TIME_0);
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.subDateStr(this.dataHelper.getStartTime(), this.dataHelper.getEndTime())));
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                strBuild.append(TaskReportConstant.TASK_REPORT_TARGET_VERSION_0);
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.dataHelper.getTrgtVsn()));
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                strBuild.append(TaskReportConstant.TASK_REPORT_TASK_RESULT_0);
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.taskInfo.getTaskProgressInfo().toString()));
            }
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_TOTAL_DEVICE);
            strBuild.append(",");
            strBuild.append(String.valueOf(this.dataHelper.getTotalResCount()));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_0);
            strBuild.append(",");
            strBuild.append(String.valueOf(this.dataHelper.getSuccessResCount()));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_FAILED_DEVICE_0);
            strBuild.append(",");
            strBuild.append(String.valueOf(this.dataHelper.getFailResCount()));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            if (this.dataHelper.getFailResCount() > 0) {
                strBuild.append(TaskReportConstant.TASK_REPORT_FAILED_DEVICE_1);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                this.createGeneralInfoTableHeader(strBuild);
                this.fillGeneralInfoTableData(strBuild, true);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            }
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            if (this.dataHelper.getSuccessResCount() > 0) {
                strBuild.append(TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_1);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                this.createGeneralInfoTableHeader(strBuild);
                this.fillGeneralInfoTableData(strBuild, false);
            }
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            strBuild = null;
        }
        catch (IOException e) {
            FileUtil.deleteReportFile(file, oBufferedWriter, oFileWriter);
            DCDebugTracer.trace(e);
            throw e;
        }
        finally {
            if (null != oBufferedWriter) {
                try {
                    oBufferedWriter.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != oFileWriter) {
                try {
                    oFileWriter.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != oStream) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildOneSheetDetailInfo(String fileName, double iSheet) throws IOException, DCException {
        FileOutputStream oStream = null;
        OutputStreamWriter oFileWriter = null;
        BufferedWriter oBufferedWriter = null;
        File file = null;
        try {
            file = new File(this.csvFileSavePath + File.separator + fileName + ".csv");
            oStream = new FileOutputStream(file);
            oFileWriter = new OutputStreamWriter((OutputStream)oStream, FileUtil.getSystemEncoding());
            oBufferedWriter = new BufferedWriter(oFileWriter);
            for (Resource res : this.resLst) {
                this.createDetailInfoTableHeader(oBufferedWriter, res);
                this.createStepInfo(oBufferedWriter, res);
                this.createCheckResultInfo(oBufferedWriter, res);
                this.createCheckItemInfo(oBufferedWriter, res, "HEALTH");
                this.createCheckItemInfo(oBufferedWriter, res, "ALARM");
                this.createCheckItemInfo(oBufferedWriter, res, "EXTENDCHECK");
                this.createBoardInfo(oBufferedWriter, res);
                if (!this.m_isIsolationTask) continue;
                this.createIsolationBoardInfo(oBufferedWriter, res);
            }
        }
        catch (IOException e) {
            FileUtil.deleteReportFile(file, oBufferedWriter, oFileWriter);
            DCDebugTracer.trace(e);
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oFileWriter) {
                    oFileWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oStream) {
                    oStream.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    private void createBoardInfo(BufferedWriter bufWriter, Resource res) throws IOException {
        if (null == bufWriter || null == res) {
            return;
        }
        this.createBoardTitleInfo(bufWriter, res);
        List<String> bdOrderLst = this.dataHelper.getBdVerOrder("CHECK_BOARD_VER_ORDER");
        List<AsnDevBoardInfo> oDevBoardInfoLst = this.dataHelper.getDevBoardInfo(res.getDeviceID());
        AsnDevBoardInfo devBoardInfo = this.createCheckBdVerHeader(bufWriter, bdOrderLst, oDevBoardInfoLst);
        if (null == devBoardInfo) {
            return;
        }
        int boardLength = devBoardInfo.oAsnT2000BoardList.size();
        int iCheckColCount = 10;
        String[][] allData = new String[boardLength][10];
        AsnT2000BoardList boardLst = devBoardInfo.oAsnT2000BoardList;
        AsnT2000Board oT2000Board = null;
        String strBoardName = null;
        for (int i = 0; i < boardLength; ++i) {
            oT2000Board = (AsnT2000Board)boardLst.get(i);
            strBoardName = new String(oT2000Board.strSlotName);
            allData[i] = new String[10];
            for (int j = 0; j < 10; ++j) {
                if (0 == j) {
                    allData[i][0] = strBoardName;
                    continue;
                }
                allData[i][j] = "--";
            }
        }
        int iUpgradeType = -1;
        boolean BEFORE_UPGRADE = false;
        boolean AFTER_UPGRADE = true;
        int PKG_UPGRADE = 2;
        int iBdOrderLen = bdOrderLst.size();
        for (AsnDevBoardInfo oDevBoardInfo : oDevBoardInfoLst) {
            AsnT2000BoardList oAsnT2000BoardList = oDevBoardInfo.oAsnT2000BoardList;
            iUpgradeType = oDevBoardInfo.iBoardInfoType.intValue();
            if (0 == iUpgradeType) {
                this.createUpgBdInfo(oAsnT2000BoardList, allData, 0);
                continue;
            }
            if (1 == iUpgradeType) {
                this.createUpgBdInfo(oAsnT2000BoardList, allData, iBdOrderLen);
                continue;
            }
            if (2 == iUpgradeType) {
                if (this.dataHelper.isTaskComplete(res)) {
                    this.createUpgBdInfo(oAsnT2000BoardList, allData, iBdOrderLen + iBdOrderLen);
                    continue;
                }
                this.createUpgBdInfo(oAsnT2000BoardList, allData, iBdOrderLen);
                continue;
            }
            DCDebugTracer.traceError("iUpgradeType Error :" + iUpgradeType);
        }
        StringBuilder strBuild = new StringBuilder();
        for (int i = 0; i < boardLength; ++i) {
            for (int j = 0; j < 10; ++j) {
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(allData[i][j]));
                strBuild.append(",");
            }
            strBuild.delete(strBuild.length() - 1, strBuild.length());
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        }
        bufWriter.write(strBuild.toString());
        strBuild.delete(0, strBuild.length());
        strBuild = null;
    }

    private void createBoardTitleInfo(BufferedWriter bufWriter, Resource res) throws IOException {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(TaskReportConstant.TASK_REPORT_CHECK_ITEM_0);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_CHECK_BOARD_VERSION);
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        strBuild.append(TaskReportConstant.TASK_REPORT_BOARD);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_VERSION_BEFORE_UPGRADE);
        strBuild.append(",");
        strBuild.append("");
        strBuild.append(",");
        strBuild.append("");
        strBuild.append(",");
        if (this.dataHelper.isTaskComplete(res)) {
            strBuild.append(TaskReportConstant.TASK_REPORT_VERSION_AFTER_UPGRADE);
            strBuild.append(",");
            strBuild.append("");
            strBuild.append(",");
            strBuild.append("");
            strBuild.append(",");
        }
        if (this.dataHelper.isSelLdSftwOpe()) {
            strBuild.append(TaskReportConstant.TASK_REPORT_TARGET_VERSION_1);
            strBuild.append(",");
            strBuild.append("");
            strBuild.append(",");
            strBuild.append("");
        }
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        bufWriter.write(strBuild.toString());
    }

    private void createIsolationBoardTitleInfo(BufferedWriter bufWriter) throws IOException {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(TaskReportConstant.ISOLATION_TASK_BOARD_INFO);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        strBuild.append(TaskReportConstant.ISOLATION_TASK_BOARD_NAME);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.ISOLATION_TASK_IS_ISOLATION_BOARD);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.ISOLATION_TASK_BOARD_CURRENT_OPR);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.ISOLATION_TASK_BOARD_OPR_RESULT);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        bufWriter.write(strBuild.toString());
        strBuild.delete(0, strBuild.length());
        strBuild = null;
    }

    private void createIsolationBoardInfo(BufferedWriter bufWriter, Resource res) throws IOException {
        List<IsolationTaskInfoObj> oIsolationBoardLst = this.dataHelper.getTaskInfo().getIsolationBoardLst(res.getDeviceID());
        if (null == oIsolationBoardLst || 0 >= oIsolationBoardLst.size()) {
            return;
        }
        this.createIsolationBoardTitleInfo(bufWriter);
        StringBuilder strBuild = new StringBuilder();
        int iBoardCount = oIsolationBoardLst.size();
        for (int i = 0; i < iBoardCount; ++i) {
            IsolationTaskInfoObj oTmpBoardInfo = oIsolationBoardLst.get(i);
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oTmpBoardInfo.toString()));
            strBuild.append(",");
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oTmpBoardInfo.getIsolationBoardState()));
            strBuild.append(",");
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oTmpBoardInfo.getCurrentOperation()));
            strBuild.append(",");
            String strOprResult = null == oTmpBoardInfo.getProgressInfo() ? "" : oTmpBoardInfo.getProgressInfo().toString();
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(strOprResult));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        }
        bufWriter.write(strBuild.toString());
        strBuild.delete(0, strBuild.length());
        strBuild = null;
    }

    private AsnDevBoardInfo createCheckBdVerHeader(BufferedWriter bufWriter, List<String> bdOrderLst, List<AsnDevBoardInfo> oDevBoardInfoLst) throws IOException {
        AsnDevBoardInfo devBoardInfo = new AsnDevBoardInfo();
        if (null == bufWriter || null == bdOrderLst || null == oDevBoardInfoLst) {
            return devBoardInfo;
        }
        StringBuilder strBuild = new StringBuilder();
        int iBdOrderLen = bdOrderLst.size();
        for (AsnDevBoardInfo oDevBoardInfo : oDevBoardInfoLst) {
            AsnT2000BoardList oAsnT2000BoardList = oDevBoardInfo.oAsnT2000BoardList;
            if (0 == oAsnT2000BoardList.size()) continue;
            devBoardInfo = oDevBoardInfo;
            String item = null;
            strBuild.append("");
            strBuild.append(",");
            StringBuilder tempBuild = new StringBuilder();
            for (int i = 0; i < iBdOrderLen; ++i) {
                item = bdOrderLst.get(i);
                tempBuild.append(item);
                tempBuild.append(",");
            }
            tempBuild.delete(tempBuild.length() - 1, tempBuild.length());
            strBuild.append((CharSequence)tempBuild);
            strBuild.append(",");
            strBuild.append((CharSequence)tempBuild);
            strBuild.append(",");
            strBuild.append((CharSequence)tempBuild);
            break;
        }
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        bufWriter.write(strBuild.toString());
        strBuild.delete(0, strBuild.length());
        strBuild = null;
        return devBoardInfo;
    }

    private void createCheckItemInfo(BufferedWriter bufWriter, Resource res, String checkItem) throws IOException {
        String[] headerLst;
        if (null == res || null == bufWriter || null == checkItem) {
            return;
        }
        int iDevId = res.getDeviceID();
        DevCheckNodeInfo devCheckNodeInfo = this.dataHelper.getCheckItemInfo(iDevId, checkItem);
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(TaskReportConstant.TASK_REPORT_CHECK_ITEM_0);
        strBuild.append(",");
        strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(devCheckNodeInfo.getNodeName()));
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        if ("ALARM".equals(checkItem)) {
            strBuild.append(this.createCheckAlarmSummaryInfo(res));
        }
        if (null == (headerLst = this.dataHelper.getTableHeaderColumns(devCheckNodeInfo))) {
            return;
        }
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            return;
        }
        int rowCount = checkReportTable.getRowCount();
        int colCount = headerLst.length;
        for (int i = 0; i < colCount; ++i) {
            strBuild.append(headerLst[i]);
            strBuild.append(",");
        }
        strBuild.delete(strBuild.length() - 1, strBuild.length());
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        ICheckReportTableModel oReportTableModel = checkReportTable.getModel();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                strBuild.append(oReportTableModel.getValueAt(i, j).toString());
                strBuild.append(",");
            }
            strBuild.delete(strBuild.length() - 1, strBuild.length());
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        }
        bufWriter.write(strBuild.toString());
        strBuild.delete(0, strBuild.length());
    }

    private void createDetailInfoTableHeader(BufferedWriter bufWriter, Resource res) throws IOException {
        if (null == bufWriter) {
            return;
        }
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(TaskReportConstant.TASK_REPORT_NE);
        strBuild.append(",");
        strBuild.append(ReportDataHelper.getInstance().getT2000DevId(res));
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_UPGRADE_RESULT);
        strBuild.append(",");
        strBuild.append(ReportDataHelper.getInstance().getResUpgradeResult(this.dataHelper.getSelectOPerLst(), res));
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        strBuild.append(TaskReportConstant.TASK_REPORT_RESOURCE_NAME);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_HEADER_GATEWAY_IP);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_OPERATION_NAME);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_START_TIME_1);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_END_TIME_1);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_CONFIGURATION_ITEM);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_CONFIGURATION_VALUE);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_PAUSE_BEFORE_CURRENT_OPERATION);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_DEPEND_ON);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_RESULT_1);
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        bufWriter.write(strBuild.toString());
    }

    private void createGeneralInfoTableHeader(StringBuilder strBuild) {
        strBuild.append(TaskReportConstant.TASK_REPORT_SEQUENCE_NO);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_RESOURCE_NAME);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_HEADER_GATEWAY_IP);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_VERSION_BEFORE_UPGRADE);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_VERSION_AFTER_UPGRADE);
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
    }

    private void createStepInfo(BufferedWriter bufWriter, Resource res) throws IOException {
        if (null == bufWriter || null == res) {
            return;
        }
        List<ITaskDeviceOperation> selectOPerLst = this.dataHelper.getSelectOPerLst();
        StringBuilder strBuild = new StringBuilder();
        int iSupportedOperation = selectOPerLst.size();
        boolean isDevice = true;
        ResourceProgressInfo resProInfo = null;
        List<TaskReportDetailBean> stepArgument = null;
        boolean isStepArg = false;
        Map<String, List<TaskReportDetailBean>> stepInfo = this.dataHelper.getStepInfo();
        String devId = null;
        for (int i = 0; i < iSupportedOperation; ++i) {
            ITaskDeviceOperation devOpr = selectOPerLst.get(i);
            resProInfo = res.getOprResultInfo(devOpr.getOperationIdString());
            if (null == resProInfo) continue;
            TaskReportDetailBean detailBean = null;
            stepArgument = stepInfo.get(devOpr.getOperationIdString());
            Iterator<TaskReportDetailBean> ite = stepArgument.iterator();
            if (null == ite) continue;
            devId = String.valueOf(res.getDeviceID());
            isStepArg = false;
            while (ite.hasNext()) {
                detailBean = ite.next();
                if (null != detailBean.getDevId() && !devId.equals(detailBean.getDevId())) continue;
                if (isDevice) {
                    strBuild.append(res.getDeviceName());
                    strBuild.append(",");
                    strBuild.append(res.getDeviceIP());
                    strBuild.append(",");
                    isDevice = false;
                } else {
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                }
                if (isStepArg) {
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfItem()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfValue()));
                } else {
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOOperationName()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getStrStartTime()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getStrEndTime()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOIsPause()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getODependOn()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getResultFoReport()));
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                }
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                isStepArg = true;
            }
            bufWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
        }
    }

    private void createCheckResultInfo(BufferedWriter bufWriter, Resource res) throws IOException {
        if (null == bufWriter || null == res) {
            return;
        }
        StringBuilder strBuild = new StringBuilder();
        boolean isHaveAffectUpgradeAlarm = this.dataHelper.isHaveAffectUpgradeAlarm(res);
        strBuild.append(TaskReportConstant.TASK_REPORT_PRE_POST_CHECK);
        strBuild.append(",");
        if (isHaveAffectUpgradeAlarm) {
            strBuild.append(TaskReportConstant.TASK_REPORT_CHECK_NG);
        } else {
            strBuild.append(TaskReportConstant.TASK_REPORT_CHECK_OK);
        }
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        bufWriter.write(strBuild.toString());
        strBuild.delete(0, strBuild.length());
        strBuild = null;
    }

    private String createCheckAlarmSummaryInfo(Resource res) throws IOException {
        String strResult = "";
        if (null == res) {
            return strResult;
        }
        StringBuilder strBuild = new StringBuilder();
        DevCheckInfo devCheckInfo = this.dataHelper.getCheckInfo(res.getDeviceID());
        if (null == devCheckInfo) {
            return "";
        }
        int checkReportType = this.dataHelper.getCheckReportType();
        if (0 == checkReportType) {
            strBuild.append(TaskReportConstant.TASK_REPORT_ALARM_BEF);
            strBuild.append(",");
            strBuild.append(devCheckInfo.getiNumOfPreCheckAlarm());
        } else if (1 == checkReportType) {
            strBuild.append(TaskReportConstant.TASK_REPORT_ALARM_AFT);
            strBuild.append(",");
            strBuild.append(devCheckInfo.getiNumOfPostCheckAlarm());
        } else if (2 == checkReportType) {
            strBuild.append(TaskReportConstant.TASK_REPORT_ALARM_BEF);
            strBuild.append(",");
            strBuild.append(devCheckInfo.getiNumOfPreCheckAlarm());
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_ALARM_AFT);
            strBuild.append(",");
            strBuild.append(devCheckInfo.getiNumOfPostCheckAlarm());
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_NEW_ALARM);
            strBuild.append(",");
            strBuild.append(devCheckInfo.getINumOfNewCheckAlarm());
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_DEL_ALARM);
            strBuild.append(",");
            strBuild.append(devCheckInfo.getINumOfDelCheckAlarm());
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_SAME_ALARM);
            strBuild.append(",");
            strBuild.append(devCheckInfo.getINumOfOldCheckAlarm());
        }
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        strResult = strBuild.toString();
        strBuild.delete(0, strBuild.length());
        strBuild = null;
        return strResult;
    }

    private void createUpgBdInfo(AsnT2000BoardList oAsnT2000BoardList, String[][] allData, int setp) {
        int iBdLength = oAsnT2000BoardList.size();
        AsnT2000Board oAsnT2000Board = null;
        AsndetailedVersionList oVerLst = null;
        List<String> bdOrderLst = this.dataHelper.getBdVerOrder("CHECK_BOARD_VER_DATA");
        int iBdOrderLen = bdOrderLst.size();
        for (int i = 0; i < iBdLength; ++i) {
            oAsnT2000Board = (AsnT2000Board)oAsnT2000BoardList.get(i);
            oVerLst = oAsnT2000Board.oAsndetailedVersionList;
            String bdName = null;
            for (int j = 0; j < iBdOrderLen; ++j) {
                bdName = bdOrderLst.get(j);
                AsndetailedVersion detailedVersion = null;
                String tmpName = null;
                for (int k = 0; k < iBdOrderLen; ++k) {
                    detailedVersion = (AsndetailedVersion)oVerLst.get(k);
                    tmpName = new String(detailedVersion.strKeyname);
                    if (bdName.equals(tmpName)) break;
                }
                if (null == detailedVersion) continue;
                allData[i][j + 1 + setp] = new String(detailedVersion.strValue);
            }
        }
    }

    private void fillGeneralInfoTableData(StringBuilder strBuild, boolean isfail) {
        int seq = 0;
        for (Resource res : this.resLst) {
            if (isfail != res.isUpgradeFail()) continue;
            strBuild.append(String.valueOf(seq++));
            strBuild.append(",");
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getDeviceName()));
            strBuild.append(",");
            strBuild.append(res.getDeviceIP());
            strBuild.append(",");
            strBuild.append(res.getDeviceType());
            strBuild.append(",");
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getOriginalVersion()));
            strBuild.append(",");
            if (StringUtils.isNullOrEmptyStr(this.dataHelper.getTrgtVsn())) {
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getDeviceVersion()));
            } else {
                strBuild.append(this.dataHelper.getTrgtVsn());
            }
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        }
    }

    @Override
    public void saveFile(IReportCreater oReportCreater, int iRange, int iMaxProgress) throws DCException {
        DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile start");
        this.m_oTaskReportCreater = oReportCreater;
        int THREE_PART = 3;
        int iStep = iRange / 3;
        int iBegin = iMaxProgress - iRange;
        this.dataHelper.initALLReportData();
        this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
        iBegin += iStep;
        this.resLst = this.dataHelper.getResLst();
        String filename = this.tskRprtFlInfo.getFileName();
        String filePath = this.tskRprtFlInfo.getFilePath();
        this.csvFileSavePath = filePath + File.separator + filename;
        FileUtil.mkDir(this.csvFileSavePath, TaskReportConstant.DIRECTORY_TASK_CREATION_FAILED);
        try {
            this.buildGeneralInformation(TaskReportConstant.TASK_REPORT_SHEET_UPGRADE_REPORT_INFO);
            this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
            this.buildDetailInformation(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
            this.dataHelper.setToNull();
        }
        catch (IOException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
        }
        DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile end..");
    }
}

