/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.impl;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.ExcelFileWtiterHelper;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDetailBean;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import java.io.File;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class SwitchBMSExcelFileWriter
implements IFileWriter {
    private static final int DETAIL_CONFIGURATION_ITEM_COL = 5;
    private static final int DETAIL_CONFIGURATION_VALUE_COL = 6;
    private static final int DETAIL_DEPEND_ON_COL = 8;
    private static final int DETAIL_DEVICE_IP_COL = 1;
    private static final int DETAIL_END_TIME_COL = 4;
    private static final int DETAIL_OPERATION_NAME_COL = 2;
    private static final int DETAIL_PAUSE_BEFORE_CURRENT_OPERATION_COL = 7;
    private static final int DETAIL_RESOURCE_NAME_COL = 0;
    private static final int DETAIL_RESULT_COL = 9;
    private static final int DETAIL_START_TIME_COL = 3;
    private static final int DEVICE_IP_COL = 2;
    private static final int DEVICE_TYPE_COL = 3;
    private static final int FIXED_DEVICES_SHEET_NUMBER = 3000;
    private static final int RESOURCE_NAME_COL = 1;
    private static final int SEQUENCE_NO_COL = 0;
    private static final int VERSION_AFTER_UPGRADE_COL = 5;
    private static final int VERSION_BEFORE_UPGRADE_COL = 4;
    private Calendar endTime = null;
    private ExcelFileWtiterHelper excelHelper = null;
    private int failResCount = 0;
    private Resource[] resLst = null;
    private List<ITaskDeviceOperation> selectOPerLst = null;
    private Calendar startTime = null;
    private Map<String, List<TaskReportDetailBean>> stepInfo = null;
    private int successResCount = 0;
    private String targetVersion;
    private ITask taskInfo;
    private TaskReportFileInfo taskReportFileInfo;
    private int totalResCount = 0;
    private WritableWorkbook workbook;
    private IReportCreater m_oTaskReportCreater = null;
    private int m_iToltalSheetNumber = 0;

    public SwitchBMSExcelFileWriter(TaskReportData taskReportData) {
        this.taskInfo = taskReportData.getTaskInformation();
        this.targetVersion = this.taskInfo.getTargetVersion();
        this.taskReportFileInfo = taskReportData.getTaskReportFileInfo();
        this.excelHelper = new ExcelFileWtiterHelper();
    }

    private void buildDetailInformation(String sheetName, int seq) {
        int seqNo = seq;
        this.m_iToltalSheetNumber = this.totalResCount / 3000 + 1;
        WritableSheet detailsheet = null;
        for (int i = 0; i < this.m_iToltalSheetNumber; ++i) {
            detailsheet = this.workbook.createSheet(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO, seqNo);
            detailsheet.getSettings().setShowGridLines(false);
            if (i > 0) {
                this.buildOneSheetDetailInfo(detailsheet, sheetName + seqNo, (double)(i + 1) / (double)this.m_iToltalSheetNumber);
            } else {
                this.buildOneSheetDetailInfo(detailsheet, sheetName, (double)(i + 1) / (double)this.m_iToltalSheetNumber);
            }
            ++seqNo;
        }
        List<TaskReportDetailBean> beanLst = null;
        int iOprCount = this.selectOPerLst.size();
        for (int i = 0; i < iOprCount; ++i) {
            ITaskDeviceOperation devOpr = this.selectOPerLst.get(i);
            beanLst = this.stepInfo.get(devOpr.getOperationIdString());
            if (null == beanLst) continue;
            for (TaskReportDetailBean bean : beanLst) {
                bean.setToNull();
                bean = null;
            }
        }
        this.stepInfo.clear();
        this.stepInfo = null;
    }

    private void buildGeneralInformation(WritableSheet upgradeInfoSheet) throws WriteException {
        ExcelFileWtiterHelper.addCell(0, 0, TaskReportConstant.TASK_REPORT_USER_NAME, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        String userName = DCFrameWorkUtil.getUserName();
        ExcelFileWtiterHelper.addDataStrCell(1, 0, UpgradeInfoHelper.convertEmptyToUnSupportFlag(userName), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, 0, TaskReportConstant.TASK_REPORT_SAVE_TIME_OF_REPORT, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(3, 0, StringUtils.getClietNowTime(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 3, 0, 5, 0);
        ExcelFileWtiterHelper.addCell(0, 1, TaskReportConstant.TASK_REPORT_TASK_TYPE, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(1, 1, this.taskReportFileInfo.getTaskType(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, 1, TaskReportConstant.TASK_REPORT_TASK_NAME, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(3, 1, this.taskReportFileInfo.getTaskName(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(4, 1, TaskReportConstant.TASK_REPORT_DEVICE_TYPE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        DeviceType devType = this.taskInfo.getSelectedDeviceType();
        String strDeviceType = devType.getDeviceTypeName();
        ExcelFileWtiterHelper.addDataStrCell(5, 1, strDeviceType, upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(0, 2, TaskReportConstant.TASK_REPORT_START_TIME_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(1, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.convertTimeToString(this.startTime)), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, 2, TaskReportConstant.TASK_REPORT_END_TIME_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(3, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.convertTimeToString(this.endTime)), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(4, 2, TaskReportConstant.TASK_REPORT_TOTAL_TIME_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(5, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(StringUtils.subDateStr(this.startTime, this.endTime)), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(0, 3, TaskReportConstant.TASK_REPORT_TARGET_VERSION_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(1, 3, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.targetVersion), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 1, 3, 5, 3);
        ExcelFileWtiterHelper.addCell(0, 4, TaskReportConstant.TASK_REPORT_TASK_RESULT_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(1, 4, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.taskInfo.getTaskProgressInfo().toString()), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 1, 4, 5, 4);
        ExcelFileWtiterHelper.addCell(0, 5, TaskReportConstant.TASK_REPORT_TOTAL_DEVICE, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(1, 5, NumberFormat.getInstance().format(this.totalResCount), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, 5, TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(3, 5, NumberFormat.getInstance().format(this.successResCount), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(4, 5, TaskReportConstant.TASK_REPORT_FAILED_DEVICE_0, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(5, 5, NumberFormat.getInstance().format(this.failResCount), upgradeInfoSheet);
        int startIndex = 8;
        if (this.failResCount > 0) {
            ExcelFileWtiterHelper.addCell(0, startIndex, TaskReportConstant.TASK_REPORT_FAILED_DEVICE_1, this.excelHelper.getRedFormat(), upgradeInfoSheet);
            this.createGeneralInfoTableHeader(upgradeInfoSheet, ++startIndex);
            startIndex = this.fillGeneralInfoTableData(upgradeInfoSheet, startIndex, true);
        }
        if (this.successResCount > 0) {
            if (this.failResCount > 0) {
                ++startIndex;
                ++startIndex;
            }
            ExcelFileWtiterHelper.addCell(0, startIndex, TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_1, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
            this.createGeneralInfoTableHeader(upgradeInfoSheet, ++startIndex);
            this.fillGeneralInfoTableData(upgradeInfoSheet, startIndex, false);
        }
        this.setBasicSheetColWidth(upgradeInfoSheet);
    }

    private int buildOneResDetailInfo(Map<String, List<TaskReportDetailBean>> stepInfo, WritableSheet detailInfoSheet, int startIndex, Resource res) {
        int index = startIndex;
        int iSupportedOperation = this.selectOPerLst.size();
        boolean isDevice = true;
        boolean isStepArg = false;
        ResourceProgressInfo resProInfo = null;
        List<TaskReportDetailBean> stepArgument = null;
        String devId = null;
        for (int i = 0; i < iSupportedOperation; ++i) {
            ITaskDeviceOperation devOpr = this.selectOPerLst.get(i);
            resProInfo = res.getOprResultInfo(devOpr.getOperationIdString());
            if (null == resProInfo) continue;
            TaskReportDetailBean detailBean = null;
            stepArgument = stepInfo.get(devOpr.getOperationIdString());
            if (null == stepArgument) continue;
            devId = String.valueOf(res.getDeviceID());
            Iterator<TaskReportDetailBean> ite = stepArgument.iterator();
            isStepArg = false;
            while (ite.hasNext()) {
                detailBean = ite.next();
                if (null != detailBean.getDevId() && !devId.equals(detailBean.getDevId())) continue;
                if (isDevice) {
                    ExcelFileWtiterHelper.addDataStrCell(0, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getDeviceName()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(1, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getDeviceIP()), detailInfoSheet);
                    isDevice = false;
                } else {
                    ExcelFileWtiterHelper.addDataStrCell(0, index, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(1, index, " --", detailInfoSheet);
                }
                if (isStepArg) {
                    ExcelFileWtiterHelper.addDataStrCell(2, index, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(3, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOStartTime()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOEndTime()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(7, index, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(8, index, " --", detailInfoSheet);
                    String strOrResult = " --";
                    if (!detailBean.getOConfItem().equals(ResourceManager.getInstance().getResString("TASK_REPORT_FILE_NAME"))) {
                        strOrResult = detailBean.getOResult();
                    }
                    ExcelFileWtiterHelper.addDataStrCell(9, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(strOrResult), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(5, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfItem()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(6, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfValue()), detailInfoSheet);
                } else {
                    ExcelFileWtiterHelper.addDataStrCell(2, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOOperationName()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(3, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getStrStartTime()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getStrEndTime()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(7, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOIsPause()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(8, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getODependOn()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(9, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getResultFoReport()), detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(5, index, " --", detailInfoSheet);
                    ExcelFileWtiterHelper.addDataStrCell(6, index, " --", detailInfoSheet);
                }
                ++index;
                isStepArg = true;
            }
        }
        return index;
    }

    private void buildOneSheetDetailInfo(WritableSheet detailInfoSheet, String sheetName, double iSheet) {
        int index = 0;
        this.createDetailInfoTableHeader(detailInfoSheet, index);
        for (Resource res : this.resLst) {
            ++index;
            index = this.buildOneResDetailInfo(this.stepInfo, detailInfoSheet, index, res);
        }
        this.setDetailSheetColWidth(detailInfoSheet);
    }

    private void createDetailInfoTableHeader(WritableSheet detailInfoSheet, int lineNumber) {
        ExcelFileWtiterHelper.addCell(0, lineNumber, TaskReportConstant.TASK_REPORT_RESOURCE_NAME, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(1, lineNumber, TaskReportConstant.TASK_REPORT_DEVICE_IP, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(2, lineNumber, TaskReportConstant.TASK_REPORT_OPERATION_NAME, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(3, lineNumber, TaskReportConstant.TASK_REPORT_START_TIME_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(4, lineNumber, TaskReportConstant.TASK_REPORT_END_TIME_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(5, lineNumber, TaskReportConstant.TASK_REPORT_CONFIGURATION_ITEM, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(6, lineNumber, TaskReportConstant.TASK_REPORT_CONFIGURATION_VALUE, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(7, lineNumber, TaskReportConstant.TASK_REPORT_PAUSE_BEFORE_CURRENT_OPERATION, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(8, lineNumber, TaskReportConstant.TASK_REPORT_DEPEND_ON, this.excelHelper.getTeaFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(9, lineNumber, TaskReportConstant.TASK_REPORT_RESULT_1, this.excelHelper.getTeaFormat(), detailInfoSheet);
    }

    private void createGeneralInfoTableHeader(WritableSheet upgradeInfoSheet, int lineNumber) {
        ExcelFileWtiterHelper.addCell(0, lineNumber, TaskReportConstant.TASK_REPORT_SEQUENCE_NO, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(1, lineNumber, TaskReportConstant.TASK_REPORT_RESOURCE_NAME, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, lineNumber, TaskReportConstant.TASK_REPORT_DEVICE_IP, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, lineNumber, TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(4, lineNumber, TaskReportConstant.TASK_REPORT_VERSION_BEFORE_UPGRADE, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(5, lineNumber, TaskReportConstant.TASK_REPORT_VERSION_AFTER_UPGRADE, this.excelHelper.getTeaFormat(), upgradeInfoSheet);
    }

    private int fillGeneralInfoTableData(WritableSheet upgradeInfoSheet, int lineNumber, boolean isfail) {
        int index = lineNumber;
        int seq = 0;
        for (Resource res : this.resLst) {
            if (isfail != res.isUpgradeFail()) continue;
            ExcelFileWtiterHelper.addDataStrCell(0, ++index, String.valueOf(++seq), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(1, index, res.getDeviceName(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(2, index, res.getDeviceIP(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(3, index, res.getDeviceType(), upgradeInfoSheet);
            ExcelFileWtiterHelper.addDataStrCell(4, index, res.getOriginalVersion(), upgradeInfoSheet);
            if (StringUtils.isNullOrEmptyStr(this.targetVersion)) {
                ExcelFileWtiterHelper.addDataStrCell(5, index, res.getDeviceVersion(), upgradeInfoSheet);
                continue;
            }
            ExcelFileWtiterHelper.addDataStrCell(5, index, this.targetVersion, upgradeInfoSheet);
        }
        return index++;
    }

    private void getAllReportData() throws DCException {
        UpgradeInfoHelper upgradeInfoHelper = new UpgradeInfoHelper(this.taskInfo);
        upgradeInfoHelper.prepareData();
        this.selectOPerLst = upgradeInfoHelper.getSelectOPerLst();
        this.resLst = upgradeInfoHelper.getResLst();
        this.stepInfo = upgradeInfoHelper.getTaskStepInfo(this.resLst[0]);
        this.resLst = upgradeInfoHelper.getResLst();
        this.startTime = upgradeInfoHelper.getStartTime();
        this.endTime = upgradeInfoHelper.getEndTime();
        this.totalResCount = upgradeInfoHelper.getTotalResCount();
        this.successResCount = upgradeInfoHelper.getSuccessResCount();
        this.failResCount = upgradeInfoHelper.getFailResCount();
    }

    @Override
    public void saveFile(IReportCreater oReportCreater, int iRange, int iMaxProgress) throws DCException {
        block10: {
            this.m_oTaskReportCreater = oReportCreater;
            int THREE_PART = 4;
            int iStep = iRange / 4;
            int iBegin = iMaxProgress - iRange;
            File reportFile = null;
            boolean isHaveException = false;
            try {
                this.getAllReportData();
                this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
                iBegin += iStep;
                WorkbookSettings ws = new WorkbookSettings();
                ws.setLocale(DCResourceMng.getInstance().getLocale());
                String filename = this.taskReportFileInfo.getFileName();
                String filePath = this.taskReportFileInfo.getFilePath();
                FileUtil.mkDir(filePath, TaskReportConstant.DIRECTORY_TASK_CREATION_FAILED);
                reportFile = new File(filePath + File.separator + filename + ".xls");
                this.workbook = Workbook.createWorkbook((File)reportFile, (WorkbookSettings)ws);
                boolean BASIC_INFO_INDEX = false;
                WritableSheet upgradeInfoSheet = this.workbook.createSheet(TaskReportConstant.TASK_REPORT_SHEET_UPGRADE_REPORT_INFO, 0);
                upgradeInfoSheet.getSettings().setShowGridLines(false);
                this.buildGeneralInformation(upgradeInfoSheet);
                this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
                boolean DETAIL_INFO_INDEX = true;
                this.buildDetailInformation(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO, 1);
                this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
                iBegin += iStep;
                boolean bIsMemoryAvailable = true;
                long lFreeMemoryAvail = 0L;
                long lFileSize = 0L;
                if (null != reportFile) {
                    lFreeMemoryAvail = reportFile.getFreeSpace();
                }
                lFileSize = this.excelHelper.getExcelFileContentSize(this.workbook);
                if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
                    isHaveException = true;
                    bIsMemoryAvailable = false;
                }
                if (bIsMemoryAvailable) {
                    this.workbook.write();
                    break block10;
                }
                throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_INSUFFICIENT_MEMORY"));
            }
            catch (DCException e) {
                DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
                DCDebugTracer.trace(e);
                isHaveException = true;
                FileUtil.deleteReportFile(reportFile, this.workbook);
                throw new DCException(e.getMessage());
            }
            catch (Exception e) {
                DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
                DCDebugTracer.trace(e);
                isHaveException = true;
                FileUtil.deleteReportFile(reportFile, this.workbook);
                throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
            }
            finally {
                if (!isHaveException) {
                    FileUtil.freeExcelReference(this.workbook);
                }
                this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
            }
        }
    }

    private void setBasicSheetColWidth(WritableSheet upgradeInfoSheet) {
        upgradeInfoSheet.setColumnView(0, 18);
        upgradeInfoSheet.setColumnView(1, 18);
        upgradeInfoSheet.setColumnView(2, 18);
        upgradeInfoSheet.setColumnView(3, 18);
        upgradeInfoSheet.setColumnView(4, 25);
        upgradeInfoSheet.setColumnView(5, 25);
    }

    private void setDetailSheetColWidth(WritableSheet detailInfoSheet) {
        detailInfoSheet.setColumnView(0, 18);
        detailInfoSheet.setColumnView(1, 18);
        detailInfoSheet.setColumnView(2, 18);
        detailInfoSheet.setColumnView(3, 18);
        detailInfoSheet.setColumnView(4, 18);
        detailInfoSheet.setColumnView(5, 20);
        detailInfoSheet.setColumnView(6, 20);
        detailInfoSheet.setColumnView(7, 25);
        detailInfoSheet.setColumnView(8, 18);
        detailInfoSheet.setColumnView(9, 18);
    }
}

