/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.impl;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.standalone.startup.DCStandaloneDebugTracer;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportDetailBean;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SwitchBMSCSVFileWriter
implements IFileWriter {
    private static final int MAX_SAVE_LINE = 500;
    private Calendar endTime = null;
    private int failResCount = 0;
    private String fileSavePath = null;
    private Resource[] resLst = null;
    private List<ITaskDeviceOperation> selectOPerLst = null;
    private Calendar startTime = null;
    private Map<String, List<TaskReportDetailBean>> stepInfo = null;
    private int successResCount = 0;
    private String targetVersion;
    private ITask taskInfo;
    private TaskReportFileInfo taskReportFileInfo;
    private int totalResCount = 0;
    private IReportCreater m_oTaskReportCreater = null;

    public SwitchBMSCSVFileWriter(TaskReportData taskReportData) {
        this.taskInfo = taskReportData.getTaskInformation();
        this.targetVersion = this.taskInfo.getTargetVersion();
        this.taskReportFileInfo = taskReportData.getTaskReportFileInfo();
    }

    private void buildDetailInformation(String fileName) throws IOException, DCException {
        int toltalSheetNumber = this.totalResCount / 3000 + 1;
        for (int i = 0; i < toltalSheetNumber; ++i) {
            if (i > 0) {
                this.buildOneSheetDetailInfo(fileName + i, (double)(i + 1) / (double)toltalSheetNumber);
                continue;
            }
            this.buildOneSheetDetailInfo(fileName, (double)(i + 1) / (double)toltalSheetNumber);
        }
        List<TaskReportDetailBean> data = null;
        if (null == this.selectOPerLst) {
            return;
        }
        int iOprCount = this.selectOPerLst.size();
        for (int i = 0; i < iOprCount; ++i) {
            ITaskDeviceOperation devOpr = this.selectOPerLst.get(i);
            data = this.stepInfo.get(devOpr.getOperationIdString());
            Iterator<TaskReportDetailBean> it = data.iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        this.stepInfo.clear();
        this.stepInfo = null;
    }

    private void buildGeneralInformation(String fileName) throws IOException, DCException {
        FileOutputStream oStream = null;
        OutputStreamWriter oWriter = null;
        BufferedWriter oBufferedWriter = null;
        StringBuilder strBuild = null;
        File file = null;
        try {
            file = new File(this.fileSavePath + File.separator + fileName + ".csv");
            oStream = new FileOutputStream(file);
            oWriter = new OutputStreamWriter((OutputStream)oStream, FileUtil.getSystemEncoding());
            strBuild = new StringBuilder();
            oBufferedWriter = new BufferedWriter(oWriter);
            strBuild.append(TaskReportConstant.TASK_REPORT_USER_NAME);
            strBuild.append(",");
            String userName = DCFrameWorkUtil.getUserName();
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(userName));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_SAVE_TIME_OF_REPORT);
            strBuild.append(",");
            strBuild.append(StringUtils.getClietNowTime());
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_TASK_TYPE);
            strBuild.append(",");
            strBuild.append(this.taskReportFileInfo.getTaskType());
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_TASK_NAME);
            strBuild.append(",");
            strBuild.append(this.taskReportFileInfo.getTaskName());
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_TYPE_0);
            strBuild.append(",");
            DeviceType devType = this.taskInfo.getSelectedDeviceType();
            String strDeviceType = devType.getDeviceTypeName();
            strBuild.append(strDeviceType);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_START_TIME_0);
            strBuild.append(",");
            strBuild.append(StringUtils.convertTimeToString(this.startTime));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_END_TIME_0);
            strBuild.append(",");
            strBuild.append(StringUtils.convertTimeToString(this.endTime));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_TOTAL_TIME_0);
            strBuild.append(",");
            strBuild.append(StringUtils.subDateStr(this.startTime, this.endTime));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_TARGET_VERSION_0);
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.targetVersion));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_TASK_RESULT_0);
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.taskInfo.getTaskProgressInfo().toString()));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_TOTAL_DEVICE);
            strBuild.append(",");
            strBuild.append(NumberFormat.getInstance().format(this.totalResCount));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_0);
            strBuild.append(",");
            strBuild.append(NumberFormat.getInstance().format(this.successResCount));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_FAILED_DEVICE_0);
            strBuild.append(",");
            strBuild.append(NumberFormat.getInstance().format(this.failResCount));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            if (this.failResCount > 0) {
                strBuild.append(TaskReportConstant.TASK_REPORT_FAILED_DEVICE_1);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                this.createGeneralInfoTableHeader(strBuild);
                this.fillGeneralInfoTableData(strBuild, true);
            }
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            if (this.successResCount > 0) {
                strBuild.append(TaskReportConstant.TASK_REPORT_SUCCESSFUL_DEVICE_1);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                this.createGeneralInfoTableHeader(strBuild);
                this.fillGeneralInfoTableData(strBuild, false);
            }
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            strBuild = null;
        }
        catch (IOException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            FileUtil.deleteReportFile(file, oBufferedWriter, oWriter);
            throw e;
        }
        finally {
            if (null != oBufferedWriter) {
                try {
                    oBufferedWriter.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oWriter) {
                try {
                    oWriter.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oStream) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
        }
    }

    private void buildOneResDeatilInfo(Map<String, List<TaskReportDetailBean>> stepInfo, BufferedWriter oBufferedWriter, StringBuilder strBuild, Resource res) throws IOException {
        int iSupportedOperation = this.selectOPerLst.size();
        boolean isDevice = false;
        boolean isStepArg = false;
        ResourceProgressInfo resProInfo = null;
        List<TaskReportDetailBean> stepArgument = null;
        isDevice = true;
        int ilineCount = 0;
        String devId = null;
        for (int i = 0; i < iSupportedOperation; ++i) {
            ITaskDeviceOperation devOpr = this.selectOPerLst.get(i);
            resProInfo = res.getOprResultInfo(devOpr.getOperationIdString());
            if (null == resProInfo || null == (stepArgument = stepInfo.get(devOpr.getOperationIdString()))) continue;
            devId = String.valueOf(res.getDeviceID());
            Iterator<TaskReportDetailBean> ite = stepArgument.iterator();
            isStepArg = false;
            while (ite.hasNext()) {
                TaskReportDetailBean detailBean = ite.next();
                if (null != detailBean.getDevId() && !devId.equals(detailBean.getDevId())) continue;
                if (isDevice) {
                    strBuild.append(res.getDeviceName());
                    strBuild.append(",");
                    strBuild.append(res.getDeviceIP());
                    strBuild.append(",");
                    isDevice = false;
                } else {
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                }
                if (isStepArg) {
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOStartTime()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOEndTime()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfItem()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfValue()));
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOResult()));
                    strBuild.append(",");
                } else {
                    strBuild.append(detailBean.getOOperationName());
                    strBuild.append(",");
                    strBuild.append(resProInfo.getStartTime());
                    strBuild.append(",");
                    strBuild.append(resProInfo.getEndTime());
                    strBuild.append(",");
                    strBuild.append("--");
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOConfValue()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getOIsPause()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(detailBean.getODependOn()));
                    strBuild.append(",");
                    strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(resProInfo.getResultFoReport()));
                }
                if (0 == ++ilineCount % 500) {
                    oBufferedWriter.write(strBuild.toString());
                    strBuild.delete(0, strBuild.length());
                }
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                isStepArg = true;
            }
        }
    }

    private void buildOneSheetDetailInfo(String fileName, double iSheet) throws IOException, DCException {
        FileOutputStream oStream = null;
        OutputStreamWriter oWriter = null;
        BufferedWriter oBufferedWriter = null;
        StringBuilder strBuild = null;
        File file = null;
        try {
            file = new File(this.fileSavePath + File.separator + fileName + ".csv");
            oStream = new FileOutputStream(file);
            oWriter = new OutputStreamWriter((OutputStream)oStream, FileUtil.getSystemEncoding());
            strBuild = new StringBuilder();
            oBufferedWriter = new BufferedWriter(oWriter);
            this.createDetailInfoTableHeader(strBuild);
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            for (Resource res : this.resLst) {
                this.buildOneResDeatilInfo(this.stepInfo, oBufferedWriter, strBuild, res);
            }
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
        }
        catch (IOException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            FileUtil.deleteReportFile(file, oBufferedWriter, oWriter);
            throw e;
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oWriter) {
                    oWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oStream) {
                    oStream.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    private void createDetailInfoTableHeader(StringBuilder strBuild) {
        strBuild.append(TaskReportConstant.TASK_REPORT_RESOURCE_NAME);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_IP);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_OPERATION_NAME);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_START_TIME_1);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_END_TIME_1);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_CONFIGURATION_ITEM);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_CONFIGURATION_VALUE);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_PAUSE_BEFORE_CURRENT_OPERATION);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_DEPEND_ON);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_RESULT_1);
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
    }

    private void createGeneralInfoTableHeader(StringBuilder strBuild) {
        strBuild.append(TaskReportConstant.TASK_REPORT_SEQUENCE_NO);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_RESOURCE_NAME);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_IP);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_VERSION_BEFORE_UPGRADE);
        strBuild.append(",");
        strBuild.append(TaskReportConstant.TASK_REPORT_VERSION_AFTER_UPGRADE);
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
    }

    private void fillGeneralInfoTableData(StringBuilder strBuild, boolean isfail) {
        int seq = 0;
        for (Resource res : this.resLst) {
            if (isfail != res.isUpgradeFail()) continue;
            strBuild.append(String.valueOf(seq++));
            strBuild.append(",");
            strBuild.append(res.getDeviceName());
            strBuild.append(",");
            strBuild.append(res.getDeviceIP());
            strBuild.append(",");
            strBuild.append(res.getDeviceType());
            strBuild.append(",");
            strBuild.append(res.getOriginalVersion());
            strBuild.append(",");
            if (StringUtils.isNullOrEmptyStr(this.targetVersion)) {
                strBuild.append(res.getDeviceVersion());
            } else {
                strBuild.append(this.targetVersion);
            }
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        }
    }

    private void getAllReportData() throws DCException {
        UpgradeInfoHelper upgradeInfoHelper = new UpgradeInfoHelper(this.taskInfo);
        upgradeInfoHelper.prepareData();
        this.selectOPerLst = upgradeInfoHelper.getSelectOPerLst();
        this.resLst = upgradeInfoHelper.getResLst();
        this.stepInfo = upgradeInfoHelper.getTaskStepInfo(this.resLst[0]);
        this.resLst = upgradeInfoHelper.getResLst();
        this.startTime = upgradeInfoHelper.getStartTime();
        this.endTime = upgradeInfoHelper.getEndTime();
        this.totalResCount = upgradeInfoHelper.getTotalResCount();
        this.successResCount = upgradeInfoHelper.getSuccessResCount();
        this.failResCount = upgradeInfoHelper.getFailResCount();
    }

    @Override
    public void saveFile(IReportCreater oTaskReportCreater, int iRange, int iMaxProgress) throws DCException {
        this.m_oTaskReportCreater = oTaskReportCreater;
        int THREE_PART = 3;
        int iStep = iRange / 3;
        int iBegin = iMaxProgress - iRange;
        this.getAllReportData();
        this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
        iBegin += iStep;
        String filename = this.taskReportFileInfo.getFileName();
        String filePath = this.taskReportFileInfo.getFilePath();
        this.fileSavePath = filePath + File.separator + filename;
        FileUtil.mkDir(this.fileSavePath, TaskReportConstant.DIRECTORY_TASK_CREATION_FAILED);
        try {
            this.buildGeneralInformation(TaskReportConstant.TASK_REPORT_SHEET_UPGRADE_REPORT_INFO);
            this.m_oTaskReportCreater.updateProgress(iBegin + iStep, iMaxProgress);
            this.buildDetailInformation(TaskReportConstant.TASK_REPORT_SHEET_DETAIL_INFO);
            this.m_oTaskReportCreater.updateProgress((iBegin += iStep) + iStep, iMaxProgress);
        }
        catch (IOException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
        }
    }
}

