/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.impl;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.ExcelFileWtiterHelper;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportNotifier;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ICheckReportNotificationListener;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ReportNotificationEvent;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportDevInfoMap;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.ReportDataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import java.io.File;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class RouterExcelFileWriter
implements IFileWriter,
ICheckReportNotificationListener {
    private static final int CHECK_ITEM_COL = 0;
    private static final int COMPARE_RESULT_COL = 4;
    static final int DEVICE_IP_COl = 1;
    static final int DEVICE_NAME_COl = 0;
    static final int DEVICE_TYPE_COl = 2;
    static final int OPERATION_RESULT_COl = 4;
    static final int POSTCHECK_RESULT_COL = 3;
    static final int PRECHECK_RESULT_COL = 2;
    static final int UPGRADE_COST_TIME_COl = 3;
    private Map<Integer, DevCheckInfo> allCheckInfo = null;
    private int checkReportType;
    private ExcelFileWtiterHelper excelHelper = null;
    private boolean isRecOK = false;
    private boolean isWait = true;
    private Resource[] resLst;
    private Object synObj = new Object();
    private ITask taskInformation;
    private TaskReportFileInfo taskReportFileInfo;
    private UpgradeInfoHelper upgradeInfoHelper = null;
    private WritableWorkbook workbook;
    private boolean isLastDev;

    private boolean isLastDev() {
        return this.isLastDev;
    }

    private void setLastDev(boolean isLastDev) {
        this.isLastDev = isLastDev;
    }

    public RouterExcelFileWriter(TaskReportData taskReportData, int checkReportType) {
        this.taskInformation = taskReportData.getTaskInformation();
        this.taskReportFileInfo = taskReportData.getTaskReportFileInfo();
        this.checkReportType = checkReportType;
        this.excelHelper = new ExcelFileWtiterHelper();
        CheckReportNotifier.getInstance().addCheckReportNotificationListener(this);
    }

    private void buildOneDeviceCheckItemInfo(WritableSheet upgradeInfoSheet, Resource res) throws DCException {
        ExcelFileWtiterHelper.addCell(0, 0, TaskReportConstant.TASK_REPORT_STATUS_RESULT, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, 0, 4, 0);
        ExcelFileWtiterHelper.addCell(0, 1, TaskReportConstant.TASK_REPORT_DEVICE_NAME, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(1, 1, TaskReportConstant.TASK_REPORT_DEVICE_IP, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, 1, TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, 1, TaskReportConstant.TASK_REPORT_UPGRADE_COST_TIME, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(4, 1, TaskReportConstant.TASK_REPORT_OPERATION_RESULT, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(0, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getDeviceName()), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(1, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getDeviceIP()), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(2, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(res.getDeviceType()), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(3, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.upgradeInfoHelper.getUpgradeTimeInfo(res)), upgradeInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(4, 2, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.upgradeInfoHelper.getUpgradeResult(res)), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(0, 4, TaskReportConstant.TASK_REPORT_CHECK_ITEM_1, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, 4, 1, 4);
        ExcelFileWtiterHelper.addCell(2, 4, TaskReportConstant.TASK_REPORT_PRECHECK_RESULT, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, 4, TaskReportConstant.TASK_REPORT_POSTCHECK_RESULT, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(4, 4, TaskReportConstant.TASK_REPORT_STATUS_COMPARE_RESULT, this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        int rowIndex = 5;
        List<DevCheckNodeInfo> nodeLst = null;
        DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
        if (null != oDevCheckNodeInfo) {
            nodeLst = oDevCheckNodeInfo.getoDevCheckNodeInfoLst();
        }
        StringBuilder header = null;
        String nodeId = null;
        if (null != nodeLst) {
            for (DevCheckNodeInfo devCheckNodeInfo : nodeLst) {
                header = new StringBuilder();
                header.append(devCheckNodeInfo.getNodeName());
                header.append(".");
                nodeId = devCheckNodeInfo.getNodeId();
                List<DevCheckNodeInfo> tempNodeLst = devCheckNodeInfo.getDevCheckNodeInfoLst();
                if (tempNodeLst.size() <= 0) {
                    if (!nodeId.equals("CurrentConfig")) continue;
                    try {
                        devCheckNodeInfo.getCheckReportTable().getModel().getRow(0).get(0).setValue("CurrentConfig");
                        devCheckNodeInfo.getCheckReportTable().getModel().getRow(0).get(1).setValue("CurrentConfig");
                        rowIndex = this.parseTableContent(devCheckNodeInfo, rowIndex, header, upgradeInfoSheet);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                    continue;
                }
                rowIndex = this.parseTableContent(devCheckNodeInfo, rowIndex, header, upgradeInfoSheet);
            }
        }
        this.setbasicSheetColWidth(upgradeInfoSheet);
    }

    private int fillRowData(DevCheckNodeInfo devCheckNodeInfo, int startIndex, StringBuilder header, WritableSheet upgradeInfoSheet) throws DCException {
        int index = startIndex;
        String strHeader = header.toString();
        if (strHeader.endsWith(".")) {
            header.delete(header.length() - 1, header.length());
        }
        if (header.length() == 0) {
            throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        ICheckReportTableModel oICheckReportTableModel = checkReportTable.getModel();
        int rowCount = oICheckReportTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (0 == this.checkReportType) {
                ExcelFileWtiterHelper.addDataStrCell(0, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(header.toString()), upgradeInfoSheet);
                ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, index, 1, index);
                ExcelFileWtiterHelper.addDataStrCell(2, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 0).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(3, index, " --", upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(4, index, " --", upgradeInfoSheet);
            } else if (1 == this.checkReportType) {
                ExcelFileWtiterHelper.addDataStrCell(0, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(header.toString()), upgradeInfoSheet);
                ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, index, 1, index);
                ExcelFileWtiterHelper.addDataStrCell(2, index, " --", upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(3, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 0).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(4, index, " --", upgradeInfoSheet);
            } else if (2 == this.checkReportType) {
                ExcelFileWtiterHelper.addDataStrCell(0, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(header.toString()), upgradeInfoSheet);
                ExcelFileWtiterHelper.mergeCells(upgradeInfoSheet, 0, index, 1, index);
                ExcelFileWtiterHelper.addDataStrCell(2, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 0).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(3, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()), upgradeInfoSheet);
                String sStatus = oICheckReportTableModel.getValueAt(i, 2).getValue();
                int status = -1;
                try {
                    status = Integer.valueOf(sStatus);
                }
                catch (Exception e) {
                    DCDebugTracer.trace("status is not int");
                }
                boolean FAIL = false;
                if (0 == status) {
                    ExcelFileWtiterHelper.addCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.upgradeInfoHelper.getCompareResult(status)), this.excelHelper.getRedFormat(), upgradeInfoSheet);
                } else {
                    ExcelFileWtiterHelper.addDataStrCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.upgradeInfoHelper.getCompareResult(status)), upgradeInfoSheet);
                }
            } else {
                DCDebugTracer.traceError("receive msg server failed : checkReportType " + this.checkReportType);
            }
            ++index;
        }
        int position = header.indexOf(".");
        if (position != -1) {
            header.delete(position + 1, header.length());
        }
        return index;
    }

    synchronized boolean isRecOK() {
        return this.isRecOK;
    }

    synchronized boolean iswait() {
        return this.isWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCheckReportProgressNotification(ReportNotificationEvent event) {
        if (null == event) {
            return;
        }
        if (event.isLastMsg()) {
            if (event.getProgressErrorCode() == 0) {
                if (this.isLastDev()) {
                    CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
                }
                this.updateCheckItemInfo();
            } else {
                CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
                Object object = this.synObj;
                synchronized (object) {
                    this.synObj.notifyAll();
                }
                this.setWait(false);
                this.setRecOK(false);
                DCDebugTracer.traceError("receive msg server failed : " + event.getProgressErrorCode());
                return;
            }
        }
    }

    private int parseTableContent(DevCheckNodeInfo oCheckNodeInfo, int index, StringBuilder header, WritableSheet upgradeInfoSheet) throws DCException {
        int srartIndex = index;
        if (null == oCheckNodeInfo) {
            return srartIndex;
        }
        List<DevCheckNodeInfo> nodeLst = oCheckNodeInfo.getDevCheckNodeInfoLst();
        if (nodeLst.size() <= 0) {
            srartIndex = this.fillRowData(oCheckNodeInfo, srartIndex, header, upgradeInfoSheet);
        } else {
            for (DevCheckNodeInfo devCheckNodeInfo : nodeLst) {
                header.append(devCheckNodeInfo.getNodeName());
                header.append(".");
                srartIndex = this.parseTableContent(devCheckNodeInfo, srartIndex, header, upgradeInfoSheet);
            }
        }
        return srartIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCheckFailedReportFile() throws DCException {
        File reportFile = null;
        boolean isHaveException = false;
        try {
            this.upgradeInfoHelper = new UpgradeInfoHelper(this.taskInformation);
            this.upgradeInfoHelper.prepareData();
            this.resLst = this.upgradeInfoHelper.getResLst();
            WorkbookSettings ws = new WorkbookSettings();
            ws.setLocale(DCResourceMng.getInstance().getLocale());
            String filename = this.taskReportFileInfo.getFileName();
            String filePath = this.taskReportFileInfo.getFilePath();
            reportFile = new File(filePath + File.separator + filename + ".xls");
            this.workbook = Workbook.createWorkbook((File)reportFile, (Workbook)Workbook.getWorkbook((File)reportFile), (WorkbookSettings)ws);
            int numberOfSheets = this.workbook.getNumberOfSheets();
            int size = this.resLst.length;
            int count = 0;
            for (Resource res : this.resLst) {
                ++count;
                this.setRecOK(false);
                if (!TaskModelUtil.isOperationCompletedForResource(this.taskInformation, "PreCheck", res) || !TaskModelUtil.isOperationCompletedForResource(this.taskInformation, "PostCheck", res)) continue;
                ReportDataHelper.getInstance().getCheckReportDetails(this.taskInformation.getTaskId(), res, 2);
                this.setWait(true);
                if (size == count) {
                    this.setLastDev(true);
                } else {
                    this.setLastDev(false);
                }
                try {
                    while (this.iswait()) {
                        Object object = this.synObj;
                        synchronized (object) {
                            this.synObj.wait(50L);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    DCDebugTracer.trace(ex);
                }
                if (!this.isRecOK()) {
                    throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
                }
                WritableSheet upgradeInfoSheet = this.workbook.createSheet(res.getDeviceIP(), numberOfSheets);
                upgradeInfoSheet.getSettings().setShowGridLines(false);
                this.buildOneDeviceCheckItemInfo(upgradeInfoSheet, res);
                ++numberOfSheets;
            }
            boolean bIsMemoryAvailable = true;
            long lFreeMemoryAvail = 0L;
            long lFileSize = 0L;
            if (null != reportFile) {
                lFreeMemoryAvail = reportFile.getFreeSpace();
            }
            lFileSize = this.excelHelper.getExcelFileContentSize(this.workbook);
            if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
                isHaveException = true;
                bIsMemoryAvailable = false;
            }
            if (!bIsMemoryAvailable) throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_INSUFFICIENT_MEMORY"));
            this.workbook.write();
            return;
        }
        catch (DCException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            isHaveException = true;
            FileUtil.deleteReportFile(reportFile, this.workbook);
            DCDebugTracer.trace(e);
            throw new DCException(e.getMessage());
        }
        catch (Exception e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            isHaveException = true;
            FileUtil.deleteReportFile(reportFile, this.workbook);
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
        }
        finally {
            if (!isHaveException) {
                FileUtil.freeExcelReference(this.workbook);
            }
            this.setToNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveFile(IReportCreater oReportCreater, int iRange, int iMaxProgress) throws DCException {
        File reportFile = null;
        boolean isHaveException = false;
        try {
            this.upgradeInfoHelper = new UpgradeInfoHelper(this.taskInformation);
            this.upgradeInfoHelper.prepareData();
            this.resLst = this.upgradeInfoHelper.getResLst();
            WorkbookSettings ws = new WorkbookSettings();
            ws.setLocale(DCResourceMng.getInstance().getLocale());
            String filename = this.taskReportFileInfo.getFileName();
            String filePath = this.taskReportFileInfo.getFilePath();
            reportFile = new File(filePath + File.separator + filename + ".xls");
            this.workbook = Workbook.createWorkbook((File)reportFile, (Workbook)Workbook.getWorkbook((File)reportFile), (WorkbookSettings)ws);
            int numberOfSheets = this.workbook.getNumberOfSheets();
            int size = this.resLst.length;
            int count = 0;
            int iBegin = iMaxProgress - iRange;
            int iStep = iRange / size + 1;
            int iTmpCurDev = 0;
            Resource[] arr$ = this.resLst;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++numberOfSheets, ++i$) {
                Resource res = arr$[i$];
                this.setRecOK(false);
                ReportDataHelper.getInstance().getCheckReportDetails(this.taskInformation.getTaskId(), res, this.checkReportType);
                this.setWait(true);
                if (size == ++count) {
                    this.setLastDev(true);
                } else {
                    this.setLastDev(false);
                }
                try {
                    while (this.iswait()) {
                        Object object = this.synObj;
                        synchronized (object) {
                            this.synObj.wait(50L);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    DCDebugTracer.trace(ex);
                }
                if (!this.isRecOK()) {
                    throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
                }
                DCDebugTracer.trace("DC::task report receive ok res=" + res.getDeviceID());
                WritableSheet upgradeInfoSheet = this.workbook.createSheet(res.getDeviceIP(), numberOfSheets);
                upgradeInfoSheet.getSettings().setShowGridLines(false);
                this.buildOneDeviceCheckItemInfo(upgradeInfoSheet, res);
                oReportCreater.updateProgress(iBegin + iStep * ++iTmpCurDev, iMaxProgress);
            }
            boolean bIsMemoryAvailable = true;
            long lFreeMemoryAvail = 0L;
            long lFileSize = 0L;
            if (null != reportFile) {
                lFreeMemoryAvail = reportFile.getFreeSpace();
            }
            lFileSize = this.excelHelper.getExcelFileContentSize(this.workbook);
            if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
                isHaveException = true;
                bIsMemoryAvailable = false;
            }
            if (!bIsMemoryAvailable) throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_INSUFFICIENT_MEMORY"));
            this.workbook.write();
            return;
        }
        catch (DCException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            isHaveException = true;
            FileUtil.deleteReportFile(reportFile, this.workbook);
            DCDebugTracer.trace(e);
            throw new DCException(e.getMessage());
        }
        catch (Exception e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            isHaveException = true;
            FileUtil.deleteReportFile(reportFile, this.workbook);
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
        }
        finally {
            oReportCreater.updateProgress(iMaxProgress, iMaxProgress);
            if (!isHaveException) {
                FileUtil.freeExcelReference(this.workbook);
            }
            this.setToNull();
        }
    }

    private void setbasicSheetColWidth(WritableSheet upgradeInfoSheet) {
        upgradeInfoSheet.setColumnView(0, 40);
        upgradeInfoSheet.setColumnView(1, 50);
        upgradeInfoSheet.setColumnView(2, 40);
        upgradeInfoSheet.setColumnView(3, 40);
        upgradeInfoSheet.setColumnView(4, 15);
    }

    synchronized void setRecOK(boolean isRecOK) {
        this.isRecOK = isRecOK;
    }

    synchronized void setWait(boolean isWait) {
        this.isWait = isWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckItemInfo() {
        this.allCheckInfo = ReportDevInfoMap.getInstance().getDevCheckReportInfo();
        Object object = this.synObj;
        synchronized (object) {
            this.synObj.notifyAll();
        }
        this.setWait(false);
        this.setRecOK(true);
    }

    private void setToNull() {
        CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
    }
}

