/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.impl;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportNotifier;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ICheckReportNotificationListener;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ReportNotificationEvent;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportDevInfoMap;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.ReportDataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;

public class RouterCSVFileWriter
implements IFileWriter,
ICheckReportNotificationListener {
    private Map<Integer, DevCheckInfo> allCheckInfo = null;
    private int checkReportType;
    private boolean isRecOK = false;
    private boolean isWait = true;
    private Resource[] resLst;
    private String saveFilePath = null;
    private Object synObj = new Object();
    private ITask taskInformation;
    private TaskReportFileInfo taskReportFileInfo;
    private UpgradeInfoHelper upgradeInfoHelper = null;
    private boolean isLastDev;

    private boolean isLastDev() {
        return this.isLastDev;
    }

    private void setLastDev(boolean isLastDev) {
        this.isLastDev = isLastDev;
    }

    public RouterCSVFileWriter(TaskReportData taskReportData, int checkReportType) {
        this.taskInformation = taskReportData.getTaskInformation();
        this.taskReportFileInfo = taskReportData.getTaskReportFileInfo();
        this.checkReportType = checkReportType;
        CheckReportNotifier.getInstance().addCheckReportNotificationListener(this);
    }

    private void buildOneDeviceCheckItemInfo(Resource res) throws IOException, DCException {
        FileOutputStream oFileStream = null;
        OutputStreamWriter oWriter = null;
        BufferedWriter oBufferedWriter = null;
        StringBuilder strBuild = null;
        File file = null;
        try {
            file = new File(this.saveFilePath + File.separator + res.getDeviceIP() + ".csv");
            oFileStream = new FileOutputStream(file);
            oWriter = new OutputStreamWriter((OutputStream)oFileStream, FileUtil.getSystemEncoding());
            strBuild = new StringBuilder();
            oBufferedWriter = new BufferedWriter(oWriter);
            strBuild.append(TaskReportConstant.TASK_REPORT_STATUS_RESULT);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_NAME);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_IP);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_UPGRADE_COST_TIME);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_OPERATION_RESULT);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(res.getDeviceName());
            strBuild.append(",");
            strBuild.append(res.getDeviceIP());
            strBuild.append(",");
            strBuild.append(res.getDeviceType());
            strBuild.append(",");
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.upgradeInfoHelper.getUpgradeTimeInfo(res)));
            strBuild.append(",");
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.upgradeInfoHelper.getUpgradeResult(res)));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_CHECK_ITEM_1);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_PRECHECK_RESULT);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_POSTCHECK_RESULT);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_STATUS_COMPARE_RESULT);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
            List<DevCheckNodeInfo> nodeLst = null;
            DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
            if (null != oDevCheckNodeInfo) {
                nodeLst = oDevCheckNodeInfo.getoDevCheckNodeInfoLst();
            }
            if (null == nodeLst) {
                return;
            }
            StringBuilder header = null;
            String nodeId = null;
            String cellValue = null;
            for (DevCheckNodeInfo devCheckNodeInfo : nodeLst) {
                header = new StringBuilder();
                header.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(devCheckNodeInfo.getNodeName()));
                header.append(".");
                nodeId = devCheckNodeInfo.getNodeId();
                List<DevCheckNodeInfo> tempNodeLst = devCheckNodeInfo.getDevCheckNodeInfoLst();
                if (tempNodeLst.size() <= 0) {
                    CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
                    ICheckReportTableModel oICheckReportTableModel = checkReportTable.getModel();
                    cellValue = oICheckReportTableModel.getValueAt(0, 0).toString();
                    if (!nodeId.equals(cellValue)) continue;
                    this.parseTableContent(devCheckNodeInfo, header, oBufferedWriter);
                    continue;
                }
                this.parseTableContent(devCheckNodeInfo, header, oBufferedWriter);
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            FileUtil.deleteReportFile(file, oBufferedWriter, oWriter);
            DCDebugTracer.traceError(e.getMessage());
            throw new DCException(e.getMessage());
        }
        catch (IOException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            FileUtil.deleteReportFile(file, oBufferedWriter, oWriter);
            DCDebugTracer.traceError(e.getMessage());
            throw e;
        }
        finally {
            if (null != oBufferedWriter) {
                try {
                    oBufferedWriter.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != oWriter) {
                try {
                    oWriter.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != oFileStream) {
                try {
                    oFileStream.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    private void fillRowData(DevCheckNodeInfo devCheckNodeInfo, StringBuilder header, BufferedWriter oBufferedWriter) throws IOException, DCException {
        String strHeader = header.toString();
        if (strHeader.endsWith(".")) {
            header.delete(header.length() - 1, header.length());
        }
        if (header.length() == 0) {
            throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        StringBuilder strBuild = new StringBuilder();
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        ICheckReportTableModel oICheckReportTableModel = checkReportTable.getModel();
        int rowCount = oICheckReportTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (0 == this.checkReportType) {
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(header.toString()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 0).getValue()));
                strBuild.append(",");
                strBuild.append("--");
                strBuild.append(",");
                strBuild.append("--");
            } else if (1 == this.checkReportType) {
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(header.toString()));
                strBuild.append(",");
                strBuild.append("--");
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 0).getValue()));
                strBuild.append(",");
                strBuild.append("--");
            } else {
                if (2 != this.checkReportType) continue;
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(header.toString()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 0).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()));
                strBuild.append(",");
                String sStatus = oICheckReportTableModel.getValueAt(i, 2).getValue();
                int status = -1;
                try {
                    status = Integer.valueOf(sStatus);
                }
                catch (Exception e) {
                    DCDebugTracer.trace("status is not int");
                }
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(this.upgradeInfoHelper.getCompareResult(status)));
            }
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            oBufferedWriter.write(strBuild.toString());
            strBuild.delete(0, strBuild.length());
        }
        int index = header.indexOf(".");
        if (index != -1) {
            header.delete(index + 1, header.length());
        }
    }

    synchronized boolean isRecOK() {
        return this.isRecOK;
    }

    synchronized boolean iswait() {
        return this.isWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCheckReportProgressNotification(ReportNotificationEvent event) {
        if (null == event) {
            return;
        }
        if (event.isLastMsg()) {
            if (event.getProgressErrorCode() == 0) {
                if (this.isLastDev()) {
                    CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
                }
                this.updateCheckItemInfo();
            } else {
                CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
                Object object = this.synObj;
                synchronized (object) {
                    this.synObj.notifyAll();
                }
                this.setWait(false);
                this.setRecOK(false);
                DCDebugTracer.traceError("receive msg server failed : " + event.getProgressErrorCode());
                return;
            }
        }
    }

    private void setToNull() {
        CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
    }

    private void parseTableContent(DevCheckNodeInfo oCheckNodeInfo, StringBuilder header, BufferedWriter oBufferedWriter) throws IOException, DCException {
        if (null == oCheckNodeInfo) {
            return;
        }
        List<DevCheckNodeInfo> nodeLst = oCheckNodeInfo.getDevCheckNodeInfoLst();
        if (nodeLst.size() <= 0) {
            this.fillRowData(oCheckNodeInfo, header, oBufferedWriter);
        } else {
            for (DevCheckNodeInfo devCheckNodeInfo : nodeLst) {
                header.append(devCheckNodeInfo.getNodeName());
                header.append(".");
                this.parseTableContent(devCheckNodeInfo, header, oBufferedWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveFile(IReportCreater oReportCreater, int iRange, int iMaxProgress) throws DCException {
        this.upgradeInfoHelper = new UpgradeInfoHelper(this.taskInformation);
        this.upgradeInfoHelper.prepareData();
        this.resLst = this.upgradeInfoHelper.getResLst();
        String filename = this.taskReportFileInfo.getFileName();
        String filePath = this.taskReportFileInfo.getFilePath();
        this.saveFilePath = filePath + File.separator + filename;
        int iBegin = iMaxProgress - iRange;
        try {
            int size = this.resLst.length;
            int count = 0;
            int iStep = iRange / size + 1;
            Resource[] arr$ = this.resLst;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) {
                    this.setToNull();
                    return;
                }
                Resource res = arr$[i$];
                ReportDataHelper.getInstance().getCheckReportDetails(this.taskInformation.getTaskId(), res, this.checkReportType);
                this.setWait(true);
                this.setRecOK(false);
                if (size == ++count) {
                    this.setLastDev(true);
                } else {
                    this.setLastDev(false);
                }
                try {
                    while (this.iswait()) {
                        Object object = this.synObj;
                        synchronized (object) {
                            this.synObj.wait(50L);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    DCDebugTracer.trace(ex);
                }
                if (!this.isRecOK()) {
                    throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
                }
                this.buildOneDeviceCheckItemInfo(res);
                oReportCreater.updateProgress(iBegin + iStep * count, iMaxProgress);
                ++i$;
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
        }
    }

    synchronized void setRecOK(boolean isRecOK) {
        this.isRecOK = isRecOK;
    }

    synchronized void setWait(boolean isWait) {
        this.isWait = isWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckItemInfo() {
        this.allCheckInfo = ReportDevInfoMap.getInstance().getDevCheckReportInfo();
        Object object = this.synObj;
        synchronized (object) {
            this.synObj.notifyAll();
        }
        this.setWait(false);
        this.setRecOK(true);
    }
}

