/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel.bean;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportBean;
import java.io.File;

public class TaskReportFileInfo
extends TaskReportBean {
    private static final String DEFAULT_PATH = "report";
    private static final long serialVersionUID = -759499301514140952L;
    private String fileName;
    private String filePath;
    private int filetype;
    private boolean isSel;
    private String taskName;
    private String taskType;

    public TaskReportFileInfo(String taskName2, String strTaskType, String fileName2) {
        this.taskName = taskName2;
        this.taskType = strTaskType;
        this.fileName = fileName2;
    }

    public static String getDefaultFilePath() {
        String dot = ".";
        File file = new File(".");
        String filePath = file.getAbsolutePath();
        int index = filePath.lastIndexOf(".");
        if (index != -1) {
            filePath = filePath.substring(0, index);
        }
        return filePath + DEFAULT_PATH;
    }

    public static int getDefaultFileType() {
        if (StringUtils.isWinSystem()) {
            return 3;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskReportFileInfo other = (TaskReportFileInfo)obj;
        if (this.fileName == null) {
            if (other.fileName != null) {
                return false;
            }
        } else {
            if (!this.fileName.equals(other.fileName)) {
                return false;
            }
            DCDebugTracer.trace("fileName is the same");
        }
        if (this.taskName == null) {
            if (other.taskName != null) {
                return false;
            }
        } else {
            if (!this.taskName.equals(other.taskName)) {
                return false;
            }
            DCDebugTracer.trace("taskName is the same");
        }
        if (this.taskType == null) {
            if (other.taskType != null) {
                return false;
            }
        } else {
            if (!this.taskType.equals(other.taskType)) {
                return false;
            }
            DCDebugTracer.trace("taskType is the same");
        }
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        if (StringUtils.isNullOrEmptyStr(this.filePath)) {
            return TaskReportFileInfo.getDefaultFilePath();
        }
        return this.filePath;
    }

    public int getFiletype() {
        return this.filetype;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public boolean isSelect() {
        return this.isSel;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFiletype(int filetype) {
        this.filetype = filetype;
    }

    public void setSelect(boolean isSel) {
        this.isSel = isSel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.taskName == null ? 0 : this.taskName.hashCode());
        result = 31 * result + (this.taskType == null ? 0 : this.taskType.hashCode());
        return result;
    }
}

