/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.tasklevel;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import com.huawei.dc.taskmgmt.report.IReport;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportData;
import com.huawei.dc.taskmgmt.report.tasklevel.impl.RouterTaskReport;
import com.huawei.dc.taskmgmt.report.tasklevel.impl.SwitchBMSTaskReport;
import com.huawei.dc.taskmgmt.report.tasklevel.impl.T2000TaskReport;
import gnu.trove.THashSet;
import java.util.List;
import javax.swing.SwingUtilities;

public class TaskReportCreater
implements IReportCreater {
    private List<TaskReportData> allTaskReportDataLst = null;
    private int m_iTotalDevCount = 0;
    private ProgressDlg proDlg = null;
    private static final int TOTAL_PROGRESS = 100;
    private static final int INVAILD = -1;

    public TaskReportCreater(List<TaskReportData> tasksInfo, int iDevCount, ProgressDlg progressDlg) {
        this.allTaskReportDataLst = tasksInfo;
        this.m_iTotalDevCount = iDevCount;
        this.proDlg = progressDlg;
    }

    public void createTasksReport() {
        int iMaxProgress = 0;
        int iProgressStep = 100 / this.m_iTotalDevCount;
        if (iProgressStep < 1) {
            iProgressStep = 1;
        }
        for (TaskReportData taskReportData : this.allTaskReportDataLst) {
            ITask oTask = taskReportData.getTaskInformation();
            int iDevCountInTask = oTask.getDeviceType().getResources().size();
            if ((iMaxProgress += iProgressStep * iDevCountInTask) > 100) {
                iMaxProgress = 99;
            }
            int iTaskDomain = this.getTaskDomain(taskReportData);
            String strFileName = taskReportData.getTaskReportFileInfo().getFileName();
            if (1 == iTaskDomain) {
                this.createTaskReport(strFileName, iProgressStep * iDevCountInTask, iMaxProgress, new SwitchBMSTaskReport(taskReportData));
                continue;
            }
            if (2 == iTaskDomain) {
                DeviceType deviceType = oTask.getDeviceType();
                boolean isSupport = deviceType.isUpgradeModeSupportedByAllDevices(4096);
                if (isSupport) {
                    this.createTaskReport(strFileName, iProgressStep * iDevCountInTask, iMaxProgress, new RouterTaskReport(taskReportData, this.getCheckReportType(oTask)));
                    continue;
                }
                this.createTaskReport(strFileName, iProgressStep * iDevCountInTask, iMaxProgress, new SwitchBMSTaskReport(taskReportData));
                continue;
            }
            if (4 == iTaskDomain) {
                this.createTaskReport(strFileName, iProgressStep * iDevCountInTask, iMaxProgress, new T2000TaskReport(taskReportData, this.getCheckReportType(taskReportData.getTaskInformation())));
                continue;
            }
            DCDebugTracer.trace("invalid domain");
        }
        this.updateProgress(100);
    }

    private void createTaskReport(String strFileName, int iRange, int iMaxProgress, IReport oTaskReport) {
        DCDebugTracer.trace(this.getClass().getName() + " [task report] createTaskReport start");
        DCDebugTracer.trace(this.getClass().getName() + " [task report] strFileName : " + strFileName);
        DCDebugTracer.trace(this.getClass().getName() + " [task report] iProgress : " + iRange);
        String errMsg = null;
        try {
            oTaskReport.bulidReport(this, iRange, iMaxProgress);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            errMsg = e.getMessage();
        }
        if (StringUtils.isNullOrEmptyStr(errMsg)) {
            errMsg = ResourceManager.getInstance().getResString("SAVE_SUCCESS");
        }
        this.handleUpdateProgress(strFileName, errMsg, iMaxProgress);
        DCDebugTracer.trace(this.getClass().getName() + " [task report] createTaskReport end..");
    }

    private void handleUpdateProgress(final String strDisplayName, final String strOpResult, final int iProgress) {
        if (0 > iProgress || iProgress > 100) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskReportCreater.this.proDlg.addRowInModel(strDisplayName, strOpResult);
                TaskReportCreater.this.proDlg.updateProgress(iProgress);
            }
        });
    }

    public void updateProgress(final int iProgress) {
        if (0 > iProgress || iProgress > 100) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskReportCreater.this.proDlg.updateProgress(iProgress);
            }
        });
    }

    @Override
    public void updateProgress(final int iProgress, int iMaxProgress) {
        if (0 > iProgress || iProgress > 100) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskReportCreater.this.proDlg.updateProgress(iProgress);
            }
        });
    }

    private int getTaskDomain(TaskReportData taskReportData) {
        DeviceType deviceType;
        int iTaskDomain = 5;
        ITask ITask2 = taskReportData.getTaskInformation();
        if (null != ITask2 && null != (deviceType = ITask2.getDeviceType())) {
            iTaskDomain = deviceType.getDeviceDomain();
        }
        return iTaskDomain;
    }

    private int getCheckReportType(ITask taskInfo) {
        boolean bSelPrecheck = this.isChckOpeSel(taskInfo, "PreCheck");
        THashSet<Resource> oResourceList = taskInfo.getDeviceType().getResources();
        boolean bCompletePrecheck = this.isSomeNEChckOpeSuccess(taskInfo, "PreCheck", bSelPrecheck, oResourceList);
        boolean bSelPostcheck = this.isChckOpeSel(taskInfo, "PostCheck");
        boolean bCompletePostcheck = this.isSomeNEChckOpeSuccess(taskInfo, "PostCheck", bSelPrecheck, oResourceList);
        int result = -1;
        result = bSelPrecheck ? this.handleSelPreCheck(bCompletePrecheck, bSelPostcheck, bCompletePostcheck) : this.handleOnlyPostCheck(bSelPostcheck, bCompletePostcheck);
        return result;
    }

    private int handleSelPreCheck(boolean bCmpltPrchck, boolean bSlPstchck, boolean bCmpltPstchck) {
        int result = bSlPstchck ? (bCmpltPrchck ? (bCmpltPstchck ? 2 : 0) : -1) : (bCmpltPrchck ? 0 : -1);
        return result;
    }

    private int handleOnlyPostCheck(boolean bSelPostcheck, boolean bCompletePostcheck) {
        int result = bSelPostcheck ? (bCompletePostcheck ? 1 : -1) : -1;
        return result;
    }

    private boolean isChckOpeSel(ITask taskInfo, String checkItem) {
        boolean bSelcheck = false;
        if (StringUtils.isNullOrEmptyStr(checkItem)) {
            return bSelcheck;
        }
        ICheckOperation oCheckOp = (ICheckOperation)TaskModelUtil.getOperationFromTask(taskInfo.getTaskId(), checkItem);
        if (null != oCheckOp && oCheckOp.isSelected()) {
            bSelcheck = true;
        }
        return bSelcheck;
    }

    private boolean isSomeNEChckOpeSuccess(ITask taskInfo, String checkItem, boolean isSel, THashSet<Resource> oResourceList) {
        boolean bSomeNESuccess = false;
        if (StringUtils.isNullOrEmptyStr(checkItem)) {
            return bSomeNESuccess;
        }
        if (isSel) {
            bSomeNESuccess = TaskModelUtil.isSomeNEOperationSucess(taskInfo, checkItem, oResourceList);
        }
        return bSomeNESuccess;
    }

    @Override
    public int getCurProgress() {
        return this.proDlg.getCurProgress();
    }
}

