/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCGetDetailResultRsp;
import com.huawei.dc.common.components.table.renderer.TooltipHeader;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.view.DefaultTreeTableHeaderRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.components.treetable.view.ReportTreeTableRenderer;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.compare.CompareFileDialog;
import com.huawei.dc.compare.datasource.ConfigFileControl;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportDevInfoMap;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellRenderer;

public class ReportTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSortTreeTable m_oReportTreeTable;
    private DCTreeTableModel m_oReportTreeTableModel;
    private JScrollPane m_oReportTableScrollPane;
    private ResourceManager m_resMgr = ResourceManager.getInstance();
    private TreeTableNode m_oRootNode;
    private JTree m_oTree;
    private int iDomain = -1;
    private int iTaskId = -1;
    private int iReportType = -1;

    public ReportTablePanel(String[] treeTableHeader) {
        this.setLayout(new BorderLayout());
        this.constructReportTree(treeTableHeader);
        this.m_oReportTreeTable.updateUI();
        this.expandAll();
        this.add((Component)this.m_oReportTableScrollPane, "Center");
    }

    public ReportTablePanel(String[] treeTableHeader, int domain, int taskId, int reportType) {
        this(treeTableHeader);
        this.iDomain = domain;
        this.iTaskId = taskId;
        this.iReportType = reportType;
        this.setLayout(new BorderLayout());
        this.constructReportTree(treeTableHeader);
        this.m_oReportTreeTable.updateUI();
        this.expandAll();
        this.add((Component)this.m_oReportTableScrollPane, "Center");
    }

    public void expandAll() {
        this.m_oTree = this.m_oReportTreeTable.getTree();
        int count = this.m_oTree.getRowCount();
        try {
            for (int i = 0; i < count; ++i) {
                this.m_oTree.expandRow(i);
                count = this.m_oTree.getRowCount();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void constructReportTree(String[] treeTableHeader) {
        this.m_oReportTreeTableModel = this.initTreeTableModel(treeTableHeader);
        this.m_oReportTreeTable = this.initTreeTable(this.m_oReportTreeTableModel);
        this.m_oTree = this.m_oReportTreeTable.getTree();
        String name = this.m_oReportTreeTable.getName();
        if (null == name || name.isEmpty()) {
            this.m_oReportTreeTable.setName("Report_View_ReportTablePanel_m_oReportTreeTable");
            this.m_oTree.setName("DeviceManager_Report_View_ReportTablePanel_m_oTree");
        } else {
            String postfix = name.substring(name.length() - 2);
            this.m_oTree.setName("DeviceManager_Report_View_ReportTablePanel_m_oTree" + postfix);
        }
        this.m_oReportTableScrollPane = new JScrollPane();
        this.m_oReportTreeTable.setFillsViewportHeight(true);
        this.m_oReportTableScrollPane.setViewportView((Component)((Object)this.m_oReportTreeTable));
        this.m_oRootNode = this.m_oReportTreeTableModel.getRoot();
        DefaultTreeTableHeaderRenderer defaultTreeTableHeaderRenderer = new DefaultTreeTableHeaderRenderer();
        ReportTreeTableRenderer treeTableCellRenderer = new ReportTreeTableRenderer(this.m_oReportTreeTable);
        defaultTreeTableHeaderRenderer.setAlign(0);
        treeTableCellRenderer.setBorder(BorderFactory.createEmptyBorder());
        this.m_oTree.setCellRenderer(new ReportTreeRenderer());
        int columns = treeTableHeader.length;
        for (int i = 1; i < columns; ++i) {
            this.m_oReportTreeTable.getColumnModel().getColumn(i).setHeaderRenderer(defaultTreeTableHeaderRenderer);
            this.m_oReportTreeTable.getColumnModel().getColumn(i).setCellRenderer(treeTableCellRenderer);
            this.m_oReportTreeTable.getColumnModel().getColumn(i).setMinWidth(50);
            this.m_oReportTreeTable.getColumnModel().getColumn(i).setPreferredWidth(100);
        }
        if (2 == this.iDomain) {
            this.m_oReportTreeTable.getColumnModel().getColumn(columns - 2).setCellEditor(new ViewCMDResultLinkEditor());
            TableColumn reportNameColumn = this.m_oReportTreeTable.getColumnModel().getColumn(columns - 1);
            reportNameColumn.setMinWidth(0);
            reportNameColumn.setPreferredWidth(0);
            reportNameColumn.setMaxWidth(0);
        }
        TooltipHeader tableHeader = new TooltipHeader(this.m_oReportTreeTable.getColumnModel(), treeTableHeader);
        this.m_oReportTreeTable.setTableHeader(tableHeader);
        this.m_oReportTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oReportTreeTable.getTableHeader().repaint();
        this.m_oReportTableScrollPane.setBackground(this.m_oReportTableScrollPane.getBackground());
        this.m_oReportTreeTable.getColumnModel().getColumn(0).setMinWidth(120);
        this.m_oReportTreeTable.getColumnModel().getColumn(0).setPreferredWidth(120);
    }

    private DCTreeTableModel initTreeTableModel(String[] tableHeaderFields) {
        if (null == tableHeaderFields || 2 > tableHeaderFields.length) {
            return null;
        }
        int columns = tableHeaderFields.length;
        Class[] arrColumnTypes = new Class[columns];
        boolean[] arrSortableColumns = new boolean[columns];
        boolean[] arrEditableColumns = new boolean[columns];
        arrColumnTypes[0] = TreeTableModel.class;
        arrSortableColumns[0] = true;
        arrEditableColumns[0] = true;
        for (int i = 1; i < columns; ++i) {
            arrColumnTypes[i] = String.class;
            arrSortableColumns[i] = false;
            arrEditableColumns[i] = false;
        }
        if (2 == this.iDomain) {
            arrEditableColumns[columns - 2] = true;
        }
        return new DCTreeTableModel(tableHeaderFields, arrColumnTypes, arrSortableColumns, arrEditableColumns);
    }

    private JSortTreeTable initTreeTable(DCTreeTableModel treeTableModel) {
        JSortTreeTable oReportTreeTable = new JSortTreeTable(treeTableModel, true);
        oReportTreeTable.setBackground(Color.WHITE);
        oReportTreeTable.setOpaque(false);
        oReportTreeTable.getTableHeader().setReorderingAllowed(false);
        oReportTreeTable.getTree().setToggleClickCount(1);
        int colNum = oReportTreeTable.getColumnCount();
        if (colNum > 6) {
            oReportTreeTable.setAutoResizeMode(0);
        }
        return oReportTreeTable;
    }

    public void disposePanel() {
        this.m_oReportTreeTable = null;
        this.m_oReportTreeTableModel = null;
        this.m_oReportTableScrollPane = null;
        this.m_oRootNode.removeAllChildren();
        this.m_oRootNode = null;
        this.m_resMgr = null;
    }

    public void recreateTable(String[] columns) {
        int iCnt = columns.length;
        int iColumnCount = this.m_oReportTreeTable.getColumnCount();
        int iBase = 0;
        if (iCnt >= iColumnCount) {
            for (iBase = 0; iBase < iColumnCount; ++iBase) {
                this.m_oReportTreeTable.getColumnModel().getColumn(iBase).setHeaderValue(columns[iBase]);
            }
            TableColumn column = null;
            int iDif = iCnt - iColumnCount;
            for (int i = 0; i < iDif; ++i) {
                column = new TableColumn();
                column.setHeaderValue(columns[iBase++]);
                this.m_oReportTreeTable.getColumnModel().addColumn(column);
            }
        } else {
            for (iBase = 0; iBase < iCnt; ++iBase) {
                this.m_oReportTreeTable.getColumnModel().getColumn(iBase).setHeaderValue(columns[iBase]);
            }
            TableColumn column = null;
            int iDif = iColumnCount - iCnt;
            for (int i = 0; i < iDif; ++i) {
                column = this.m_oReportTreeTable.getColumnModel().getColumn(iBase++);
                this.m_oReportTreeTable.removeColumn(column);
            }
        }
        this.clearTableData();
        this.resreshTreeTable();
    }

    public TreeTableNode getRootNode() {
        return this.m_oRootNode;
    }

    public void clearTableData() {
        this.m_oReportTreeTableModel.getRoot().removeAllChildren();
    }

    public void resreshTreeTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReportTablePanel.this.m_oReportTreeTable.getTableHeader().updateUI();
                ReportTablePanel.this.m_oReportTreeTable.updateUI();
                ReportTablePanel.this.m_oReportTreeTable.getTree().updateUI();
                ReportTablePanel.this.expandAll();
            }
        });
    }

    public JSortTreeTable getReportTreeTable() {
        return this.m_oReportTreeTable;
    }

    public void setReportTreeTable(JSortTreeTable reportTreeTable) {
        this.m_oReportTreeTable = reportTreeTable;
    }

    public DCTreeTableModel getReportTreeTableModel() {
        return this.m_oReportTreeTableModel;
    }

    private int getSelectDeviceID() {
        ReportDevInfoMap reportDevInfoMap = ReportDevInfoMap.getInstance();
        Map<Integer, DevCheckInfo> devCheckReportInfo = reportDevInfoMap.getDevCheckReportInfo();
        Set<Map.Entry<Integer, DevCheckInfo>> selDeviceCheckRepMap = devCheckReportInfo.entrySet();
        int devId = -1;
        Iterator<Map.Entry<Integer, DevCheckInfo>> selDeviceCheckRepItr = selDeviceCheckRepMap.iterator();
        Map.Entry<Integer, DevCheckInfo> selDeviceCheckRepEntry = null;
        if (selDeviceCheckRepItr.hasNext()) {
            selDeviceCheckRepEntry = selDeviceCheckRepItr.next();
            devId = selDeviceCheckRepEntry.getKey();
        }
        return devId;
    }

    private class ReportTreeRenderer
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private ReportTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree oTree, Object oValue, boolean bIsSelected, boolean bIsExpanded, boolean bIsLeaf, int iRow, boolean bHasFocus) {
            Vector ver;
            TreeTableNode oNode;
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            oLabel.setIconTextGap(8);
            oLabel.setBorder(ReportTablePanel.this.getBorder());
            String displayName = "";
            if (oValue instanceof TreeTableNode && (oNode = (TreeTableNode)oValue).getUserObject() instanceof Vector && (ver = (Vector)oNode.getUserObject()).size() > 0) {
                Object object = ver.get(0);
                displayName = object instanceof TreeTableNodeCellData ? ((TreeTableNodeCellData)object).getCellDataValue().toString() : (object instanceof CheckReportTableCell ? ((CheckReportTableCell)object).getValue() : "");
            }
            if (ReportTablePanel.this.m_oReportTreeTable.isRowSelected(iRow)) {
                oLabel.setBackground(ReportTablePanel.this.m_oReportTreeTable.getSelectionBackground());
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setBackground(ReportTablePanel.this.m_oReportTreeTable.getBackground());
                oLabel.setForeground(ReportTablePanel.this.m_oReportTreeTable.getForeground());
            }
            oLabel.setText(displayName);
            oLabel.setBorder(null);
            return oLabel;
        }
    }

    private class ViewCMDResultLinkEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1349229278805824882L;
        private JButton m_oLinkButton = new JButton();
        private String m_strCheckItem = null;

        public ViewCMDResultLinkEditor() {
            this.m_oLinkButton.setBackground(Color.gray);
            this.m_oLinkButton.setRolloverEnabled(true);
            this.m_oLinkButton.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComponent oComponent = null;
            Object lastColCell = table.getValueAt(row, table.getColumnCount() - 1);
            if (lastColCell instanceof String && value instanceof String && !value.equals("")) {
                this.m_strCheckItem = lastColCell.toString();
                this.m_oLinkButton.setText(value.toString());
                this.m_oLinkButton.setToolTipText(value.toString());
                this.m_oLinkButton.setHorizontalAlignment(2);
                oComponent = this.m_oLinkButton;
            } else {
                JLabel oLabel = new JLabel();
                oLabel.setOpaque(true);
                String strVal = "";
                oLabel.setText(strVal);
                oLabel.setBorder(ReportTablePanel.this.getBorder());
                oComponent = oLabel;
            }
            ((Component)oComponent).setBackground(ReportTablePanel.this.m_oReportTreeTable.getSelectionBackground());
            ((Component)oComponent).setForeground(Color.white);
            return oComponent;
        }

        @Override
        public void actionPerformed(ActionEvent oEvent) {
            this.updateButtonView();
            if (2 == ReportTablePanel.this.iReportType) {
                List<String> cmdReslut = this.getCommandResultInfo();
                if (null == cmdReslut || 2 != cmdReslut.size()) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ReportTablePanel.this.m_resMgr.getResString("COMPARE_PARAMETER_ERROR"), ReportTablePanel.this.m_resMgr.getResString("ERROR"), 0);
                } else {
                    CompareFileDialog dialog = new CompareFileDialog((Frame)DCFrameWorkUtil.getMainFrame(), ReportTablePanel.this.m_resMgr.getResString("Check_Reports_Title"), true);
                    dialog.setCompareContentAndInfo(ReportTablePanel.this.m_resMgr.getResString("PRECHECK_COMMAND_RESULT"), cmdReslut.get(0), ReportTablePanel.this.m_resMgr.getResString("POSTCHECK_COMMAND_RESULT"), cmdReslut.get(1));
                    ConfigFileControl.releaseResource();
                    dialog.setVisible(true);
                }
            } else {
                List<String> cmdReslut = this.getCommandResultInfo();
                if (null != cmdReslut) {
                    ViewCommandResultDialog dialog = new ViewCommandResultDialog(cmdReslut.get(0));
                    dialog.setTitle(ReportTablePanel.this.m_resMgr.getResString("VIEW_COMMAND_RESULT_TITLE"));
                    dialog.setVisible(true);
                }
            }
            this.fireEditingStopped();
            this.updateButtonView();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReportTablePanel.this.m_oReportTreeTable.updateUI();
                }
            });
        }

        public List<String> getCommandResultInfo() {
            List<String> oTaskResultList = null;
            AsnDCGetDetailResultRsp oAsnDCGetDetailResultRsp = null;
            try {
                oAsnDCGetDetailResultRsp = TaskSyncCommController.getInstance().getDetailsResultList(ReportTablePanel.this.iTaskId, ReportTablePanel.this.getSelectDeviceID(), ReportTablePanel.this.iReportType, this.m_strCheckItem);
            }
            catch (DCException exception) {
                DCDebugTracer.traceError(exception.getMessage());
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ReportTablePanel.this.m_resMgr.getResString("GET_COMMAND_RESULT_ERROR"), ReportTablePanel.this.m_resMgr.getResString("ERROR"), 0);
            }
            if (null != oAsnDCGetDetailResultRsp && 3 != oAsnDCGetDetailResultRsp.enOperationId.value) {
                oTaskResultList = TaskCommUtil.getCommandResultList(oAsnDCGetDetailResultRsp.oAsnDCGetCommandResultRsp);
            }
            return oTaskResultList;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        private void updateButtonView() {
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, ReportTablePanel.this.m_oReportTreeTable.getBackground());
            this.m_oLinkButton.setBorder(oMatteBorder);
            this.m_oLinkButton.setBackground(ReportTablePanel.this.m_oReportTreeTable.getBackground());
            String strOplink = "<html><a href=\"x\">" + ReportTablePanel.this.m_resMgr.getResString("CHECK_REPORT_VIEW_DETAIL") + "</a></html>";
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
            this.m_oLinkButton.setBackground(ReportTablePanel.this.m_oReportTreeTable.getSelectionBackground());
            this.m_oLinkButton.setForeground(Color.white);
        }
    }
}

