/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ReportSaveFileFilter;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.configtree.ConfigTreePanel;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.report.devlevel.ISaveFile;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportDevInfoMap;
import com.huawei.dc.taskmgmt.report.devlevel.view.ReportTableMainPanel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public abstract class ReportDlg
extends DCModalDialog
implements DCTreeEventListener {
    private static final long serialVersionUID = -4739158741025102526L;
    protected ITask m_oTask = null;
    protected ConfigTreePanel m_oLeftTreePanel = null;
    protected JTextPane m_oRightReportTitlePanel = null;
    protected JPanel m_oRightPagePanel = null;
    protected JPanel m_oRightRadioBtnPanel = null;
    protected ReportTableMainPanel m_oRightTableMainPanel = null;
    protected JPanel m_oCloseBtnPanel = null;
    protected DevCheckNodeInfo m_oDevCheckNodeInfo = null;
    protected DevCheckNodeInfo m_oCurSelectedNodeInfo = null;
    protected ResourceManager m_resMgr = ResourceManager.getInstance();
    protected static final int DLG_WIDTH = 750;
    protected static final int DLG_HEIGHT = 450;
    protected int iReportType = -1;
    protected String m_strReportGenerateTime = "";
    protected int iViewStatus = 1;
    protected JRadioButton m_rbViewDiffence = null;
    protected JRadioButton m_rbViewAll = null;

    public ReportDlg(DevCheckNodeInfo oDevCheckNodeInfo, int reportType, ITask task) {
        this.m_oDevCheckNodeInfo = oDevCheckNodeInfo;
        this.iReportType = reportType;
        this.m_oTask = task;
        this.setResizable(true);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle(ResourceManager.getInstance().getResString("Check_Reports_Title"));
        this.initTreePanel();
        this.initRightReportTitlePanel();
        this.initRadiBtnPanel();
        this.initTablePanel(this.m_resMgr.getResString("CHECK_REPORT_CONFIG_TREE_ROOT"));
        this.initButtonPanel();
        this.addAllComponent();
        this.addActinListener();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    public void initRightReportTitlePanel() {
        this.m_oRightReportTitlePanel = new JTextPane();
        this.m_oRightReportTitlePanel.setName("Report_View_ReportDlg_m_oRightReportTitlePanel");
        this.m_oRightReportTitlePanel.setEditable(false);
        this.m_oRightReportTitlePanel.setContentType("text/html");
        this.m_oRightReportTitlePanel.setText(this.getRightReportTitle().toString());
        this.m_oRightReportTitlePanel.setPreferredSize(new Dimension(495, 130));
        this.m_oRightReportTitlePanel.setMinimumSize(new Dimension(495, 130));
        this.m_oRightReportTitlePanel.setBackground(DCFrameWorkUtil.getBackgroundColor());
    }

    private void initTreePanel() {
        if (null == this.m_oDevCheckNodeInfo) {
            return;
        }
        ConfigTreeNodeInfo oConfigTreeNodeInfo = this.getLeftContent(this.m_oDevCheckNodeInfo);
        oConfigTreeNodeInfo.setTreeType(1);
        this.m_oLeftTreePanel = new ConfigTreePanel(oConfigTreeNodeInfo, this.m_oTask);
        this.m_oLeftTreePanel.setName("devicemanagement_ReportDlg_m_oLeftTreePanel");
        this.m_oLeftTreePanel.setPreferredSize(new Dimension(250, 500));
        this.m_oLeftTreePanel.setMinimumSize(new Dimension(250, 500));
    }

    protected void initRadiBtnPanel() {
        this.m_oRightRadioBtnPanel = new JPanel();
        this.m_oRightRadioBtnPanel.setLayout(new FlowLayout(0, 0, 5));
        this.m_rbViewDiffence = new JRadioButton();
        this.m_rbViewDiffence.setFocusable(false);
        this.m_rbViewDiffence.setName("DMSReportDlg_m_rbViewDiffence");
        if (2 == this.iReportType) {
            this.m_rbViewDiffence.setText(this.m_resMgr.getResString("DMSReportDlg_View_Diffence"));
        } else {
            this.m_rbViewDiffence.setText(this.m_resMgr.getResString("DMSReportDlg_View_Failed"));
        }
        this.m_oRightRadioBtnPanel.add(this.m_rbViewDiffence);
        this.m_oRightRadioBtnPanel.add(Box.createHorizontalStrut(50));
        this.m_rbViewDiffence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReportDlg.this.viewDifferentCheckItem();
            }
        });
        this.m_rbViewAll = new JRadioButton();
        this.m_rbViewAll.setFocusable(false);
        this.m_rbViewAll.setName("DMSReportDlg_m_rbViewAll");
        this.m_rbViewAll.setText(this.m_resMgr.getResString("DMSReportDlg_View_All"));
        this.m_oRightRadioBtnPanel.add(this.m_rbViewAll);
        this.m_rbViewAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReportDlg.this.viewAllCheckItem();
            }
        });
        ButtonGroup viewButtonGrp = new ButtonGroup();
        viewButtonGrp.add(this.m_rbViewDiffence);
        viewButtonGrp.add(this.m_rbViewAll);
        this.m_rbViewDiffence.setSelected(true);
    }

    protected abstract void viewAllCheckItem();

    public abstract void viewDifferentCheckItem();

    protected abstract void initTablePanel(String var1);

    protected abstract void addAllComponent();

    protected void addActinListener() {
        this.m_oLeftTreePanel.addDeviceTreeEventListener(this);
    }

    protected ConfigTreeNodeInfo getLeftContent(DevCheckNodeInfo nodeInfo) {
        ConfigTreeNodeInfo configTreeNodeInfo = null;
        if (null != nodeInfo && nodeInfo.isCheckItem()) {
            configTreeNodeInfo = new ConfigTreeNodeInfo();
            configTreeNodeInfo.setTreeType(1);
            configTreeNodeInfo.setNodeID(nodeInfo.getNodeId());
            configTreeNodeInfo.getConfigNodeAttr().setNodeName(this.m_resMgr.getResString(nodeInfo.getNodeName()));
            configTreeNodeInfo.getConfigNodeAttrEx().setStatus(nodeInfo.getStatus());
            ConfigTreeNodeInfo oTmpTreeNodeInfo = null;
            for (int i = 0; i < nodeInfo.getDevCheckNodeInfoLst().size(); ++i) {
                oTmpTreeNodeInfo = this.getLeftContent(nodeInfo.getDevCheckNodeInfoLst().get(i));
                oTmpTreeNodeInfo.setParentID(nodeInfo.getNodeId());
                configTreeNodeInfo.getNodeInfoLst().add(oTmpTreeNodeInfo);
            }
        }
        return configTreeNodeInfo;
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject eventObject) {
    }

    @Override
    protected String getCurrentContext() {
        String sHelpID = "";
        switch (this.iReportType) {
            case 0: {
                sHelpID = "HELP_TOPIC_TASK_VIEW_PRE_CHECK_REPORT";
                break;
            }
            case 1: {
                sHelpID = "HELP_TOPIC_TASK_VIEW_POST_CHECK_REPORT";
                break;
            }
            case 2: {
                sHelpID = "HELP_TOPIC_TASK_VIEW_COMPARE_CHECK_REPORT";
                break;
            }
            default: {
                sHelpID = "HELP_TOPIC_TASK_VIEW_TASK_REPORT";
            }
        }
        return sHelpID;
    }

    protected void initButtonPanel() {
        this.m_oCloseBtnPanel = new JPanel();
        this.m_oCloseBtnPanel.setPreferredSize(new Dimension(250, 21));
        this.m_oCloseBtnPanel.setMinimumSize(new Dimension(250, 21));
        this.m_oCloseBtnPanel.setName("devicemanagement_ReportDlg_m_oCloseBtnPanel");
        GridBagLayout layout = new GridBagLayout();
        this.m_oCloseBtnPanel.setLayout(layout);
        this.m_oOKBtn.setText(this.m_resMgr.getResString("DEVICETABLE_POPUP_MENU_ITEM_SAVE"));
        this.m_oOKBtn.setMnemonic(83);
        this.m_oOKBtn.setPreferredSize(new Dimension(100, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(100, 21));
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportDlg.this.oKButtonActionPerformed();
            }
        });
        this.m_oCancelBtn.setText(this.m_resMgr.getResString("CLOSE"));
        this.m_oCancelBtn.setMnemonic(67);
        this.m_oCancelBtn.setPreferredSize(new Dimension(100, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(100, 21));
        this.m_oCloseBtnPanel.add(Box.createVerticalStrut(2), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.m_oCloseBtnPanel.add((Component)this.m_oOKBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 2, 0), 0, 0));
        this.m_oCloseBtnPanel.add((Component)this.m_oCancelBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 12, 2, 0), 0, 0));
    }

    protected abstract void oKButtonActionPerformed();

    public TreeTableNode constructNode(String[] treeTableRoot) {
        if (null == treeTableRoot || 2 > treeTableRoot.length) {
            return null;
        }
        int columns = treeTableRoot.length;
        Vector<Object> oRow = new Vector<Object>(columns);
        TreeTableNodeCellData oNodeData = new TreeTableNodeCellData(treeTableRoot[0]);
        oRow.add(0, oNodeData);
        for (int i = 1; i < columns; ++i) {
            oRow.add(i, treeTableRoot[i]);
        }
        TreeTableNode node = new TreeTableNode(oRow);
        oNodeData.setAttachedTreeNode(node);
        return node;
    }

    public void addNewRow(CheckReportTableCell[] cellValues, TreeTableNode treeNode) {
        TreeTableNode oChildTableNode = this.constructNode(cellValues);
        if (null == oChildTableNode || null == treeNode) {
            return;
        }
        treeNode.add(oChildTableNode);
    }

    public TreeTableNode constructNode(CheckReportTableCell[] cellValues) {
        if (cellValues == null || 2 > cellValues.length) {
            return null;
        }
        int colums = cellValues.length;
        Vector<CheckReportTableCell> oRow = new Vector<CheckReportTableCell>(3);
        for (int i = 0; i < colums; ++i) {
            oRow.add(cellValues[i]);
        }
        TreeTableNode treeTableNode = new TreeTableNode(oRow);
        return treeTableNode;
    }

    public void addNewRow(List<CheckReportTableCell> cellValues, TreeTableNode treeNode) {
        if (cellValues == null || 2 > cellValues.size()) {
            return;
        }
        this.addNewRow(cellValues.toArray(new CheckReportTableCell[0]), treeNode);
    }

    protected StringBuffer getCurrentTime() {
        Calendar instance = Calendar.getInstance();
        StringBuffer strTime = new StringBuffer("");
        int curMonth = instance.get(2) + 1;
        strTime.append(instance.get(1));
        strTime.append(this.convertDateTimeStr(curMonth));
        strTime.append(this.convertDateTimeStr(instance.get(5)));
        strTime.append(this.convertDateTimeStr(instance.get(11)));
        strTime.append(this.convertDateTimeStr(instance.get(12)));
        strTime.append(this.convertDateTimeStr(instance.get(13)));
        return strTime;
    }

    private String convertDateTimeStr(int value) {
        String current = "00" + value;
        int length = current.length();
        current = current.substring(length - 2);
        return current;
    }

    protected StringBuffer getRightReportTitle() {
        int domain = this.m_oTask.getDeviceType().getDeviceDomain();
        StringBuffer strTitle = new StringBuffer("<html><table width=\"100%\">");
        strTitle.append("<tr><th colspan= \"4\">");
        strTitle.append(this.getReportTittle(this.iReportType));
        strTitle.append("</th></tr>");
        strTitle.append("<tr><td nowrap>");
        String str5 = this.m_resMgr.getResString("RPT_GENERATION_TIME") + " :";
        strTitle.append(str5);
        strTitle.append("</td>");
        this.m_strReportGenerateTime = this.getCurrentTime().toString();
        if (2 == domain) {
            strTitle.append("<td nowrap colspan= \"3\">");
            strTitle.append(this.m_strReportGenerateTime);
            strTitle.append("</td></tr>");
        } else if (2 == this.iReportType) {
            strTitle.append("<td nowrap>");
            strTitle.append(this.m_strReportGenerateTime);
            strTitle.append("</td>");
            strTitle.append("<td nowrap colspan= \"2\">");
            strTitle.append(this.m_resMgr.getResString("CHECK_REPORT_COLOR_DESC"));
            strTitle.append("</td></tr>");
        } else {
            strTitle.append("<td nowrap colspan= \"3\">");
            strTitle.append(this.m_strReportGenerateTime);
            strTitle.append("</td></tr>");
        }
        strTitle.append("<tr><td nowrap>");
        String str2 = this.m_resMgr.getResString("TASK_NAME") + " :";
        strTitle.append(str2);
        strTitle.append("</td>");
        if (2 == domain) {
            strTitle.append("<td nowrap colspan= \"3\">");
            strTitle.append(this.m_oTask.getTaskName());
            strTitle.append("</td></tr>");
        } else if (2 == this.iReportType) {
            strTitle.append("<td nowrap>");
            strTitle.append(this.m_oTask.getTaskName());
            strTitle.append("</td>");
            strTitle.append("<td nowrap bgcolor=\"blue\">");
            strTitle.append(" ");
            strTitle.append("</td>");
            strTitle.append("<td nowrap>");
            strTitle.append(this.m_resMgr.getResString("CHECK_REPORT_PRECHECK_CONTENT"));
            strTitle.append("</td></tr>");
        } else {
            strTitle.append("<td nowrap colspan= \"3\">");
            strTitle.append(this.m_oTask.getTaskName());
            strTitle.append("</td></tr>");
        }
        strTitle.append("<tr><td nowrap>");
        String str1 = this.m_resMgr.getResString("TASK_DEVICE_TYPE") + " :";
        strTitle.append(str1);
        strTitle.append("</td>");
        if (2 == domain) {
            strTitle.append("<td nowrap colspan= \"3\">");
            strTitle.append(this.getSelectedDeviceTypeName());
            strTitle.append("</td></tr>");
        } else if (2 == this.iReportType) {
            strTitle.append("<td nowrap>");
            strTitle.append(this.m_oTask.getSelectedDeviceType().getDeviceTypeName());
            strTitle.append("</td>");
            strTitle.append("<td nowrap bgcolor=\"red\">");
            strTitle.append(" ");
            strTitle.append("</td>");
            strTitle.append("<td nowrap>");
            strTitle.append(this.m_resMgr.getResString("CHECK_REPORT_POSTCHECK_CONTENT"));
            strTitle.append("</td></tr>");
        } else {
            strTitle.append("<td nowrap colspan= \"3\">");
            strTitle.append(this.m_oTask.getSelectedDeviceType().getDeviceTypeName());
            strTitle.append("</td></tr>");
        }
        strTitle.append("<tr><td nowrap>");
        if (2 == domain) {
            String str = this.m_resMgr.getResString("DEVICE_IP") + " :";
            strTitle.append(str);
            strTitle.append("</td>");
            strTitle.append("<td nowrap colspan= \"3\">");
            strTitle.append(this.getSelectDeviceIP());
            strTitle.append("</td></tr>");
        } else {
            String str4 = this.m_resMgr.getResString("CHECK_REPORT_TOTAL_DEVICES") + " :";
            strTitle.append(str4);
            strTitle.append("</td>");
            if (2 == this.iReportType) {
                strTitle.append("<td nowrap>");
                strTitle.append(this.m_oTask.getSelectedDeviceType().getResources().size());
                strTitle.append("</td>");
                strTitle.append("<td nowrap bgcolor=\"black\">");
                strTitle.append(" ");
                strTitle.append("</td>");
                strTitle.append("<td nowrap>");
                strTitle.append(this.m_resMgr.getResString("CHECK_REPORT_COMPARE_CHECK_CONTENT"));
                strTitle.append("</td></tr>");
            } else {
                strTitle.append("<td nowrap colspan= \"3\">");
                strTitle.append(this.m_oTask.getSelectedDeviceType().getResources().size());
                strTitle.append("</td></tr>");
            }
        }
        strTitle.append("</table></html>");
        return strTitle;
    }

    private String getSelectDeviceIP() {
        ReportDevInfoMap reportDevInfoMap = ReportDevInfoMap.getInstance();
        Map<Integer, DevCheckInfo> devCheckReportInfo = reportDevInfoMap.getDevCheckReportInfo();
        Set<Map.Entry<Integer, DevCheckInfo>> selDeviceCheckRepMap = devCheckReportInfo.entrySet();
        int devId = -1;
        Iterator<Map.Entry<Integer, DevCheckInfo>> selDeviceCheckRepItr = selDeviceCheckRepMap.iterator();
        Map.Entry<Integer, DevCheckInfo> selDeviceCheckRepEntry = null;
        if (selDeviceCheckRepItr.hasNext()) {
            selDeviceCheckRepEntry = selDeviceCheckRepItr.next();
            devId = selDeviceCheckRepEntry.getKey();
        }
        String targetIp = "";
        DeviceType devType = this.m_oTask.getSelectedDeviceType();
        THashSet<Resource> resLst = devType.getResources();
        if (null == resLst) {
            return targetIp;
        }
        for (Resource res : resLst) {
            if (devId != res.getDeviceID()) continue;
            targetIp = res.getDeviceIP();
            break;
        }
        return targetIp;
    }

    private String getSelectedDeviceTypeName() {
        ReportDevInfoMap reportDevInfoMap = ReportDevInfoMap.getInstance();
        Map<Integer, DevCheckInfo> devCheckReportInfo = reportDevInfoMap.getDevCheckReportInfo();
        Set<Map.Entry<Integer, DevCheckInfo>> selDeviceCheckRepMap = devCheckReportInfo.entrySet();
        int devId = -1;
        Iterator<Map.Entry<Integer, DevCheckInfo>> selDeviceCheckRepItr = selDeviceCheckRepMap.iterator();
        Map.Entry<Integer, DevCheckInfo> selDeviceCheckRepEntry = null;
        if (selDeviceCheckRepItr.hasNext()) {
            selDeviceCheckRepEntry = selDeviceCheckRepItr.next();
            devId = selDeviceCheckRepEntry.getKey();
        }
        String targetIp = "";
        String deviceTypeName = "";
        DeviceType devType = this.m_oTask.getSelectedDeviceType();
        THashSet<Resource> resLst = devType.getResources();
        if (null == resLst) {
            return targetIp;
        }
        for (Resource res : resLst) {
            if (devId != res.getDeviceID()) continue;
            deviceTypeName = res.getDeviceType();
            break;
        }
        return deviceTypeName;
    }

    protected String getReportTittle(int iReportType) {
        String reportTitle = "";
        switch (iReportType) {
            case 0: {
                reportTitle = this.m_resMgr.getResString("PRE_CHECK_REPORT");
                break;
            }
            case 1: {
                reportTitle = this.m_resMgr.getResString("POST_CHECK_REPORT");
                break;
            }
            case 2: {
                reportTitle = this.m_resMgr.getResString("COMPARE_CHECK_REPORTS");
                break;
            }
        }
        return reportTitle;
    }

    protected void getCheckFailedItem(ConfigTreeNodeInfo oConfigTreeNodeInfo, List<String> nodeIdVector) {
        List<ConfigTreeNodeInfo> treeNodeLst;
        if (null == oConfigTreeNodeInfo || null == oConfigTreeNodeInfo.getConfigNodeAttrEx()) {
            return;
        }
        int iStatus = oConfigTreeNodeInfo.getConfigNodeAttrEx().getStatus();
        if (2 == iStatus || 3 == iStatus || 1 == iStatus) {
            nodeIdVector.add(oConfigTreeNodeInfo.getNodeID());
        }
        if (0 >= (treeNodeLst = oConfigTreeNodeInfo.getNodeInfoLst()).size()) {
            return;
        }
        int nodeNum = treeNodeLst.size();
        for (int i = 0; i < nodeNum; ++i) {
            this.getCheckFailedItem(treeNodeLst.get(i), nodeIdVector);
        }
    }

    protected void saveRecords(final String strFileName, final ISaveFile oSaveFileImp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bSaveSuccess = false;
                boolean isSpaceForSave = true;
                if (null == oSaveFileImp || null == strFileName) {
                    bSaveSuccess = false;
                } else {
                    bSaveSuccess = oSaveFileImp.saveAs(strFileName);
                    isSpaceForSave = oSaveFileImp.getIsSpaceForSave();
                }
                if (bSaveSuccess) {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ReportDlg.this.m_resMgr.getResString("SAVE_SUCCESS"), ReportDlg.this.m_resMgr.getResString("INFO"), 1);
                } else {
                    String errorMsg = null;
                    errorMsg = isSpaceForSave ? "SAVE_FAILURE" : "ACCESS_DENIED_OR_LOW_DISK_SPACE";
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ReportDlg.this.m_resMgr.getResString(errorMsg), ReportDlg.this.m_resMgr.getResString("ERROR_MESSAGE"), 0);
                    File oFile = new File(strFileName);
                    boolean isDelete = true;
                    if (oFile.isFile()) {
                        isDelete = oFile.delete();
                    }
                    if (!isDelete) {
                        DCDebugTracer.traceError("==== It is unsuccessful to delete the file.====");
                    }
                }
            }
        });
    }

    protected void setFileTypeAndName(DCFileChooser oFileChooserDlg) {
        StringBuffer strTime = this.getCurrentTime();
        if (StringUtils.isWinSystem()) {
            String[] strExcel = new String[]{"xls"};
            ReportSaveFileFilter excelFileFilter = new ReportSaveFileFilter(strExcel, this.m_resMgr.getResString("EXCEL2_FILE"));
            oFileChooserDlg.setFileFilter(excelFileFilter);
        }
        String[] strCVS = new String[]{"csv"};
        ReportSaveFileFilter cvsFileFilter = new ReportSaveFileFilter(strCVS, this.m_resMgr.getResString("EXCEL_FILE"));
        oFileChooserDlg.setFileFilter(cvsFileFilter);
        String fileName = FileUtil.getFileName(this.m_resMgr.getResString("CHECK_REPORT_DEFAULT_FILE_NAME") + strTime.toString());
        oFileChooserDlg.setSelectedFile(new File(fileName));
    }

    protected TreeTableNode addNode(TreeTableNode oParentNode, TreeTableNode oChildNode) {
        if (null == oParentNode || null == oChildNode) {
            return oChildNode;
        }
        Vector ochildObj = (Vector)oChildNode.getUserObject();
        Enumeration<TreeNode> oChildEnum = oParentNode.breadthFirstEnumeration();
        TreeTableNode nodeInfo = null;
        Vector oDestObj = null;
        while (oChildEnum.hasMoreElements()) {
            nodeInfo = (TreeTableNode)oChildEnum.nextElement();
            Object obj = nodeInfo.getUserObject();
            if (null == obj || !(obj instanceof Vector) || !this.compare(ochildObj, oDestObj = (Vector)obj)) continue;
            return nodeInfo;
        }
        oParentNode.add(oChildNode);
        return oChildNode;
    }

    private boolean compare(Vector sourceVec, Vector destVec) {
        boolean bSame = true;
        if (null == sourceVec) {
            return null == destVec;
        }
        if (null == destVec || sourceVec.size() != destVec.size()) {
            return false;
        }
        int size = sourceVec.size();
        Object oSource = null;
        Object oDest = null;
        for (int i = 0; i < size; ++i) {
            oSource = sourceVec.get(i);
            oDest = destVec.get(i);
            if (null == oSource && null == oDest) continue;
            if (null != oSource && null != oDest) {
                if (sourceVec.get(i).toString().equals(destVec.get(i).toString())) continue;
                return false;
            }
            return false;
        }
        return bSame;
    }

    @Override
    public void doCleanUp() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(null);
        this.m_oLeftTreePanel = null;
        this.m_oRightReportTitlePanel = null;
        this.m_oRightPagePanel = null;
        this.m_oRightRadioBtnPanel = null;
        this.m_oRightTableMainPanel.clear();
        this.m_oRightTableMainPanel = null;
        this.m_oCloseBtnPanel = null;
        this.m_resMgr = null;
        this.m_rbViewDiffence = null;
        this.m_rbViewAll = null;
        DCCleanupUtil.cleanupComponent((JComponent)((Object)this));
        super.doCleanUp();
    }

    @Override
    protected void closeDialog() {
        this.dispose();
        super.closeDialog();
    }
}

