/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportConstant;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import javax.swing.tree.TreePath;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public final class ReportCommon {
    private ReportCommon() {
    }

    private static Colour getExcelCellColour(Color color) {
        Colour oColour = null;
        oColour = ReportConstant.POSTCHECK_COLOR == color ? Colour.RED : (ReportConstant.PRECHECK_COLOR == color ? Colour.BLUE : (ReportConstant.COMPARE_FAIL_COLOR == color ? Colour.BLUE_GREY : Colour.PALETTE_BLACK));
        return oColour;
    }

    public static void setExcelCellBackground(WritableCellFormat cellFormat, ICheckReportTableCell cell) {
        if (null == cellFormat || null == cell) {
            return;
        }
        Color oColor = cell.getCellBackground();
        if (null != oColor) {
            Colour oColour = ReportCommon.getExcelCellColour(oColor);
            try {
                cellFormat.setBackground(oColour);
            }
            catch (WriteException exception) {
                DCDebugTracer.traceError(exception.getMessage());
            }
        }
    }

    public static WritableCellFormat getWritableCellFormat(Color color) {
        WritableFont oColorFont = null;
        oColorFont = ReportConstant.POSTCHECK_COLOR == color ? new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.RED) : (ReportConstant.PRECHECK_COLOR == color ? new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE) : (ReportConstant.COMPARE_FAIL_COLOR == color ? new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE_GREY) : new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.PALETTE_BLACK)));
        return new WritableCellFormat(oColorFont);
    }

    public static WritableCellFormat getWritableCellFormatDMS(Color color) {
        WritableFont oColorFont = null;
        oColorFont = ReportConstant.POSTCHECK_COLOR == color ? new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.RED) : (ReportConstant.PRECHECK_COLOR == color ? new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE) : (ReportConstant.COMPARE_FAIL_COLOR == color ? new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE_GREY) : new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.PALETTE_BLACK)));
        WritableCellFormat format = new WritableCellFormat(oColorFont);
        try {
            format.setBorder(Border.ALL, BorderLineStyle.THIN);
        }
        catch (WriteException e) {
            DCDebugTracer.traceError(e.getMessage());
        }
        return format;
    }

    public static String getReportName(int iReportType) {
        String reportName = "";
        ResourceManager resMgr = ResourceManager.getInstance();
        reportName = 0 == iReportType ? resMgr.getResString("PRE_CHECK_REPORT") : (1 == iReportType ? resMgr.getResString("POST_CHECK_REPORT") : (2 == iReportType ? resMgr.getResString("COMPARE_CHECK_REPORTS") : ""));
        return reportName;
    }

    public static String convertCheckitem(String prefix) {
        if (null == prefix || "".equals(prefix.trim())) {
            prefix = "";
        } else {
            int checkItemLength = prefix.length();
            String temp1 = prefix.substring(0, checkItemLength / 2);
            String temp2 = prefix.substring(checkItemLength / 2 + 1);
            if (Collator.getInstance().equals(temp1, temp2) && prefix.contains(".")) {
                prefix = temp1;
                temp2 = ResourceManager.getInstance().getResString(temp1);
                Locale oLocale = DCResourceMng.getInstance().getLocale();
                if (!Collator.getInstance().equals(prefix.toLowerCase(oLocale), temp2.toLowerCase(oLocale))) {
                    prefix = temp2;
                }
            } else {
                String[] temp = prefix.split("\\.");
                String checkItem = null;
                try {
                    DCSortableTreeTable m_oTaskTreeTable = DCFrameWorkUtil.getTaskTablePanel().getTaskTreeTable();
                    if (null == m_oTaskTreeTable || m_oTaskTreeTable.getSelectedRowCount() != 1) {
                        checkItem = ResourceManager.getInstance().getResString(temp[0]);
                    } else {
                        int iSelectedRow = m_oTaskTreeTable.getSelectedRow();
                        TreePath oTreePath = m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
                        TreeTableNode oTaskTableNode = null;
                        ITask oTaskObj = null;
                        if (null != oTreePath && null != (oTaskTableNode = (TreeTableNode)oTreePath.getLastPathComponent())) {
                            oTaskObj = TaskTableUtil.getTaskForTableNode(oTaskTableNode);
                        }
                        checkItem = null == oTaskObj ? ResourceManager.getInstance().getResString(temp[0]) : ResourceManager.getInstance().getSpecialResForDMS(oTaskObj.getDeviceType().getDeviceTypeName(), temp[0]);
                    }
                }
                catch (Exception e) {
                    checkItem = ResourceManager.getInstance().getResString(temp[0]);
                }
                prefix = checkItem + prefix.substring(temp[0].length());
            }
        }
        return prefix;
    }

    public static void closeIOStream(WritableWorkbook workbook) {
        if (null != workbook) {
            try {
                workbook.close();
            }
            catch (WriteException exception) {
                DCDebugTracer.traceError(exception.getMessage());
            }
            catch (IOException exception) {
                DCDebugTracer.traceError(exception.getMessage());
            }
        }
    }

    public static boolean isHaveFreeSpace(File csvFile, long lFileSize) {
        boolean isSaveSuccess = true;
        long lFreeMemoryAvail = 0L;
        if (null != csvFile) {
            lFreeMemoryAvail = csvFile.getFreeSpace();
        }
        if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
            isSaveSuccess = false;
        }
        return isSaveSuccess;
    }
}

