/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.common.components.table.editor.FileBrowseButtonCellEditor;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.FileType;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.model.TaskReportTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DevReportPanel
extends JPanel {
    private static final long serialVersionUID = -1281439836474400733L;
    private static final int ROW_ZERO = 0;
    private static final int COL_ZERO = 0;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private JScrollPane scrollPnl = null;
    private TaskReportFileInfo oTaskReportFileInfo = null;
    private JTable taskReportTable = null;
    private TaskReportTableModel taskReportTableModel;
    private ComboBoxWithToolTip[] fileTypeComboBox = null;

    public DevReportPanel(TaskReportFileInfo taskReportFileInfo) {
        this.setPreferredSize(new Dimension(600, 400));
        this.setMinimumSize(new Dimension(600, 400));
        this.oTaskReportFileInfo = taskReportFileInfo;
        this.taskReportTableModel = new TaskReportTableModel();
        this.fileTypeComboBox = new ComboBoxWithToolTip[1];
        this.initTable();
        this.updateData();
        this.addItemFileTypeComboBox();
        this.taskReportTable.updateUI();
    }

    private void displayWarningMsg(String strErrorMessage) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrorMessage, ResourceManager.getInstance().getResString("INFO"), 1);
    }

    public boolean validateDataSelection() {
        boolean isEmptyPath = false;
        int iSelectRow = 0;
        String savePath = (String)this.taskReportTable.getValueAt(0, 4);
        String tempPath = ResourceManager.getInstance().getResString("SELECT_FILE_PATH").trim();
        if (StringUtils.isNullOrEmptyStr(savePath) || savePath.trim().equalsIgnoreCase(tempPath)) {
            isEmptyPath = true;
        }
        if (isEmptyPath) {
            ListSelectionModel oSelectionModel = this.taskReportTable.getSelectionModel();
            oSelectionModel.setSelectionInterval(iSelectRow, iSelectRow);
            Rectangle oRect = this.taskReportTable.getCellRect(iSelectRow, 0, true);
            this.taskReportTable.scrollRectToVisible(oRect);
            this.refreshTable();
            String strWarningMsg = ResourceManager.getInstance().getResString("SELECT_REPORT_EMPTY_PATH_WARN");
            this.displayWarningMsg(MessageFormat.format(strWarningMsg, iSelectRow + 1));
            return true;
        }
        FileType fileType = (FileType)this.fileTypeComboBox[0].getSelectedItem();
        TaskReportFileInfo taskReportFileInfo = this.oTaskReportFileInfo;
        taskReportFileInfo.setFiletype(fileType.getCode());
        return false;
    }

    public void setTheSameAsTheFirstLine() {
        String savepath = (String)this.taskReportTable.getValueAt(0, 4);
        int selIndex = 0;
        if (null != this.fileTypeComboBox[0]) {
            selIndex = this.fileTypeComboBox[0].getSelectedIndex();
        }
        this.taskReportTable.setValueAt(savepath, 0, 4);
        this.fileTypeComboBox[0].setSelectedIndex(selIndex);
        this.refreshTable();
    }

    private void initTable() {
        DCDebugTracer.trace("Entering initTablePanel");
        this.taskReportTable = new JTable(this.taskReportTableModel);
        this.taskReportTable.setRowHeight(21);
        this.taskReportTable.getTableHeader().setReorderingAllowed(false);
        this.taskReportTable.setRowSelectionAllowed(true);
        this.taskReportTable.setSelectionMode(2);
        this.taskReportTable.setFocusable(false);
        this.taskReportTable.setName("TaskReportPanel_taskReportTable");
        TableColumn fileTypeColumn = this.taskReportTable.getColumnModel().getColumn(3);
        FileTypeColumnRenderer oFileTypeColumnRenderer = new FileTypeColumnRenderer();
        fileTypeColumn.setCellRenderer(oFileTypeColumnRenderer);
        this.fileTypeComboBox[0] = new ComboBoxWithToolTip();
        fileTypeColumn.setCellEditor(new FileTypeColumnEditor(this.fileTypeComboBox[0]));
        TableColumn savePathColumn = this.taskReportTable.getColumnModel().getColumn(4);
        savePathColumn.setCellRenderer(new FileBrowseButtonCellRenderer());
        savePathColumn.setCellEditor(new FileBrowseButtonCellEditor(4, new JCheckBox(), this.taskReportTable));
        TableColumn reportNameColumn = this.taskReportTable.getColumnModel().getColumn(2);
        reportNameColumn.setMaxWidth(0);
        reportNameColumn.setMinWidth(0);
        reportNameColumn.setPreferredWidth(0);
        this.scrollPnl = new JScrollPane();
        this.scrollPnl.getViewport().add(this.taskReportTable);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPnl, "Center");
    }

    public int parseIsSelect() {
        int iSelectStatus = -1;
        int iRowCount = this.taskReportTable.getRowCount();
        int iSelectAll = 0;
        int iDoNotSelect = 0;
        Boolean isSel = null;
        for (int i = 0; i < iRowCount; ++i) {
            isSel = (Boolean)this.taskReportTable.getValueAt(i, 0);
            if (isSel.booleanValue()) {
                ++iSelectAll;
                continue;
            }
            ++iDoNotSelect;
        }
        iSelectStatus = iRowCount == iSelectAll ? 0 : (iRowCount == iDoNotSelect ? 2 : 1);
        return iSelectStatus;
    }

    private void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != DevReportPanel.this.taskReportTable) {
                    DevReportPanel.this.taskReportTable.repaint();
                    DevReportPanel.this.taskReportTable.getTableHeader().repaint();
                }
            }
        });
    }

    public void setCheckBoxStatus() {
        this.taskReportTable.setValueAt(this.m_oCheckBoxHeader.isSelected(), 0, 0);
        this.taskReportTable.repaint();
        this.taskReportTable.getTableHeader().repaint();
    }

    private void updateData() {
        this.taskReportTableModel.getDataVector().add((Vector)((Object)this.oTaskReportFileInfo));
    }

    private void addItemFileTypeComboBox() {
        boolean isWinSystem = StringUtils.isWinSystem();
        this.fileTypeComboBox[0] = new ComboBoxWithToolTip();
        if (isWinSystem) {
            this.fileTypeComboBox[0].addItem(new FileType(3, FileType.XLS_FILE_DESC));
        }
        if (!DCFrameWorkUtil.getIsSingleClient() && !isWinSystem) {
            this.fileTypeComboBox[0].addItem(new FileType(0, FileType.CSV_FILE_DESC));
        }
    }

    public void setToNull() {
        this.m_oCheckBoxHeader = null;
        for (ComboBoxWithToolTip comboBox : this.fileTypeComboBox) {
            comboBox.removeAllItems();
        }
        this.fileTypeComboBox = null;
        this.taskReportTableModel.setToNull();
        if (this.taskReportTable != null) {
            this.taskReportTable.removeAll();
        }
        this.scrollPnl = null;
    }

    private class FileTypeColumnRenderer
    implements TableCellRenderer {
        private FileTypeColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return DevReportPanel.this.fileTypeComboBox[row];
        }
    }

    private class FileTypeColumnEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -4773872422494591121L;

        FileTypeColumnEditor(ComboBoxWithToolTip oFileTypeCombox) {
            super(oFileTypeCombox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return DevReportPanel.this.fileTypeComboBox[row];
        }
    }

    class FileBrowseButtonCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -3078076068737664113L;

        FileBrowseButtonCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FileBrowseButtonCellEditor oButtoncellEditor = (FileBrowseButtonCellEditor)table.getCellEditor(row, column);
            return oButtoncellEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 3203851254842383706L;

        CheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable oTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            Boolean isSelect = (Boolean)oTable.getModel().getValueAt(iRow, 0);
            if (bIsSelected) {
                this.setForeground(Color.white);
                this.setBackground(new Color(75, 110, 145));
            } else {
                this.setForeground(Color.black);
                this.setBackground(Color.white);
            }
            this.setSelected(isSelect);
            this.setText(null);
            return this;
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source instanceof AbstractButton) {
                DevReportPanel.this.setCheckBoxStatus();
                DevReportPanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            }
        }
    }
}

