/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ReportProgressDlg;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.report.devlevel.DevCheckReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.view.DevReportPanel;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DevReportDlg
extends DCModalDialog
implements ActionListener {
    private static final long serialVersionUID = -5199969648259388545L;
    private static final String CANCEL_ACTION = "cancelAction";
    private static final String OK_ACTION = "okAction";
    private ResourceManager m_resMgr = ResourceManager.getInstance();
    private List<Integer> oDevIdList = null;
    private JPanel okCancelPanel = null;
    private JLabel oDescLabel = null;
    private ReportProgressDlg progressDlg = null;
    private static final int ROWHIGHT = 21;
    private TaskReportFileInfo oTaskReportFileInfo = null;
    private DevReportPanel devReportPanel = null;
    private ITask oTask = null;

    public DevReportDlg(ITask task, List<Integer> devIdLst, String dialogName) throws DCException {
        this.oTask = task;
        this.oDevIdList = devIdLst;
        this.setLayout(new GridBagLayout());
        this.fillDevToReportInfoLst();
        this.devReportPanel = new DevReportPanel(this.oTaskReportFileInfo);
        this.add(this.getoDescLabel(), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(12, 12, 12, 8), 0, 0));
        this.add(this.devReportPanel, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.7, 10, 1, new Insets(5, 12, 0, 12), 0, 0));
        this.initOkCancelButtonPanel();
        this.add(this.okCancelPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 15, 2, new Insets(5, 12, 12, 8), 0, 0));
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.setTitle(dialogName);
        this.setSize(600, 400);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String strCmd = e.getActionCommand();
        if (OK_ACTION.equalsIgnoreCase(strCmd)) {
            this.okActionPerformed();
        }
        if (CANCEL_ACTION.equalsIgnoreCase(strCmd)) {
            this.closeActionPerformed();
        }
    }

    public void closeActionPerformed() {
        this.closeDialog();
    }

    @Override
    public void closeDialog() {
        this.setToNull();
        this.dispose();
    }

    private void fillDevToReportInfoLst() {
        if (this.oDevIdList == null || this.oDevIdList.isEmpty()) {
            return;
        }
        int taskType = this.oTask.getTaskTypeId();
        String strTaskType = TaskCommUtil.converTaskTypeToStr(taskType);
        if (IsolationCommonOperation.isIsolationTask(taskType)) {
            strTaskType = strTaskType + "(" + ResourceManager.getInstance().getResString("ISOLATION_TASK_TYPE_POSTFIX") + ")";
        }
        String fileName = ResourceManager.getInstance().getResString("CHECK_REPORT_DEFAULT_FILE_NAME") + StringUtils.getStrNowTime("yyyyMMddHHmmss");
        fileName = FileUtil.getFileName(fileName);
        this.oTaskReportFileInfo = new TaskReportFileInfo(this.oTask.getTaskName(), strTaskType, fileName);
        this.oTaskReportFileInfo.setSelect(true);
        this.oTaskReportFileInfo.setFilePath(TaskReportFileInfo.getDefaultFilePath());
        this.oTaskReportFileInfo.setFiletype(TaskReportFileInfo.getDefaultFileType());
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_TASK_VIEW_REPORT";
    }

    private void initCancelButton() {
        if (null == this.m_oCancelBtn) {
            this.m_oCancelBtn = new JButton();
        }
        this.m_oCancelBtn.setMaximumSize(new Dimension(90, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(90, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(90, 21));
        this.m_oCancelBtn.setText(this.m_resMgr.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oCancelBtn.setActionCommand(CANCEL_ACTION);
        this.m_oCancelBtn.addActionListener(this);
        this.m_oCancelBtn.setName("DevReportDlg_m_oCancelBtn");
    }

    public JLabel getoDescLabel() {
        if (null == this.oDescLabel) {
            this.oDescLabel = new JLabel();
        }
        this.oDescLabel.setMaximumSize(new Dimension(200, 21));
        this.oDescLabel.setMinimumSize(new Dimension(200, 21));
        this.oDescLabel.setPreferredSize(new Dimension(200, 21));
        this.oDescLabel.setText(this.m_resMgr.getResString("GENERATE_CHECK_REPORT_DESC"));
        this.oDescLabel.setName("DevReportDlg_m_oCancelBtn");
        return this.oDescLabel;
    }

    private void initOkButton() {
        if (null == this.m_oOKBtn) {
            this.m_oOKBtn = new JButton();
        }
        this.m_oOKBtn.setMaximumSize(new Dimension(90, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(90, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(90, 21));
        this.m_oOKBtn.setText(this.m_resMgr.getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oOKBtn.setActionCommand(OK_ACTION);
        this.m_oOKBtn.addActionListener(this);
        this.m_oOKBtn.setName("DevReportDlg_m_oOKBtn");
    }

    private void initOkCancelButtonPanel() {
        this.initOkButton();
        this.initCancelButton();
        this.okCancelPanel = new JPanel();
        this.okCancelPanel.setPreferredSize(new Dimension(800, 33));
        this.okCancelPanel.setMinimumSize(new Dimension(800, 33));
        this.okCancelPanel.setName("DevReportDlg_okCancelPanel");
        FlowLayout flowLayout = new FlowLayout(2);
        this.okCancelPanel.setLayout(flowLayout);
        this.okCancelPanel.add(this.m_oOKBtn);
        this.okCancelPanel.add(this.m_oCancelBtn);
    }

    public void okActionPerformed() {
        DCDebugTracer.trace(this.getClass().getName() + " [device check report] okActionPerformed start");
        boolean bHasError = this.devReportPanel.validateDataSelection();
        if (bHasError) {
            DCDebugTracer.trace(this.getClass().getName() + " [device check report] validateDataSelection error.");
            return;
        }
        ArrayList<TaskReportFileInfo> taskReportInfoLst = new ArrayList<TaskReportFileInfo>();
        taskReportInfoLst.add(this.oTaskReportFileInfo);
        this.closeDialog();
        String reportName = this.m_resMgr.getResString("GENERATE_TASK_REPORT_REPORT_DEFAULT_NAME");
        String opeName = this.m_resMgr.getResString("OPERATION_RESOULT_SUTO_PROGRESS");
        String strTitle = this.getTitle();
        this.progressDlg = new ReportProgressDlg(reportName, opeName);
        DCHelpManager.getInstance().enableF1HelpKey(this.progressDlg.getContentPane(), this.getCurrentContext());
        this.progressDlg.setTitle(strTitle);
        this.progressDlg.setUserObject(taskReportInfoLst);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DevReportDlg.this.progressDlg.showDetailInfo();
                DevReportDlg.this.progressDlg.setVisible(true);
            }
        });
        Thread reportThread = new Thread(){

            @Override
            public void run() {
                DevCheckReportCreater taskReportCreater = new DevCheckReportCreater(DevReportDlg.this.oTaskReportFileInfo, DevReportDlg.this.oTask, DevReportDlg.this.oDevIdList, DevReportDlg.this.progressDlg);
                taskReportCreater.createTasksReport();
            }
        };
        reportThread.setName("reportThread");
        reportThread.start();
        DCDebugTracer.trace(this.getClass().getName() + " [device check report] okActionPerformed end..");
    }

    public void setToNull() {
        DCCleanupUtil.cleanupComponent(this.okCancelPanel);
        this.okCancelPanel = null;
        if (null != this.devReportPanel) {
            this.devReportPanel.setToNull();
        }
        this.devReportPanel = null;
    }
}

