/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.components.treetable.view.ReportTreeTableRenderer;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.report.devlevel.ISaveFile;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.DefaultCheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.view.DMSCheckReportCSVFile;
import com.huawei.dc.taskmgmt.report.devlevel.view.DMSCheckReportExcelFile;
import com.huawei.dc.taskmgmt.report.devlevel.view.ReportDlg;
import com.huawei.dc.taskmgmt.report.devlevel.view.ReportTableMainPanel;
import com.huawei.dc.taskmgmt.report.devlevel.view.ReportTablePanel;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;

public class DMSReportDlg
extends ReportDlg
implements DCTreeEventListener {
    private static final long serialVersionUID = 3037636803707460120L;
    private int iColumnNum = -1;
    private ReportTablePanel m_oRightTablePanel = null;
    List<String> curCheckItemLst = new ArrayList<String>();
    private int delCnt = 0;

    public DMSReportDlg(DevCheckNodeInfo oDevCheckNodeInfo, int reportType, ITask task) {
        super(oDevCheckNodeInfo, reportType, task);
        if (null != this.m_oRightTableMainPanel) {
            this.m_oRightTablePanel = this.m_oRightTableMainPanel.getReportTablePanelLst().get(0);
            if (null != this.m_oRightTablePanel) {
                this.viewDifferentCheckItem();
                this.m_oRightTablePanel.resreshTreeTable();
            }
        }
    }

    @Override
    protected ConfigTreeNodeInfo getLeftContent(DevCheckNodeInfo nodeInfo) {
        ConfigTreeNodeInfo configTreeNodeInfo = null;
        if (null != nodeInfo) {
            configTreeNodeInfo = new ConfigTreeNodeInfo();
            configTreeNodeInfo.setTreeType(1);
            configTreeNodeInfo.setNodeID(nodeInfo.getNodeId());
            configTreeNodeInfo.getConfigNodeAttr().setNodeName(this.getSubInfo("", nodeInfo.getNodeName()));
            configTreeNodeInfo.getConfigNodeAttrEx().setStatus(nodeInfo.getStatus());
            boolean bCompareCheck = this.iReportType == 2;
            boolean bCheckItem = nodeInfo.isCheckItem();
            if (bCompareCheck && !bCheckItem) {
                CheckReportTable oCheckReportTable = nodeInfo.getCheckReportTable();
                configTreeNodeInfo.setCheckReportTable(nodeInfo.getCheckReportTable());
                if (null != oCheckReportTable) {
                    boolean bContainsDifItem = this.isContainsDifItem(configTreeNodeInfo.getCheckReportTable());
                    configTreeNodeInfo.getConfigNodeAttrEx().setContiansDifItem(bContainsDifItem);
                }
            }
            if (!bCheckItem || bCompareCheck) {
                ConfigTreeNodeInfo oTmpTreeNodeInfo = null;
                boolean bContainsDif = false;
                for (int i = 0; i < nodeInfo.getDevCheckNodeInfoLst().size(); ++i) {
                    oTmpTreeNodeInfo = this.getLeftContent(nodeInfo.getDevCheckNodeInfoLst().get(i));
                    if (null == oTmpTreeNodeInfo.getCheckReportTable()) {
                        oTmpTreeNodeInfo.setCheckReportTable(nodeInfo.getCheckReportTable());
                    }
                    if (this.isContainsDifItem(oTmpTreeNodeInfo.getCheckReportTable())) {
                        bContainsDif = true;
                        oTmpTreeNodeInfo.getConfigNodeAttrEx().setContiansDifItem(true);
                    }
                    oTmpTreeNodeInfo.setParentID(nodeInfo.getNodeId());
                    oTmpTreeNodeInfo.setTreeType(1);
                    configTreeNodeInfo.getNodeInfoLst().add(oTmpTreeNodeInfo);
                }
                if (nodeInfo.isCheckItem()) {
                    bContainsDif = this.isContainsDifItem(nodeInfo.getCheckReportTable());
                }
                if (bContainsDif && nodeInfo.isCheckItem()) {
                    configTreeNodeInfo.getConfigNodeAttrEx().setContiansDifItem(true);
                }
            }
        }
        if (null != configTreeNodeInfo && null == configTreeNodeInfo.getCheckReportTable() && null != nodeInfo && nodeInfo.isCheckItem()) {
            configTreeNodeInfo.setCheckReportTable(nodeInfo.getCheckReportTable());
        }
        return configTreeNodeInfo;
    }

    @Override
    protected void addAllComponent() {
        GridBagLayout gridLayout = new GridBagLayout();
        this.setLayout(gridLayout);
        this.setTitle(this.m_resMgr.getResString("Check_Reports_Title"));
        this.setMinimumSize(new Dimension(750, 450));
        this.setSize(new Dimension(750, 450));
        GridBagConstraints rightTitleGrdBagConsts = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 12), 0, 0);
        this.add(this.m_oRightReportTitlePanel, rightTitleGrdBagConsts);
        GridBagConstraints rightRadioGrdBagConsts = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 12), 0, 0);
        this.add(this.m_oRightRadioBtnPanel, rightRadioGrdBagConsts);
        GridBagConstraints reportContnetScrollPaneGrdBagConsts = new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(12, 0, 0, 12), 0, 0);
        this.add(this.m_oRightTableMainPanel, reportContnetScrollPaneGrdBagConsts);
        JSortTreeTable rightTable = this.m_oRightTablePanel.getReportTreeTable();
        rightTable.addMouseMotionListener(new ReportTableMouseMotionListener());
        rightTable.addMouseListener(new ReportTableMouseListener());
        GridBagConstraints leftTreeGrdBagConsts = new GridBagConstraints(0, 0, 1, 4, 0.0, 1.0, 10, 1, new Insets(12, 12, 0, 12), 0, 0);
        this.add(this.m_oLeftTreePanel, leftTreeGrdBagConsts);
        GridBagConstraints closeButtonPaneGrdBagConsts = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 14, 2, new Insets(12, 12, 12, 12), 0, 0);
        this.add(this.m_oCloseBtnPanel, closeButtonPaneGrdBagConsts);
    }

    @Override
    protected void initTablePanel(String sNodeID) {
        if (null == this.m_oTask) {
            return;
        }
        this.m_oCurSelectedNodeInfo = this.m_oDevCheckNodeInfo;
        this.m_oRightTableMainPanel = new ReportTableMainPanel(this.m_oDevCheckNodeInfo, this.getColumns(), new Dimension(495, 330), this.m_oTask, this.iReportType);
        this.m_oRightTablePanel = this.m_oRightTableMainPanel.getReportTablePanelLst().get(0);
    }

    @Override
    public void viewAllCheckItem() {
        this.iViewStatus = 0;
        this.m_oRightTablePanel.clearTableData();
        this.addDataToTable(this.m_oCurSelectedNodeInfo);
        this.m_oRightTablePanel.resreshTreeTable();
    }

    public void initCurCheckItem(DevCheckNodeInfo oCurSelectedNodeInfo) {
        List<DevCheckNodeInfo> oDevCheckNodeInfoLst;
        if (oCurSelectedNodeInfo.isCheckItem() && !this.curCheckItemLst.contains(oCurSelectedNodeInfo.getNodeId())) {
            this.curCheckItemLst.add(oCurSelectedNodeInfo.getNodeId());
        }
        if (null == (oDevCheckNodeInfoLst = oCurSelectedNodeInfo.getDevCheckNodeInfoLst()) || oDevCheckNodeInfoLst.isEmpty()) {
            return;
        }
        DevCheckNodeInfo oTmpTreeNodeInfo = null;
        for (int i = 0; i < oDevCheckNodeInfoLst.size(); ++i) {
            oTmpTreeNodeInfo = oDevCheckNodeInfoLst.get(i);
            this.initCurCheckItem(oTmpTreeNodeInfo);
        }
    }

    @Override
    public void viewDifferentCheckItem() {
        this.iViewStatus = 1;
        this.curCheckItemLst.clear();
        this.initCurCheckItem(this.m_oCurSelectedNodeInfo);
        ConfigTreeNodeInfo oConfigTreeNodeInfo = this.getLeftContent(this.m_oCurSelectedNodeInfo);
        if (this.iReportType == 2) {
            HashMap<String, String> nodeIdMap = new HashMap<String, String>();
            this.getCheckDifAndFailedItem(oConfigTreeNodeInfo, nodeIdMap);
            this.updateCompareTableForNodeId(this.m_oRightTablePanel, nodeIdMap);
            this.removeNode(this.m_oRightTablePanel.getRootNode());
        } else {
            ArrayList<String> nodeIdLst = new ArrayList<String>(4);
            this.getCheckFailedItem(oConfigTreeNodeInfo, nodeIdLst);
            this.updateTableForNodeId(this.m_oRightTablePanel, nodeIdLst);
        }
    }

    private void removeNode(TreeTableNode oTreeTableNode) {
        this.removeEmptySuccAndSameNode(this.m_oRightTablePanel.getRootNode());
        while (this.delCnt > 0) {
            this.delCnt = 0;
            this.removeEmptySuccAndSameNode(this.m_oRightTablePanel.getRootNode());
        }
    }

    @Override
    protected void getCheckFailedItem(ConfigTreeNodeInfo oConfigTreeNodeInfo, List<String> nodeIdVector) {
        List<ConfigTreeNodeInfo> treeNodeLst;
        if (null == oConfigTreeNodeInfo || null == oConfigTreeNodeInfo.getConfigNodeAttrEx()) {
            return;
        }
        int iStatus = oConfigTreeNodeInfo.getConfigNodeAttrEx().getStatus();
        if (2 == iStatus || 3 == iStatus) {
            nodeIdVector.add(oConfigTreeNodeInfo.getNodeID());
        }
        if (0 >= (treeNodeLst = oConfigTreeNodeInfo.getNodeInfoLst()).size()) {
            return;
        }
        int nodeNum = treeNodeLst.size();
        for (int i = 0; i < nodeNum; ++i) {
            this.getCheckFailedItem(treeNodeLst.get(i), nodeIdVector);
        }
    }

    public boolean isCheckItem(String strNodeID) {
        DevCheckNodeInfo refreshNodeInfo = this.getCheckNode(strNodeID);
        if (null != refreshNodeInfo) {
            return refreshNodeInfo.isCheckItem();
        }
        return false;
    }

    public DevCheckNodeInfo getCheckNode(String strNodeID) {
        if (StringUtils.isNullOrEmptyStr(strNodeID)) {
            return null;
        }
        DevCheckNodeInfo refreshNodeInfo = null;
        int nodeNum = this.m_oDevCheckNodeInfo.getDevCheckNodeInfoLst().size();
        for (int i = 0; i < nodeNum; ++i) {
            refreshNodeInfo = this.m_oDevCheckNodeInfo.getSubNodeForID(strNodeID);
            if (null == refreshNodeInfo) continue;
            return refreshNodeInfo;
        }
        return null;
    }

    public String getCheckItemId(String strNodeID) {
        if (this.isCheckItem(strNodeID)) {
            return strNodeID;
        }
        for (String oCheckItem : this.curCheckItemLst) {
            if (!strNodeID.startsWith(oCheckItem)) continue;
            return oCheckItem;
        }
        return strNodeID;
    }

    private void getCheckDifAndFailedItem(ConfigTreeNodeInfo oConfigTreeNodeInfo, HashMap<String, String> nodeMap) {
        List<ConfigTreeNodeInfo> treeNodeLst;
        if (null == oConfigTreeNodeInfo || null == oConfigTreeNodeInfo.getConfigNodeAttrEx()) {
            return;
        }
        int iStatus = oConfigTreeNodeInfo.getConfigNodeAttrEx().getStatus();
        boolean bConstainsDifItem = false;
        if (null != oConfigTreeNodeInfo.getCheckReportTable()) {
            try {
                ICheckReportTableModel oICheckReportTableModel = oConfigTreeNodeInfo.getCheckReportTable().getModel();
                int checkReuseltIndex = 2;
                bConstainsDifItem = oICheckReportTableModel.getRow(0).get(checkReuseltIndex).getValue().equals("0");
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        } else {
            bConstainsDifItem = oConfigTreeNodeInfo.getConfigNodeAttrEx().isContiansDifItem();
        }
        if (2 == iStatus || 3 == iStatus || bConstainsDifItem) {
            if (this.isCheckItem(oConfigTreeNodeInfo.getNodeID())) {
                nodeMap.put(oConfigTreeNodeInfo.getNodeID(), oConfigTreeNodeInfo.getNodeID());
            } else {
                nodeMap.put(oConfigTreeNodeInfo.getNodeID(), this.getCheckItemId(oConfigTreeNodeInfo.getParentID()));
            }
        }
        if (0 >= (treeNodeLst = oConfigTreeNodeInfo.getNodeInfoLst()).size()) {
            return;
        }
        int nodeNum = treeNodeLst.size();
        for (int i = 0; i < nodeNum; ++i) {
            this.getCheckDifAndFailedItem(treeNodeLst.get(i), nodeMap);
        }
    }

    private void updateCompareTableForNodeId(ReportTablePanel panel, HashMap<String, String> nodeIdMap) {
        if (null == panel || null == nodeIdMap) {
            return;
        }
        panel.clearTableData();
        this.iColumnNum = this.getColumnNum(null);
        Set<Map.Entry<String, String>> entryMap = nodeIdMap.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entryMap.iterator();
        DevCheckNodeInfo refreshNodeInfo = null;
        Map.Entry<String, String> entry = null;
        TreeSet<String> values = new TreeSet<String>();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (values.contains(entry.getValue())) continue;
            refreshNodeInfo = this.m_oDevCheckNodeInfo.getSubNodeForID(entry.getValue());
            this.writeHyperLinkRow(refreshNodeInfo);
            values.add(entry.getValue());
        }
        panel.resreshTreeTable();
    }

    private void removeEmptySuccAndSameNode(TreeTableNode oTreeTableNode) {
        Vector obj = (Vector)oTreeTableNode.getUserObject();
        if (oTreeTableNode.isLeaf() && obj != null) {
            int size = obj.size();
            int iNullCnt = 0;
            for (int i = 0; i < size; ++i) {
                if (null != obj.get(i)) continue;
                ++iNullCnt;
            }
            if (iNullCnt == size - 1) {
                oTreeTableNode.removeFromParent();
                ++this.delCnt;
            }
        }
        int iChdCnt = oTreeTableNode.getChildCount();
        for (int j = iChdCnt - 1; j >= 0; --j) {
            this.removeEmptySuccAndSameNode((TreeTableNode)oTreeTableNode.getChildAt(j));
        }
    }

    private void updateTableForNodeId(ReportTablePanel panel, List<String> nodeIdLst) {
        if (null == panel || null == nodeIdLst) {
            return;
        }
        panel.clearTableData();
        this.iColumnNum = this.getColumnNum(null);
        int nodeNum = nodeIdLst.size();
        DevCheckNodeInfo refreshNodeInfo = null;
        for (int i = 0; i < nodeNum; ++i) {
            refreshNodeInfo = this.m_oDevCheckNodeInfo.getSubNodeForID(nodeIdLst.get(i));
            this.writeHyperLinkRow(refreshNodeInfo);
        }
        panel.resreshTreeTable();
    }

    @Override
    protected void addActinListener() {
        this.m_oLeftTreePanel.addDeviceTreeEventListener(this);
    }

    @Override
    public void onTreeNodeSelection(DCEventObject eventObject) {
        Object nodeObject = eventObject.getSource();
        if (!(nodeObject instanceof ConfigTreeNodeInfo)) {
            return;
        }
        ConfigTreeNodeInfo oConfigTreeNodeInfo = (ConfigTreeNodeInfo)nodeObject;
        String nodeId = oConfigTreeNodeInfo.getNodeID();
        this.m_oRightTablePanel.clearTableData();
        this.m_oCurSelectedNodeInfo = this.m_oDevCheckNodeInfo.getSubNodeForID(nodeId);
        if (1 == this.iViewStatus) {
            this.viewDifferentCheckItem();
        } else {
            this.viewAllCheckItem();
        }
    }

    private void addDataToTable(DevCheckNodeInfo tmpDevCheckNodeInfo) {
        if (null == tmpDevCheckNodeInfo) {
            return;
        }
        if (!tmpDevCheckNodeInfo.isCheckItem()) {
            List<DevCheckNodeInfo> nodeLst = tmpDevCheckNodeInfo.getDevCheckNodeInfoLst();
            int checkNodeInfoNum = nodeLst.size();
            for (int i = 0; i < checkNodeInfoNum; ++i) {
                this.addDataToTable(nodeLst.get(i));
            }
            boolean bContainsDif = this.isContainsDifItem(tmpDevCheckNodeInfo.getCheckReportTable());
            if (bContainsDif) {
                if (this.iColumnNum <= 0) {
                    this.iColumnNum = this.getColumnNum(null);
                }
                this.writeHyperLinkRow(tmpDevCheckNodeInfo);
            }
        } else {
            if (this.iColumnNum <= 0) {
                this.iColumnNum = this.getColumnNum(null);
            }
            this.writeHyperLinkRow(tmpDevCheckNodeInfo);
        }
    }

    private int getTaskUpgradeMode() {
        Resource res;
        DeviceType devType = this.m_oTask.getSelectedDeviceType();
        THashSet<Resource> reslst = devType.getResources();
        int upgradeMode = 0;
        int DEFAULT_UPGRADE_MODE = 0;
        Iterator i$ = reslst.iterator();
        while (i$.hasNext() && DEFAULT_UPGRADE_MODE == (upgradeMode = (res = (Resource)i$.next()).getUpgradeMode())) {
        }
        return upgradeMode;
    }

    private void writeHyperLinkRow(DevCheckNodeInfo tmpDevCheckNodeInfo) {
        CheckReportTable table = tmpDevCheckNodeInfo.getCheckReportTable();
        String[] cols = new String[this.iColumnNum + 2];
        cols[0] = this.getSubInfo("", tmpDevCheckNodeInfo.getNodeName());
        boolean isSnmpSupported = false;
        if (0 != (this.getTaskUpgradeMode() & 0x2000)) {
            isSnmpSupported = true;
        }
        String checkId = tmpDevCheckNodeInfo.getNodeId();
        cols[this.iColumnNum] = isSnmpSupported && !checkId.equals("CurrentConfig") ? "" : "<html><a href=\"x\">" + this.m_resMgr.getResString("CHECK_REPORT_VIEW_DETAIL") + "</a></html>";
        if (null != table) {
            int rowNum = table.getRowCount();
            if (1 == rowNum) {
                ICheckReportTableModel model = table.getModel();
                int colNum = table.getColumnCount();
                for (int i = 0; i < colNum; ++i) {
                    cols[i + 1] = model.getValueAt(0, i).toString();
                }
                if (2 == this.iReportType) {
                    cols[colNum] = this.getCompareColCell(cols[colNum]);
                }
                cols[this.iColumnNum + 1] = tmpDevCheckNodeInfo.getNodeId();
                TreeTableNode node = this.constructNode(cols);
                this.m_oRightTablePanel.getRootNode().add(node);
            } else {
                cols[this.iColumnNum + 1] = tmpDevCheckNodeInfo.getNodeId();
                TreeTableNode node = this.constructNode(cols);
                this.m_oRightTablePanel.getRootNode().add(node);
                this.fillTableContent(tmpDevCheckNodeInfo, node, "");
            }
        } else {
            cols[this.iColumnNum + 1] = tmpDevCheckNodeInfo.getNodeId();
            TreeTableNode node = this.constructNode(cols);
            this.m_oRightTablePanel.getRootNode().add(node);
            this.fillTableContent(tmpDevCheckNodeInfo, node, "");
        }
    }

    private void fillTableContent(DevCheckNodeInfo oCheckNodeInfo, TreeTableNode parentNode, String parentId) {
        if (null == oCheckNodeInfo) {
            return;
        }
        List<DevCheckNodeInfo> nodeLst = oCheckNodeInfo.getDevCheckNodeInfoLst();
        if (0 >= nodeLst.size()) {
            this.fillLeafNodeTableInfo(oCheckNodeInfo, parentNode, parentId);
        } else {
            int nodeNum = nodeLst.size();
            String[] cols = null;
            TreeTableNode node = null;
            DevCheckNodeInfo oDevCheckNodeInfo = null;
            CheckReportTable table = null;
            for (int i = 0; i < nodeNum; ++i) {
                oDevCheckNodeInfo = nodeLst.get(i);
                table = oDevCheckNodeInfo.getCheckReportTable();
                if (table != null && table.getRowCount() > 1 || oDevCheckNodeInfo.getDevCheckNodeInfoLst().size() > 0) {
                    cols = new String[this.iColumnNum + 2];
                    cols[0] = this.getSubInfo(oCheckNodeInfo.getNodeId(), oDevCheckNodeInfo.getNodeId());
                    node = this.constructNode(cols);
                    parentNode.add(node);
                    this.fillTableContent(oDevCheckNodeInfo, node, oCheckNodeInfo.getNodeId());
                    continue;
                }
                this.fillTableContent(oDevCheckNodeInfo, parentNode, oCheckNodeInfo.getNodeId());
            }
        }
    }

    private void fillLeafNodeTableInfo(DevCheckNodeInfo oCheckNodeInfo, TreeTableNode parentNode, String parentId) {
        CheckReportTable table = oCheckNodeInfo.getCheckReportTable();
        if (table != null) {
            int rowNum = table.getRowCount();
            Vector<CheckReportTableCell> colVector = new Vector<CheckReportTableCell>();
            CheckReportTableCell tableCell = null;
            CheckReportTableCell lastTableCell = null;
            CheckReportTableCell firstCell = null;
            CheckReportTableCell newCell = null;
            CheckReportTableCell cell = null;
            int colNumber = 0;
            for (int i = 0; i < rowNum; ++i) {
                colVector.clear();
                colVector.addAll(((DefaultCheckReportTableModel)table.getModel()).getRow(i));
                if (2 == this.iReportType) {
                    cell = (CheckReportTableCell)colVector.get(colVector.size() - 1);
                    if (this.iViewStatus == 1 && !"0".equalsIgnoreCase(cell.getValue())) continue;
                    newCell = this.getCompareColCell(cell);
                    colVector.remove(colVector.size() - 1);
                    colVector.add(newCell);
                }
                tableCell = new CheckReportTableCell();
                tableCell.setCellBackground(Color.WHITE);
                lastTableCell = new CheckReportTableCell();
                firstCell = new CheckReportTableCell();
                firstCell.setValue(this.getSubInfo(parentId, oCheckNodeInfo.getNodeId()));
                colVector.add(tableCell);
                colVector.add(lastTableCell);
                colVector.add(0, firstCell);
                colNumber = colVector.size();
                if (colNumber != this.iColumnNum + 2) {
                    DCDebugTracer.trace("Data is incorrect from server.");
                }
                for (int j = colNumber - 1; j > this.iColumnNum + 1; --j) {
                    colVector.remove(j);
                }
                this.addNewRow(colVector, parentNode);
            }
        }
    }

    private CheckReportTableCell getCompareColCell(CheckReportTableCell cell) {
        CheckReportTableCell newCell = new CheckReportTableCell();
        if ("0".equalsIgnoreCase(cell.getValue())) {
            newCell.setValue(this.m_resMgr.getResString("COMPARE_FAIL"));
        } else if ("1".equalsIgnoreCase(cell.getValue())) {
            newCell.setValue(this.m_resMgr.getResString("COMPARE_SUCCESS"));
        } else {
            newCell.setValue(this.m_resMgr.getResString("NO_NEED_COMPARE"));
        }
        return newCell;
    }

    private String getCompareColCell(String cellValue) {
        String newCellValue = "";
        newCellValue = "0".equalsIgnoreCase(cellValue) ? this.m_resMgr.getResString("COMPARE_FAIL") : ("1".equalsIgnoreCase(cellValue) ? this.m_resMgr.getResString("COMPARE_SUCCESS") : this.m_resMgr.getResString("NO_NEED_COMPARE"));
        return newCellValue;
    }

    public String getSubInfo(String parentId, String subNodeId) {
        if (null == parentId || null == subNodeId) {
            return subNodeId;
        }
        if ("".equals(parentId)) {
            int checkItemLength = subNodeId.length();
            String temp1 = subNodeId.substring(0, checkItemLength / 2);
            String temp2 = subNodeId.substring(checkItemLength / 2 + 1);
            if (Collator.getInstance().equals(temp1, temp2) && subNodeId.contains(".")) {
                subNodeId = temp1;
                temp2 = ResourceManager.getInstance().getResString(temp1);
                Locale oLocale = DCResourceMng.getInstance().getLocale();
                if (!Collator.getInstance().equals(subNodeId.toLowerCase(oLocale), temp2.toLowerCase(oLocale))) {
                    subNodeId = temp2;
                }
            }
            return subNodeId;
        }
        int iTmpLen = parentId.length() + 1;
        if (iTmpLen < subNodeId.length()) {
            return subNodeId.substring(parentId.length() + 1);
        }
        return subNodeId;
    }

    private int getColumnNum(DevCheckNodeInfo oCheckNodeInfo) {
        int iColNum = -1;
        String[] tableHeader = this.getColumns();
        if (null != tableHeader) {
            iColNum = tableHeader.length - 2;
            return iColNum;
        }
        CheckReportTable table = oCheckNodeInfo.getCheckReportTable();
        List<DevCheckNodeInfo> nodeLst = oCheckNodeInfo.getDevCheckNodeInfoLst();
        if (null != table) {
            iColNum = table.getColumnCount();
            return iColNum;
        }
        for (int i = 0; i < nodeLst.size(); ++i) {
            iColNum = this.getColumnNum(nodeLst.get(i));
        }
        return iColNum;
    }

    protected String[] getColumns() {
        String[] tableHeader = null;
        tableHeader = 0 == this.iReportType ? new String[]{this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"), this.m_resMgr.getResString("CHECK_REPORT_PRECHECK_COL"), this.m_resMgr.getResString("CHECK_REPORT_DETAIL_LINK_COL"), this.m_resMgr.getResString("CHECK_REPORT_HIDDEN_COL")} : (1 == this.iReportType ? new String[]{this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"), this.m_resMgr.getResString("CHECK_REPORT_POSTCHECK_COL"), this.m_resMgr.getResString("CHECK_REPORT_DETAIL_LINK_COL"), this.m_resMgr.getResString("CHECK_REPORT_HIDDEN_COL")} : new String[]{this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"), this.m_resMgr.getResString("CHECK_REPORT_PRECHECK_COL"), this.m_resMgr.getResString("CHECK_REPORT_POSTCHECK_COL"), this.m_resMgr.getResString("CHECK_REPORT_COMPARE_COL"), this.m_resMgr.getResString("CHECK_REPORT_DETAIL_LINK_COL"), this.m_resMgr.getResString("CHECK_REPORT_HIDDEN_COL")});
        return tableHeader;
    }

    private void setCursorStatus(int status) {
        Cursor cur = null;
        cur = 12 == status ? new Cursor(12) : new Cursor(0);
        DCFrameWorkUtil.setCursor((Component)((Object)this), cur);
    }

    @Override
    protected void oKButtonActionPerformed() {
        this.saveTableContentToFile();
    }

    private void saveTableContentToFile() {
        this.m_oOKBtn.getModel().setPressed(true);
        this.m_oOKBtn.getModel().setRollover(true);
        this.m_oOKBtn.repaint();
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return;
            }
        }
        DCSaveFileChooser oFileChooserDlg = null;
        oFileChooserDlg = new DCSaveFileChooser(strPath, false);
        oFileChooserDlg.setFileFilter(10);
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(true);
        String fileName = FileUtil.getFileName(ResourceManager.getInstance().getResString("CHECK_REPORT_DEFAULT_FILE_NAME"));
        oFileChooserDlg.setDefaultFileName(fileName + this.getCurrentTime().toString());
        int iReturnVal = oFileChooserDlg.showSaveDialog(this.getContentPane());
        if (iReturnVal == 0) {
            String strFileName = oFileChooserDlg.getFullFileName();
            ISaveFile oSaveFile = null;
            Locale oLocale = DCResourceMng.getInstance().getLocale();
            if (strFileName.toLowerCase(oLocale).endsWith(".xls")) {
                oSaveFile = new DMSCheckReportExcelFile(this.iReportType, this.m_strReportGenerateTime, this.m_oTask, this.m_oDevCheckNodeInfo);
                this.saveRecords(strFileName, oSaveFile);
            } else if (strFileName.toLowerCase(oLocale).endsWith(".csv")) {
                oSaveFile = new DMSCheckReportCSVFile(this.iReportType, this.m_strReportGenerateTime, this.m_oTask, this.m_oDevCheckNodeInfo);
                this.saveRecords(strFileName, oSaveFile);
            } else {
                DCOptionPane.showMessageDialog((Component)((Object)this), this.m_resMgr.getResString("CHECKREPORT_TABLE_FILE_TYPE_NOT_SUPP"), this.m_resMgr.getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    private boolean isContainsDifItem(CheckReportTable oCheckReportTable) {
        if (null != oCheckReportTable && null != oCheckReportTable.getModel() && oCheckReportTable.getColumnCount() > 2) {
            int iRowCount = oCheckReportTable.getModel().getRowCount();
            Vector<ICheckReportTableCell> vector = null;
            for (int i = 0; i < iRowCount; ++i) {
                vector = oCheckReportTable.getModel().getRow(i);
                if (null == vector || Collator.getInstance().equals(vector.get(0).toString(), vector.get(1).toString())) continue;
                return true;
            }
        }
        return false;
    }

    private class ReportTableMouseListener
    extends MouseAdapter {
        private ReportTableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DMSReportDlg.this.setCursorStatus(0);
        }
    }

    private class ReportTableMouseMotionListener
    extends MouseMotionAdapter {
        private ReportTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            JSortTreeTable rightTable = DMSReportDlg.this.m_oRightTablePanel.getReportTreeTable();
            if (rightTable.columnAtPoint(oPoint) == DMSReportDlg.this.iColumnNum) {
                TableCellRenderer oRenderer = rightTable.getCellRenderer(rightTable.rowAtPoint(oPoint), DMSReportDlg.this.iColumnNum);
                Object value = rightTable.getValueAt(rightTable.rowAtPoint(oPoint), DMSReportDlg.this.iColumnNum);
                if (oRenderer instanceof ReportTreeTableRenderer && value instanceof String) {
                    DMSReportDlg.this.setCursorStatus(12);
                } else {
                    DMSReportDlg.this.setCursorStatus(0);
                }
            } else {
                DMSReportDlg.this.setCursorStatus(0);
            }
        }
    }
}

