/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.ExcelFileWtiterHelper;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.report.devlevel.ISaveFile;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.view.ReportCommon;
import java.awt.Color;
import java.io.File;
import java.util.List;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class DMSCheckReportExcelFile
implements ISaveFile {
    private static final long serialVersionUID = 3037636803707460120L;
    protected int iReportType = -1;
    private String m_strReportGenerateTime = "";
    private DevCheckNodeInfo m_oDevCheckNodeInfo = null;
    private ITask m_oTask = null;
    private int excelRowNum = 0;
    private static final int CHECK_ITEM_COL = 0;
    private boolean bIsMemoryAvailable = true;
    private ResourceManager m_resMgr = ResourceManager.getInstance();

    public DMSCheckReportExcelFile(int reportType, String reportTime, ITask task, DevCheckNodeInfo nodeInfo) {
        this.iReportType = reportType;
        this.m_strReportGenerateTime = reportTime;
        this.m_oTask = task;
        this.m_oDevCheckNodeInfo = nodeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveAs(String strFileName) {
        WritableWorkbook workbook;
        boolean isSaveSuccess;
        block11: {
            WritableSheet sheet;
            WritableCellFormat oBlackFont;
            File excelFile;
            List<DevCheckNodeInfo> tableElements;
            block10: {
                isSaveSuccess = true;
                tableElements = this.m_oDevCheckNodeInfo.getDevCheckNodeInfoLst();
                if (null == tableElements) {
                    return false;
                }
                workbook = null;
                excelFile = null;
                int mergeCellsCount = 1;
                if (this.iReportType == 2) {
                    mergeCellsCount = 3;
                }
                excelFile = new File(strFileName);
                workbook = Workbook.createWorkbook((File)excelFile);
                WritableFont boldtitleFont = new WritableFont(WritableFont.ARIAL, 16, WritableFont.BOLD);
                boldtitleFont.setColour(Colour.PALETTE_BLACK);
                WritableCellFormat boldTitle = new WritableCellFormat(boldtitleFont);
                boldTitle.setBorder(Border.ALL, BorderLineStyle.THIN);
                WritableFont oBlueColorFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
                oBlueColorFont.setColour(Colour.BLUE);
                WritableFont oRedColorFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
                oRedColorFont.setColour(Colour.RED);
                WritableFont oBlackColorFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
                oBlackColorFont.setColour(Colour.PALETTE_BLACK);
                oBlackFont = new WritableCellFormat(oBlackColorFont);
                oBlackFont.setBorder(Border.ALL, BorderLineStyle.THIN);
                WritableFont tasktitleFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
                tasktitleFont.setColour(Colour.PALETTE_BLACK);
                WritableCellFormat taskTitle = new WritableCellFormat(tasktitleFont);
                taskTitle.setBorder(Border.ALL, BorderLineStyle.THIN);
                String csvRptTitle = ReportCommon.getReportName(this.iReportType);
                sheet = workbook.createSheet(csvRptTitle, 0);
                Label rptTitleCell = new Label(0, this.excelRowNum, csvRptTitle, (CellFormat)boldTitle);
                sheet.addCell((WritableCell)rptTitleCell);
                sheet.mergeCells(0, this.excelRowNum, mergeCellsCount, this.excelRowNum);
                ++this.excelRowNum;
                Label rptDateTitleCell = new Label(0, this.excelRowNum, this.m_resMgr.getResString("RPT_GENERATION_TIME"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)rptDateTitleCell);
                Label rptDateValueCell = new Label(1, this.excelRowNum, this.m_strReportGenerateTime, (CellFormat)oBlackFont);
                sheet.addCell((WritableCell)rptDateValueCell);
                sheet.mergeCells(1, this.excelRowNum, mergeCellsCount, this.excelRowNum);
                ++this.excelRowNum;
                Label rptTaskTitleCell = new Label(0, this.excelRowNum, this.m_resMgr.getResString("TASK_NAME") + ' ' + ':', (CellFormat)taskTitle);
                sheet.addCell((WritableCell)rptTaskTitleCell);
                Label rptTaskValueCell = new Label(1, this.excelRowNum, this.m_oTask.getTaskName(), (CellFormat)oBlackFont);
                sheet.addCell((WritableCell)rptTaskValueCell);
                sheet.mergeCells(1, this.excelRowNum, mergeCellsCount, this.excelRowNum);
                ++this.excelRowNum;
                Label rptDeviceTypeTitleCell = new Label(0, this.excelRowNum, this.m_resMgr.getResString("TASK_DEVICE_TYPE"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)rptDeviceTypeTitleCell);
                Label rptDeviceTypeValueCell = new Label(1, this.excelRowNum, this.m_oTask.getSelectedDeviceType().getDeviceTypeName(), (CellFormat)oBlackFont);
                sheet.addCell((WritableCell)rptDeviceTypeValueCell);
                sheet.mergeCells(1, this.excelRowNum, mergeCellsCount, this.excelRowNum);
                ++this.excelRowNum;
                Label rptTotalDevicesTitleCell = new Label(0, this.excelRowNum, this.m_resMgr.getResString("DEVICE_IP"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)rptTotalDevicesTitleCell);
                Label rptTotalDevicesValueCell = new Label(1, this.excelRowNum, "" + this.m_oTask.getSelectedDeviceType().getFirstResource().getDeviceIP(), (CellFormat)oBlackFont);
                sheet.addCell((WritableCell)rptTotalDevicesValueCell);
                sheet.mergeCells(1, this.excelRowNum, mergeCellsCount, this.excelRowNum);
                ++this.excelRowNum;
                Label nulllabel1 = new Label(0, this.excelRowNum, "", (CellFormat)taskTitle);
                sheet.addCell((WritableCell)nulllabel1);
                Label nulllabel2 = new Label(1, this.excelRowNum, "", (CellFormat)oBlackFont);
                sheet.addCell((WritableCell)nulllabel2);
                sheet.mergeCells(1, this.excelRowNum, mergeCellsCount, this.excelRowNum);
                ++this.excelRowNum;
                if (this.fillTableHeader(sheet, taskTitle)) break block10;
                boolean bl = false;
                ReportCommon.closeIOStream(workbook);
                return bl;
            }
            try {
                ++this.excelRowNum;
                int tableNum = tableElements.size();
                DevCheckNodeInfo oTableInfo = null;
                for (int i = 0; i < tableNum; ++i) {
                    oTableInfo = tableElements.get(i);
                    this.getTableContent(sheet, oBlackFont, oTableInfo, "");
                }
                ExcelFileWtiterHelper excelHelper = new ExcelFileWtiterHelper();
                this.bIsMemoryAvailable = true;
                long lFreeMemoryAvail = 0L;
                long lFileSize = 0L;
                if (null != excelFile) {
                    lFreeMemoryAvail = excelFile.getFreeSpace();
                }
                lFileSize = excelHelper.getExcelFileContentSize(workbook);
                if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
                    isSaveSuccess = false;
                    this.bIsMemoryAvailable = false;
                }
                if (!this.bIsMemoryAvailable) break block11;
                workbook.write();
            }
            catch (Exception allException) {
                try {
                    isSaveSuccess = false;
                    DCDebugTracer.traceError(allException.getMessage());
                }
                catch (Throwable throwable) {
                    ReportCommon.closeIOStream(workbook);
                    throw throwable;
                }
                ReportCommon.closeIOStream(workbook);
            }
        }
        ReportCommon.closeIOStream(workbook);
        return isSaveSuccess;
    }

    private boolean fillTableHeader(WritableSheet sheet, WritableCellFormat taskTitle) {
        boolean isSaveSuccess = true;
        try {
            if (0 == this.iReportType) {
                Label checkItemCell = new Label(0, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)checkItemCell);
                Label valueCell = new Label(1, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_PRECHECK_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)valueCell);
            } else if (1 == this.iReportType) {
                Label checkItemCell = new Label(0, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)checkItemCell);
                Label valueCell = new Label(1, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_POSTCHECK_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)valueCell);
            } else {
                Label checkItemCell = new Label(0, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)checkItemCell);
                Label precheckCell = new Label(1, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_PRECHECK_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)precheckCell);
                Label postcheckCell = new Label(2, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_POSTCHECK_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)postcheckCell);
                Label compareCell = new Label(3, this.excelRowNum, this.m_resMgr.getResString("CHECK_REPORT_COMPARE_COL"), (CellFormat)taskTitle);
                sheet.addCell((WritableCell)compareCell);
            }
        }
        catch (Exception exception) {
            isSaveSuccess = false;
            DCDebugTracer.traceError(exception.getMessage());
        }
        return isSaveSuccess;
    }

    private boolean writeTableContent(WritableSheet sheet, WritableCellFormat oBlackFont, ICheckReportTableModel content, String prefix) {
        if (null == content) {
            return false;
        }
        prefix = ReportCommon.convertCheckitem(prefix);
        boolean result = true;
        try {
            int colNum = content.getColumnCount();
            int rowNum = content.getRowCount();
            Label excelHeaderCell = null;
            ICheckReportTableCell cell = null;
            for (int row = 0; row < rowNum; ++row) {
                excelHeaderCell = new Label(0, this.excelRowNum, prefix, (CellFormat)ReportCommon.getWritableCellFormatDMS(Color.BLACK));
                sheet.addCell((WritableCell)excelHeaderCell);
                for (int col = 0; col < colNum; ++col) {
                    cell = content.getValueAt(row, col);
                    if (null == cell) {
                        excelHeaderCell = new Label(col + 1, this.excelRowNum, "", (CellFormat)ReportCommon.getWritableCellFormatDMS(Color.white));
                    } else {
                        int length = cell.getValue().length();
                        String cellValue = cell.getValue();
                        if (length > 1024) {
                            DCDebugTracer.trace("DMSCheckReportExcelFile#writeTableContent lost some data");
                            DCDebugTracer.trace(cellValue);
                            cellValue = cellValue.substring(0, 1023);
                            cell.setValue(cellValue + "...");
                        }
                        excelHeaderCell = this.getTableCellLabel(colNum, col, cell);
                    }
                    sheet.addCell((WritableCell)excelHeaderCell);
                }
                ++this.excelRowNum;
            }
        }
        catch (Exception allException) {
            result = false;
            DCDebugTracer.traceError(allException.getMessage());
        }
        return result;
    }

    private Label getTableCellLabel(int colNum, int col, ICheckReportTableCell cell) {
        Label excelHeaderCell = null;
        excelHeaderCell = col == colNum - 1 && 2 == this.iReportType ? ("0".equalsIgnoreCase(cell.getValue()) ? new Label(col + 1, this.excelRowNum, this.m_resMgr.getResString("COMPARE_FAIL"), (CellFormat)ReportCommon.getWritableCellFormatDMS(Color.RED)) : ("1".equalsIgnoreCase(cell.getValue()) ? new Label(col + 1, this.excelRowNum, this.m_resMgr.getResString("COMPARE_SUCCESS"), (CellFormat)ReportCommon.getWritableCellFormatDMS(Color.BLACK)) : new Label(col + 1, this.excelRowNum, this.m_resMgr.getResString("NO_NEED_COMPARE"), (CellFormat)ReportCommon.getWritableCellFormatDMS(Color.BLACK)))) : new Label(col + 1, this.excelRowNum, cell.getValue(), (CellFormat)ReportCommon.getWritableCellFormatDMS(cell.getCellColor()));
        return excelHeaderCell;
    }

    private boolean getTableContent(WritableSheet sheet, WritableCellFormat oBlackFont, DevCheckNodeInfo oTableInfo, String prefix) {
        String nodeId = oTableInfo.getNodeId();
        prefix = "" + nodeId;
        List<DevCheckNodeInfo> subNodeLst = oTableInfo.getDevCheckNodeInfoLst();
        if (subNodeLst != null && 0 < subNodeLst.size()) {
            int tableNum = subNodeLst.size();
            for (int i = 0; i < tableNum; ++i) {
                this.getTableContent(sheet, oBlackFont, subNodeLst.get(i), prefix);
            }
        } else {
            ICheckReportTableModel content;
            CheckReportTable reportTable = oTableInfo.getCheckReportTable();
            if (null != reportTable && !this.writeTableContent(sheet, oBlackFont, content = reportTable.getModel(), prefix)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getIsSpaceForSave() {
        return this.bIsMemoryAvailable;
    }
}

