/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.report.devlevel.ISaveFile;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportConstant;
import com.huawei.dc.taskmgmt.report.devlevel.view.ReportCommon;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class DMSCheckReportCSVFile
implements ISaveFile {
    private static final long serialVersionUID = 3037636803707460120L;
    protected int iReportType = -1;
    private String m_strReportGenerateTime = "";
    private DevCheckNodeInfo m_oDevCheckNodeInfo = null;
    private ITask m_oTask = null;
    private boolean bIsMemoryAvailable = true;
    private ResourceManager m_resMgr = ResourceManager.getInstance();

    public DMSCheckReportCSVFile(int reportType, String reportTime, ITask task, DevCheckNodeInfo nodeInfo) {
        this.iReportType = reportType;
        this.m_strReportGenerateTime = reportTime;
        this.m_oTask = task;
        this.m_oDevCheckNodeInfo = nodeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveAs(String strFileName) {
        boolean isSaveSuccess = true;
        List<DevCheckNodeInfo> tableElements = this.m_oDevCheckNodeInfo.getDevCheckNodeInfoLst();
        if (null == tableElements) {
            return false;
        }
        FileOutputStream oStream = null;
        OutputStreamWriter oWriter = null;
        BufferedWriter oBufferedWriter = null;
        StringBuilder strBuild = null;
        try {
            File file = new File(strFileName);
            oStream = new FileOutputStream(file);
            oWriter = new OutputStreamWriter((OutputStream)oStream, FileUtil.getSystemEncoding());
            strBuild = new StringBuilder();
            String title = ReportCommon.getReportName(this.iReportType);
            if ("".equals(title)) {
                DCDebugTracer.traceError("==== The iReportType is error.====");
                boolean bl = false;
                return bl;
            }
            strBuild.append(title);
            strBuild.append(DCConstants.LINE_SEPARATOR);
            strBuild.append(this.m_resMgr.getResString("RPT_GENERATION_TIME"));
            strBuild.append(",");
            strBuild.append(this.m_strReportGenerateTime);
            strBuild.append(DCConstants.LINE_SEPARATOR);
            strBuild.append(this.m_resMgr.getResString("TASK_NAME"));
            strBuild.append(",");
            strBuild.append(this.m_oTask.getTaskName());
            strBuild.append(DCConstants.LINE_SEPARATOR);
            strBuild.append(this.m_resMgr.getResString("TASK_DEVICE_TYPE"));
            strBuild.append(",");
            strBuild.append(this.m_oTask.getSelectedDeviceType().getDeviceTypeName());
            strBuild.append(DCConstants.LINE_SEPARATOR);
            strBuild.append(this.m_resMgr.getResString("DEVICE_IP"));
            strBuild.append(",");
            strBuild.append(this.m_oTask.getSelectedDeviceType().getFirstResource().getDeviceIP());
            strBuild.append(DCConstants.LINE_SEPARATOR);
            strBuild.append(DCConstants.LINE_SEPARATOR);
            this.fillTableHeader(strBuild);
            int tableNum = tableElements.size();
            DevCheckNodeInfo oTableInfo = null;
            for (int i = 0; i < tableNum; ++i) {
                oTableInfo = tableElements.get(i);
                this.getTableContent(strBuild, oTableInfo);
            }
            if (ReportCommon.isHaveFreeSpace(file, strBuild.toString().getBytes().length)) {
                this.bIsMemoryAvailable = true;
                oBufferedWriter = new BufferedWriter(oWriter);
                oBufferedWriter.write(strBuild.toString());
            } else {
                this.bIsMemoryAvailable = false;
                isSaveSuccess = false;
                DCDebugTracer.traceWarning("The hardware space is not enough.");
            }
        }
        catch (IOException ioException) {
            isSaveSuccess = false;
            DCDebugTracer.traceError(ioException.getMessage());
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oWriter) {
                    oWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oStream) {
                    oStream.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
        return isSaveSuccess;
    }

    private void fillTableHeader(StringBuilder strBuild) {
        if (0 == this.iReportType) {
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"));
            strBuild.append(",");
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_PRECHECK_COL"));
            strBuild.append(DCConstants.LINE_SEPARATOR);
        } else if (1 == this.iReportType) {
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"));
            strBuild.append(",");
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_POSTCHECK_COL"));
            strBuild.append(DCConstants.LINE_SEPARATOR);
        } else {
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_CHECK_ITEM_COL"));
            strBuild.append(",");
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_PRECHECK_COL"));
            strBuild.append(",");
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_POSTCHECK_COL"));
            strBuild.append(",");
            strBuild.append(this.m_resMgr.getResString("CHECK_REPORT_COMPARE_COL"));
            strBuild.append(DCConstants.LINE_SEPARATOR);
        }
    }

    private void writeTableContent(StringBuilder strBuild, ICheckReportTableModel content, String prefix) {
        if (null == content) {
            return;
        }
        prefix = ReportCommon.convertCheckitem(prefix);
        int colNum = content.getColumnCount();
        int rowNum = content.getRowCount();
        ICheckReportTableCell cell = null;
        for (int row = 0; row < rowNum; ++row) {
            strBuild.append(prefix);
            strBuild.append(",");
            for (int col = 0; col < colNum; ++col) {
                cell = content.getValueAt(row, col);
                this.writeTableCellInfo(strBuild, colNum, col, cell);
            }
            strBuild.append(DCConstants.LINE_SEPARATOR);
        }
    }

    private void writeTableCellInfo(StringBuilder strBuild, int colNum, int col, ICheckReportTableCell cell) {
        if (null == cell) {
            strBuild.append("");
            strBuild.append(",");
        } else {
            if (col == colNum - 1 && 2 == this.iReportType) {
                if ("0".equalsIgnoreCase(cell.getValue())) {
                    strBuild.append(this.m_resMgr.getResString("COMPARE_FAIL"));
                } else if ("1".equalsIgnoreCase(cell.getValue())) {
                    strBuild.append(this.m_resMgr.getResString("COMPARE_SUCCESS"));
                } else {
                    strBuild.append(this.m_resMgr.getResString("NO_NEED_COMPARE"));
                }
            } else {
                strBuild.append(ReportConstant.clearLineSeparator(cell.getValue()));
            }
            strBuild.append(",");
        }
    }

    private void getTableContent(StringBuilder strBuild, DevCheckNodeInfo oTableInfo) {
        String nodeId = oTableInfo.getNodeId();
        List<DevCheckNodeInfo> subNodeLst = oTableInfo.getDevCheckNodeInfoLst();
        if (subNodeLst != null && 0 < subNodeLst.size()) {
            int tableNum = subNodeLst.size();
            for (int i = 0; i < tableNum; ++i) {
                this.getTableContent(strBuild, subNodeLst.get(i));
            }
        } else {
            CheckReportTable reportTable = oTableInfo.getCheckReportTable();
            if (null != reportTable) {
                ICheckReportTableModel content = reportTable.getModel();
                this.writeTableContent(strBuild, content, nodeId);
            }
        }
    }

    @Override
    public boolean getIsSpaceForSave() {
        return this.bIsMemoryAvailable;
    }
}

