/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportNotifier;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportProgressController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class AutoProgressDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JProgressBar m_oProgressBar = null;
    private JButton m_oCancelButton;
    private CheckReportProgressController m_oController;

    public AutoProgressDlg(CheckReportProgressController oController, String strDialogTitle) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.m_oController = oController;
        this.jbInit();
        this.setTitle(strDialogTitle);
        this.setDefaultCloseOperation(2);
    }

    private void jbInit() {
        this.initDialog();
        this.initProgressbar();
        this.initCancelButton();
    }

    private void initDialog() {
        this.setSize(500, 120);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.getContentPane().setLayout(null);
    }

    private void initProgressbar() {
        this.m_oProgressBar = new JProgressBar(0, 0, 100);
        this.m_oProgressBar.setName("DeviceManagement_AutoProgressDlg_m_oProgressBar");
        this.m_oProgressBar.setOpaque(true);
        this.m_oProgressBar.setBounds(10, 15, 470, 21);
        this.m_oProgressBar.setBackground(this.getBackground());
        this.m_oProgressBar.setForeground(new Color(0, 0, 116));
        this.m_oProgressBar.setValue(0);
        this.m_oProgressBar.setStringPainted(true);
        this.m_oProgressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.gray));
        this.getContentPane().add((Component)this.m_oProgressBar, null);
    }

    private void initCancelButton() {
        this.m_oCancelButton = new JButton();
        this.m_oCancelButton.setName("DeviceManagement_AutoProgressDlg_m_oCancelButton");
        this.m_oCancelButton.setBounds(new Rectangle(400, 55, 80, 21));
        this.m_oCancelButton.setText(ResourceManager.getInstance().getResString("MDP_SETTING_CANCEL_BTN"));
        this.m_oCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutoProgressDlg.this.closeDialog();
            }
        });
        this.getContentPane().add((Component)this.m_oCancelButton, null);
    }

    @Override
    public void closeDialog() {
        CheckReportNotifier.getInstance().removeTaskNotificationListener(this.m_oController);
        this.setVisible(false);
        this.dispose();
    }

    public void setProgress(final int iProgress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoProgressDlg.this.m_oProgressBar.setValue(iProgress);
                AutoProgressDlg.this.m_oProgressBar.updateUI();
                AutoProgressDlg.this.getContentPane().validate();
                AutoProgressDlg.this.getContentPane().repaint();
            }
        });
    }

    @Override
    protected String getCurrentContext() {
        return "";
    }
}

