/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.model;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeader;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeaderElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DevCheckNodeInfo
implements Serializable {
    private static final long serialVersionUID = -669969231473895254L;
    private String m_strNodeId = "";
    private String m_strNodeName = null;
    private int iStatus = 0;
    private boolean bIsCheckItem = false;
    private List<DevCheckNodeInfo> m_oDevCheckNodeInfoLst = new ArrayList<DevCheckNodeInfo>(5);
    private CheckReportTable m_oCheckReportTable = null;

    public String getNodeId() {
        return this.m_strNodeId;
    }

    public void setNodeId(String nodeId) {
        if (null == nodeId) {
            this.m_strNodeName = "";
            this.m_strNodeId = "";
        } else {
            this.m_strNodeId = nodeId;
            this.m_strNodeName = ResourceManager.getInstance().getResString(this.m_strNodeId);
        }
    }

    public void setNodeId(String nodeId, String devType) {
        if (null == nodeId) {
            this.m_strNodeName = "";
            this.m_strNodeId = "";
        } else {
            this.m_strNodeId = nodeId;
            this.m_strNodeName = ResourceManager.getInstance().getSpecialResForDMS(devType, this.m_strNodeId);
        }
    }

    public int getStatus() {
        return this.iStatus;
    }

    public void setStatus(int status) {
        this.iStatus = status;
    }

    public boolean isCheckItem() {
        return this.bIsCheckItem;
    }

    public void setIsCheckItem(boolean isCheckItem) {
        this.bIsCheckItem = isCheckItem;
    }

    public List<DevCheckNodeInfo> getDevCheckNodeInfoLst() {
        return this.m_oDevCheckNodeInfoLst;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_strNodeId == null ? 0 : this.m_strNodeId.hashCode());
        result = 31 * result + (this.m_strNodeName == null ? 0 : this.m_strNodeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DevCheckNodeInfo other = (DevCheckNodeInfo)obj;
        if (this.m_strNodeId == null ? other.m_strNodeId != null : !this.m_strNodeId.equals(other.m_strNodeId)) {
            return false;
        }
        return !(this.m_strNodeName == null ? other.m_strNodeName != null : !this.m_strNodeName.equals(other.m_strNodeName));
    }

    public void setDevCheckNodeInfoLst(List<DevCheckNodeInfo> devCheckNodeInfoLst) {
        this.m_oDevCheckNodeInfoLst = devCheckNodeInfoLst;
    }

    public CheckReportTable getCheckReportTable() {
        return this.m_oCheckReportTable;
    }

    public void setCheckReportTable(CheckReportTable checkReportTable) {
        this.m_oCheckReportTable = checkReportTable;
    }

    public String getNodeName() {
        return this.m_strNodeName;
    }

    public void setNodeName(String nodeName) {
        this.m_strNodeName = nodeName;
    }

    public String[] getTableHeaderColumns() {
        String[] columns = null;
        CheckReportTable table = this.getCheckReportTable();
        List<DevCheckNodeInfo> nodeLst = this.getDevCheckNodeInfoLst();
        if (null != table) {
            ICheckReportHeader reportHeader = table.getTableHeader();
            if (null != reportHeader) {
                List<ICheckReportHeaderElement> oHeadLst = reportHeader.getHeaderElementList();
                if (null != oHeadLst && !oHeadLst.isEmpty()) {
                    columns = this.getTableHeader(oHeadLst);
                }
            } else {
                columns = new String[]{};
            }
        } else {
            for (int i = 0; i < nodeLst.size(); ++i) {
                columns = nodeLst.get(i).getTableHeaderColumns();
                if (null == columns) continue;
                return columns;
            }
        }
        return columns;
    }

    private String[] getTableHeader(List<ICheckReportHeaderElement> oHeadLst) {
        CheckReportTableCell oTableCell = null;
        String[] columns = new String[oHeadLst.size()];
        for (int i = 0; i < oHeadLst.size(); ++i) {
            oTableCell = (CheckReportTableCell)((Object)oHeadLst.get(i));
            if (null == oTableCell) continue;
            columns[i] = oTableCell.getValue();
        }
        return columns;
    }

    public boolean isContainNode(DevCheckNodeInfo devCheckNodeInfo) {
        boolean result = false;
        if (null == devCheckNodeInfo) {
            return false;
        }
        String nodeId = devCheckNodeInfo.getNodeId();
        if (this.m_strNodeId.equalsIgnoreCase(nodeId)) {
            return true;
        }
        if (null != this.m_oDevCheckNodeInfoLst) {
            int nodeNum = this.m_oDevCheckNodeInfoLst.size();
            for (int i = 0; i < nodeNum; ++i) {
                if (!this.m_oDevCheckNodeInfoLst.get(i).isContainNode(devCheckNodeInfo)) continue;
                return true;
            }
        }
        return result;
    }

    public DevCheckNodeInfo getSubNodeForID(String nodeId) {
        DevCheckNodeInfo oDevCheckNodeInfo = null;
        if (null == nodeId || "".equals(nodeId.trim())) {
            return null;
        }
        if (nodeId.equalsIgnoreCase(this.m_strNodeId)) {
            return this;
        }
        if (null != this.m_oDevCheckNodeInfoLst) {
            int nodeNum = this.m_oDevCheckNodeInfoLst.size();
            for (int i = 0; i < nodeNum; ++i) {
                oDevCheckNodeInfo = this.m_oDevCheckNodeInfoLst.get(i).getSubNodeForID(nodeId);
                if (null == oDevCheckNodeInfo) continue;
                return oDevCheckNodeInfo;
            }
        }
        return oDevCheckNodeInfo;
    }
}

