/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.model;

import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.InvalidNumOfColException;
import java.util.List;
import java.util.Vector;

public class DefaultCheckReportTableModel
implements ICheckReportTableModel {
    private static final long serialVersionUID = 1L;
    private List<List<CheckReportTableCell>> m_oRowList = new Vector<List<CheckReportTableCell>>(8);
    private int iColCount;

    public DefaultCheckReportTableModel(int colSize) {
        this.iColCount = colSize;
    }

    @Override
    public int getColumnCount() {
        return this.iColCount;
    }

    @Override
    public int getRowCount() {
        return this.m_oRowList.size();
    }

    @Override
    public ICheckReportTableCell getValueAt(int rowIndex, int columnIndex) {
        if (this.getRowCount() > rowIndex && this.getColumnCount() > columnIndex) {
            return (ICheckReportTableCell)((Vector)this.m_oRowList.get(rowIndex)).get(columnIndex);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void addRow(Vector row) throws InvalidNumOfColException {
        this.validateRowElement(row);
        this.m_oRowList.add(row);
    }

    private void validateRowElement(Vector row) throws InvalidNumOfColException {
        int iSize = row.size();
        if (this.getColumnCount() != iSize) {
            throw new InvalidNumOfColException();
        }
        for (int i = 0; i < iSize; ++i) {
            if (row.get(i) instanceof ICheckReportTableCell) continue;
            throw new ClassCastException();
        }
    }

    public Vector getRow(int iRowIndex) {
        return (Vector)this.m_oRowList.get(iRowIndex);
    }
}

