/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.model;

import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeader;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeaderElement;
import com.huawei.dc.taskmgmt.report.devlevel.model.InvalidNumOfColException;
import java.util.ArrayList;
import java.util.List;

public class CheckReportHeader
implements ICheckReportHeader {
    private static final long serialVersionUID = 1L;
    private List m_oHeaderElementList;
    private int iHeaderRowSpan = 1;
    private int iColCount;

    public CheckReportHeader(int rowSpan, int colCount) throws InvalidNumOfColException {
        if (1 > rowSpan || 1 > colCount) {
            throw new InvalidNumOfColException();
        }
        this.iHeaderRowSpan = rowSpan;
        this.m_oHeaderElementList = new ArrayList(8);
        this.iColCount = colCount;
    }

    @Override
    public int getColumnCount() {
        return this.iColCount;
    }

    public List getHeaderElementList() {
        return this.m_oHeaderElementList;
    }

    @Override
    public int getRowSpanCount() {
        return this.iHeaderRowSpan;
    }

    @Override
    public void setHeaderElementList(List headerElementList) {
        this.m_oHeaderElementList = headerElementList;
    }

    @Override
    public ICheckReportHeaderElement getHeaderElement(int col) {
        if (col >= this.m_oHeaderElementList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ICheckReportHeaderElement)this.m_oHeaderElementList.get(col);
    }
}

