/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.impl;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.ExcelFileWtiterHelper;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.impl.BMSDevTaskReport;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import gnu.trove.THashSet;
import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class BMSExcelFileWriter
implements IFileWriter {
    private static final int CHECK_ITEM_COL = 0;
    private static final int PRECHECK_STASUS_COL = 1;
    private static final int PRECHECK_RESULT_COL = 2;
    private static final int POSTCHECK_RESULT_COL = 4;
    private static final int POSTCHECK_STASUS_COL = 3;
    private static final int COMPARE_RESULT_COL = 5;
    private static final int BASIC_SEQUENCE_NO_COL = 0;
    private static final int BASIC_RESOURCE_NAME_COL = 1;
    private static final int BASIC_NE_IP_COL = 2;
    private static final int BASIC_DEV_TYPE_COL = 3;
    private static final int BASIC_COM_RESULT_COL = 4;
    private int iCurDevCheckReportType;
    private final String DEV_TYPE_STR;
    private ExcelFileWtiterHelper excelHelper = null;
    private Map<Integer, DevCheckInfo> allCheckInfo = null;
    private THashSet<Resource> oResLst = null;
    private ResourceManager resMgr = ResourceManager.getInstance();
    private TaskReportFileInfo taskReportFileInfo;
    private int iChkItemDiffCnt = 0;

    public void setAllCheckInfo(Map<Integer, DevCheckInfo> allCheckInfo) {
        this.allCheckInfo = allCheckInfo;
    }

    public BMSExcelFileWriter(TaskReportFileInfo taskReportFileInfo, String strDevTypeName, THashSet<Resource> resLst) {
        this.oResLst = resLst;
        this.DEV_TYPE_STR = strDevTypeName;
        this.taskReportFileInfo = taskReportFileInfo;
        this.excelHelper = new ExcelFileWtiterHelper();
    }

    private void buildOneDeviceCheckItemInfo(WritableSheet upgradeInfoSheet, Resource res) throws DCException {
        int curSheetRowNum = 0;
        ExcelFileWtiterHelper.addCell(0, curSheetRowNum, this.resMgr.getResString("CHECK_REPORT_NE_RESULT"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
        if (null == oDevCheckNodeInfo) {
            ExcelFileWtiterHelper.addDataStrCell(1, curSheetRowNum, this.resMgr.getResString("CHECK_DATA_EMPTY"), upgradeInfoSheet);
            return;
        }
        int iComResult = oDevCheckNodeInfo.getiCheckCompareResult();
        ExcelFileWtiterHelper.addDataStrCell(1, curSheetRowNum, BMSDevTaskReport.parseCompareResult(iComResult), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, curSheetRowNum, this.resMgr.getResString("CHECK_COMPARE_COUNT"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ++curSheetRowNum;
        ++curSheetRowNum;
        curSheetRowNum = this.createAlarmInfo(upgradeInfoSheet, res, curSheetRowNum);
        ++curSheetRowNum;
        this.createCheckItemInfo(upgradeInfoSheet, res, ++curSheetRowNum);
        ExcelFileWtiterHelper.addDataNumberCell(3, 0, String.valueOf(this.iChkItemDiffCnt), upgradeInfoSheet);
        upgradeInfoSheet.setColumnView(0, 25);
        upgradeInfoSheet.setColumnView(2, 18);
        upgradeInfoSheet.setColumnView(1, 18);
        upgradeInfoSheet.setColumnView(4, 18);
        upgradeInfoSheet.setColumnView(3, 18);
        upgradeInfoSheet.setColumnView(5, 18);
    }

    private void createCheckItemInfo(WritableSheet upgradeInfoSheet, Resource res, int curSheetRowNum) throws DCException {
        int iRowNumber = curSheetRowNum;
        DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
        DevCheckNodeInfo devStatusNodeInfo = oDevCheckNodeInfo.getCheckItemInfo("DeviceStatus");
        DevCheckNodeInfo mxuStatusNodeInfo = oDevCheckNodeInfo.getCheckItemInfo("MxuStatus");
        if ("".equals(devStatusNodeInfo.getNodeId()) && "".equals(mxuStatusNodeInfo.getNodeId())) {
            DCDebugTracer.trace("BMSExcelFileWriter#createCheckItemInfo->do not have DEVICE_STATUS &  MXU_STATUS information");
            return;
        }
        iRowNumber = this.createCheckItemColorDesc(upgradeInfoSheet, iRowNumber);
        ExcelFileWtiterHelper.addCell(0, iRowNumber, this.resMgr.getResString("CHECK_REPORT_CHKITM_CHK"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        this.iCurDevCheckReportType = oDevCheckNodeInfo.getiCheckReportType();
        this.createCheckItemHeader(upgradeInfoSheet, ++iRowNumber);
        int startRow = ++iRowNumber;
        iRowNumber = this.createCheckItemContent(upgradeInfoSheet, iRowNumber, devStatusNodeInfo);
        ExcelFileWtiterHelper.setRowGroup(upgradeInfoSheet, startRow, iRowNumber - 2);
        startRow = iRowNumber;
        iRowNumber = this.createCheckItemContent(upgradeInfoSheet, iRowNumber, mxuStatusNodeInfo);
        ExcelFileWtiterHelper.setRowGroup(upgradeInfoSheet, startRow, iRowNumber - 2);
    }

    private int createCheckItemContent(WritableSheet upgradeInfoSheet, int curSheetRowNum, DevCheckNodeInfo oDevCheckNodeInfo) throws DCException {
        int rowIndex = curSheetRowNum;
        List<DevCheckNodeInfo> nodeLst = oDevCheckNodeInfo.getDevCheckNodeInfoLst();
        StringBuilder header = null;
        if (null != nodeLst) {
            for (DevCheckNodeInfo devCheckNodeInfo : nodeLst) {
                header = new StringBuilder();
                header.append(oDevCheckNodeInfo.getNodeName());
                header.append(".");
                header.append(devCheckNodeInfo.getNodeName());
                header.append(".");
                List<DevCheckNodeInfo> tempNodeLst = devCheckNodeInfo.getDevCheckNodeInfoLst();
                if (tempNodeLst.size() <= 0) {
                    rowIndex = this.fillRowData(devCheckNodeInfo, rowIndex, header.toString(), upgradeInfoSheet);
                    continue;
                }
                this.createCheckItemContent(upgradeInfoSheet, curSheetRowNum, oDevCheckNodeInfo);
            }
        }
        return rowIndex;
    }

    private void createCheckItemHeader(WritableSheet upgradeInfoSheet, int curSheetRowNum) {
        ExcelFileWtiterHelper.addCell(0, curSheetRowNum, this.resMgr.getResString("TASK_REPORT_CHECK_ITEM_1"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(1, curSheetRowNum, this.resMgr.getResString("REPORT_COL_PRECHECK_VALUE"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(2, curSheetRowNum, this.resMgr.getResString("REPORT_COL_PRECHECK_STATUS"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(3, curSheetRowNum, this.resMgr.getResString("REPORT_COL_POSTCHECK_VALUE"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(4, curSheetRowNum, this.resMgr.getResString("REPORT_COL_POSTCHECK_STATUS"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        ExcelFileWtiterHelper.addCell(5, curSheetRowNum, this.resMgr.getResString("CHECK_REPORT_COM_RESULT"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
    }

    private int createAlarmInfo(WritableSheet upgradeInfoSheet, Resource res, int curSheetRowNum) {
        int rowNumber = curSheetRowNum;
        DevCheckInfo devCheckInfo = this.allCheckInfo.get(res.getDeviceID());
        DevCheckNodeInfo devCheckNodeInfo = devCheckInfo.getCheckItemInfo("DeviceAlarm");
        if ("".equals(devCheckNodeInfo.getNodeId())) {
            DCDebugTracer.trace("BMSCSVFileWriter#createAlarmInfo->do not have alarm information");
            return rowNumber;
        }
        rowNumber = this.createAlarmColorDesc(upgradeInfoSheet, rowNumber);
        ExcelFileWtiterHelper.addCell(0, rowNumber, this.resMgr.getResString("TASK_REPORT_ALARM"), this.excelHelper.getBoldFormat(), upgradeInfoSheet);
        this.createAlarmHeader(upgradeInfoSheet, ++rowNumber);
        ++rowNumber;
        rowNumber = this.createAlarmContent(upgradeInfoSheet, res, rowNumber);
        return rowNumber;
    }

    private int createAlarmContent(WritableSheet detailInfoSheet, Resource res, int startIndex) {
        int lineNumber = startIndex;
        DevCheckInfo devCheckInfo = this.allCheckInfo.get(res.getDeviceID());
        DevCheckNodeInfo devCheckNodeInfo = devCheckInfo.getCheckItemInfo("DeviceAlarm");
        List<DevCheckNodeInfo> nodeLst = devCheckNodeInfo.getDevCheckNodeInfoLst();
        for (DevCheckNodeInfo devNodeInfo : nodeLst) {
            int[][] position = new int[][]{{0, -1, -1}, {1, -1, -1}, {2, 2, 3}, {4, -1, -1}, {5, -1, -1}};
            CheckReportTable checkReportTable = devNodeInfo.getCheckReportTable();
            if (null == checkReportTable) continue;
            ICheckReportTableModel oReportTableModel = checkReportTable.getModel();
            int rowCount = checkReportTable.getRowCount();
            int colCount = position.length;
            boolean MERAGE_START_INDEX = true;
            int MERAGE_END_INDEX = 2;
            boolean COL_INDEX = false;
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    ExcelFileWtiterHelper.addAlarmCellData(position[j][0], lineNumber, (CheckReportTableCell)oReportTableModel.getValueAt(i, j), detailInfoSheet);
                    if (-1 == position[j][1]) continue;
                    ExcelFileWtiterHelper.mergeCells(detailInfoSheet, position[j][1], lineNumber, position[j][2], lineNumber);
                }
                ++lineNumber;
            }
        }
        return lineNumber;
    }

    private void createAlarmHeader(WritableSheet detailInfoSheet, int startIndex) {
        ExcelFileWtiterHelper.addCell(0, startIndex, this.resMgr.getResString("REPORT_COL_ALARM_ID"), this.excelHelper.getBoldFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(1, startIndex, this.resMgr.getResString("REPORT_COL_ALARM_NAME"), this.excelHelper.getBoldFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(2, startIndex, this.resMgr.getResString("REPORT_COL_ALARM_LOCATE_INFO"), this.excelHelper.getBoldFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 2, startIndex, 3, startIndex);
        ExcelFileWtiterHelper.addCell(4, startIndex, this.resMgr.getResString("REPORT_COL_ALARM_LEVEL"), this.excelHelper.getBoldFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addCell(5, startIndex, this.resMgr.getResString("REPORT_COL_ALARM_START_TIME"), this.excelHelper.getBoldFormat(), detailInfoSheet);
    }

    private int createAlarmColorDesc(WritableSheet detailInfoSheet, int startIndex) {
        int lineNumber = startIndex;
        ExcelFileWtiterHelper.addCell(3, lineNumber, "", this.excelHelper.getBuleFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, this.resMgr.getResString("CHECK_REPORT_PRECHECK_CONTENT"), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber, 5, lineNumber);
        ExcelFileWtiterHelper.addCell(3, ++lineNumber, "", this.excelHelper.getRedFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, this.resMgr.getResString("CHECK_REPORT_POSTCHECK_CONTENT"), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber, 5, lineNumber);
        ExcelFileWtiterHelper.addCell(3, ++lineNumber, "", this.excelHelper.getBlackFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, this.resMgr.getResString("CHECK_REPORT_COMPARE_CHECK_CONTENT"), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber, 5, lineNumber);
        return lineNumber;
    }

    private int createCheckItemColorDesc(WritableSheet detailInfoSheet, int startIndex) {
        int lineNumber = startIndex;
        ExcelFileWtiterHelper.addCell(3, lineNumber, "", this.excelHelper.getBuleFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, this.resMgr.getResString("CHECK_REPORT_PRECHECK_UNNORMAL"), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber, 5, lineNumber);
        ExcelFileWtiterHelper.addCell(3, ++lineNumber, "", this.excelHelper.getRedFormat(), detailInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, this.resMgr.getResString("CHECK_REPORT_POSTCHECK_UNNORMAL"), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber, 5, lineNumber);
        ExcelFileWtiterHelper.addDataStrCell(3, ++lineNumber, "", detailInfoSheet);
        ExcelFileWtiterHelper.addDataStrCell(4, lineNumber, this.resMgr.getResString("CHECK_REPORT_PRE_POST_NORMAL"), detailInfoSheet);
        ExcelFileWtiterHelper.mergeCells(detailInfoSheet, 4, lineNumber, 5, lineNumber);
        return lineNumber;
    }

    private int fillRowData(DevCheckNodeInfo devCheckNodeInfo, int startIndex, String header, WritableSheet upgradeInfoSheet) throws DCException {
        int index = startIndex;
        if (header.length() == 0) {
            throw new DCException(this.resMgr.getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            throw new DCException(this.resMgr.getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        ICheckReportTableModel oICheckReportTableModel = checkReportTable.getModel();
        int rowCount = oICheckReportTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ExcelFileWtiterHelper.addDataStrCell(0, index, BMSDevTaskReport.getCheckItemValue(header, oICheckReportTableModel.getValueAt(i, 0).getValue()), upgradeInfoSheet);
            if (0 == this.iCurDevCheckReportType) {
                ExcelFileWtiterHelper.addDataStrCell(1, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(2, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 3).getValue())), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(3, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 2).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 4).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(5, index, " --", upgradeInfoSheet);
            } else if (1 == this.iCurDevCheckReportType) {
                ExcelFileWtiterHelper.addDataStrCell(1, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(2, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 3).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(3, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 2).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 4).getValue())), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(5, index, " --", upgradeInfoSheet);
            } else if (2 == this.iCurDevCheckReportType) {
                ExcelFileWtiterHelper.addDataStrCell(1, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(2, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 3).getValue())), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(3, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 2).getValue()), upgradeInfoSheet);
                ExcelFileWtiterHelper.addDataStrCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 4).getValue())), upgradeInfoSheet);
                int preCheckResult = 0;
                try {
                    preCheckResult = Integer.valueOf(oICheckReportTableModel.getValueAt(i, 3).getValue());
                }
                catch (NumberFormatException nfe) {
                    preCheckResult = 1;
                }
                int postCheckResult = 0;
                try {
                    postCheckResult = Integer.valueOf(oICheckReportTableModel.getValueAt(i, 4).getValue());
                }
                catch (NumberFormatException nfe) {
                    postCheckResult = 1;
                }
                int compareResult = 1;
                if (preCheckResult == postCheckResult) {
                    compareResult = 0;
                    ExcelFileWtiterHelper.addCompareCellData(5, index, -1, BMSDevTaskReport.parseCompareResult(compareResult), upgradeInfoSheet);
                } else if (1 == preCheckResult && 0 == postCheckResult) {
                    ExcelFileWtiterHelper.addCompareCellData(5, index, 0, BMSDevTaskReport.parseCompareResult(compareResult), upgradeInfoSheet);
                    ++this.iChkItemDiffCnt;
                } else if (0 == preCheckResult && 1 == postCheckResult) {
                    ExcelFileWtiterHelper.addCompareCellData(5, index, 1, BMSDevTaskReport.parseCompareResult(compareResult), upgradeInfoSheet);
                    ++this.iChkItemDiffCnt;
                } else {
                    DCDebugTracer.trace("BMSExcelFileWriter#fillRowData=>do not need handle");
                }
            } else {
                DCDebugTracer.traceError("BMSExcelFileWriter#fillRowData=>receive msg server failed : checkReportType " + this.iCurDevCheckReportType);
            }
            ++index;
        }
        return index;
    }

    private String generateLinkStr(String sheetName) {
        String text = "";
        String filename = this.taskReportFileInfo.getFileName() + ".xls";
        try {
            text = "HYPERLINK(\"[" + filename + "] " + "'" + sheetName + "'!" + "B1" + "\", \" " + this.resMgr.getResString("CHECK_REPORT_NOT_SAME") + "\")";
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            text = this.resMgr.getResString("CHECK_REPORT_NOT_SAME");
        }
        return text;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveFile(IReportCreater reportCreater, int iRange, int iMaxProgress) throws DCException {
        File reportFile = null;
        boolean isHaveException = false;
        WritableWorkbook workbook = null;
        try {
            boolean create;
            WorkbookSettings ws = new WorkbookSettings();
            ws.setLocale(DCResourceMng.getInstance().getLocale());
            String filename = this.taskReportFileInfo.getFileName();
            String filePath = this.taskReportFileInfo.getFilePath();
            File file = new File(filePath);
            if (!file.exists() && !(create = file.mkdir())) {
                DCDebugTracer.trace("create floder failed : " + filePath);
                throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
            }
            reportFile = new File(filePath + File.separator + filename + ".xls");
            workbook = Workbook.createWorkbook((File)reportFile, (WorkbookSettings)ws);
            int numberOfSheets = 0;
            WritableSheet basicSheet = workbook.createSheet(this.resMgr.getResString("CHECK_REPORT_STATISTIC_SHEET_NAME"), numberOfSheets);
            basicSheet.getSettings().setShowGridLines(false);
            this.updateBasicInfo(basicSheet);
            int iStatisticDataIndex = 6;
            int iTmpCurDev = 0;
            String sheetName = null;
            int step = (iRange - 50) / (this.oResLst.size() + 1) + 1;
            for (Resource res : this.oResLst) {
                this.iChkItemDiffCnt = 0;
                sheetName = this.resMgr.getResString("CHECK_REPORT_SHEET_NAME", new String[]{res.getDeviceIP()});
                WritableSheet checkInfoSheet = workbook.createSheet(sheetName, ++numberOfSheets);
                checkInfoSheet.getSettings().setShowGridLines(false);
                this.buildOneDeviceCheckItemInfo(checkInfoSheet, res);
                this.updateStatisticCheckInfo(basicSheet, sheetName, res, iStatisticDataIndex, iTmpCurDev);
                ++iStatisticDataIndex;
                reportCreater.updateProgress(50 + ++iTmpCurDev * step, iMaxProgress);
            }
            boolean bIsMemoryAvailable = true;
            long lFreeMemoryAvail = 0L;
            long lFileSize = 0L;
            if (null != reportFile) {
                lFreeMemoryAvail = reportFile.getFreeSpace();
            }
            lFileSize = this.excelHelper.getExcelFileContentSize(workbook);
            if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
                isHaveException = true;
                bIsMemoryAvailable = false;
            }
            if (!bIsMemoryAvailable) throw new DCException(this.resMgr.getResString("TASK_REPORT_INSUFFICIENT_MEMORY"));
            workbook.write();
            if (isHaveException) return;
        }
        catch (DCException e) {
            try {
                DCDebugTracer.trace(this.getClass().getName() + " [dev report] saveFile failed , Exception as below :");
                isHaveException = true;
                FileUtil.deleteReportFile(reportFile, workbook);
                DCDebugTracer.trace(e);
                throw new DCException(e.getMessage());
                catch (Exception e2) {
                    DCDebugTracer.trace(this.getClass().getName() + " [dev report] saveFile failed , Exception as below :");
                    DCDebugTracer.trace(e2);
                    isHaveException = true;
                    FileUtil.deleteReportFile(reportFile, workbook);
                    throw new DCException(this.resMgr.getResString("TASK_REPORT_SAVE_FAILURE"));
                }
            }
            catch (Throwable throwable) {
                if (isHaveException) throw throwable;
                FileUtil.freeExcelReference(workbook);
                throw throwable;
            }
        }
        FileUtil.freeExcelReference(workbook);
    }

    private void updateBasicInfo(WritableSheet basicSheet) throws DCException {
        ExcelFileWtiterHelper.addCell(0, 0, TaskReportConstant.TASK_REPORT_USER_NAME, this.excelHelper.getBoldFormat(), basicSheet);
        String userName = DCFrameWorkUtil.getUserName();
        ExcelFileWtiterHelper.addDataStrCell(1, 0, UpgradeInfoHelper.convertEmptyToUnSupportFlag(userName), basicSheet);
        ExcelFileWtiterHelper.addCell(2, 0, TaskReportConstant.TASK_REPORT_SAVE_TIME_OF_REPORT, this.excelHelper.getBoldFormat(), basicSheet);
        ExcelFileWtiterHelper.addDataStrCell(3, 0, StringUtils.getClietNowTime(), basicSheet);
        ExcelFileWtiterHelper.mergeCells(basicSheet, 3, 0, 4, 0);
        ExcelFileWtiterHelper.addCell(0, 1, TaskReportConstant.TASK_REPORT_TOTAL_DEVICE, this.excelHelper.getBoldFormat(), basicSheet);
        ExcelFileWtiterHelper.addDataNumberCell(1, 1, NumberFormat.getInstance().format(this.oResLst.size()), basicSheet);
        ExcelFileWtiterHelper.mergeCells(basicSheet, 1, 1, 4, 1);
        ExcelFileWtiterHelper.addCell(0, 4, this.resMgr.getResString("CHECK_REPORT_CHK_DETAIL"), this.excelHelper.getBoldFormat(), basicSheet);
        ExcelFileWtiterHelper.addCell(0, 5, TaskReportConstant.TASK_REPORT_SEQUENCE_NO, this.excelHelper.getTeaFormat(), basicSheet);
        ExcelFileWtiterHelper.addCell(1, 5, TaskReportConstant.TASK_REPORT_RESOURCE_NAME, this.excelHelper.getTeaFormat(), basicSheet);
        ExcelFileWtiterHelper.addCell(2, 5, TaskReportConstant.TASK_REPORT_DEVICE_IP, this.excelHelper.getTeaFormat(), basicSheet);
        ExcelFileWtiterHelper.addCell(3, 5, TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1, this.excelHelper.getTeaFormat(), basicSheet);
        ExcelFileWtiterHelper.addCell(4, 5, this.resMgr.getResString("CHECK_REPORT_COM_RESULT"), this.excelHelper.getTeaFormat(), basicSheet);
        basicSheet.setColumnView(0, 18);
        basicSheet.setColumnView(1, 18);
        basicSheet.setColumnView(2, 18);
        basicSheet.setColumnView(3, 18);
        basicSheet.setColumnView(4, 25);
    }

    private void updateStatisticCheckInfo(WritableSheet basicSheet, String linkSheetName, Resource res, int index, int seq) throws DCException {
        ExcelFileWtiterHelper.addDataStrCell(0, index, String.valueOf(seq), basicSheet);
        ExcelFileWtiterHelper.addDataStrCell(1, index, res.getDeviceName(), basicSheet);
        ExcelFileWtiterHelper.addDataStrCell(2, index, res.getDeviceIP(), basicSheet);
        ExcelFileWtiterHelper.addDataStrCell(3, index, this.DEV_TYPE_STR, basicSheet);
        DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
        if (null == oDevCheckNodeInfo) {
            ExcelFileWtiterHelper.addDataStrCell(4, index, this.resMgr.getResString("CHECK_DATA_EMPTY"), basicSheet);
        } else {
            int iComResult = oDevCheckNodeInfo.getiCheckCompareResult();
            if (1 == iComResult) {
                ExcelFileWtiterHelper.addHyperLink(4, index, this.generateLinkStr(linkSheetName), basicSheet);
            } else if (0 == iComResult) {
                ExcelFileWtiterHelper.addDataStrCell(4, index, this.resMgr.getResString("CHECK_REPORT_SAME"), basicSheet);
            } else {
                ExcelFileWtiterHelper.addDataStrCell(4, index, UpgradeInfoHelper.convertEmptyToUnSupportFlag(""), basicSheet);
            }
        }
    }
}

