/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.impl;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.report.IReport;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportNotifier;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ICheckReportNotificationListener;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ReportNotificationEvent;
import com.huawei.dc.taskmgmt.report.devlevel.impl.BMSCSVFileWriter;
import com.huawei.dc.taskmgmt.report.devlevel.impl.BMSExcelFileWriter;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportDevInfoMap;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import com.huawei.dc.taskmgmt.report.tasklevel.util.ReportDataHelper;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import gnu.trove.THashSet;
import java.io.File;
import java.util.List;
import java.util.Map;

public class BMSDevTaskReport
implements IReport,
ICheckReportNotificationListener {
    public static final int FIFTH = 50;
    private long firstOpenClientTime = -1L;
    public static final int NORMAL = 0;
    public static final int UNNORMAL = 1;
    private Map<Integer, DevCheckInfo> allCheckInfo = null;
    private int ifileType;
    private boolean isRecOK = false;
    private boolean isWait = true;
    private IReportCreater oReportCreater = null;
    private ITask oTask = null;
    private TaskReportFileInfo oTaskReportFileInfo = null;
    private THashSet<Resource> resLst = null;
    private Object synObj = new Object();

    public BMSDevTaskReport(TaskReportFileInfo taskReportFileInfo, ITask task, List<Integer> devIdList) {
        this.firstOpenClientTime = System.nanoTime();
        this.ifileType = taskReportFileInfo.getFiletype();
        this.oTaskReportFileInfo = taskReportFileInfo;
        this.oTask = task;
        this.fillResLst(devIdList);
        CheckReportNotifier.getInstance().addCheckReportNotificationListener(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BMSDevTaskReport other = (BMSDevTaskReport)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulidReport(IReportCreater reportCreater, int iRange, int iMaxProgress) throws DCException {
        DCDebugTracer.trace(this.getClass().getName() + " [dev report] bulidReport start");
        this.oReportCreater = reportCreater;
        try {
            this.getCheckReportDetails();
        }
        finally {
            CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
        }
        String fileFullPath = this.oTaskReportFileInfo.getFilePath() + File.separator + this.oTaskReportFileInfo.getFileName();
        String devTypeName = this.oTask.getDeviceType().getDeviceTypeName();
        if (0 == this.ifileType) {
            BMSCSVFileWriter csvFileWriter = new BMSCSVFileWriter(fileFullPath, devTypeName, this.resLst);
            DCDebugTracer.trace(this.getClass().getName() + " [dev report] saveFile csv start");
            csvFileWriter.setAllCheckInfo(this.allCheckInfo);
            csvFileWriter.saveFile(this.oReportCreater, iRange, iMaxProgress);
            DCDebugTracer.trace(this.getClass().getName() + " [dev report] saveFile csv end..");
        } else if (3 == this.ifileType) {
            BMSExcelFileWriter excelFileWriter = new BMSExcelFileWriter(this.oTaskReportFileInfo, devTypeName, this.resLst);
            DCDebugTracer.trace(this.getClass().getName() + " [dev report] saveFile excel start");
            excelFileWriter.setAllCheckInfo(this.allCheckInfo);
            excelFileWriter.saveFile(this.oReportCreater, iRange, iMaxProgress);
            DCDebugTracer.trace(this.getClass().getName() + " [dev report] saveFile excel  end..");
        }
        DCDebugTracer.trace(this.getClass().getName() + " [dev report] bulidReport end..");
    }

    private void fillResLst(List<Integer> oSelDevIdList) {
        int SEL_DEV_CNT = oSelDevIdList.size();
        this.resLst = new THashSet(SEL_DEV_CNT);
        DeviceInfo devInfo = null;
        Resource res = null;
        for (int i = 0; i < SEL_DEV_CNT; ++i) {
            devInfo = DeviceInfoManagerImpl.getInstance().getDevice(oSelDevIdList.get(i));
            res = new Resource();
            res.setDeviceID(devInfo.getDevId());
            res.setDeviceIP(devInfo.getDevIPAddress());
            res.setDeviceName(devInfo.getDevName());
            this.resLst.add((Object)res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getCheckReportDetails() throws DCException {
        this.setRecOK(false);
        ReportDataHelper.getInstance().getCheckReportDetails(this.oTask.getTaskId(), this.resLst);
        this.setWait(true);
        try {
            while (this.iswait()) {
                Object object = this.synObj;
                synchronized (object) {
                    this.synObj.wait(50L);
                }
            }
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        if (!this.isRecOK()) {
            throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
    }

    synchronized boolean isRecOK() {
        return this.isRecOK;
    }

    synchronized boolean iswait() {
        return this.isWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onCheckReportProgressNotification(ReportNotificationEvent event) {
        if (null == event) {
            return;
        }
        if (event.isLastMsg()) {
            this.oReportCreater.updateProgress(50, 50);
            CheckReportNotifier.getInstance().removeTaskNotificationListener(this);
            if (event.getProgressErrorCode() == 0) {
                this.updateCheckItemInfo();
                return;
            }
            Object object = this.synObj;
            synchronized (object) {
                this.synObj.notifyAll();
            }
            this.setWait(false);
            this.setRecOK(false);
            DCDebugTracer.traceError("receive msg server failed : " + event.getProgressErrorCode());
            return;
        }
        int curProgress = this.oReportCreater.getCurProgress();
        int PROGRESS_STEP = 10;
        this.oReportCreater.updateProgress(curProgress += 10, 50);
    }

    synchronized void setRecOK(boolean isRecOK) {
        this.isRecOK = isRecOK;
    }

    synchronized void setWait(boolean isWait) {
        this.isWait = isWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckItemInfo() {
        this.allCheckInfo = ReportDevInfoMap.getInstance().getDevCheckReportInfo();
        Object object = this.synObj;
        synchronized (object) {
            this.synObj.notifyAll();
        }
        this.setWait(false);
        this.setRecOK(true);
    }

    public static String parseStatusCheckResult(String key) {
        int iComResult = 0;
        try {
            iComResult = Integer.parseInt(key);
        }
        catch (NumberFormatException nfe) {
            iComResult = -1;
        }
        String strCompareResult = "";
        strCompareResult = 0 == iComResult ? ResourceManager.getInstance().getResString("CHECK_REPORT_NORMAL") : (1 == iComResult ? ResourceManager.getInstance().getResString("CHECK_REPORT_UNNORMAL") : key);
        return strCompareResult;
    }

    public static String parseCompareResult(int iComResult) {
        String strCompareResult = "";
        strCompareResult = 1 == iComResult ? ResourceManager.getInstance().getResString("CHECK_REPORT_NOT_SAME") : (0 == iComResult ? ResourceManager.getInstance().getResString("CHECK_REPORT_SAME") : (2 == iComResult ? ResourceManager.getInstance().getResString("CHECK_REPORT_NONEED_COMPARE") : UpgradeInfoHelper.convertEmptyToUnSupportFlag("")));
        return strCompareResult;
    }

    public static String getCheckItemValue(String header, String content) {
        String checkItem = header;
        if (!(StringUtils.isNullOrEmptyStr(content) || "--".equals(content) || "_".equals(content))) {
            checkItem = checkItem + content;
        } else {
            int index = header.lastIndexOf(".");
            checkItem = header.substring(0, index);
        }
        return UpgradeInfoHelper.convertEmptyToUnSupportFlag(checkItem);
    }
}

