/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.impl;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.report.IFileWriter;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.impl.BMSDevTaskReport;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableModel;
import com.huawei.dc.taskmgmt.report.tasklevel.constant.TaskReportConstant;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;

public class BMSCSVFileWriter
implements IFileWriter {
    private Map<Integer, DevCheckInfo> allCheckInfo = null;
    private final String DEV_TYPE_STR;
    private int iCurDevCheckReportType;
    private THashSet<Resource> oResLst = null;
    private ResourceManager resMgr = ResourceManager.getInstance();
    private String saveFilePath = null;

    public BMSCSVFileWriter(String strSaveFilePath, String strDevTypeName, THashSet<Resource> resLst) {
        this.oResLst = resLst;
        this.DEV_TYPE_STR = strDevTypeName;
        this.saveFilePath = strSaveFilePath;
    }

    private void buildOneDeviceCheckItemInfo1(Resource res) throws DCException, IOException {
        FileOutputStream oFileOutPut = null;
        OutputStreamWriter oWriter = null;
        BufferedWriter oBufferedWriter = null;
        StringBuilder strBuild = null;
        File file = null;
        String fileName = null;
        try {
            fileName = this.resMgr.getResString("CHECK_REPORT_SHEET_NAME", new String[]{res.getDeviceIP()});
            file = new File(this.saveFilePath + File.separator + fileName + ".csv");
            oFileOutPut = new FileOutputStream(file);
            oWriter = new OutputStreamWriter((OutputStream)oFileOutPut, FileUtil.getSystemEncoding());
            strBuild = new StringBuilder();
            oBufferedWriter = new BufferedWriter(oWriter);
            strBuild.append(this.resMgr.getResString("CHECK_REPORT_NE_RESULT"));
            DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
            if (null == oDevCheckNodeInfo) {
                strBuild.append(",");
                strBuild.append(this.resMgr.getResString("CHECK_DATA_EMPTY"));
            } else {
                int iComResult = oDevCheckNodeInfo.getiCheckCompareResult();
                strBuild.append(",");
                strBuild.append(BMSDevTaskReport.parseCompareResult(iComResult));
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
                oBufferedWriter.write(strBuild.toString());
                oBufferedWriter.flush();
                this.createAlarmInfo(res, oBufferedWriter);
                this.createCheckItemInfo(res, oBufferedWriter);
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            FileUtil.deleteReportFile(file, oBufferedWriter, oWriter);
            DCDebugTracer.traceError(e.getMessage());
            throw new DCException(e.getMessage());
        }
        catch (IOException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            FileUtil.deleteReportFile(file, oBufferedWriter, oWriter);
            DCDebugTracer.traceError(e.getMessage());
            throw e;
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oWriter) {
                    oWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oFileOutPut) {
                    oFileOutPut.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    private void buildStatisticCheckItemInfo() throws DCException, IOException {
        FileOutputStream oStream = null;
        OutputStreamWriter oWriter = null;
        BufferedWriter oBufferedWriter = null;
        StringBuilder strBuild = null;
        File file = null;
        try {
            file = new File(this.saveFilePath + File.separator + this.resMgr.getResString("CHECK_REPORT_STATISTIC_SHEET_NAME") + ".csv");
            oStream = new FileOutputStream(file);
            oWriter = new OutputStreamWriter((OutputStream)oStream, FileUtil.getSystemEncoding());
            strBuild = new StringBuilder();
            oBufferedWriter = new BufferedWriter(oWriter);
            strBuild.append(TaskReportConstant.TASK_REPORT_USER_NAME);
            strBuild.append(",");
            strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(DCFrameWorkUtil.getUserName()));
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_SAVE_TIME_OF_REPORT);
            strBuild.append(",");
            strBuild.append(StringUtils.getClietNowTime());
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_TOTAL_DEVICE);
            strBuild.append(",");
            strBuild.append(NumberFormat.getInstance().format(this.oResLst.size()));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(this.resMgr.getResString("CHECK_REPORT_CHK_DETAIL"));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            strBuild.append(TaskReportConstant.TASK_REPORT_SEQUENCE_NO);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_RESOURCE_NAME);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_IP);
            strBuild.append(",");
            strBuild.append(TaskReportConstant.TASK_REPORT_DEVICE_TYPE_1);
            strBuild.append(",");
            strBuild.append(this.resMgr.getResString("CHECK_REPORT_COM_RESULT"));
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            int seq = 0;
            for (Resource res : this.oResLst) {
                strBuild.append(String.valueOf(seq++));
                strBuild.append(",");
                strBuild.append(res.getDeviceName());
                strBuild.append(",");
                strBuild.append(res.getDeviceIP());
                strBuild.append(",");
                strBuild.append(this.DEV_TYPE_STR);
                DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseCompareResult(oDevCheckNodeInfo.getiCheckCompareResult())));
                strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            }
            oBufferedWriter.write(strBuild.toString());
            oBufferedWriter.flush();
        }
        catch (IOException e) {
            DCDebugTracer.trace(this.getClass().getName() + " [task report] saveFile failed , Exception as below :");
            DCDebugTracer.trace(e);
            FileUtil.deleteReportFile(file, oBufferedWriter, oWriter);
            DCDebugTracer.traceError(e.getMessage());
            throw e;
        }
        finally {
            try {
                if (null != oBufferedWriter) {
                    oBufferedWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oWriter) {
                    oWriter.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
            try {
                if (null != oStream) {
                    oStream.close();
                }
            }
            catch (IOException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    private void createAlarmContent(Resource res, StringBuilder strBuild) {
        DevCheckInfo devCheckInfo = this.allCheckInfo.get(res.getDeviceID());
        DevCheckNodeInfo devCheckNodeInfo = devCheckInfo.getCheckItemInfo("DeviceAlarm");
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            return;
        }
        int ALARM_COL_CNT = 5;
        ICheckReportTableModel oReportTableModel = checkReportTable.getModel();
        int rowCount = checkReportTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < 5; ++j) {
                strBuild.append(oReportTableModel.getValueAt(i, j).toString());
                strBuild.append(",");
            }
            strBuild.delete(strBuild.length() - 1, strBuild.length());
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        }
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
    }

    private void createAlarmHeader(StringBuilder strBuild) {
        strBuild.append(this.resMgr.getResString("REPORT_COL_ALARM_ID"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_ALARM_NAME"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_ALARM_LOCATE_INFO"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_ALARM_LEVEL"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_ALARM_START_TIME"));
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
    }

    private void createAlarmInfo(Resource res, BufferedWriter oWriter) throws IOException {
        DevCheckInfo devCheckInfo = this.allCheckInfo.get(res.getDeviceID());
        DevCheckNodeInfo devCheckNodeInfo = devCheckInfo.getCheckItemInfo("DeviceAlarm");
        if ("".equals(devCheckNodeInfo.getNodeId())) {
            DCDebugTracer.trace("BMSExcelFileWriter#createAlarmInfo->do not have alarm information");
            return;
        }
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(this.resMgr.getResString("TASK_REPORT_ALARM"));
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        this.createAlarmHeader(strBuild);
        this.createAlarmContent(res, strBuild);
        oWriter.write(strBuild.toString());
        oWriter.flush();
    }

    private void createCheckItemContent(DevCheckNodeInfo oDevCheckNodeInfo, BufferedWriter oWriter) throws DCException, IOException {
        List<DevCheckNodeInfo> nodeLst = oDevCheckNodeInfo.getDevCheckNodeInfoLst();
        if (null != nodeLst) {
            StringBuilder content = null;
            for (DevCheckNodeInfo devCheckNodeInfo : nodeLst) {
                content = new StringBuilder();
                content.append(oDevCheckNodeInfo.getNodeName());
                content.append(".");
                content.append(devCheckNodeInfo.getNodeName());
                content.append(".");
                List<DevCheckNodeInfo> tempNodeLst = devCheckNodeInfo.getDevCheckNodeInfoLst();
                if (tempNodeLst.size() <= 0) {
                    this.fillRowData(devCheckNodeInfo, content.toString(), oWriter);
                    continue;
                }
                this.createCheckItemContent(devCheckNodeInfo, oWriter);
            }
        }
    }

    private void createCheckItemHeader(StringBuilder strBuild) {
        strBuild.append(this.resMgr.getResString("TASK_REPORT_CHECK_ITEM_1"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_PRECHECK_VALUE"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_PRECHECK_STATUS"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_POSTCHECK_VALUE"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("REPORT_COL_POSTCHECK_STATUS"));
        strBuild.append(",");
        strBuild.append(this.resMgr.getResString("CHECK_REPORT_COM_RESULT"));
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
    }

    private void createCheckItemInfo(Resource res, BufferedWriter oWriter) throws DCException, IOException {
        DevCheckInfo oDevCheckNodeInfo = this.allCheckInfo.get(res.getDeviceID());
        DevCheckNodeInfo devStatusNodeInfo = oDevCheckNodeInfo.getCheckItemInfo("DeviceStatus");
        DevCheckNodeInfo mxuStatusNodeInfo = oDevCheckNodeInfo.getCheckItemInfo("MxuStatus");
        if ("".equals(devStatusNodeInfo.getNodeId()) && "".equals(mxuStatusNodeInfo.getNodeId())) {
            DCDebugTracer.trace("BMSExcelFileWriter#createCheckItemInfo->do not have DEVICE_STATUS &  MXU_STATUS information");
            return;
        }
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(this.resMgr.getResString("CHECK_REPORT_CHKITM_CHK"));
        strBuild.append(TaskReportConstant.LINE_SEPARATOR);
        this.iCurDevCheckReportType = oDevCheckNodeInfo.getiCheckReportType();
        this.createCheckItemHeader(strBuild);
        oWriter.write(strBuild.toString());
        oWriter.flush();
        strBuild.delete(0, strBuild.length());
        this.createCheckItemContent(oDevCheckNodeInfo.getCheckItemInfo("DeviceStatus"), oWriter);
        this.createCheckItemContent(oDevCheckNodeInfo.getCheckItemInfo("MxuStatus"), oWriter);
    }

    private void fillRowData(DevCheckNodeInfo devCheckNodeInfo, String header, BufferedWriter oBufferedWriter) throws IOException, DCException {
        if (header.length() == 0) {
            throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        StringBuilder strBuild = new StringBuilder();
        CheckReportTable checkReportTable = devCheckNodeInfo.getCheckReportTable();
        if (null == checkReportTable) {
            throw new DCException(ResourceManager.getInstance().getResString("SYS_SETTING_FAILED_TO_RETRIEVE_FROM_SERVER"));
        }
        ICheckReportTableModel oICheckReportTableModel = checkReportTable.getModel();
        int rowCount = oICheckReportTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            strBuild.append(BMSDevTaskReport.getCheckItemValue(header, oICheckReportTableModel.getValueAt(i, 0).getValue()));
            if (0 == this.iCurDevCheckReportType) {
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 3).getValue())));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 2).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 4).getValue()));
                strBuild.append(",");
                strBuild.append(" --");
            } else if (1 == this.iCurDevCheckReportType) {
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 3).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 2).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 4).getValue())));
                strBuild.append(",");
                strBuild.append(" --");
            } else {
                if (2 != this.iCurDevCheckReportType) continue;
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 1).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 3).getValue())));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(oICheckReportTableModel.getValueAt(i, 2).getValue()));
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseStatusCheckResult(oICheckReportTableModel.getValueAt(i, 4).getValue())));
                int preCheckResult = Integer.valueOf(oICheckReportTableModel.getValueAt(i, 3).getValue());
                int postCheckResult = Integer.valueOf(oICheckReportTableModel.getValueAt(i, 4).getValue());
                int compareResult = 1;
                if (preCheckResult == postCheckResult) {
                    compareResult = 0;
                }
                strBuild.append(",");
                strBuild.append(UpgradeInfoHelper.convertEmptyToUnSupportFlag(BMSDevTaskReport.parseCompareResult(compareResult)));
            }
            strBuild.append(TaskReportConstant.LINE_SEPARATOR);
            oBufferedWriter.write(strBuild.toString());
            oBufferedWriter.flush();
            strBuild.delete(0, strBuild.length());
        }
    }

    @Override
    public void saveFile(IReportCreater oReportCreater, int iRange, int iMaxProgress) throws DCException {
        int step = (iRange - 50) / (this.oResLst.size() + 1) + 1;
        int iCurFileCnt = 0;
        try {
            boolean create;
            File file = new File(this.saveFilePath);
            if (!file.exists() && !(create = file.mkdir())) {
                DCDebugTracer.trace("create floder failed : " + this.saveFilePath);
                throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
            }
            this.buildStatisticCheckItemInfo();
            oReportCreater.updateProgress(50 + ++iCurFileCnt * step, iMaxProgress);
            for (Resource res : this.oResLst) {
                this.buildOneDeviceCheckItemInfo1(res);
                oReportCreater.updateProgress(50 + ++iCurFileCnt * step, iMaxProgress);
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_SAVE_FAILURE"));
        }
    }

    public void setAllCheckInfo(Map<Integer, DevCheckInfo> allCheckInfo) {
        this.allCheckInfo = allCheckInfo;
    }
}

