/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel.controller;

import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportNotifier;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ICheckReportNotificationListener;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ReportNotificationEvent;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportDataModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReport;
import com.huawei.dc.taskmgmt.report.devlevel.view.DMSReportDlg;
import com.huawei.dc.taskmgmt.report.devlevel.view.ReportDlg;
import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;

public class CheckReportProgressController
implements ICheckReportNotificationListener {
    private int iReportType;
    private int iTotalReportCount;
    private int iCurrentReportCount;
    private SimpleProgressDlg m_oProgressDialog;
    private ITask m_oTask;
    private List<String> m_oDeviceTypeList;
    private ReportDlg oCheckReportUI = null;

    public CheckReportProgressController(ITask oTask, int iReportType, int iNumOfDevices) {
        this.m_oTask = oTask;
        this.iReportType = iReportType;
        this.m_oProgressDialog = new SimpleProgressDlg(ResourceManager.getInstance().getResString("REPORT_PROGRESS_DLG_TITLE"), true, ResourceManager.getInstance().getResString("GETTING_CHECK_REPORT_INFO_PROMPT")){
            private static final long serialVersionUID = 9144645144399907069L;

            @Override
            public void doCleanUp() {
                super.doCleanUp();
                CheckReportNotifier.getInstance().removeTaskNotificationListener(CheckReportProgressController.this);
            }
        };
        CheckReportNotifier.getInstance().addCheckReportNotificationListener(this);
    }

    @Override
    public void onCheckReportProgressNotification(ReportNotificationEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        if (oEvent.getTotalPackageCount() != -1) {
            this.iTotalReportCount = oEvent.getTotalPackageCount();
            return;
        }
        if (0 != oEvent.getProgressErrorCode()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oEvent.getProgressErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            this.m_oProgressDialog.doCleanUp();
            this.m_oProgressDialog = null;
            return;
        }
        this.updateProgress();
    }

    private void updateProgress() {
        ++this.iCurrentReportCount;
        int iCurrentProgress = this.getCurrentProgress();
        if (100 == iCurrentProgress) {
            this.m_oProgressDialog.doCleanUp();
            this.m_oProgressDialog = null;
            this.openCheckReport();
        }
    }

    private void openCheckReport() {
        ICheckReport oCheckReport = CheckReportDataModel.getInstance().getReport(this.iReportType);
        List<DevCheckNodeInfo> devCheckNodeInfoLst = oCheckReport.getReportTableNodeList();
        if (devCheckNodeInfoLst.isEmpty()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("DEVICE_NO_INFORMATION"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        DevCheckNodeInfo oDevCheckNodeInfo = new DevCheckNodeInfo();
        oDevCheckNodeInfo.setNodeId(ResourceManager.getInstance().getResString("CHECK_REPORT_CONFIG_TREE_ROOT"));
        oDevCheckNodeInfo.setStatus(0);
        List<DevCheckNodeInfo> oDevCheckNodeInfoLst = oDevCheckNodeInfo.getDevCheckNodeInfoLst();
        oDevCheckNodeInfoLst.addAll(devCheckNodeInfoLst);
        int devDomain = this.m_oTask.getDeviceType().getDeviceDomain();
        if (2 == devDomain) {
            this.oCheckReportUI = new DMSReportDlg(oDevCheckNodeInfo, this.iReportType, this.m_oTask);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != CheckReportProgressController.this.oCheckReportUI) {
                    CheckReportProgressController.this.oCheckReportUI.setVisible(true);
                }
            }
        });
    }

    public synchronized void initializeProgress(int iTotalReportCount) {
        this.iTotalReportCount = iTotalReportCount;
        this.iCurrentReportCount = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CheckReportProgressController.this.m_oProgressDialog.setVisible(true);
            }
        });
    }

    private int getCurrentProgress() {
        float fProgress = (float)this.iCurrentReportCount / (float)this.iTotalReportCount;
        int iProgressPercentage = (int)fProgress * 100;
        if (0 > iProgressPercentage) {
            iProgressPercentage = 0;
        } else if (100 < iProgressPercentage) {
            iProgressPercentage = 100;
        }
        return iProgressPercentage;
    }

    public void setDeviceTypes(List<String> oDeviceTypes) {
        this.m_oDeviceTypeList = oDeviceTypes;
    }

    public List<String> getDeviceTypes() {
        return this.m_oDeviceTypeList;
    }
}

