/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.report.devlevel;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.ReportProgressDlg;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.report.IReportCreater;
import com.huawei.dc.taskmgmt.report.devlevel.impl.BMSDevTaskReport;
import com.huawei.dc.taskmgmt.report.tasklevel.bean.TaskReportFileInfo;
import java.util.List;
import javax.swing.SwingUtilities;

public class DevCheckReportCreater
implements IReportCreater {
    private static final int TOTAL_PROGRESS = 100;
    private List<Integer> oSelDevIdList = null;
    private ITask oTask = null;
    private TaskReportFileInfo oTaskReportFileInfo = null;
    private ReportProgressDlg proDlg = null;

    public DevCheckReportCreater(TaskReportFileInfo taskReportFileInfo, ITask task, List<Integer> devIdList, ReportProgressDlg progressDlg) {
        this.oTaskReportFileInfo = taskReportFileInfo;
        this.oTask = task;
        this.oSelDevIdList = devIdList;
        this.proDlg = progressDlg;
    }

    public void createTasksReport() {
        String errMsg = "";
        this.updateProgress(0);
        try {
            BMSDevTaskReport oBMSDevTaskReport = new BMSDevTaskReport(this.oTaskReportFileInfo, this.oTask, this.oSelDevIdList);
            oBMSDevTaskReport.bulidReport(this, 100, 100);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            errMsg = e.getMessage();
        }
        if (StringUtils.isNullOrEmptyStr(errMsg)) {
            errMsg = ResourceManager.getInstance().getResString("SAVE_SUCCESS");
        }
        this.handleUpdateProgress(this.oTaskReportFileInfo.getFileName(), errMsg);
        DCDebugTracer.trace(this.getClass().getName() + "[device check  report] createTaskReport end..");
        this.updateProgress(100);
    }

    @Override
    public int getCurProgress() {
        return this.proDlg.getCurProgress();
    }

    private void handleUpdateProgress(final String strDisplayName, final String strOpResult) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DevCheckReportCreater.this.proDlg.addRowInModel(strDisplayName, strOpResult);
            }
        });
    }

    @Override
    public void updateProgress(final int iProgress, final int iMaxProgress) {
        if (0 > iProgress || iProgress > 100) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (iProgress > iMaxProgress) {
                    DevCheckReportCreater.this.proDlg.updateProgress(iMaxProgress);
                } else {
                    DevCheckReportCreater.this.proDlg.updateProgress(iProgress);
                }
                DevCheckReportCreater.this.proDlg.repaint();
            }
        });
    }

    public void updateProgress(final int iProgress) {
        if (0 > iProgress || iProgress > 100) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DevCheckReportCreater.this.proDlg.updateProgress(iProgress);
                DevCheckReportCreater.this.proDlg.repaint();
            }
        });
    }
}

