/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.model.ProgressInfo;
import java.awt.Color;
import java.io.Serializable;

public class TaskProgressInfo
extends ProgressInfo
implements Serializable {
    private static final long serialVersionUID = -6872748268669596348L;
    private Color taskStausColor;
    private static final Color TASK_STATE_RUNNING_COLOR = Color.BLUE;
    private static final Color TASK_STATE_NOT_RUN_COLOR = Color.BLACK;
    private static final Color TASK_STATE_PAUSED_COLOR = new Color(255, 128, 0);
    private static final Color TASK_STATE_FAILURE_COLOR = new Color(196, 48, 45);
    private static final Color TASK_STATE_SUCCESS_COLOR = new Color(74, 181, 80);

    @Override
    public String toString() {
        ResourceManager oResManager = ResourceManager.getInstance();
        if (this.m_iState == 0) {
            return oResManager.getResString("TASK_STATE_NOT_RUN");
        }
        if (this.m_iState == 1) {
            this.setTaskStausColor(TASK_STATE_RUNNING_COLOR);
            return oResManager.getResString("TASK_STATE_RUNNING");
        }
        if (this.m_iState == 2) {
            if (this.m_iResult == 1) {
                this.setTaskStausColor(TASK_STATE_FAILURE_COLOR);
                return oResManager.getResString("TASK_FAILURE_MESSAGE");
            }
        } else if (this.m_iState == 3) {
            if (this.m_iResult == 0) {
                this.setTaskStausColor(TASK_STATE_SUCCESS_COLOR);
                return oResManager.getResString("TASK_SUCCESS_MESSAGE");
            }
            if (this.m_iResult == 1) {
                this.setTaskStausColor(TASK_STATE_FAILURE_COLOR);
                return oResManager.getResString("TASK_FAILURE_MESSAGE");
            }
            if (this.m_iResult == 3) {
                this.setTaskStausColor(TASK_STATE_SUCCESS_COLOR);
                return oResManager.getResString("TASK_PARTICAL_SUCCESS_MESSAGE");
            }
        } else if (this.m_iState == 4) {
            String strMsg = "";
            this.setTaskStausColor(TASK_STATE_PAUSED_COLOR);
            if (-1 == this.m_iPausedActivateGrp) {
                strMsg = oResManager.getResString("TASK_STATE_PAUSED");
            } else if (Short.MAX_VALUE == this.m_iPausedActivateGrp) {
                String strPauseMsg = oResManager.getResString("MANUAL_ACTIVATE_GROUP_NAME");
                strMsg = oResManager.getResString("TASK_STATE_PAUSED") + " " + strPauseMsg;
            } else {
                String strPauseMsg = oResManager.getResString("GROUP_ACTIVATION_PAUSED", new String[]{"" + this.m_iPausedActivateGrp});
                strMsg = oResManager.getResString("TASK_STATE_PAUSED") + " " + strPauseMsg;
            }
            return strMsg;
        }
        this.setTaskStausColor(TASK_STATE_NOT_RUN_COLOR);
        return "";
    }

    public synchronized Color getTaskStausColor() {
        return this.taskStausColor;
    }

    public synchronized void setTaskStausColor(Color taskStausColor) {
        this.taskStausColor = taskStausColor;
    }
}

