/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.TaskTypeConfiguration;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TaskModelUtil {
    public static void updateTaskStatus(int iTaskID, int iTaskStatus) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskID);
        oTask.getTaskProgressInfo().setState(iTaskStatus);
    }

    public static void updateTaskAndResourceStatus(int iTaskID, int iTaskStatus) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskID);
        oTask.getTaskProgressInfo().setState(iTaskStatus);
        THashSet<Resource> oResourceList = oTask.getSelectedDeviceType().getResources();
        Iterator oResItor = oResourceList.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            oResource.getProgressInfo().setState(iTaskStatus);
        }
    }

    public static IOperation getOperationFromTask(int iTaskId, String strOperationId) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        if (null == strOperationId || null == oTask || null == oTask.getSupportedOperation()) {
            return null;
        }
        List<ITaskDeviceOperation> oSupportedOps = oTask.getSupportedOperation();
        int iOperationCount = oSupportedOps.size();
        for (int i = 0; i < iOperationCount; ++i) {
            IOperation oOperation = oSupportedOps.get(i);
            if (!strOperationId.equals(oOperation.getOperationIdString())) continue;
            return oOperation;
        }
        return null;
    }

    public static boolean isTaskStarted(ITask oTask) {
        if (null == oTask || null == oTask.getSelectedDeviceType().getResources()) {
            return false;
        }
        THashSet<Resource> oResList = oTask.getSelectedDeviceType().getResources();
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            ResourceProgressInfo oResProgress = oRes.getProgressInfo();
            if (0 == oResProgress.getState()) continue;
            return true;
        }
        return false;
    }

    public static TIntArrayList getSupportGroupLst() {
        String sKey = "";
        if (DCFrameWorkUtil.getIsSingleClient()) {
            int iSelDomain = StandAloneDomainInfo.getInstance().getSelectedDomain();
            switch (iSelDomain) {
                case 4: {
                    sKey = "TASK_GROUP_ID_OPTIX";
                    break;
                }
                case 3: {
                    sKey = "TASK_GROUP_ID_ACCESS";
                    break;
                }
                case 2: {
                    sKey = "TASK_GROUP_ID_ROUTE";
                    break;
                }
                default: {
                    sKey = "TASK_GROUP_ID_ROUTE";
                }
            }
            return DeviceInfoUtil.getIDLst(sKey);
        }
        return TaskModelUtil.generateGroupsForIn();
    }

    private static TIntArrayList generateGroupsForIn() {
        TIntArrayList oGroupLst = new TIntArrayList();
        int iServerDeployDomian = DCFrameWorkUtil.getServerDeployDomain();
        boolean bDeployAccessDomain = (iServerDeployDomian & 1) != 0;
        boolean bDeployRouteDomain = (iServerDeployDomian & 2) != 0;
        boolean bDeployOptixDomain = (iServerDeployDomian & 4) != 0;
        TIntArrayList oDomianGroups = null;
        if (bDeployAccessDomain) {
            oDomianGroups = DeviceInfoUtil.getIDLst("TASK_GROUP_ID_ACCESS");
            TaskModelUtil.refreshGroups(oGroupLst, oDomianGroups);
        }
        if (bDeployRouteDomain) {
            oDomianGroups = DeviceInfoUtil.getIDLst("TASK_GROUP_ID_ROUTE");
            TaskModelUtil.refreshGroups(oGroupLst, oDomianGroups);
        }
        if (bDeployOptixDomain) {
            oDomianGroups = DeviceInfoUtil.getIDLst("TASK_GROUP_ID_OPTIX");
            TaskModelUtil.refreshGroups(oGroupLst, oDomianGroups);
        }
        return oGroupLst;
    }

    private static void refreshGroups(TIntArrayList oAllGroupLst, TIntArrayList oDomainGroupLst) {
        int iDomianGroupID = -1;
        for (int i = 0; i < oDomainGroupLst.size(); ++i) {
            iDomianGroupID = oDomainGroupLst.get(i);
            if (oAllGroupLst.contains(iDomianGroupID)) continue;
            oAllGroupLst.add(iDomianGroupID);
        }
    }

    public static boolean isTaskTypeSupportedForDeviceTypes(int taskTypeId, DeviceTypeInfo[] arrDeviceTypes, int[] iDeviceIdLst) {
        if (null == arrDeviceTypes || 0 == arrDeviceTypes.length) {
            return false;
        }
        boolean isSupport = false;
        for (int i = 0; i < arrDeviceTypes.length; ++i) {
            TaskTypeConfiguration taskTypeConf;
            DeviceTypeInfo deviceType = arrDeviceTypes[i];
            int[] m_oiDeviceIdLst = TaskModelUtil.getDevTypeInfoFromDevID(iDeviceIdLst, deviceType);
            IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(deviceType, m_oiDeviceIdLst);
            if (oDevTypeConfigModel == null || null == (taskTypeConf = (TaskTypeConfiguration)oDevTypeConfigModel.getTaskTaskTypeConfiguration())) continue;
            if (isSupport) break;
            if (taskTypeId == 10) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 1, 0);
                continue;
            }
            if (taskTypeId == 14) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 13, 4);
                continue;
            }
            if (taskTypeId == 11) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 12, 5);
                continue;
            }
            if (taskTypeId == 6) {
                if (DCFrameWorkUtil.getIsSingleClient() || !deviceType.getIsMXUDevice()) continue;
                isSupport = true;
                continue;
            }
            IParaList oParaList1 = taskTypeConf.getParaList(taskTypeId);
            if (oParaList1 == null) continue;
            isSupport = true;
        }
        if (taskTypeId == 0 || taskTypeId == 1 || taskTypeId == 5 || taskTypeId == 12 || taskTypeId == 4 || taskTypeId == 13) {
            isSupport = false;
        }
        return isSupport;
    }

    public static boolean isTaskTypeSupportedForDeviceTypesOnlyExistsDev(int taskTypeId, DeviceTypeInfo[] arrDeviceTypes, int[] iDeviceIdLst) {
        if (null == arrDeviceTypes || 0 == arrDeviceTypes.length) {
            return false;
        }
        int iSize = arrDeviceTypes.length;
        String[] strDevTypeNameLst = new String[iSize];
        String[] strDevTypeVersionNameLst = new String[iSize];
        for (int i = 0; i < iSize; ++i) {
            DeviceTypeInfo deviceType = arrDeviceTypes[i];
            strDevTypeNameLst[i] = deviceType.getDevTypeName();
            strDevTypeVersionNameLst[i] = deviceType.getDevTypeVersionName();
        }
        ArrayList<IDeviceTypeConfigModel> oDeviceTypeConfigModelLst = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModelOnlyExistsDev(strDevTypeNameLst, strDevTypeVersionNameLst, iDeviceIdLst);
        boolean isSupport = TaskModelUtil.isSupportTaskType(taskTypeId, oDeviceTypeConfigModelLst, arrDeviceTypes);
        return isSupport;
    }

    public static boolean isSupportTaskType(int taskTypeId, ArrayList<IDeviceTypeConfigModel> oDeviceTypeConfigModelLst, DeviceTypeInfo[] arrDeviceTypes) {
        boolean isSupport = false;
        DCDebugTracer.trace("TaskModelUtil#isSupportTaskType:oDeviceTypeConfigModelLst.size->" + oDeviceTypeConfigModelLst.size());
        DCDebugTracer.trace("TaskModelUtil#isSupportTaskType:arrDeviceTypes.length->" + arrDeviceTypes.length);
        for (int i = 0; i < oDeviceTypeConfigModelLst.size() && i < arrDeviceTypes.length; ++i) {
            TaskTypeConfiguration taskTypeConf;
            IDeviceTypeConfigModel oDevTypeConfigModel = oDeviceTypeConfigModelLst.get(i);
            DeviceTypeInfo deviceType = arrDeviceTypes[i];
            if (oDevTypeConfigModel == null || null == (taskTypeConf = (TaskTypeConfiguration)oDevTypeConfigModel.getTaskTaskTypeConfiguration())) continue;
            if (isSupport) break;
            if (taskTypeId == 10) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 1, 0);
                continue;
            }
            if (taskTypeId == 14) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 13, 4);
                continue;
            }
            if (taskTypeId == 11) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 12, 5);
                continue;
            }
            if (taskTypeId == 6) {
                if (DCFrameWorkUtil.getIsSingleClient() || !deviceType.getIsMXUDevice()) continue;
                isSupport = true;
                continue;
            }
            IParaList oParaList1 = taskTypeConf.getParaList(taskTypeId);
            if (oParaList1 == null) continue;
            isSupport = true;
        }
        if (taskTypeId == 0 || taskTypeId == 1 || taskTypeId == 5 || taskTypeId == 12 || taskTypeId == 4 || taskTypeId == 13) {
            isSupport = false;
        }
        return isSupport;
    }

    public static boolean isTaskTypeConfNull(TaskTypeConfiguration taskTypeConf, int tasktyp1, int tasktype2) {
        IParaList oParaList1 = taskTypeConf.getParaList(tasktyp1);
        IParaList oParaList2 = taskTypeConf.getParaList(tasktype2);
        boolean isSupport = false;
        if (null != oParaList1 || null != oParaList2) {
            isSupport = true;
        }
        return isSupport;
    }

    public static boolean isTaskTypeSupportedForT2000DeviceTypes(int taskTypeId, DeviceTypeInfo[] arrDeviceTypes, int[] iDeviceIdLst) {
        if (null == arrDeviceTypes || 0 == arrDeviceTypes.length) {
            return false;
        }
        boolean isSupport = false;
        for (int i = 0; i < arrDeviceTypes.length; ++i) {
            TaskTypeConfiguration taskTypeConf;
            DeviceTypeInfo deviceType = arrDeviceTypes[i];
            int[] m_iDeviceIdLst = new int[]{iDeviceIdLst[i]};
            IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(deviceType, m_iDeviceIdLst);
            if (oDevTypeConfigModel == null || null == (taskTypeConf = (TaskTypeConfiguration)oDevTypeConfigModel.getTaskTaskTypeConfiguration())) continue;
            if (isSupport) break;
            if (taskTypeId == 14) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 13, 4);
                continue;
            }
            if (taskTypeId == 11) {
                isSupport = TaskModelUtil.isTaskTypeConfNull(taskTypeConf, 12, 5);
                continue;
            }
            IParaList oParaList1 = taskTypeConf.getParaList(taskTypeId);
            if (oParaList1 == null) continue;
            isSupport = true;
        }
        return isSupport;
    }

    public static boolean isSupportedForDeviceTypes(int taskTypeId, DeviceTypeInfo[] arrDeviceTypes, int[] iDeviceIdLst) {
        if (null == arrDeviceTypes || 0 == arrDeviceTypes.length) {
            return false;
        }
        boolean isSupport = true;
        for (int i = 0; i < arrDeviceTypes.length; ++i) {
            IParaList oParalist;
            TaskTypeConfiguration taskTypeConf;
            DeviceTypeInfo deviceType = arrDeviceTypes[i];
            int[] m_iDeviceIdLst = TaskModelUtil.getDevTypeInfoFromDevID(iDeviceIdLst, deviceType);
            IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(deviceType, m_iDeviceIdLst);
            if (oDevTypeConfigModel == null || null == (taskTypeConf = (TaskTypeConfiguration)oDevTypeConfigModel.getTaskTaskTypeConfiguration()) || (oParalist = taskTypeConf.getParaList(taskTypeId)) != null) continue;
            isSupport = false;
            break;
        }
        return isSupport;
    }

    public static boolean isOperationCompletedForResource(ITask oTask, String strOperationId, Resource oResource) {
        if (null == oTask || null == strOperationId || null == oResource) {
            return false;
        }
        boolean isComplete = false;
        ResourceProgressInfo oProgressInfo = oResource.getOprResultInfo(strOperationId);
        if (null != oProgressInfo) {
            isComplete = (3 == oProgressInfo.getState() || 2 == oProgressInfo.getState()) && 0 == oProgressInfo.getResult();
        }
        return isComplete;
    }

    public static boolean isCurOperationCompletedForResource(ITask oTask, String strOperationId, Resource oResource) {
        if (null == oTask || null == strOperationId || null == oResource) {
            return false;
        }
        ResourceProgressInfo oProgressInfo = oResource.getProgressInfo();
        String strCurrentOperationId = oProgressInfo.getCurrentOperationId();
        int iCurrOpStatus = oProgressInfo.getState();
        return strOperationId.equalsIgnoreCase(strCurrentOperationId) && (3 == iCurrOpStatus || 2 == iCurrOpStatus);
    }

    public static boolean isSomeNEOperationSucess(ITask oTask, String strOperationId, THashSet<Resource> oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return false;
        }
        Iterator oResItor = oResourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            if (!TaskModelUtil.isOperationCompletedForResource(oTask, strOperationId, oRes)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOperationCompletedForResourceList(ITask oTask, String strOperationId, THashSet<Resource> oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return false;
        }
        Iterator oResItor = oResourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            if (TaskModelUtil.isOperationCompletedForResource(oTask, strOperationId, oRes)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCurOperationCompletedForResourceList(ITask oTask, String strOperationId, THashSet<Resource> oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return false;
        }
        Iterator oResItor = oResourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            if (TaskModelUtil.isCurOperationCompletedForResource(oTask, strOperationId, oRes)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOperationInProgressForResource(ITask oTask, Resource oResource) {
        if (null == oTask || null == oResource) {
            return false;
        }
        ResourceProgressInfo oProgressInfo = oResource.getProgressInfo();
        int iCurrOpStatus = oProgressInfo.getState();
        return 1 == iCurrOpStatus;
    }

    public static boolean isOperationInProgressForResourceList(ITask oTask, THashSet<Resource> oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return false;
        }
        Iterator oResItor = oResourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            if (!TaskModelUtil.isOperationInProgressForResource(oTask, oRes)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChckOpeSel(ITask taskInfo, String checkItem) {
        boolean bSelcheck = false;
        if (StringUtils.isNullOrEmptyStr(checkItem)) {
            return bSelcheck;
        }
        ICheckOperation oCheckOp = (ICheckOperation)TaskModelUtil.getOperationFromTask(taskInfo.getTaskId(), checkItem);
        if (null != oCheckOp && oCheckOp.isSelected()) {
            bSelcheck = true;
        }
        return bSelcheck;
    }

    public static boolean isChckOpeComplete(ITask taskInfo, String checkItem, boolean isSel, THashSet<Resource> oResourceList) {
        boolean bCompletecheck = false;
        if (StringUtils.isNullOrEmptyStr(checkItem)) {
            return bCompletecheck;
        }
        if (isSel) {
            bCompletecheck = TaskModelUtil.isOperationCompletedForResourceList(taskInfo, checkItem, oResourceList);
        }
        return bCompletecheck;
    }

    public static boolean checkOperationStatusForResourceList(ITask oTask, String strOperationId, THashSet<Resource> oResourceList, int status) {
        if (null == oTask || null == strOperationId) {
            return false;
        }
        int operId = OperationIdStore.getInstance().getOperationId(strOperationId);
        if (!oTask.getTaskDeviceOperation(operId).isSelected()) {
            return false;
        }
        Iterator oResItor = oResourceList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            if (TaskModelUtil.checkOperationStatusForResource(oTask, strOperationId, oRes, status)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkOperationStatusForResource(ITask oTask, String strOperationId, Resource oResource, int result) {
        if (null == oTask || null == strOperationId || null == oResource) {
            return false;
        }
        ResourceProgressInfo progressInfo = oResource.getOprResultInfo(strOperationId);
        if (progressInfo == null) {
            return false;
        }
        if (progressInfo.getCurrentOperationId().equals(strOperationId)) {
            if (progressInfo.getState() == 0) {
                return false;
            }
            int tmpResult = progressInfo.getResult();
            if (tmpResult == result) {
                return true;
            }
        }
        return false;
    }

    public static List<ITaskDeviceOperation> getTaskOperationLst(ITask oTask, boolean bSelected) {
        if (null == oTask) {
            return null;
        }
        ArrayList<ITaskDeviceOperation> oRtnLst = new ArrayList<ITaskDeviceOperation>();
        List<ITaskDeviceOperation> oSupportLst = oTask.getSupportedOperation();
        for (ITaskDeviceOperation oTaskOper : oSupportLst) {
            if (null == oTaskOper || oTaskOper.isSelected() != bSelected) continue;
            oRtnLst.add(oTaskOper);
        }
        return oRtnLst;
    }

    public static String getCorrectDevTypeVer(DeviceType oDeviceType) {
        if (null == oDeviceType) {
            DCDebugTracer.trace(" method getCorrectDevTypeVer end.. oDeviceType is null ");
            return "";
        }
        String strDevTypeVersion = oDeviceType.getDeviceTypeVersionName();
        if (oDeviceType.getDeviceDomain() == 2) {
            boolean bAllSupportTelnet = oDeviceType.isUpgradeModeSupportedByAllDevices(4096);
            boolean bContainsClusterNE = DeviceInfoUtil.isContainsClusterDevice(oDeviceType.getResources());
            if (bAllSupportTelnet && !bContainsClusterNE) {
                if (!strDevTypeVersion.endsWith("_telnet")) {
                    strDevTypeVersion = strDevTypeVersion + "_telnet";
                }
            } else if (strDevTypeVersion.endsWith("_telnet")) {
                strDevTypeVersion = StringUtils.removePostfix(strDevTypeVersion, "_telnet");
            }
        }
        return strDevTypeVersion;
    }

    public static int[] getDevTypeInfoFromDevID(int[] iDeviceIdLst, DeviceTypeInfo deviceType) {
        int[] m_oDeviceIdLst = new int[]{-1000};
        for (int j = 0; j < iDeviceIdLst.length; ++j) {
            DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDeviceIdLst[j]);
            if (null == oDeviceInfo || null == oDeviceInfo || !oDeviceInfo.getDeviceTypeInfo().equals(deviceType)) continue;
            m_oDeviceIdLst[0] = iDeviceIdLst[j];
            break;
        }
        return m_oDeviceIdLst;
    }
}

