/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskModelUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TaskGroup
implements ITaskGroup {
    private String m_oTaskGroupName = null;
    private List<ITask> m_oTaskList = new ArrayList<ITask>(0);
    private int m_iTaskGroupId = -1;
    private static final int[] ALL_TASK_GROUP_ID_LST = new int[]{0, 1, 10, 7, 2, 4, 13, 14, 3, 5, 12, 11, 6, 256};

    @Override
    public void addTask(ITask oTask) {
        if (null != oTask && !this.m_oTaskList.contains(oTask)) {
            this.m_oTaskList.add(oTask);
        }
    }

    @Override
    public void changeTaskState(int taskID, int taskState) {
    }

    @Override
    public void changeTaskState(ITask task, int taskState) {
    }

    @Override
    public List<ITask> getAllTask() {
        return this.m_oTaskList;
    }

    @Override
    public List<ITask> getAllTask(int taskState) {
        return this.m_oTaskList;
    }

    @Override
    public List<ITask> getTasksByTaskStatus(int taskStatus) {
        ArrayList<ITask> taskList = new ArrayList<ITask>();
        for (int i = 0; i < this.m_oTaskList.size(); ++i) {
            ITask oTask = this.m_oTaskList.get(i);
            int iCurTaskState = oTask.getTaskProgressInfo().getState();
            boolean bIsTaskStarted = TaskModelUtil.isTaskStarted(oTask);
            if (4 == iCurTaskState) {
                this.handleTaskPaused(taskStatus, oTask, bIsTaskStarted, taskList);
                continue;
            }
            this.handleTaskProgress(taskStatus, oTask, iCurTaskState, taskList);
        }
        return taskList;
    }

    private void handleTaskProgress(int iTaskStatus, ITask oTask, int iCurTaskState, List<ITask> taskList) {
        if (2 == iTaskStatus) {
            if (1 == iCurTaskState || 2 == iCurTaskState) {
                taskList.add(oTask);
            }
        } else if (iTaskStatus == iCurTaskState) {
            taskList.add(oTask);
        }
    }

    private void handleTaskPaused(int iTaskStatus, ITask oTask, boolean bIsTaskStarted, List<ITask> taskList) {
        if (!bIsTaskStarted && 0 == iTaskStatus) {
            taskList.add(oTask);
        } else if (bIsTaskStarted && 2 == iTaskStatus) {
            taskList.add(oTask);
        }
    }

    @Override
    public ITask getTask(int taskId) {
        int iLstSize = this.m_oTaskList.size();
        for (int j = 0; j < iLstSize; ++j) {
            ITask oTask = this.m_oTaskList.get(j);
            if (taskId != oTask.getTaskId()) continue;
            return oTask;
        }
        return null;
    }

    @Override
    public ITask getTask(String strTaskName) {
        return null;
    }

    @Override
    public int getTaskGroupId() {
        return this.m_iTaskGroupId;
    }

    @Override
    public String getTaskGroupName() {
        return this.m_oTaskGroupName;
    }

    @Override
    public void removeTask(int[] taskID) {
        for (int iTaskId : taskID) {
            int iLstSize = this.m_oTaskList.size();
            for (int j = iLstSize - 1; j >= 0; --j) {
                ITask oTask = this.m_oTaskList.get(j);
                if (iTaskId != oTask.getTaskId()) continue;
                this.m_oTaskList.remove(j);
            }
        }
    }

    @Override
    public void removeTask(ITask[] task) {
    }

    @Override
    public void removeAllTasks() {
        this.m_oTaskList.clear();
    }

    @Override
    public void setTaskGroupId(int taskGroupId) {
        this.m_iTaskGroupId = taskGroupId;
    }

    @Override
    public void setTaskGroupName(String strTaskGroupName) {
        this.m_oTaskGroupName = strTaskGroupName;
    }

    public String toString() {
        return this.m_oTaskGroupName;
    }

    @Override
    public void updateTask(ITask task) {
    }

    @Override
    public void deleteResource(List<Resource> resourceList) {
        int iNoOfTask = this.m_oTaskList.size();
        ArrayList<ITask> oTempTaskList = new ArrayList<ITask>(4);
        for (int i = 0; i < iNoOfTask; ++i) {
            ITask oTask = this.m_oTaskList.get(i);
            THashSet<Resource> oTaskResources = oTask.getSelectedDeviceType().getResources();
            if (6 == oTask.getTaskTypeId()) continue;
            this.deleteActiveInfoFormTsk(resourceList, oTask);
            this.deleteDeiceFrmLst(oTaskResources, resourceList);
            if (oTaskResources.size() != 0) continue;
            oTempTaskList.add(oTask);
        }
        this.m_oTaskList.removeAll(oTempTaskList);
    }

    @Override
    public void deleteResource(int iTaskID, List<Resource> resourceList) {
        int iNoOfTask = this.m_oTaskList.size();
        ArrayList<ITask> oTempTaskList = new ArrayList<ITask>(4);
        for (int i = 0; i < iNoOfTask; ++i) {
            ITask oTask = this.m_oTaskList.get(i);
            if (iTaskID != oTask.getTaskId()) continue;
            THashSet<Resource> oTaskResources = oTask.getSelectedDeviceType().getResources();
            this.deleteActiveInfoFormTsk(resourceList, oTask);
            this.deleteDeiceFrmLst(oTaskResources, resourceList);
            if (oTaskResources.size() != 0) continue;
            oTempTaskList.add(oTask);
        }
        this.m_oTaskList.removeAll(oTempTaskList);
    }

    private void deleteActiveInfoFormTsk(List<Resource> resourceList, ITask oTask) {
        DCDebugTracer.trace("Method deleteActiveInfoFormTsk start");
        List<ITaskDeviceOperation> supportedOperation = oTask.getSupportedOperation();
        for (ITaskDeviceOperation operation : supportedOperation) {
            if (!(operation instanceof ActivationOperation)) continue;
            for (Resource oResource : resourceList) {
                List<ActivationElementInfo> elementLst;
                int iGroupId;
                int deleteDeviceID = oResource.getDeviceID();
                ActivationConfigPara configuredPara = (ActivationConfigPara)operation.getConfiguredPara();
                List<ActivationGroupInfo> groupLst = configuredPara.getActivateGroupInfoLst();
                if (null == groupLst) continue;
                ArrayList<ActivationElementInfo> allElementLst = new ArrayList<ActivationElementInfo>(0);
                for (ActivationGroupInfo groupInfo : groupLst) {
                    iGroupId = groupInfo.getGroupId();
                    elementLst = configuredPara.getElementsFromGroup(iGroupId);
                    Iterator<ActivationElementInfo> elementLstIterator = elementLst.iterator();
                    while (elementLstIterator.hasNext()) {
                        ActivationElementInfo activationElementInfo = elementLstIterator.next();
                        if (activationElementInfo.getResource().getDeviceID() != deleteDeviceID) continue;
                        elementLstIterator.remove();
                        DCDebugTracer.trace("Delete deleteDeviceID : " + deleteDeviceID);
                    }
                    allElementLst.addAll(elementLst);
                }
                configuredPara.setElementInfoLst(allElementLst);
                Iterator<ActivationGroupInfo> groupIterator = groupLst.iterator();
                while (groupIterator.hasNext()) {
                    ActivationGroupInfo groupInfo;
                    groupInfo = groupIterator.next();
                    iGroupId = groupInfo.getGroupId();
                    elementLst = configuredPara.getElementsFromGroup(iGroupId);
                    if (elementLst.size() != 0) continue;
                    groupIterator.remove();
                    DCDebugTracer.trace("Delete iGroupId : " + iGroupId);
                }
            }
        }
        DCDebugTracer.trace("Method deleteActiveInfoFormTsk end..");
    }

    private void deleteDeiceFrmLst(THashSet<Resource> oTaskResourcesLst, List<Resource> oResourceList) {
        int iSizeofLst = oResourceList.size();
        Resource oTaskResource = null;
        Resource oResource = null;
        for (int i = 0; i < iSizeofLst; ++i) {
            oResource = oResourceList.get(i);
            Iterator oResItor = oTaskResourcesLst.iterator();
            while (oResItor.hasNext()) {
                oTaskResource = (Resource)oResItor.next();
                if (oResource.getDeviceID() != oTaskResource.getDeviceID()) continue;
                oResItor.remove();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_iTaskGroupId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskGroup other = (TaskGroup)obj;
        return this.m_iTaskGroupId == other.m_iTaskGroupId;
    }

    public static int[] getTaskGroupIdLst() {
        return ALL_TASK_GROUP_ID_LST;
    }
}

