/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnTaskDetailsResultInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResultEnum;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import gnu.trove.TIntObjectHashMap;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;

public class TaskDeviceLogInfo
implements Serializable {
    private static final long serialVersionUID = 1718652451600756127L;
    private StringBuffer m_strLogInfo = null;
    private String RED_COLOR = "#ff0000";
    private boolean m_bGotOldData = false;
    private boolean m_bGotLogNotification = false;
    private int m_iTaskID = -1;
    private TIntObjectHashMap<StringBuffer> m_MapLogInfo = new TIntObjectHashMap();
    private int MAX_ROW_COUNT = 100;
    private int iCurrentPage = 1;
    private int iLastPage = 1;
    private int iTotalRowConut = 0;
    static final String STARTUP_CONFIG = "StartupConfig";
    static final String DISPLAY_STARTUP = "display startup";
    private String strforPreandPost = "";

    public TaskDeviceLogInfo() {
        this.m_strLogInfo = new StringBuffer();
        String strMaxRowNum = ResourceManager.getInstance().getResString("MAX_NE_OPERLOG_NUM", "config");
        try {
            this.MAX_ROW_COUNT = Integer.parseInt(strMaxRowNum);
            if (this.MAX_ROW_COUNT > 400) {
                this.MAX_ROW_COUNT = 400;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            this.MAX_ROW_COUNT = 400;
        }
    }

    public void updateLogInfo(AsnTaskDetailsResultInfo oOprLogInfo, int iTaskID) {
        AsnTaskDetailsResultInfo oDevOprLogInfo = oOprLogInfo;
        this.m_iTaskID = iTaskID;
        if (null == oDevOprLogInfo) {
            DCDebugTracer.trace("[progress abnormality] updateLogInfo#oDevOprLogInfo is NULL");
            return;
        }
        this.refreshLogInfoMap();
        String strLog = "";
        int iAsnLogTypeEnum = oOprLogInfo.enAsnLogTypeEnum.value;
        DCDebugTracer.trace("[progress abnormality] oOprLogInfo.enAsnLogTypeEnum.value" + iAsnLogTypeEnum);
        switch (iAsnLogTypeEnum) {
            case 2: {
                strLog = this.constructEventLog(oOprLogInfo);
                break;
            }
            case 1: {
                strLog = this.constructOperationLog(oOprLogInfo);
                break;
            }
            case 3: {
                strLog = this.constructCheckOprLog(oOprLogInfo);
                break;
            }
            case 4: {
                strLog = this.constructBasicDevLog(oOprLogInfo);
                break;
            }
            case 5: {
                strLog = this.constructTerminalLog(oOprLogInfo);
                break;
            }
        }
        if (!"".equals(strLog)) {
            if (0 > this.m_strLogInfo.indexOf(strLog)) {
                this.m_strLogInfo.append(strLog);
            } else {
                DCDebugTracer.trace("the log(" + strLog + ") is repeated.");
            }
        }
    }

    public void clearLogInfo() {
        this.m_strLogInfo.setLength(0);
        this.m_MapLogInfo.clear();
        this.iCurrentPage = 1;
        this.iLastPage = 1;
        this.iTotalRowConut = 0;
    }

    private String constructCheckOprLog(AsnTaskDetailsResultInfo oOprLogInfo) {
        String sFileName;
        boolean bIsFailureLog = false;
        StringBuffer sbLog = new StringBuffer();
        Calendar oCal = oOprLogInfo.ologTime;
        if (null != oCal) {
            sbLog.append(DCTimeDateUtil.getLocaleDisplayTime(oCal));
            sbLog.append(" : ");
        }
        String strCheckTypeID = null;
        StringBuffer sbTmpLog = new StringBuffer();
        if (null != oOprLogInfo.strCheckTypeId) {
            strCheckTypeID = new String(oOprLogInfo.strCheckTypeId);
            try {
                ITask oTask = TaskDataModel.getInstance().getTask(this.m_iTaskID);
                String devTypeName = oTask.getDeviceType().getDeviceTypeName();
                if (ResourceManager.getInstance().isDmsForSpecialDevType(devTypeName)) {
                    sbTmpLog.append(ResourceManager.getInstance().getSpecialResForDMS(devTypeName, strCheckTypeID));
                } else {
                    sbTmpLog.append(DCFrameWorkUtil.getLocalizedString(strCheckTypeID));
                }
            }
            catch (Exception e) {
                sbTmpLog.append(DCFrameWorkUtil.getLocalizedString(strCheckTypeID));
            }
            sbTmpLog.append(" ");
        }
        String string = sFileName = null != oOprLogInfo.strFileName ? new String(oOprLogInfo.strFileName) : "";
        if (!StringUtils.isNullOrEmptyStr(sFileName)) {
            sbTmpLog.append(sFileName);
            sbTmpLog.append(" ");
        }
        switch (oOprLogInfo.enAsnStatus.value) {
            case 1: {
                if (this.strforPreandPost.equals(ResourceManager.getInstance().getResString("AUTO_UPGRADE_REBOOT_OPERATION"))) {
                    this.strforPreandPost = ResourceManager.getInstance().getResString("CHECk_REPORT_POSTCHECK_SUBHEADER");
                }
                sbTmpLog.append(this.strforPreandPost);
                sbTmpLog.append(" ");
                sbTmpLog.append(ResourceManager.getInstance().getResString("OPERATION_START"));
                sbTmpLog.append(" ");
                this.strforPreandPost = "";
                break;
            }
            case 3: {
                String operName = new String(oOprLogInfo.strOperationId);
                if (null != operName && (operName.equals("PreCheck") || operName.equals("PostCheck"))) {
                    sbTmpLog.append(ResourceManager.getInstance().getResString("TASK_STATUS_0"));
                } else {
                    sbTmpLog.append(ResourceManager.getInstance().getResString("LOG_INFO_SUCCESSFUL"));
                }
                sbTmpLog.append(" ");
                if (null == oOprLogInfo.oErrorCode || oOprLogInfo.oErrorCode.iErrorNo.intValue() == 0) break;
                sbTmpLog.append("(").append(ErrorCodeReader.getInstance().getErrorDesc(oOprLogInfo.oErrorCode.iErrorNo)).append(") ");
                break;
            }
            case 2: {
                if (null == oOprLogInfo.oErrorCode) break;
                bIsFailureLog = true;
                String str2 = ResourceManager.getInstance().getResString("TASK_FAILURE_MESSAGE") + ".";
                sbTmpLog.append(str2);
                sbTmpLog.append(" ");
                sbTmpLog.append(ResourceManager.getInstance().getResString("FAILURE_REASON"));
                sbTmpLog.append(": ");
                sbTmpLog.append(ErrorCodeReader.getInstance().getErrorDesc(oOprLogInfo.oErrorCode.iErrorNo));
                break;
            }
        }
        if (bIsFailureLog) {
            sbLog.append("<b><Font color = \"");
            sbLog.append(this.RED_COLOR);
            sbLog.append("\">");
            sbLog.append(sbTmpLog);
            sbLog.append("</Font></b><br>");
        } else {
            sbLog.append(sbTmpLog);
            sbLog.append("<br>");
        }
        ++this.iTotalRowConut;
        String sDetailInfo = "";
        if (null != oOprLogInfo.oErrorCode && null != oOprLogInfo.oErrorCode.strResult) {
            sDetailInfo = new String(oOprLogInfo.oErrorCode.strResult);
            String[] rowCount = sDetailInfo.split("\n");
            if (null != rowCount) {
                this.iTotalRowConut += rowCount.length;
            }
            sbLog.append("<pre>");
            sbLog.append(sDetailInfo);
            sbLog.append("<br></pre>");
            ++this.iTotalRowConut;
        }
        return sbLog.toString();
    }

    private void getResultString(AsnDCErrorCodeInfo oErrorCode, StringBuffer strLog) {
        if (null != oErrorCode.strResult) {
            String strResult = new String(oErrorCode.strResult);
            String[] rowCount = strResult.split("\n");
            if (rowCount != null) {
                this.iTotalRowConut += rowCount.length;
            }
            if (999293081 == oErrorCode.iErrorNo.intValue()) {
                strResult = strResult.replaceAll("\n", "<BR>");
            }
            if (0 != strResult.length()) {
                strLog.append("<BR> (");
                strLog.append(strResult);
                strLog.append(") ");
                ++this.iTotalRowConut;
            }
        }
    }

    private String constructOperationLog(AsnTaskDetailsResultInfo oOprLogInfo) {
        String sOperName;
        String key;
        boolean bIsFailureLog = false;
        StringBuffer sbLog = new StringBuffer();
        Calendar oCal = oOprLogInfo.ologTime;
        if (null != oCal) {
            sbLog.append(DCTimeDateUtil.getLocaleDisplayTime(oCal));
            sbLog.append(" : ");
        }
        ITask oTask = TaskDataModel.getInstance().getTask(this.m_iTaskID);
        List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
        int iLen = oOprList.size();
        String strOpr = new String(oOprLogInfo.strOperationId);
        int iOprID = OperationIdStore.getInstance().getOperationId(strOpr);
        boolean bShowStackDevice = false;
        String sStackDevName = "";
        if (iOprID == 6 || iOprID == 9 || iOprID == 8 || iOprID == 10) {
            bShowStackDevice = true;
            int iDeviceID = null != oOprLogInfo.oAsnTaskResource.iDeviceId ? oOprLogInfo.oAsnTaskResource.iDeviceId.intValue() : -1;
            int iStackID = null != oOprLogInfo.oAsnTaskResource.iStackId ? oOprLogInfo.oAsnTaskResource.iStackId.intValue() : -1;
            Resource oResource = oTask.getDeviceType().getResource(iDeviceID, iStackID);
            if (iStackID != -1 && null != oResource) {
                sStackDevName = "(" + oResource.getDeviceName() + ")";
            }
        }
        boolean bBoardLevelPkgDifuseTask = (oTask.getTaskTypeId() == 5 || oTask.getTaskTypeId() == 12) && oTask.getUpgradeLevel() == 2;
        String sShowBoardName = this.getDeviceInfo(oOprLogInfo, oTask, iOprID, bBoardLevelPkgDifuseTask);
        IOperation oObj = null;
        StringBuffer strTmpLog = new StringBuffer();
        boolean isFoundOperationID = false;
        for (int i = 0; i < iLen; ++i) {
            oObj = oOprList.get(i);
            if (oObj.getOperationId() != iOprID) continue;
            isFoundOperationID = true;
            this.strforPreandPost = oObj.getOperationName();
            strTmpLog.append(this.strforPreandPost);
            strTmpLog.append(" ");
            break;
        }
        if (!isFoundOperationID && !(key = "DEVICE_OPERATION_TYPE_" + iOprID).equals(sOperName = ResourceManager.getInstance().getResString(key))) {
            strTmpLog.append(sOperName);
            strTmpLog.append(" ");
        }
        switch (oOprLogInfo.enAsnStatus.value) {
            case 0: {
                bShowStackDevice = false;
                strTmpLog.append(ResourceManager.getInstance().getResString("PREPARATION"));
                strTmpLog.append(" ");
                break;
            }
            case 1: {
                strTmpLog.append(ResourceManager.getInstance().getResString("OPERATION_START"));
                strTmpLog.append(" ");
                break;
            }
            case 3: {
                if (strTmpLog.toString().contains(ResourceManager.getInstance().getResString("DEVICE_OPERATION_TYPE_21"))) {
                    strTmpLog.append(ResourceManager.getInstance().getResString("TASK_STATUS_0"));
                    strTmpLog.append(": ");
                    strTmpLog.append(ErrorCodeReader.getInstance().getErrorDesc(oOprLogInfo.oErrorCode.iErrorNo));
                    strTmpLog.append("\n");
                } else {
                    strTmpLog.append(ResourceManager.getInstance().getResString("LOG_INFO_SUCCESSFUL"));
                }
                strTmpLog.append(" ");
                if (null == oOprLogInfo.strFileName || oOprLogInfo.strFileName.length <= 0) break;
                this.addFileName(strTmpLog, oOprLogInfo);
                break;
            }
            case 4: {
                strTmpLog.append(ResourceManager.getInstance().getResString("OPERATION_PAUSED"));
                strTmpLog.append(" ");
                break;
            }
            case 2: {
                if (null != oOprLogInfo.enAsnResult && oOprLogInfo.enAsnResult.value == 0) {
                    strTmpLog.append(ResourceManager.getInstance().getResString("LOG_INFO_SUCCESSFUL"));
                    strTmpLog.append(" ");
                    break;
                }
                if (null == oOprLogInfo.oErrorCode) break;
                bIsFailureLog = true;
                strTmpLog.append(ResourceManager.getInstance().getResString("OPERATION_FAILED_LOG").trim());
                strTmpLog.append(" ");
                strTmpLog.append(ResourceManager.getInstance().getResString("FAILURE_REASON"));
                strTmpLog.append(": ");
                strTmpLog.append(ErrorCodeReader.getInstance().getErrorDesc(oOprLogInfo.oErrorCode.iErrorNo));
                this.getResultString(oOprLogInfo.oErrorCode, strTmpLog);
                break;
            }
        }
        if (bShowStackDevice && !"".equals(sStackDevName)) {
            strTmpLog.append(sStackDevName);
        }
        if (!"".equals(sShowBoardName)) {
            strTmpLog.append(sShowBoardName);
        }
        if (bIsFailureLog) {
            sbLog.append("<b><Font color = \"");
            sbLog.append(this.RED_COLOR);
            sbLog.append("\">");
            sbLog.append(strTmpLog);
            sbLog.append("</Font></b><br>");
        } else {
            sbLog.append(strTmpLog);
            sbLog.append("<br>");
        }
        return sbLog.toString();
    }

    private String getDeviceInfo(AsnTaskDetailsResultInfo oOprLogInfo, ITask oTask, int iOprID, boolean bBoardLevelPkgDifuseTask) {
        String sShowBoardName = "";
        if ((oTask.getTaskTypeId() == 3 || bBoardLevelPkgDifuseTask) && (iOprID == 6 || iOprID == 8) || IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId())) {
            int iDeviceID = null != oOprLogInfo.oAsnTaskResource.iDeviceId ? oOprLogInfo.oAsnTaskResource.iDeviceId.intValue() : -1;
            int iFrameID = null != oOprLogInfo.oAsnTaskResource.iFrameId ? oOprLogInfo.oAsnTaskResource.iFrameId.intValue() : -1;
            int iRackID = null != oOprLogInfo.oAsnTaskResource.iRackId ? oOprLogInfo.oAsnTaskResource.iRackId.intValue() : -1;
            int iSlotID = null != oOprLogInfo.oAsnTaskResource.iSlotId ? oOprLogInfo.oAsnTaskResource.iSlotId.intValue() : -1;
            int iSlotIDforNA = iRackID + iSlotID;
            Resource oResource = oTask.getTemporaryDevType().getResource(iDeviceID, iFrameID, iSlotIDforNA);
            if (null != oResource && 0 <= iSlotID) {
                String sSlotName = DeviceInfoManagerImpl.getInstance().getBoardNameForT2000(iSlotIDforNA);
                sShowBoardName = "(" + oResource.getSlotLabel() + "_" + sSlotName + ")";
            }
        }
        return sShowBoardName;
    }

    private void addFileName(StringBuffer strLog, AsnTaskDetailsResultInfo oOprLogInfo) {
        if (0 != oOprLogInfo.strFileName.length) {
            strLog.append("( ");
            strLog.append(DCFrameWorkUtil.getLocalizedString("BACKUPFILESTABLE_FILENAME"));
            strLog.append(" = ");
            strLog.append(new String(oOprLogInfo.strFileName));
            strLog.append(" )");
            strLog.append(" ");
        }
    }

    private String constructBasicDevLog(AsnTaskDetailsResultInfo oOprLogInfo) {
        DeviceInfo oDevInfo;
        AsnTaskResource oDevRes;
        Calendar oCal = oOprLogInfo.ologTime;
        StringBuffer sbLog = new StringBuffer();
        if (null != oCal) {
            sbLog.append(DCTimeDateUtil.getLocaleDisplayTime(oCal));
            sbLog.append(" : ");
        }
        if (null != (oDevRes = oOprLogInfo.oAsnTaskResource) && null != (oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oDevRes.iDeviceId.intValue()))) {
            sbLog.append(ResourceManager.getInstance().getResString("POLICYINFOPAN_TABLE_DEVICETYPE"));
            sbLog.append(" = ");
            sbLog.append(oDevInfo.getDeviceTypeInfo().getDevTypeName());
            sbLog.append(",  ");
            sbLog.append(ResourceManager.getInstance().getResString("DEVICE_TYPE_VER"));
            sbLog.append(" = ");
            sbLog.append(oDevInfo.getDeviceTypeInfo().getDevTypeVersionName());
            if (null != oDevRes.strSWversion) {
                sbLog.append(", ");
                sbLog.append(ResourceManager.getInstance().getResString("VERSION"));
                sbLog.append(" = ");
                sbLog.append(new String(oDevRes.strSWversion));
            }
        }
        sbLog.append("<br>");
        ++this.iTotalRowConut;
        return sbLog.toString();
    }

    private String constructTerminalLog(AsnTaskDetailsResultInfo oOprLogInfo) {
        this.refreshLogInfoMap();
        AsnStatusEnum oAsnStatus = oOprLogInfo.enAsnStatus;
        AsnTaskResultEnum oAnsResultEnum = oOprLogInfo.enAsnResult;
        StringBuffer sbLog = new StringBuffer();
        Calendar oCal = oOprLogInfo.ologTime;
        if (null != oCal) {
            sbLog.append(DCTimeDateUtil.getLocaleDisplayTime(oCal));
            sbLog.append(" : ");
        }
        int iDevID = oOprLogInfo.oAsnTaskResource.iDeviceId.intValue();
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
        String sDevIP = null != oDevInfo ? oDevInfo.getDevIPAddress() : "";
        String sOperationInfo = "";
        if (oAsnStatus.value == 1) {
            sOperationInfo = ResourceManager.getInstance().getResString("MANUAL_REBOOT_CONNECT_DEV", new String[]{sDevIP});
        } else if (oAsnStatus.value == 3) {
            sOperationInfo = ResourceManager.getInstance().getResString("MANUAL_REBOOT_DISCONNECT_DEV", new String[]{sDevIP});
        }
        if (oAnsResultEnum.value == 0) {
            sbLog.append(sOperationInfo);
            sbLog.append(" ");
            sbLog.append(ResourceManager.getInstance().getResString("SUCCESS_RESULT"));
            sbLog.append("<br>");
        } else {
            sbLog.append("<b><Font color = \"");
            sbLog.append(this.RED_COLOR);
            sbLog.append("\">");
            sbLog.append(sOperationInfo);
            sbLog.append(ResourceManager.getInstance().getResString("FAILURE_RESULT"));
            sbLog.append("</Font></b><br>");
        }
        ++this.iTotalRowConut;
        return sbLog.toString();
    }

    private String constructEventLog(AsnTaskDetailsResultInfo oOprLogInfo) {
        AsnDCErrorCodeInfo oError;
        AsnTaskResource oRes;
        StringBuffer sbLog = new StringBuffer();
        Calendar oCal = oOprLogInfo.ologTime;
        if (null != oCal) {
            sbLog.append(DCTimeDateUtil.getLocaleDisplayTime(oCal));
            sbLog.append(" : ");
        }
        if (null != (oRes = oOprLogInfo.oAsnTaskResource) && null != oRes.iRackId && null != oRes.iSlotId) {
            sbLog.append(" ");
            sbLog.append(oRes.iRackId.intValue());
            sbLog.append("-");
            sbLog.append(oRes.iSlotId);
        }
        if (null != (oError = oOprLogInfo.oErrorCode)) {
            String strResult;
            BigInteger oIntegerObj = oError.iErrorNo;
            sbLog.append(" ");
            sbLog.append(ErrorCodeReader.getInstance().getErrorDesc(oIntegerObj));
            if (null != oError.strResult && 0 != (strResult = new String(oError.strResult)).length()) {
                sbLog.append(" (");
                sbLog.append(strResult);
                sbLog.append(") ");
            }
        }
        sbLog.append("<br>");
        return sbLog.toString();
    }

    public String getLogInfo() {
        StringBuffer oLogInfo = new StringBuffer(this.m_strLogInfo);
        if (!this.m_MapLogInfo.contains(this.iLastPage)) {
            this.m_MapLogInfo.put(this.iLastPage, (Object)oLogInfo);
        }
        if (this.iLastPage == this.iCurrentPage) {
            return this.m_strLogInfo.toString();
        }
        return ((StringBuffer)this.m_MapLogInfo.get(this.iCurrentPage)).toString();
    }

    public String getPageContent() {
        return this.iCurrentPage + "/" + this.iLastPage + ResourceManager.getInstance().getResString("NE_Operation_Log_Page_Label");
    }

    public synchronized boolean hasGotOldData() {
        return this.m_bGotOldData;
    }

    public synchronized void setToGetOldData(boolean bGotOldData) {
        this.m_bGotOldData = bGotOldData;
    }

    public synchronized boolean hasGotLogNotification() {
        return this.m_bGotLogNotification;
    }

    public synchronized void setGotLogNotification(boolean bGotLogNotification) {
        this.m_bGotLogNotification = bGotLogNotification;
    }

    private void refreshLogInfoMap() {
        if (this.iTotalRowConut >= this.MAX_ROW_COUNT) {
            StringBuffer oLogInfo = new StringBuffer(this.m_strLogInfo);
            if (this.m_MapLogInfo.contains(this.iLastPage)) {
                this.m_MapLogInfo.remove(this.iLastPage);
                this.m_MapLogInfo.put(this.iLastPage, (Object)oLogInfo);
            } else {
                this.m_MapLogInfo.put(this.iLastPage, (Object)oLogInfo);
            }
            this.iTotalRowConut = 0;
            this.m_strLogInfo.setLength(0);
            if (this.iCurrentPage == this.iLastPage) {
                ++this.iCurrentPage;
            }
            ++this.iLastPage;
        }
    }

    public void setCurrentPage(int pageNum) {
        this.iCurrentPage = pageNum;
    }

    public int getCurrentPage() {
        return this.iCurrentPage;
    }

    public void removeCurrentPage() {
        --this.iCurrentPage;
    }

    public void addCurrentPage() {
        ++this.iCurrentPage;
    }

    public int getTotalPage() {
        return this.iLastPage;
    }

    public int getLastPage() {
        return this.iLastPage;
    }
}

