/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class TaskDataModel
implements ITaskDataModel,
IDCObjectDeallocator {
    private static ITaskDataModel m_oTaskDataModel = null;
    private Hashtable m_oTaskGroupList = new Hashtable(0);
    private String m_oCreatingTaskName = "";

    public String toString() {
        return "TaskDataModel [m_oTaskGroupList=" + this.m_oTaskGroupList + "]";
    }

    private TaskDataModel() {
    }

    @Override
    public void addTaskGroup(ITaskGroup oTaskGroup) {
        if (-1 == oTaskGroup.getTaskGroupId()) {
            return;
        }
        this.m_oTaskGroupList.put(oTaskGroup.getTaskGroupId(), oTaskGroup);
    }

    @Override
    public List getAllTaskGroup() {
        return new ArrayList(this.m_oTaskGroupList.values());
    }

    @Override
    public ITaskGroup getTaskGroup(int taskGroupId) {
        if (null == this.m_oTaskGroupList || 0 == this.m_oTaskGroupList.size()) {
            DCDebugTracer.trace("DC:: TaskDataModel(int taskGroupId)::TaskGrouplist->null/size = 0");
            return null;
        }
        return (ITaskGroup)this.m_oTaskGroupList.get(taskGroupId);
    }

    @Override
    public ITaskGroup getTaskGroupForTaskOperation(int taskGroupId) {
        ITaskGroup oTaskGroup = null;
        taskGroupId = taskGroupId > 256 ? 256 : taskGroupId;
        switch (taskGroupId) {
            case 0: 
            case 1: {
                oTaskGroup = (ITaskGroup)this.m_oTaskGroupList.get(10);
                break;
            }
            case 5: 
            case 12: {
                oTaskGroup = (ITaskGroup)this.m_oTaskGroupList.get(11);
                break;
            }
            case 4: 
            case 13: {
                oTaskGroup = (ITaskGroup)this.m_oTaskGroupList.get(14);
                break;
            }
            case 6: {
                oTaskGroup = (ITaskGroup)this.m_oTaskGroupList.get(6);
                break;
            }
            default: {
                oTaskGroup = (ITaskGroup)this.m_oTaskGroupList.get(taskGroupId);
            }
        }
        return oTaskGroup;
    }

    @Override
    public ITaskGroup getTaskGroup(String strTaskGroupName) {
        if (null == strTaskGroupName) {
            DCDebugTracer.trace("DC:: TaskDataModel::strTaskGroupName->null");
            return null;
        }
        if (null == this.m_oTaskGroupList || 0 == this.m_oTaskGroupList.size()) {
            DCDebugTracer.trace("DC:: TaskDataModel(String strTaskGroupName )::TaskGrouplist->null/size = 0");
            return null;
        }
        Enumeration oTaskGroupList = this.m_oTaskGroupList.keys();
        while (oTaskGroupList.hasMoreElements()) {
            ITaskGroup oTaskGroup = (ITaskGroup)oTaskGroupList.nextElement();
            if (!strTaskGroupName.equalsIgnoreCase(oTaskGroup.getTaskGroupName())) continue;
            return oTaskGroup;
        }
        return null;
    }

    @Override
    public void removeTaskGroup(ITaskGroup oTaskGroup) {
        if (this.m_oTaskGroupList.contains(oTaskGroup)) {
            this.m_oTaskGroupList.remove(oTaskGroup);
        }
    }

    @Override
    public void clearTaskModel() {
        this.m_oTaskGroupList.clear();
    }

    @Override
    public ITask getTask(int iTaskID) {
        if (null == this.m_oTaskGroupList || 0 == this.m_oTaskGroupList.size()) {
            DCDebugTracer.trace("TaskDataModel#getTask end.. m_oTaskGroupList is null taskid=" + iTaskID);
            return null;
        }
        Enumeration oTaskGroupList = this.m_oTaskGroupList.keys();
        while (oTaskGroupList.hasMoreElements()) {
            Integer oTaskGroupId = (Integer)oTaskGroupList.nextElement();
            ITaskGroup oTaskGroup = this.getTaskGroupForTaskOperation(oTaskGroupId);
            ITask oTask = oTaskGroup.getTask(iTaskID);
            if (null == oTask) continue;
            return oTask;
        }
        DCDebugTracer.trace("TaskDataModel#getTask end.. do not found taskid=" + iTaskID);
        return null;
    }

    @Override
    public void removeTask(int iTaskID) {
        DCDebugTracer.trace("TaskDataModel#removeTask start");
        DCDebugTracer.trace("iTaskID : " + iTaskID);
        int[] arrTaskId = new int[]{iTaskID};
        if (this.m_oTaskGroupList == null || 0 == this.m_oTaskGroupList.size()) {
            DCDebugTracer.trace("TaskDataModel#removeTask end.. m_oTaskGroupList is null");
            return;
        }
        Enumeration oTaskGroupList = this.m_oTaskGroupList.keys();
        while (oTaskGroupList.hasMoreElements()) {
            Integer oTaskGroupId = (Integer)oTaskGroupList.nextElement();
            ITaskGroup oTaskGroup = this.getTaskGroupForTaskOperation(oTaskGroupId);
            oTaskGroup.removeTask(arrTaskId);
        }
        DCDebugTracer.trace("TaskDataModel#removeTask end..");
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oTaskGroupList) {
            this.m_oTaskGroupList.clear();
            this.m_oTaskGroupList = null;
        }
        m_oTaskDataModel = null;
    }

    public static synchronized ITaskDataModel getInstance() {
        if (null == m_oTaskDataModel) {
            m_oTaskDataModel = new TaskDataModel();
            DCObjectDestructor.getInstance().addObjectForDestructor((TaskDataModel)m_oTaskDataModel);
        }
        return m_oTaskDataModel;
    }

    @Override
    public void notifyTaskEvent(TaskEvent taskEventObj) {
        if (null != taskEventObj) {
            Object source;
            if (TaskEventID.RESOURCE_DELETION == taskEventObj.getTaskEventType()) {
                Object source2 = taskEventObj.getSource();
                if (null != source2) {
                    this.deleteResouce((List)source2);
                }
            } else if (TaskEventID.RESOURCE_DELETION_ONLY_IN_TASK == taskEventObj.getTaskEventType() && null != (source = taskEventObj.getSource())) {
                this.deleteResouce(taskEventObj.getTaskID(), (List)source);
            }
            DCDebugTracer.trace("TaskDataModel the event id is " + (Object)((Object)taskEventObj.getTaskEventType()));
        }
    }

    private void deleteResouce(int iTaskID, List oResource) {
        List oAllTaskGroup = this.getAllTaskGroup();
        for (int i = 0; i < oAllTaskGroup.size(); ++i) {
            ITaskGroup oTaskGroup = (ITaskGroup)oAllTaskGroup.get(i);
            oTaskGroup.deleteResource(iTaskID, oResource);
        }
    }

    private void deleteResouce(List oResource) {
        List oAllTaskGroup = this.getAllTaskGroup();
        for (int i = 0; i < oAllTaskGroup.size(); ++i) {
            ITaskGroup oTaskGroup = (ITaskGroup)oAllTaskGroup.get(i);
            oTaskGroup.deleteResource(oResource);
        }
    }

    @Override
    public int getTaskCount() {
        ArrayList<Integer> oTaskIdList = new ArrayList<Integer>(0);
        if (0 == this.m_oTaskGroupList.size()) {
            return oTaskIdList.size();
        }
        Enumeration oTaskGroupList = this.m_oTaskGroupList.keys();
        while (oTaskGroupList.hasMoreElements()) {
            Integer oTaskGroupId = (Integer)oTaskGroupList.nextElement();
            ITaskGroup oTaskGroup = this.getTaskGroupForTaskOperation(oTaskGroupId);
            List<ITask> oTaskList = oTaskGroup.getAllTask();
            for (int i = 0; i < oTaskList.size(); ++i) {
                int iTaskID = oTaskList.get(i).getTaskId();
                if (oTaskIdList.contains(iTaskID)) continue;
                oTaskIdList.add(iTaskID);
            }
        }
        return oTaskIdList.size();
    }

    @Override
    public void setCreatingTaskName(String strCreatingTaskName) {
        this.m_oCreatingTaskName = strCreatingTaskName;
    }

    @Override
    public String getCreatingTaskName() {
        return this.m_oCreatingTaskName;
    }
}

