/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBConfigPara;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageDevInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Task
implements ITask {
    private static final long serialVersionUID = 1L;
    public static final int DEVICE_LEVEL = 1;
    public static final int BOARD_LEVEL = 2;
    public static final int SIMLOADPATH = 0;
    public static final int SIMROLLBACKPATH = 1;
    public static final int SIMLOADFILENAME = 2;
    public static final int PKGLOADFILENAME = 2;
    private ContentType m_oTaskContentType = null;
    private int m_iTaskId = -1;
    private String m_strTaskName = null;
    private String m_strTargetVerion = "";
    private DeviceType m_oDeviceType = null;
    private List m_oDeviceTypeList = null;
    private DeviceType m_tempDevTypeForUpgardeModel = null;
    private DeviceType temporaryDevType = new DeviceType();
    private LoadSimPackageInfo temporaryLoadSimPackageInfo = null;
    private Calendar m_oStartTime = null;
    private Calendar m_oEndTime = null;
    private int m_iTaskTypeId;
    private List<ITaskDeviceOperation> m_oTaskOpLst = null;
    private int m_iTaskViewType;
    private LoadSimPackageInfo oLoadSimPackageInfo = null;
    private ActiveInfo oActiveInfo = null;
    private TaskProgressInfo m_oTaskProgress;
    private int m_iUpgardeLevel = 1;
    private LoadFileInfoListParam m_oLoadParam;
    private boolean isUpdateLoadOp = false;
    private int m_iHighefficiencyMode = 0;
    private boolean m_bUpgradeFeasibilityRequired = false;
    private boolean m_bUpgradeFeasibilitySuccess = false;
    private RecoverDBConfigPara m_oRecoverDBConfigPara;
    private int m_iLoadType = 0;
    private boolean m_oThirdPartySupported = false;
    private String m_oThirdPartyServerName = "";
    private ExternalFTPInfo m_oExternalFTPInfo = null;
    private boolean bAutoTask = false;
    private boolean m_isOffLineTask = false;
    private HashMap<Integer, List<IsolationTaskInfoObj>> m_oIsolationBoardMap = null;
    private boolean m_isCheckHighEfficiency = false;
    private int iDowngradeType = 0;

    public Task() {
        this.initializeDefaultAttributes();
    }

    public String toString() {
        return "Task [m_iTaskId=" + this.m_iTaskId + ", m_iTaskTypeId=" + this.m_iTaskTypeId + ", m_strTaskName=" + this.m_strTaskName + "]";
    }

    @Override
    public boolean isThirdPartySupported() {
        return this.m_oThirdPartySupported;
    }

    @Override
    public void setThirdPartySupported(boolean mOThirdPartySupported) {
        this.m_oThirdPartySupported = mOThirdPartySupported;
    }

    @Override
    public boolean isbAutoTask() {
        return this.bAutoTask;
    }

    @Override
    public void setbAutoTask(boolean bAutoTask) {
        this.bAutoTask = bAutoTask;
    }

    private void initializeDefaultAttributes() {
        this.m_oTaskProgress = new TaskProgressInfo();
        this.m_oTaskProgress.setState(0);
        this.m_oTaskOpLst = new ArrayList<ITaskDeviceOperation>(0);
    }

    @Override
    public void setLoadSimPackageInfo(LoadSimPackageInfo oLoadSimPackageInfo) {
        this.oLoadSimPackageInfo = oLoadSimPackageInfo;
    }

    @Override
    public LoadSimPackageInfo getLoadSimPackageInfo() {
        return this.oLoadSimPackageInfo;
    }

    @Override
    public void setActivationInfo(ActiveInfo oActiveInfo) {
        this.oActiveInfo = oActiveInfo;
    }

    @Override
    public ActiveInfo getActivationInfo() {
        return this.oActiveInfo;
    }

    @Override
    public DeviceType getSelectedDeviceType() {
        return this.m_oDeviceType;
    }

    @Override
    public List getSelectedDeviceTypes() {
        return this.m_oDeviceTypeList;
    }

    @Override
    public DeviceType getTempDevTypeForUpgardeModel() {
        return this.m_tempDevTypeForUpgardeModel;
    }

    @Override
    public Calendar getStartTime() {
        return this.m_oStartTime;
    }

    @Override
    public Calendar getEndTime() {
        return this.m_oEndTime;
    }

    @Override
    public void setEndTime(Calendar mOEndTime) {
        this.m_oEndTime = mOEndTime;
    }

    @Override
    public List<ITaskDeviceOperation> getSupportedOperation() {
        return this.m_oTaskOpLst;
    }

    @Override
    public String getTargetVersion() {
        return this.m_strTargetVerion;
    }

    @Override
    public int getTaskId() {
        return this.m_iTaskId;
    }

    @Override
    public String getTaskName() {
        return this.m_strTaskName;
    }

    @Override
    public TaskProgressInfo getTaskProgressInfo() {
        return this.m_oTaskProgress;
    }

    @Override
    public void setTaskProgressInfo(TaskProgressInfo m_oTaskProgress) {
        this.m_oTaskProgress = m_oTaskProgress;
    }

    @Override
    public void setDeviceType(DeviceType deviceType) {
        this.m_oDeviceType = deviceType;
    }

    @Override
    public void setDeviceTypes(List deviceTypes) {
        this.m_oDeviceTypeList = deviceTypes;
    }

    @Override
    public void setTempDevTypeForUpgardeModel(DeviceType m_tempDevTypeForUpgardeModel) {
        this.m_tempDevTypeForUpgardeModel = m_tempDevTypeForUpgardeModel;
    }

    @Override
    public DeviceType getDeviceType() {
        return this.m_oDeviceType;
    }

    @Override
    public List getDeviceTypes() {
        this.m_oDeviceTypeList = new ArrayList(0);
        THashSet<Resource> resList = this.getDeviceType().getResources();
        for (Resource res : resList) {
            if (this.m_oDeviceTypeList.contains(res.getDeviceType())) continue;
            this.m_oDeviceTypeList.add(res.getDeviceType());
        }
        return this.m_oDeviceTypeList;
    }

    @Override
    public List<DeviceType> getDeviceTypesList() {
        return this.m_oDeviceTypeList;
    }

    @Override
    public List<DeviceTypeInfo> getDeviceTypeLst() {
        ArrayList<DeviceTypeInfo> oDeviceTypeLst = new ArrayList<DeviceTypeInfo>(0);
        if (this.m_oDeviceType == null) {
            return oDeviceTypeLst;
        }
        THashSet<Resource> resList = this.getDeviceType().getResources();
        DeviceInfo oDeviceInfo = null;
        DeviceTypeInfo devTypeInfo = null;
        for (Resource res : resList) {
            oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(res.getDeviceID());
            if (null == oDeviceInfo || oDeviceTypeLst.contains(devTypeInfo = oDeviceInfo.getDeviceTypeInfo())) continue;
            oDeviceTypeLst.add(devTypeInfo);
        }
        return oDeviceTypeLst;
    }

    @Override
    public void setStartTime(Calendar calender) {
        this.m_oStartTime = calender;
    }

    @Override
    public void setTaskId(int taskId) {
        this.m_iTaskId = taskId;
    }

    @Override
    public void setTaskName(String strTaskName) {
        this.m_strTaskName = strTaskName;
    }

    @Override
    public void setTargetVersion(String strTargetVersion) {
        if (strTargetVersion != null && !"".equals(strTargetVersion) && 4 == this.m_oDeviceType.getDeviceDomain()) {
            String temVersion = strTargetVersion.toUpperCase();
            int beginIndex = temVersion.lastIndexOf("(OPTIX");
            if (beginIndex == -1) {
                beginIndex = temVersion.lastIndexOf("(ATN");
            }
            if (beginIndex == -1) {
                beginIndex = temVersion.lastIndexOf("(SLM");
            }
            if (beginIndex > -1) {
                strTargetVersion = strTargetVersion.substring(0, beginIndex);
            }
        }
        this.m_strTargetVerion = strTargetVersion;
    }

    @Override
    public void setTaskTypeId(int iTaskTypeId) {
        this.m_iTaskTypeId = iTaskTypeId;
    }

    @Override
    public int getTaskTypeId() {
        return this.m_iTaskTypeId;
    }

    @Override
    public void setSupportedOperation(List taskDevOperationLst) {
        this.m_oTaskOpLst = taskDevOperationLst;
    }

    @Override
    public int getTaskViewType() {
        return this.m_iTaskViewType;
    }

    @Override
    public void setTaskViewType(int iViewType) {
        this.m_iTaskViewType = iViewType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_iTaskId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        return this.m_iTaskId == other.getTaskId();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initializeDefaultAttributes();
        in.defaultReadObject();
    }

    @Override
    public ContentType getTaskContentType() {
        return this.m_oTaskContentType;
    }

    @Override
    public void setTaskContentType(ContentType oContentType) {
        this.m_oTaskContentType = oContentType;
    }

    @Override
    public DeviceType getTemporaryDevType() {
        return this.temporaryDevType;
    }

    @Override
    public void setTemporaryDevType(DeviceType oDeviceType) {
        this.temporaryDevType = oDeviceType;
    }

    @Override
    public void setUpgradeLevel(int level) {
        this.m_iUpgardeLevel = level;
    }

    @Override
    public int getUpgradeLevel() {
        return this.m_iUpgardeLevel;
    }

    @Override
    public void setLoadFileInfoListParam(LoadFileInfoListParam m_oLoadParam) {
        this.m_oLoadParam = m_oLoadParam;
    }

    @Override
    public LoadFileInfoListParam getLoadFileInfoListParam() {
        return this.m_oLoadParam;
    }

    @Override
    public void setTemporaryLoadSimPackageInfo(LoadSimPackageInfo oLoadSimPackageInfo) {
        this.temporaryLoadSimPackageInfo = oLoadSimPackageInfo;
    }

    @Override
    public LoadSimPackageInfo getTemporaryLoadSimPackageInfo() {
        return this.temporaryLoadSimPackageInfo;
    }

    @Override
    public boolean isUpdateLoadOperation() {
        return this.isUpdateLoadOp;
    }

    @Override
    public void setUpdateLoadOperation(boolean isUpdate) {
        this.isUpdateLoadOp = isUpdate;
    }

    @Override
    public int getHighefficiencyMode() {
        return this.m_iHighefficiencyMode;
    }

    @Override
    public void setHighefficiencyMode(int highefficiencyMode) {
        this.m_iHighefficiencyMode = highefficiencyMode;
    }

    @Override
    public boolean isUpdateForSelectDev() {
        boolean isUpdate = false;
        if (this.m_tempDevTypeForUpgardeModel == null) {
            isUpdate = true;
        } else {
            THashSet<Resource> m_oResources = this.m_oDeviceType.getResources();
            THashSet<Resource> m_oTempResources = this.m_tempDevTypeForUpgardeModel.getResources();
            if (m_oResources.size() != m_oTempResources.size()) {
                isUpdate = true;
            } else {
                Iterator oResItor = m_oResources.iterator();
                Resource m_oResource = null;
                while (oResItor.hasNext()) {
                    boolean isExistDev = false;
                    m_oResource = (Resource)oResItor.next();
                    Iterator oTmpResItor = m_oTempResources.iterator();
                    Resource m_oTempResource = null;
                    while (oTmpResItor.hasNext()) {
                        m_oTempResource = (Resource)oTmpResItor.next();
                        if (m_oResource.getDeviceID() != m_oTempResource.getDeviceID()) continue;
                        isExistDev = true;
                        break;
                    }
                    if (isExistDev) continue;
                    isUpdate = true;
                    break;
                }
            }
        }
        return isUpdate;
    }

    @Override
    public boolean isUpgradeFeasibilityRequired() {
        return this.m_bUpgradeFeasibilityRequired;
    }

    @Override
    public void setUpgradeFeasibilityRequired(boolean upgradeFeasibilityRequired) {
        this.m_bUpgradeFeasibilityRequired = upgradeFeasibilityRequired;
    }

    @Override
    public boolean isUpgradeFeasibilitySuccess() {
        return this.m_bUpgradeFeasibilitySuccess;
    }

    @Override
    public void setUpgradeFeasibilitySuccess(boolean upgradeFeasibilitySuccess) {
        this.m_bUpgradeFeasibilitySuccess = upgradeFeasibilitySuccess;
    }

    @Override
    public RecoverDBConfigPara getRecoverDBConfigPara() {
        return this.m_oRecoverDBConfigPara;
    }

    @Override
    public void setRecoverDBConfigPara(RecoverDBConfigPara oRecoverDBConfigPara) {
        this.m_oRecoverDBConfigPara = oRecoverDBConfigPara;
    }

    @Override
    public boolean isStackDevicePresent(int roleType) {
        return DeviceInfoUtil.isStackDevicePresent(this.getDeviceType().getResources(), roleType);
    }

    @Override
    public boolean isClusterDevice() {
        boolean bIsClusterDevicePresent = false;
        THashSet<Resource> oResList = this.getDeviceType().getResources();
        for (Resource oRes : oResList) {
            if (2 != oRes.getRoleType() && 1 != oRes.getRoleType()) continue;
            bIsClusterDevicePresent = true;
            break;
        }
        return bIsClusterDevicePresent;
    }

    @Override
    public boolean isContainTL1Device() {
        boolean bIsClusterDevicePresent = false;
        THashSet<Resource> oResList = this.getDeviceType().getResources();
        for (Resource oRes : oResList) {
            if (!DeviceInfoUtil.isTL1Dev(oRes.getDeviceID())) continue;
            bIsClusterDevicePresent = true;
            break;
        }
        return bIsClusterDevicePresent;
    }

    @Override
    public boolean isClusterChildDevice() {
        boolean bIsClusterDevicePresent = false;
        THashSet<Resource> oResList = this.getDeviceType().getResources();
        for (Resource oRes : oResList) {
            if (2 != oRes.getRoleType()) continue;
            bIsClusterDevicePresent = true;
            break;
        }
        return bIsClusterDevicePresent;
    }

    @Override
    public int getLoadSoftwareType() {
        return this.m_iLoadType;
    }

    @Override
    public void setLoadSoftwareType(int iLoadType) {
        this.m_iLoadType = iLoadType;
    }

    @Override
    public Vector getDevListByDevType(String devType) {
        Vector<Integer> devList = new Vector<Integer>();
        THashSet<Resource> resList = this.getDeviceType().getResources();
        for (Resource resInfo : resList) {
            if (!resInfo.getDeviceType().equals(devType)) continue;
            devList.add(resInfo.getDeviceID());
        }
        return devList;
    }

    @Override
    public String getLoadAllPathForMimicPackageUpgrade(int pathType, LoadSimPackageInfo packageInfo, String strLoadPkgPathfromActivationInfo) {
        Vector devList = packageInfo.getDevList();
        List devTypeNameList = this.getDeviceTypes();
        return this.getAllPathForMimicPackageUpgrade(devTypeNameList, devList, pathType, strLoadPkgPathfromActivationInfo);
    }

    public String getAllPathForMimicPackageUpgrade(List<String> devTypeNameList, List<LoadSimPackageDevInfo> devList, int pathType, String strLoadPkgPathfromActivationInfo) {
        String path = "";
        IDeviceInfoManager oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        block0: for (String devTypeName : devTypeNameList) {
            for (LoadSimPackageDevInfo devInfo : devList) {
                Resource res = oDeviceInfoMgr.getResourceForID(devInfo.getDevId());
                if (res == null || !res.getDeviceType().equals(devTypeName)) continue;
                if (pathType == 0) {
                    path = devInfo.getFilePath();
                } else if (pathType == 1) {
                    path = devInfo.getRollBackPath();
                }
                if (null == strLoadPkgPathfromActivationInfo || !strLoadPkgPathfromActivationInfo.equals(path)) continue block0;
                return path;
            }
        }
        return path;
    }

    @Override
    public String getLoadAllPath(int pathType, LoadSimPackageInfo packageInfo) {
        Vector devList = packageInfo.getDevList();
        List devTypeNameList = this.getDeviceTypes();
        return this.getAllPath(devTypeNameList, devList, pathType);
    }

    @Override
    public String getAllPath(List<String> devTypeNameList, List<LoadSimPackageDevInfo> devList, int pathType) {
        String path = "";
        IDeviceInfoManager oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        block0: for (String devTypeName : devTypeNameList) {
            for (LoadSimPackageDevInfo devInfo : devList) {
                Resource res = oDeviceInfoMgr.getResourceForID(devInfo.getDevId());
                if (res == null || !res.getDeviceType().equals(devTypeName)) continue;
                if (pathType == 0) {
                    path = devInfo.getFilePath();
                    continue block0;
                }
                if (pathType != 1) continue block0;
                path = devInfo.getRollBackPath();
                continue block0;
            }
        }
        return path;
    }

    @Override
    public void setPathByDevType(int pathType, String path, String devType) {
        LoadSimPackageInfo packageInfo = this.getLoadSimPackageInfo();
        Vector devList = packageInfo.getDevList();
        IDeviceInfoManager oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        for (LoadSimPackageDevInfo devInfo : devList) {
            Resource res = oDeviceInfoMgr.getResourceForID(devInfo.getDevId());
            if (res == null || !res.getDeviceType().equals(devType)) continue;
            if (pathType == 0) {
                devInfo.setFilePath(path);
                continue;
            }
            if (pathType == 1) {
                devInfo.setRollbackPath(path);
                continue;
            }
            if (pathType != 2) continue;
            devInfo.setFileName(path);
        }
    }

    @Override
    public String getPathByDevType(int pathType, String devType) {
        LoadSimPackageInfo packageInfo = this.getLoadSimPackageInfo();
        if (null == packageInfo) {
            return "";
        }
        Vector devList = packageInfo.getDevList();
        IDeviceInfoManager oDeviceInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        for (LoadSimPackageDevInfo devInfo : devList) {
            Resource res = oDeviceInfoMgr.getResourceForID(devInfo.getDevId());
            if (res == null || !res.getDeviceType().equals(devType)) continue;
            if (pathType == 0) {
                return devInfo.getFilePath();
            }
            if (pathType == 1) {
                return devInfo.getRollBackPath();
            }
            return devInfo.getFileName();
        }
        return "";
    }

    @Override
    public ITaskDeviceOperation getTaskDeviceOperation(int IOperationID) {
        if (null == this.m_oTaskOpLst) {
            return null;
        }
        for (int i = 0; i < this.m_oTaskOpLst.size(); ++i) {
            if (IOperationID != this.m_oTaskOpLst.get(i).getOperationId()) continue;
            return this.m_oTaskOpLst.get(i);
        }
        return null;
    }

    @Override
    public String getTaskTypeName() {
        String sTaskTypeName = "";
        ResourceManager oResMgr = ResourceManager.getInstance();
        switch (this.m_iTaskTypeId) {
            case 0: {
                sTaskTypeName = oResMgr.getResString("SOFTWARE_UPGRADE_TASK_GROUP");
                break;
            }
            case 1: {
                sTaskTypeName = oResMgr.getResString("SOFTWARE_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 2: {
                sTaskTypeName = oResMgr.getResString("PATCH_UPDATE_TASK_GROUP");
                break;
            }
            case 3: {
                sTaskTypeName = oResMgr.getResString("MIMIC_PACKAGE_UPDATE_TASK_GROUP");
                break;
            }
            case 4: {
                sTaskTypeName = oResMgr.getResString("PACKAGE_UPDATE_TASK_GROUP");
                break;
            }
            case 5: {
                sTaskTypeName = oResMgr.getResString("PACKAGE_DIFFUSION_UPDATE_TASK_GROUP");
                break;
            }
            case 7: {
                sTaskTypeName = oResMgr.getResString("OLT_AGENTUPGRADE_TASK_GROUP");
                break;
            }
            case 12: {
                sTaskTypeName = oResMgr.getResString("PACKAGE_DIFFUSION_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 13: {
                sTaskTypeName = oResMgr.getResString("PACKAGE_DOWNGRADE_TASK_GROUP");
                break;
            }
            default: {
                sTaskTypeName = "";
            }
        }
        return sTaskTypeName;
    }

    @Override
    public boolean getIsOffLineTask() {
        return this.m_isOffLineTask;
    }

    @Override
    public void setIsOffLineTask(boolean isOffLineTask) {
        this.m_isOffLineTask = isOffLineTask;
    }

    @Override
    public void addIsolationBoard(IsolationTaskInfoObj oIsolationBoard) {
        Integer key;
        if (null == this.m_oIsolationBoardMap) {
            this.m_oIsolationBoardMap = new HashMap();
        }
        if (null == this.m_oIsolationBoardMap.get(key = Integer.valueOf(oIsolationBoard.getDevId()))) {
            this.m_oIsolationBoardMap.put(key, new ArrayList());
        }
        this.m_oIsolationBoardMap.get(key).add(oIsolationBoard);
    }

    @Override
    public List<IsolationTaskInfoObj> getIsolationBoardLst(int iDevId) {
        if (null == this.m_oIsolationBoardMap) {
            return null;
        }
        return this.m_oIsolationBoardMap.get(iDevId);
    }

    @Override
    public boolean isCheckHighEfficiency() {
        return this.m_isCheckHighEfficiency;
    }

    @Override
    public void setIsCheckHighEfficiency(boolean isCheck) {
        this.m_isCheckHighEfficiency = isCheck;
    }

    @Override
    public boolean isFailed() {
        if (null == this.m_oTaskProgress) {
            return false;
        }
        int iTaskOpResult = this.m_oTaskProgress.getResult();
        int iTaskOpState = this.m_oTaskProgress.getState();
        return 2 == iTaskOpState && 1 == iTaskOpResult;
    }

    @Override
    public boolean isPaused() {
        if (null == this.m_oTaskProgress) {
            return false;
        }
        int iTaskOpResult = this.m_oTaskProgress.getResult();
        int iTaskOpState = this.m_oTaskProgress.getState();
        return 4 == iTaskOpState && 2 == iTaskOpResult;
    }

    @Override
    public boolean isRunning() {
        if (null == this.m_oTaskProgress) {
            return false;
        }
        int iTaskOpState = this.m_oTaskProgress.getState();
        return 2 == iTaskOpState;
    }

    @Override
    public boolean isComplete() {
        if (null == this.m_oTaskProgress) {
            return false;
        }
        int iTaskOpState = this.m_oTaskProgress.getState();
        return 3 == iTaskOpState;
    }

    @Override
    public boolean isHaveFailedRes() {
        boolean isHaveFailedRes = false;
        DeviceType devType = this.getDeviceType();
        THashSet<Resource> resLst = devType.getResources();
        if (null == resLst) {
            return isHaveFailedRes;
        }
        for (Resource res : resLst) {
            if (!res.isFailed()) continue;
            isHaveFailedRes = true;
            break;
        }
        return isHaveFailedRes;
    }

    @Override
    public boolean isInProgress() {
        if (null == this.m_oTaskProgress) {
            return false;
        }
        int iTaskOpState = this.m_oTaskProgress.getState();
        return 1 == iTaskOpState;
    }

    @Override
    public boolean isSucc() {
        boolean isSucc = true;
        DeviceType devType = this.getDeviceType();
        THashSet<Resource> resLst = devType.getResources();
        if (null == resLst) {
            return isSucc;
        }
        for (Resource res : resLst) {
            if (res.isSuccess()) continue;
            isSucc = false;
            break;
        }
        return isSucc;
    }

    @Override
    public boolean isDMSDomain() {
        if (null == this.m_oDeviceType) {
            return false;
        }
        return 2 == this.m_oDeviceType.getDeviceDomain();
    }

    @Override
    public boolean isBMSDomain() {
        if (null == this.m_oDeviceType) {
            return false;
        }
        return 1 == this.m_oDeviceType.getDeviceDomain();
    }

    @Override
    public boolean isT2000Domain() {
        if (null == this.m_oDeviceType) {
            return false;
        }
        return 4 == this.m_oDeviceType.getDeviceDomain();
    }

    @Override
    public String getThirdPartyServerName() {
        return this.m_oThirdPartyServerName;
    }

    @Override
    public void setThirdPartyServerName(String m_oThirdPartyServerName) {
        this.m_oThirdPartyServerName = m_oThirdPartyServerName;
    }

    @Override
    public ExternalFTPInfo getThirdPartyFTPInfo() {
        return this.m_oExternalFTPInfo;
    }

    @Override
    public void setThirdPartyFTPInfo(ExternalFTPInfo oExternalFTPInfo) {
        this.m_oExternalFTPInfo = oExternalFTPInfo;
    }

    @Override
    public void setDownGradeType(int iValue) {
        this.iDowngradeType = iValue;
    }

    @Override
    public int getDownGradeType() {
        return this.iDowngradeType;
    }
}

